// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module ff_macro_p2c # (
 parameter DATA_WIDTH = 256,
 parameter NUM_FLOPS = 1 // based on number of flops you need in 1 dir 
 ) (
 input logic clk,

 input [DATA_WIDTH -1:0] in_data ,

 output [DATA_WIDTH -1:0] out_data

);


 (* altera_attribute = {"-name FORCE_HYPER_REGISTER_FOR_PERIPHERY_CORE_TRANSFER ON"} *)
    reg [DATA_WIDTH-1:0] in_data_reg [NUM_FLOPS:0];    

    assign in_data_reg[0] = in_data;


    genvar i;
    
    generate 
    for (i=0 ; i<NUM_FLOPS ; i=i+1 ) begin : hps_p2c_ff
      always @(posedge clk) begin
          in_data_reg[i+1] <= in_data_reg[i];
      end
    end
    endgenerate

    assign out_data = in_data_reg[NUM_FLOPS];



    
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "RtVKlZGjfRixi4xI11oYmrX+PMax0ulTtjOi5H3vq2H9zwuewt6wOulIreltk437X2PN4+MA07zC7WAQxIKVWtvCyK8cLE2rjfi6HhxTSzoTIo1Qrz0u4txZkK44gbWE8ciHAjGJlVBS72Jo2w+woMvcnXL0SDXJLwiZGCMnECEWfD/klH6X8VTgVJ7kFzee0lqdtgSl5H6EDucawAfGK9fcaYln19FxKZB59GmwSkemHPWE5ms1NIdMeg7hCv/qoHBXX8zJnwem1KEhUMQuPdKgOz1/RlcWa1qlUFbZOZpbWS/jUPST4Tt87JiZ2tkFp4d77ydsFTH8zftwZr+6KFVXDAHzwZ5O5zdSZxGQCrJTqyJztwXERPG69z5gf5ZPPRDsbVhq8Eus+jXtjl5JQhLqDXaJH1DXEKipFkzg5CMGuPZhFAvFzSVjiaHiV4ISFcSzUGB9DJfwigaxBGp+VNpOwVlGzVAAdBk2LIeYxZPwGVJtsgyt+xjjLeDmQe4HodErY69aa2y4pJKaVZ1XdBmjOtvipfDep2gmdVrd7qoH7atDR7dz/VchWxiWOPHR9Cgekl2cnZwde200enQq0SZuSbZl4DXwrocViO600QxoB3OFuEFFIwHVfsHYp6fTNGWwpbMLUNzjGgnKE4AnKQb7v0HumTIroyy8U+zVQw8dvIwTZii6weJrwnJ8W3Na1glA1lHucf6HxAIrwYvV/cu+oQDLGhEVGq+rK1o3iIz18bb1XH9jbMTwdp/iaU6s+X81KI9e++eTOa7Gzyn3rROVeO0f5Pqt/7t4fvNrkPt3CP26ksjUuvX3tT0vV1powFNMb0MZFcrcl15fhEDxELnAWOjzIHqdSxatoLXfTWTM7pUDr54pwab1YagUI8Oeua7eiNGBpX269IQRz3W9kiuwzUiqHGqZVhwVuKSVo7hCb3DUFPH5OXpYBWg6Ob/egJahJP0yUj0475ZkbFGt1pc0UBwtCLMET4LXypIHq59bewWT7sDHhVbFy7OgBTHn"
`endif