#****************************************************************************
#
# SPDX-License-Identifier: MIT-0
# Copyright(c) 2019-2021 Intel Corporation.
#
#****************************************************************************
#
# Sample SDC for Agilex GHRD.
#
#****************************************************************************

set_time_format -unit ns -decimal_places 3

# 50MHz board input clock, 150MHz for EMIF refclk
create_clock -name MAIN_CLOCK -period 20 [get_ports CLK_50_B5B]
create_clock -name EMIF_REF_CLOCK -period "166.666MHz" [get_ports LPDDR4A_REFCLK_p]

# sourcing JTAG related SDC
source ./jtag.sdc

# FPGA IO port constraints
set_false_path -from [get_ports {USER_BUTTON}] -to *
set_false_path -from [get_ports {BUTTON}] -to *
set_false_path -from [get_ports {USER_SW[*]}] -to *
set_false_path -from [get_ports {USER_LED}] -to *
set_false_path -from [get_ports {LED}] -to *
set_false_path -from * -to [get_ports {USER_LED}]
set_false_path -from * -to [get_ports {LED}]

