# (C) 2001-2024 Intel Corporation. All rights reserved.
# Your use of Intel Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Intel Program License Subscription 
# Agreement, Intel FPGA IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Intel and sold by 
# Intel or its authorized distributors.  Please refer to the applicable 
# agreement for further details.



#***********************************************************
# Set diffrence clock frequency for different speed grade
#***********************************************************

#**************************************************************
# Time Information
#**************************************************************
set_time_format -unit ns -decimal_places 3

derive_clock_uncertainty

#**************************************************************
# Create Clock
#**************************************************************

create_clock -period "250 Mhz" -name {dphy_clock_bridge_in_clk_clk} {dphy_clock_bridge_in_clk_clk}
create_clock -period "250 Mhz" -name {axi_clock_bridge_in_clk_clk} {axi_clock_bridge_in_clk_clk}

###### Set False Path in 24.1 for MIPI DPHY violation path

# HSD Case: 15015562853 - Recovery timing violation
set_false_path -from [get_keepers -no_duplicates {*rst_controller_001|alt_rst_sync_uq1|altera_reset_synchronizer_int_chain_out}] -to [get_keepers -no_duplicates {*mipi_dphy|mipi_dphy|arch|dphy_inst|dphy_core_inst|dphy_link[*].dphy_link_used.dphy_pcs|dphy_regfile_ins|*}]

# HSD Case: 15015562633 - Setup timing violation
set_false_path -from [get_keepers -no_duplicates {*mipi_dphy|mipi_dphy|arch|dphy_inst|dphy_core_inst|dphy_link[*].dphy_link_used.dphy_pcs|dphy_*x.dphy_pcs_*x|dphy_pcs_dlanes[*].pcs_data_*x|timing_blk|init_done}] -to [get_keepers -no_duplicates {*mipi_dphy|mipi_dphy|arch|dphy_inst|dphy_core_inst|dphy_link[*].dphy_link_used.dphy_pcs|dphy_regfile_ins|dphy_regfile_ins|dout[8]}]
set_false_path -from [get_keepers -no_duplicates {*mipi_dphy|mipi_dphy|arch|dphy_inst|dphy_core_inst|dphy_link[*].dphy_link_used.dphy_pcs|dphy_*x.dphy_pcs_*x|pcs_clk_*x|timing_blk|init_done}] -to [get_keepers -no_duplicates {*mipi_dphy|mipi_dphy|arch|dphy_inst|dphy_core_inst|dphy_link[*].dphy_link_used.dphy_pcs|dphy_regfile_ins|dphy_regfile_ins|dout[8]}]


