/*
 * VVP_PIP.cpp
 *
 *  Created on: Aug 23, 2024
 *      Author: User
 */

#include <stdio.h>
#include <stdlib.h> // malloc, free
#include <unistd.h>  // usleep (unix standard?)
#include "system.h"
#include "VVP_PIP.h"



VVP_PIP::VVP_PIP(uint32_t BaseAddr):
VVP_CORE(BaseAddr){
	// TODO Auto-generated destructor stub
	int result;
	result =  intel_vvp_pip_conv_init(&m_instance, (intel_vvp_core_base)BaseAddr);
	if (result != 0){
		printf("intel_vvp_pip_conv_init failed\r\n");
	}else{
		m_bValidInstance = true;
	}
}

VVP_PIP::~VVP_PIP() {
	// TODO Auto-generated destructor stub
}

bool VVP_PIP::IsLiteMode(){
	bool bYes;

	if (!m_bValidInstance){
		printf("PIP invalid instance\r\n");
		return false;
	}
	bYes = intel_vvp_pip_conv_get_lite_mode(&m_instance);
	return bYes;
}

void VVP_PIP::ShowStatus() {
	// TODO Auto-generated destructor stub

//	int result;
	bool bYes;
	uint32_t   value32;
	uint8_t value8;

	if (!m_bValidInstance){
		printf("PIP invalid instance\r\n");
		return;
	}
	printf("=========== PIP Status =============\r\n");

		bYes = intel_vvp_pip_conv_get_lite_mode(&m_instance);
		printf("PIP lite mode: %s\r\n", bYes?"Yes":"No");

		bYes = intel_vvp_pip_conv_get_debug_enabled(&m_instance);
		printf("PIP debug mode: %s\r\n", bYes?"Yes":"No");

		bYes = intel_vvp_pip_conv_is_running(&m_instance);
		printf("PIP running: %s\r\n", bYes?"Yes":"No");


		value8 =  intel_vvp_pip_conv_get_status(&m_instance);
		printf("PIP status: %d\r\n", value8);



		// via register access
		// https://www.intel.com/content/www/us/en/docs/programmable/683329/24-2/pixels-in-parallel-converter-registers.html
		printf("query via register\r\n");


		value32 = IORD_32DIRECT(m_BaseAddr, PIP_IMG_INFO_WIDTH);
		printf("PIP image width: %d (%xh)\r\n", (value32 & 0xFF) , value32);

		value32 = IORD_32DIRECT(m_BaseAddr, PIP_IMG_INFO_SUBSAMPLING);
		printf("PIP SubSampling width: %d (%xh)\r\n", (value32 & 0x3), value32);



		value32 = IORD_32DIRECT(m_BaseAddr, PIP_STATUS);
		printf("PIP Status: %d (%xh)\r\n", (value32 & 0x1), value32);



		printf("\r\n");

}

bool VVP_PIP::Config(int nWidth, int nSubSampling){

	if (!m_bValidInstance){
		printf("PIP invalid instance\r\n");
		return false;
	}


	IOWR_32DIRECT(m_BaseAddr, PIP_IMG_INFO_WIDTH, nWidth);
	IOWR_32DIRECT(m_BaseAddr, PIP_IMG_INFO_SUBSAMPLING, nSubSampling);

	return true;

}

