/*
 * VVP_FB.h
 *
 *  Created on: Aug 23, 2024
 *      Author: User
 */

#ifndef VVP_FB_H_
#define VVP_FB_H_

#include <stdint.h>
#include <stdbool.h>

#include "intel_vvp_vfb_regs.h"
#include "intel_vvp_vfb.h"
#include "VVP_Core.h"

// https://www.intel.com/content/www/us/en/docs/programmable/683329/24-2/video-frame-buffer-ip-registers.html
// When you turn on lite mode, registers are RW only if you turn on Debug features, otherwise they are WO. For full, turn off lite mode.
// richard note: register is read only in full mode. only lite-mote is writable

#define FB_IMG_INFO_WIDTH			0x0120
#define FB_IMG_INFO_HEIGHT			0x0124
#define FB_IMG_INFO_INTERLACE		0x0128
#define FB_IMG_INFO_COLORSPACE		0x0130
#define FB_IMG_INFO_SUBSAMPLING		0x0134
#define FB_IMG_INFO_COSITING		0x0138
#define FB_IMG_INFO_FIELD_COUNT		0x013c // Read only
#define FB_INPUT_STATUS				0x0140
#define FB_NUM_INPUT_FIELDS			0x0144
#define FB_NUM_DROPPED_FIELDS		0x0148
#define FB_NUM_INVALID_FIELDS		0x014c
#define FB_OUTPUT_STATUS			0x0150
#define FB_NUM_OUTPUT_FIELDS		0x0154
#define FB_NUM_REPEATED_FIELDS		0x0158
#define FB_OUTPUT_CONTROL			0x015c


class VVP_FB : public VVP_CORE {
protected:
	intel_vvp_vfb_instance m_instance;
public:
	VVP_FB(uint32_t BaseAddr);
	virtual ~VVP_FB();

	void ShowStatus();
	bool Config(int nWidth=1920, int nHeight = 1080);
	bool Run(bool Start = true);
	bool IsLiteMode();
};

#endif /* VVP_FB_H_ */
