# (C) 2001-2025 Altera Corporation. All rights reserved.
# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Altera Program License Subscription 
# Agreement, Altera IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Altera and sold by 
# Altera or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


#**************************************************************
# SDC Entity File: intel_vvp_cvo_core
#**************************************************************

# CDC Helper procedures

proc apply_cdc {from_list to_list {delay 100} {multiplier 0.8}} {
  set from_keepers [get_keepers $from_list -nowarn]
  set to_keepers [get_keepers $to_list -nowarn]

  if {[get_collection_size $from_keepers] > 0} {
    if {[get_collection_size $from_keepers] > 1} {
        set_max_skew -from $from_keepers -to $to_keepers -get_skew_value_from_clock_period min_clock_period -skew_value_multiplier $multiplier
    }
    set_min_delay -from $from_keepers -to $to_keepers -$delay
    set_max_delay -from $from_keepers -to $to_keepers $delay
    set_net_delay -from $from_keepers -to $to_keepers -max -get_value_from_clock_period min_clock_period -value_multiplier $multiplier
  }
}

proc apply_cdc_flop_primitive {instance} {
  apply_cdc "${instance}|data\[*\]" "${instance}|g_synchronizer_flop\[*\].u_synchronizer_flop|gen_flop_primitive\[*\].u_flop_primitive|out_data"
}

proc apply_cdc_vid_dimensions {instance} {
  apply_cdc_flop_primitive "${instance}|i_cdc_sof"
  apply_cdc_flop_primitive "${instance}|i_cdc_1_second"
  apply_cdc "${instance}|r_vid_clks_latched_reg\[*\]"   "${instance}|i_cdc_clk_count|r1_out_data\[*\]"
  apply_cdc "${instance}|r_vid_1_second_ltchd_reg\[*\]" "${instance}|i_cdc_vid_clk_freq|r1_out_data\[*\]"
}

proc apply_cdc_streaming_fifo {instance} {
  apply_cdc "${instance}|read_addr\[*\]"    "${instance}|read_addr_meta\[*\]"
  apply_cdc "${instance}|write_addr\[*\]"   "${instance}|write_addr_meta\[*\]"
}

# Core specific

foreach i {1 2 3 4 5 6 7 8 9 10 11 12 13} {
  apply_cdc_flop_primitive "g_runtime_control.u_cdc_reg_${i}"
}

foreach i {14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29} {
  apply_cdc_flop_primitive "g_runtime_control.u_mb_cdc_reg_${i}"
}

apply_cdc_vid_dimensions {g_fr_dims.i_timing_vid_dimensions}
apply_cdc_vid_dimensions {g_make_tpg_input.g_make_tpg_dims.i_timing_vid_dimensions}
apply_cdc_vid_dimensions {g_make_vid_dims.i_timing_vid_dimensions}

apply_cdc_streaming_fifo {g_make_tpg_input.i_tpg_input_align|g_cdc_vid_fifo.i_cdc_fifo|i_general_fifo}
apply_cdc_streaming_fifo {i_vid_input_align|g_cdc_vid_fifo.i_cdc_fifo|i_general_fifo}



