// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




`timescale 1ps/1ps

module wr_comp_sel_kt2puei #(
    parameter WIDTH=10,
    parameter PIPELINE_OUT=0,
    parameter PIPELINE_CMP=0
) (
    input           clk,
input [WIDTH:0] in_0, 

    input [WIDTH-1:0] base,
    input [1-1:0] shift_occurred, 
    input [1-1:0] clr,    
    output logic sel,
    output logic [1-1:0] sel_index
);
logic [1-1:0] equal,equal_reg;
logic sel_int;
logic [1-1:0] sel_index_int;
logic [1-1:0] shift_occurred_reg;


compare_eq #( .WIDTH (WIDTH) ) com0 ( .in_a(in_0[WIDTH-1:0]), .in_b(base), .equal(equal[0]) );



generate 
    if (PIPELINE_CMP) begin : PIPELINE_CMP_OUT
        always @ (posedge clk) begin
            equal_reg <= equal;
            shift_occurred_reg <= shift_occurred;
        end
    end
    else begin : NO_PIPELINE_CMP_OUT
        assign equal_reg = equal;
        assign shift_occurred_reg = shift_occurred;
    end
endgenerate

wr_pri_mux_kt2puei pri_mux (
.in0             (equal_reg[0] && in_0[WIDTH]),

    .shift_index_out (shift_occurred_reg),
    .sel             (sel_int),
    .sel_index       (sel_index_int),
    .clr             (clr)

);

generate
    if (PIPELINE_OUT) begin
        always @ (posedge clk) begin
            sel       <= sel_int;
            sel_index <= sel_index_int;
        end
    end
    else begin
        assign sel = sel_int;
        assign sel_index = sel_index_int;
    end
endgenerate 
endmodule

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "IVO7kKpMhl468DZmkPLZ5tKfLbB0BAdsGOapOqMPbSr8wdqz58cuuOIwyiJwGdy49mvkvjej6MLG6RJTDx0wIhAWBPUPY2+OHw8UcjROYu9HFbfd5EXTt2R/6HpG2bqnk/RfdajsIUbOb175TAG3lGPKIhIlhP29Q30mqlbR8xUHRcK2ofoJWbix+JjpSorf88bHab1FFz47avKqd83e+hiKFIWjh9xGEMPd4S6lFkYiEPh07vhdIQD3K3lnNfEtoeX/SkJ5FnydoyF7dNT7RGB88FRIwgYid5XPL2k+XBU9WWKVd3QNxN+92o7F4tpyVKasfaBdixsREKTpT7FQeZrm2jiL9OeGWwKCieUBlrduXgbU3OnNNSAXQUdzv7yH0DJd4qzimP03N2SskN29t7SRerxMzkMvb+4s2M83fbY5xZ1B2usvbUgzLFVdct0ikQ3VE9RI82JtfzyDE+SzvCC3lqxpP6EnVoFkmuL3eaWDKovP7ZMjNObA/vCByil2mpZDHwyL1zTkW4jE/swzPY6O5cF84jj2ir737NBvLqGrJdRJ3gdddpNzCCk0QuI+PCh3UUqnEqxJCNWCVEBIbFh9anuKSYn9qi61a57huDOYeFDmGcv1owBwumENOiSBnxHbWub63CNhmPQSYs7jXHwTapuIfXhjsOyRPgTQqE3gKGjPCsNsM1Owu8s7/e26PZ4f7ryxNNowj+jkIz+01HZrnTOCk6+LoMpzeHuXXJv3OTObtr56eKunefq8RhXC8IE8M5jwWT0vunjYbVuGzC639ZcTYDcXwIgoogVb27e8HQDP6AiO8sNJT4EHmfcNdsv25T7/qDJbt0UDsTTBSfiZlCyK6xUS5ejAJVxJoQX1qSjZ+B9QSniQz7lvzRTFzoog27dJu+UHArd1wxcqlA+It7y4VX0384h98OjS+4n8ydWSr/Om293yHUtqOdGM+X/+7ZT22iwLMUj56CIobXxzMNAWW5ANTqDfCXaBlHsOcOzPcVUcM6AykyI2i6Ox"
`endif