// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.




`timescale 1ps/1ps

module rd_sipo_plus_kt2puei #(
    parameter DEPTH = 1, 
    parameter TOTAL_W = 35,
    parameter ID_W    =10
) (
    input clk,
    input rst,
    input in_valid,
    input [TOTAL_W-2:0] in_data, 
    output in_ready,
    input [DEPTH-1:0] clr, 
    output [DEPTH-1:0] shift_occurred, 
    output [TOTAL_W-1:0] dout0

);

logic [TOTAL_W-1:0] mem[DEPTH-1:0];




logic shift_in;



assign shift_in  = in_ready & in_valid;




always @ (posedge clk) begin
    if (shift_in)
        mem[1-1][TOTAL_W-2:0] <= in_data[TOTAL_W-2:0];

end

always @ (posedge clk) begin

    if (rst)
        mem[0][TOTAL_W-1] <= 0;
    else if (shift_in)
        mem[0][TOTAL_W-1] <= 1 & (! clr[0]);
    else if (clr[0])
        mem[0][TOTAL_W-1] <= 0;

end

assign in_ready = !(  mem[0][TOTAL_W-1]  );

assign dout0 = mem[0];

endmodule
    


`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "IVO7kKpMhl468DZmkPLZ5tKfLbB0BAdsGOapOqMPbSr8wdqz58cuuOIwyiJwGdy49mvkvjej6MLG6RJTDx0wIhAWBPUPY2+OHw8UcjROYu9HFbfd5EXTt2R/6HpG2bqnk/RfdajsIUbOb175TAG3lGPKIhIlhP29Q30mqlbR8xUHRcK2ofoJWbix+JjpSorf88bHab1FFz47avKqd83e+hiKFIWjh9xGEMPd4S6lFkYhNXPyEt7PpKDgNiOr1BTQW7QCP/C0vtErCrA9ufiBgobf+U7Cr+KWeD1fZjHXfKITZqMNHotlTrtRYYMP1iMZmOw3aT+pOzmammd/s8IQ/m4VG3m5TfqYUKxwHoo9YFFM2hAtg8bn5lvhkPY19BUhTWNKt+MDGVZzQTbZvJ2WwXinRofiW5A5n2mNg6CyJ7Gqo73v0mDrlA7D32RSvlEGzucGmfR2r81MbK36IFkxjgXX1W9opud02Gx+wtML0jnTLjY7k7MqMTWHokYtxrHXvbDXyAycr3rTsRi2scnWc5jGA9EiXtrHUqVQbyYkkjBXIkl/SRwVKUgQbnBkG900XkSD/bE9d9WUyu2qk72C4ZnCW3HCjtSu/U0u4bDNvHKMut0Q4tDmQm2ShIloGuSgoSlixpuALwmmtHpu/W1wt+AHHk0+Z1tz3fnAE6hFrX42nsjI7RUjxA69/XIMC0KSaOK7WtUuCJbXmPuA0A0/ZB2YXyIuE3a8QXOG6UxaT7ih/zbVErjWYjQAVL9do2G0i9cw2G7EjBqg3U+I5BTdMGM2AcMrdbKzviI6By5vTx9m+w+bElGHqsvV79yuGQm90YmHpv2bWgIFszoUGD8IN1MY9HwfJE6t6va0MmkQOnq0+CyEJzh7AhuRaZG6Kei1MOsznxyzixW3TCcZsqI9fJ/1erF03aJsQNfMxp8tZcTFryKTRVzxxqGurFhSqk4LnrtIsoq/BdD5WY4mpbk0AyHYGFnNC02fIts2pXIq8LleTNbjEBMijrtbW/Ud+qoJ"
`endif