// system_i2c_0.v

// Generated using ACDS version 25.3 109

`timescale 1 ps / 1 ps
module system_i2c_0 #(
		parameter FIFO_DEPTH      = 4,
		parameter FIFO_DEPTH_LOG2 = 2
	) (
		input  wire        clk,       //            clock.clk
		input  wire        rst_n,     //       reset_sink.reset_n
		output wire        intr,      // interrupt_sender.irq
		input  wire [3:0]  addr,      //              csr.address
		input  wire        read,      //                 .read
		input  wire        write,     //                 .write
		input  wire [31:0] writedata, //                 .writedata
		output wire [31:0] readdata,  //                 .readdata
		input  wire        sda_in,    //       i2c_serial.sda_in
		input  wire        scl_in,    //                 .scl_in
		output wire        sda_oe,    //                 .sda_oe
		output wire        scl_oe     //                 .scl_oe
	);

	altera_avalon_i2c #(
		.USE_AV_ST       (0),
		.FIFO_DEPTH      (FIFO_DEPTH),
		.FIFO_DEPTH_LOG2 (FIFO_DEPTH_LOG2)
	) i2c_camera (
		.clk       (clk),                  //   input,   width = 1,            clock.clk
		.rst_n     (rst_n),                //   input,   width = 1,       reset_sink.reset_n
		.intr      (intr),                 //  output,   width = 1, interrupt_sender.irq
		.addr      (addr),                 //   input,   width = 4,              csr.address
		.read      (read),                 //   input,   width = 1,                 .read
		.write     (write),                //   input,   width = 1,                 .write
		.writedata (writedata),            //   input,  width = 32,                 .writedata
		.readdata  (readdata),             //  output,  width = 32,                 .readdata
		.sda_in    (sda_in),               //   input,   width = 1,       i2c_serial.sda_in
		.scl_in    (scl_in),               //   input,   width = 1,                 .scl_in
		.sda_oe    (sda_oe),               //  output,   width = 1,                 .sda_oe
		.scl_oe    (scl_oe),               //  output,   width = 1,                 .scl_oe
		.src_data  (),                     // (terminated),                               
		.src_valid (),                     // (terminated),                               
		.src_ready (1'b0),                 // (terminated),                               
		.snk_data  (16'b0000000000000000), // (terminated),                               
		.snk_valid (1'b0),                 // (terminated),                               
		.snk_ready ()                      // (terminated),                               
	);

endmodule
