// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// synthesis translate_off
`timescale 1ns / 1ps
// synthesis translate_on

module altera_avalon_i2c_txout (
    input           clk,
    input           rst_n,
    input [15:0]    sda_hold,
    input           start_sda_out,
    input           restart_sda_out,
    input           stop_sda_out,
    input           mst_tx_sda_out,
    input           mst_rx_sda_out,
    input           restart_scl_out,
    input           stop_scl_out,
    input           mst_tx_scl_out,
    input           mst_rx_scl_out,
    input           pop_tx_fifo_state,
    input           pop_tx_fifo_state_dly,

    output          sda_oe,
    output          scl_oe

);

reg         data_oe;
reg         clk_oe;
reg         clk_oe_nxt_dly;
reg [15:0]  sda_hold_cnt;
reg [15:0]  sda_hold_cnt_nxt;

wire        data_oe_nxt;
wire        clk_oe_nxt;
wire        clk_oe_nxt_hl;
wire        load_sda_hold_cnt;
wire        sda_hold_en;

assign data_oe_nxt  =   ~start_sda_out   |
                        ~restart_sda_out |
                        ~stop_sda_out    |
                        ~mst_tx_sda_out  |
                        ~mst_rx_sda_out;

assign clk_oe_nxt   =   ~restart_scl_out |
                        ~stop_scl_out    |
                        ~mst_tx_scl_out  |
                        ~mst_rx_scl_out;

assign clk_oe_nxt_hl        = clk_oe_nxt & ~clk_oe_nxt_dly;
assign load_sda_hold_cnt    = clk_oe_nxt_hl;
assign sda_hold_en          = (sda_hold_cnt_nxt != 16'h0) | pop_tx_fifo_state | pop_tx_fifo_state_dly;

assign sda_oe   = data_oe;
assign scl_oe   = clk_oe;

always @(posedge clk or negedge rst_n) begin
    if (!rst_n)
        clk_oe_nxt_dly <= 1'b0;
    else
        clk_oe_nxt_dly <= clk_oe_nxt;
end

always @(posedge clk or negedge rst_n) begin
    if (!rst_n)
        data_oe <= 1'b0;
    else if (sda_hold_en)
        data_oe <= data_oe;
    else
        data_oe <= data_oe_nxt;
end

always @(posedge clk or negedge rst_n) begin
    if (!rst_n)
        clk_oe <= 1'b0;
    else if (pop_tx_fifo_state_dly)
        clk_oe <= clk_oe;
    else
        clk_oe <= clk_oe_nxt;
end

always @(posedge clk or negedge rst_n) begin
    if (!rst_n)
        sda_hold_cnt <= 16'h0;
    else
        sda_hold_cnt <= sda_hold_cnt_nxt;
end

always @* begin
    if (load_sda_hold_cnt)
        sda_hold_cnt_nxt = sda_hold;
    else if (sda_hold_cnt != 16'h0)
        sda_hold_cnt_nxt = sda_hold_cnt - 16'h1;
    else
        sda_hold_cnt_nxt = sda_hold_cnt;
end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "LCZU50Qy5TRPJvoGT/BiytbCNLEOTuSUL1UuWGpIp8LvdGJd3jAKibMZ4pWITna/xt8kRPe3uuWIMwHR0+bXCcYpyOxveNy7wnY61rIOECZ7ckl5ry5Q7MoIxVp9coHOMHjZP15fkBlPmPcSbKjCRu8qLgIpALcXjcvgG6+I4/L3iVIBukiEqhm4Z3w+bI2lW3zpnYndlSAgigOWRG/RDGprvnwtcoGXVNzuWrtkHy+CRpk1Nx3Uu+909lBkG9FTistK1gjEDo5pXvCkP3x0DFoeZFDkZ3Q9frBT3ziXc/SdCBP4DOpWqRW0lyIrKcUHS2NnQns4kWbqW0edD8mLeTcFDAHKz9AiTonXDaQbai9uPo8Z5rlrRUOGaTbO7yf5iuC1W+StqaND0foCygfkDtu1Ta/kT/59cLlSn9aYFK2pIbm85W+HtW0As+ukf5f56I2Lin1mRtwRiIEGMwosU7D3ZO6LCA0+Q6onPNmYPuodlkLspc8p+kgOUE77jnx/iRUca8lVE2VQAhghkv3iUx1vwTqUo+SEgnCiZUnpVFqmE+cEXF4TPgI4jSZP9bvR0+K/3HQbOMSeo62y9j/MPlRtT2DXaBtFLbJ+IrWotVn9E7GIJyiCotCwavqnxupC2QQLFx6cFZ/V35QQ5lqJs1e+pC62VJfDxXH/E8FNl/YvCBR1nluKYaxj5mztxSiIC+O7Cl8VuxLKjVSNXLA3X3sHG75yh+mNPFX0ylXakUJIr8JkeEYvEskFXQHI9B2say/YLdwFiKDnhdgm7WUKL1nYLcI3QkZ3xCcPRoDIZ5nkL1oDpi6ulrqzmj8vdL0y3sTPYUj2DQZB1feHUkedV2QYxhiaIwCP+AQs2dolNKW3ZgcwNvGmAQ/ijU8Evl9uiZGsnP99BfYqd+FNoKOaZ7NodZnmFFH+TOjGfp0ws18pXbv8bd9GU9TYc02jsnAmC1Uuftrdv+pk1GObXONpU8ag5tg0qaBzTilIuSp6YUvTagjqJWfk7uUDkUYBkm5M"
`endif