// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps / 1 ps //RG commented
// baeckler - 07-12-2014
// DESCRIPTION
// Wrapper for MLAB hardware cells in typical arrangement

module directphy_mlab #(
	parameter WIDTH = 20,
	parameter ADDR_WIDTH = 5,
	parameter SIM_EMULATE = 1'b0   // this may not be exactly the same at the fine grain timing level 
)
(
	input wclk,
	input wena,
	input [ADDR_WIDTH-1:0] waddr_reg,
	input [WIDTH-1:0] wdata_reg,
	input [ADDR_WIDTH-1:0] raddr,
	output [WIDTH-1:0] rdata		
);

genvar i;
generate
	if (!SIM_EMULATE) begin
        /////////////////////////////////////////////
        // hardware cells

        // the fourteen nm only (the Stratix 10) needs another data register
       // reg [WIDTH-1:0] wdata_reg_2 /* synthesis preserve */;
       // always @(posedge wclk) wdata_reg_2 <= wdata_reg;


		for (i=0; i<WIDTH; i=i+1)  begin : ml
			wire wclk_w = wclk;  // workaround strange modelsim warning due to cell model tristate
            // Note: the stratix 5 cell is the same other than timing
			//stratixv_mlab_cell lrm (
                        tennm_mlab_cell lrm (
				.clk0(wclk_w),
				.ena0(wena),
				
				// synthesis translate_off
				.clk1(1'b0),
				.ena1(1'b1),
				//.ena2(1'b1),
				.clr(1'b0),
				.devclrn(1'b1),
				.devpor(1'b1),
				// synthesis translate_on			

				.portabyteenamasks(1'b1),
				//.portadatain(wdata_reg_2[i]),
				.portadatain(wdata_reg[i]),
				.portaaddr(waddr_reg),
				.portbaddr(raddr),
				.portbdataout(rdata[i])			
				
			);

			defparam lrm .mixed_port_feed_through_mode = "dont_care";
			defparam lrm .logical_ram_name = "lrm";
			defparam lrm .logical_ram_depth = 1 << ADDR_WIDTH;
			defparam lrm .logical_ram_width = WIDTH;
			defparam lrm .first_address = 0;
			defparam lrm .last_address = (1 << ADDR_WIDTH)-1;
			defparam lrm .first_bit_number = i;
			defparam lrm .data_width = 1;
			defparam lrm .address_width = ADDR_WIDTH;
		end
	end
	else begin
		/////////////////////////////////////////////
		// sim equivalent

		localparam NUM_WORDS = (1 << ADDR_WIDTH);
		reg [WIDTH-1:0] storage [0:NUM_WORDS-1];
		integer k = 0;
		initial begin
			for (k=0; k<NUM_WORDS; k=k+1) begin
				storage[k] = 0;
			end
		end

		always @(posedge wclk) begin
			if (wena) storage [waddr_reg] <= wdata_reg;	
		end

		reg [WIDTH-1:0] rdata_b = 0;
		always @(*) begin
			rdata_b = storage[raddr];
		end
		
		assign rdata = rdata_b;
	end
	
endgenerate

endmodule	

`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5Conti+gYNYo9cSL/gyDnw/m0Cu7CADdtO6YoN4G91pw+rbOEGOK98vhOwNwkl4AW674AE6MpJOjDkdGUtFAsBC2xNImiT/XyMfyEPyCWOM8ZpzbZM0QOzl/DgRH1iDvBEWZ8SIwvWC9QH/PsUWf5suzYwhMelcG6f3lg94mhnCkB2HTY9JeYYVIrUn6e3Gn2DNSg4KlNfi3zSU3SPv5miApSjh43Tk5sGHlkLyXvXU/5AfCXGO6IpmXQHUQuAs3DnvHUwqEQCSyfIVDa7kS4ggrUt3ybQhqMaHBFjS7K9T2TKE7GQhg/LGUVIAiaxdRgDpckgmHPazSJ8WzRh0LdkIpL2ONrXlY22SP9kDI2kTb5Zw6dHzZe77sDZF8N27stowDGBocVKHlnQQ0y6VAx2jY4hk46Ak/SO7EFGMBtM/GZ0/x7YBM311Ko8u5J78pFfVH59P++7zxFXI7KbFteFfr1dLv+n7fME6V/Lu/5AouZcHQ7pITYYbOJcipYbVD+nSpPMz/gsf4TQKcDOdGNs3RtTD0XAF25vT0iiDcjaGYhC3RLqbsCo6MSNOiwcJuPFZoQQFXvB/Ge8TIdwEfL/+tCn9sIbQL0oP9OwKZtb3rK963v1rwNyN+WWxNjKsm9pGBRz2YH397SJIj7NIVDp44/pA9U5V9E4QcM57nVjBbVCYlKM9YpaMkx1bolp//xTP9ErLsoJQ21RqHy6UE2s0H/mDnPMX0vSm1aieZhgUGjL4o2F+vTr3NkGJpI2PmxFOylM55DyKjYmAmirA7JED2LnuawttKbdNHBbek4VbE4dWUGTwpNZq6srKSNvOxRiREIqGeTtzL5NLz45zfuT9F+IbUn73hlJroBcTaD4gnokHwxSn1TRbvqhxicN8/uWjzcjb/XgA2ucNcw0zjult1w7Q+5OBbvhjTBSROlU4YuM1oRUcZ3+6WKNnkgHw9KgTJ5+DxQPt49D1trj6K6gOtXlBHmcSw95ChJEg2yd1QhFuZahnZl5Dnzbd9Er5W"
`endif