// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1ps/1ps

module directphy_gray_cntr_3 #(
	parameter INIT_VAL = 4'h0
)(
	input clk,
	input ena,
	input aclr,
	output reg [2:0] cntr
);

initial cntr = INIT_VAL;

always @(posedge clk or posedge aclr) begin
	if (aclr) cntr <= INIT_VAL;
	else begin
		if (ena) begin
			case (cntr) 
				3'h0 : cntr <= 3'h1;
				3'h1 : cntr <= 3'h3;
				3'h2 : cntr <= 3'h6;
				3'h3 : cntr <= 3'h2;
				3'h4 : cntr <= 3'h0;
				3'h5 : cntr <= 3'h4;
				3'h6 : cntr <= 3'h7;
				3'h7 : cntr <= 3'h5;
			endcase
		end
	end
end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5Conti+gYNYo9cSL/gyDnw/m0Cu7CADdtO6YoN4G91pw+rbOEGOK98vhOwNwkl4AW674AE6MpJOjDkdGUtFAsBC2xNImiT/XyMfyEPyCWOM8ZpzbZM0QOzl/DgRH1iDvBEWZ8SIwvWC9QH/PsUWf5suzYwhMelcG6f3lg94mhnCkB2HTY9JeYYVIrUn6e3Gn2DNSg4KlNfi3zSU3SPv5miApSjh43Tk5sGHlkLyXvXVTxrI2prrZeGCAU5BgpqLhUlvkVWmD0ES0cLvGGtI1RlrpEPkRG9QC6EYCFrANXdpY5qHYAfgf3NI9rZum4AnikS2nCDsQrWdNi/jmDQpO2tv9ZUWsXDzrRsi8T2XkeJ4ndpUhqPIcocz16gD1dm5l9BGLWXC04bLxXEXqXfpipQBiPPFC649c+mRclFIbjMpDrdsJa2TtPuG1qAr9avlGL52VnWrdbyIl9OIwMfCfZmgEBqRiUfp6PTHntQzVD2jbUXLYydbI3lXjXZRr7buSkiNYD3b51orRF/qJLc1GURIdH2xZfWOElP+7sFl5bX3DF+kJB9t3SkrmwBqX3Q2RxVLL+Du8gsTUZxFnCDBQ6jlkXGFRFR9B5/MSrp6RqttSJRqXEks8iwjN5D54y7t7/UNKk2quWyznfyXyVDke6JhNXCJIx6Tj9Yw6wPIYfp3O90xjF+XcRyfGlI7ndphY/ux7gxF3/R9ZshCWZThQ3c9nWO9BoJMoRVRKrvxwY69f+Vt9r5yJNEtwzetzx4ycts/XCyyBfRxEHiPSy57nCvRuaLgIfsfouJ0KmbS+usd5R13ACWYNIw3eiZRMGpq4TrZsfZkY6SsLs8QOGJC2gB4k274QyMttczJq3HGhVIXRdfv10OvsInV4+JYY92fPTBP/ftAK8nauONUnjdhwfpLBXFB7tbOxt1GjmOQRQ7manR8v2HSWg5AolMIcQTbEfqXtXS44j/QA6OHCdDJMf1J8Cd7l5uai/XpkgiHxyL9odTzQkN57XYVp2yTn/dbX"
`endif