// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// Clocked priority encoder with state
//
// On each clock cycle, updates state to show which request is granted.
// Most recent grant holder is always the highest priority.
// If current grant holder is not making a request, while others are, 
// then new grant holder is always the requester with lowest bit number.
// If no requests, current grant holder retains grant state

// $Header$

// Same as  ../../../altera_xcvr_generic/ctrl/alt_xcvr_arbiter.sv without timescale

//altera message_off 16753
module alt_xcvr_arbiter #(
	parameter width = 2
) (
	input  wire clock,
	input  wire [width-1:0] req,	// req[n] requests for this cycle
	output reg  [width-1:0] grant	// grant[n] means requester n is grantee in this cycle
);

	wire idle;	// idle when no requests
	wire [width-1:0] keep;	// keep[n] means requester n is requesting, and already has the grant
							// Note: current grantee is always highest priority for next grant
	wire [width-1:0] take;	// take[n] means requester n is requesting, and there are no higher-priority requests

	assign keep = req & grant;	// current grantee is always highest priority for next grant
	assign idle = ~| req;		// idle when no requests

	initial begin
		grant = 0;
	end

	// grant next state depends on current grant and take priority
	always @(posedge clock) begin
		grant <= 
// synthesis translate_off
                    (grant === {width{1'bx}})? {width{1'b0}} :
// synthesis translate_on
				keep				// if current grantee is requesting, gets to keep grant
				 | ({width{idle}} & grant)	// if no requests, grant state remains unchanged
				 | take;			// take applies only if current grantee is not requesting
	end

	// 'take' bus encodes priority.  Request with lowest bit number wins when current grantee not requesting
	assign take[0] = req[0]
					 & (~| (keep & ({width{1'b1}} << 1)));	// no 'keep' from lower-priority inputs
	genvar i;
	generate
	for (i=1; i < width; i = i + 1) begin : arb
		assign take[i] = req[i]
						 & (~| (keep & ({width{1'b1}} << (i+1))))	// no 'keep' from lower-priority inputs
						 & (~| (req & {i{1'b1}}));	// no 'req' from higher-priority inputs
	end
	endgenerate
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "KvY3cInsyNb25msnrLt7stVcYrfTnHuIYVMQ1737VTJbaDsQP/fg37OQ8BqprVvzIW+w5ltsgbh+KL63tK5E/46JxXrXQPHower03fou3CtkaHIVqFQFY/TqIUSi3JDAI38mKKcWurZB6Wc8ZG5hj06oOJlI+8DfIxJfa5D5HCsq1ylDZ6HHjPT51Z+H71nwlAGcdbIr1aaGa3JYsYd6B5rDj8hxcsdjszWqfgZ98/d3imTzMnpSQ+ddH9EPXKvbdzUuySGRNyjYyscAIpGeC7VrYL7cUliJl85FoWrBTWdphpdoYBSv5mKD31qPxP1ePtZ+D2CRLHRuhnIU83S1+adntMwVup4zFVUFTbyMbkVne9wXrefKNudOvrreavbPrAeh4NkpEYv8dI26EaZW7mG9AUd2JI2h7iWzdeJensSjUQgfAe7sFkMhAuRYIixQcRotQ2PG9lK58zEps6UySSJBZQvHTgQOfIMcue5g21T2CeO7Gg4iSQnH9W8UUUbGvbrrh6bcdT+Vh2KJV0mXuqk9PyO5VFZ9xyuue9VNBGhqA7kSxkQUGn7vMr7NBKQGr5wS4sArssUQkHeO848eGz4glt/iYoLd+DpOvZw82pcaK5vsDHObSF8Oo3cH/4CwD5dSNkjynS8zvaR0Tp/9MYhTUAt3wD6x4Ji5VLraavbNQ723/nRfSCIWcF4Isz0xNgIEjnT10+mZUXzc6x8D3jEbzZFlxyWOfXVGyk6E4ZVhdxPM0PXQTu8czyZw1ESSZLUAtik1It2rLwaUU9SFlXs6hlJHJu/cs8jKB04NBlL8EVE/+ynbZowIdyrmjLl2bVNqkT/ZBZhBwLQIVcaMJuOiHlU7duIsPlAJcL3Bz7rmA3WtidwHNztsClgsBXP8askbb5zTM2raC7CZEPfeHRYQzrHn8c81zspQXs6TGgwN9dsvejEi0Ky7I3lZCUoGejONhcB9cWk1MlsjpottahNAIbIJqqOCReN534Cu5MPWEihT9/LzqARiWUgO9Vr9"
`endif