module xcvr_fmcp_x4_intel_directphy_gts_2 (
		input  wire [0:0]   i_rx_cdr_refclk_p,        //    i_rx_cdr_refclk_p.clk,                  The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]   i_tx_pll_refclk_p,        //    i_tx_pll_refclk_p.clk,                  The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]   i_pma_cu_clk,             //         i_pma_cu_clk.clk,                  The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]   i_system_pll_clk,         //     i_system_pll_clk.clk,                  The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]   i_system_pll_lock,        //    i_system_pll_lock.system_pll_lock,      The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]   i_tx_reset,               //           i_tx_reset.tx_reset,             TX reset input for TX XCVRs and TX datapath. Must be kept asserted until tx_reset_ack is asserted.
		input  wire [0:0]   i_rx_reset,               //           i_rx_reset.rx_reset,             RX reset input for RX XCVRs and RX datapath. Must be kept asserted until rx_reset_ack is asserted.
		output wire [0:0]   o_tx_reset_ack,           //       o_tx_reset_ack.tx_reset_ack,         TX fully in reset indicator.
		output wire [0:0]   o_rx_reset_ack,           //       o_rx_reset_ack.rx_reset_ack,         RX fully in reset indicator.
		output wire [0:0]   o_tx_ready,               //           o_tx_ready.tx_ready,             Status port to indicate when TX XCVRs and TX datapath are reset successfully and ready for data transfer.
		output wire [0:0]   o_rx_ready,               //           o_rx_ready.rx_ready,             RX de-skew NOT enabled: Status port to indicate when RX XCVRs and RX datapath are reset successfully and ready for data transfer. RX de-skew enabled: Status port to indicate when RX XCVRs and RX datapath are reset successfully, RX de-skew is done, and ready for data transfer.
		input  wire         i_tx_coreclkin_xcvr0,     // i_tx_coreclkin_xcvr0.clk,                  TX parallel clock input.
		input  wire         i_tx_coreclkin_xcvr1,     // i_tx_coreclkin_xcvr1.clk,                  TX parallel clock input.
		input  wire         i_tx_coreclkin_xcvr2,     // i_tx_coreclkin_xcvr2.clk,                  TX parallel clock input.
		input  wire         i_tx_coreclkin_xcvr3,     // i_tx_coreclkin_xcvr3.clk,                  TX parallel clock input.
		input  wire         i_rx_coreclkin_xcvr0,     // i_rx_coreclkin_xcvr0.clk,                  RX parallel clock input.
		input  wire         i_rx_coreclkin_xcvr1,     // i_rx_coreclkin_xcvr1.clk,                  RX parallel clock input.
		input  wire         i_rx_coreclkin_xcvr2,     // i_rx_coreclkin_xcvr2.clk,                  RX parallel clock input.
		input  wire         i_rx_coreclkin_xcvr3,     // i_rx_coreclkin_xcvr3.clk,                  RX parallel clock input.
		output wire         o_tx_clkout_xcvr0,        //    o_tx_clkout_xcvr0.clk,                  Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		output wire         o_tx_clkout_xcvr1,        //    o_tx_clkout_xcvr1.clk,                  Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		output wire         o_tx_clkout_xcvr2,        //    o_tx_clkout_xcvr2.clk,                  Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		output wire         o_tx_clkout_xcvr3,        //    o_tx_clkout_xcvr3.clk,                  Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		output wire         o_rx_clkout_xcvr0,        //    o_rx_clkout_xcvr0.clk,                  Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		output wire         o_rx_clkout_xcvr1,        //    o_rx_clkout_xcvr1.clk,                  Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		output wire         o_rx_clkout_xcvr2,        //    o_rx_clkout_xcvr2.clk,                  Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		output wire         o_rx_clkout_xcvr3,        //    o_rx_clkout_xcvr3.clk,                  Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		input  wire [3:0]   i_src_rs_grant,           //       i_src_rs_grant.src_rs_grant,         Grant Signal
		output wire [3:0]   o_src_rs_req,             //         o_src_rs_req.src_rs_req,           Request Signal
		output wire [3:0]   o_tx_serial_data,         //     o_tx_serial_data.o_tx_serial_data,     TX serial data port.
		output wire [3:0]   o_tx_serial_data_n,       //   o_tx_serial_data_n.o_tx_serial_data_n,   Differential pair for TX serial data port. Historically was hidden; however now used in pam4 signal simulation model, hence needs to be connected by user.
		input  wire [3:0]   i_rx_serial_data,         //     i_rx_serial_data.i_rx_serial_data,     RX serial data port.
		input  wire [3:0]   i_rx_serial_data_n,       //   i_rx_serial_data_n.i_rx_serial_data_n,   Differential pair for RX serial data port. Historically was hidden; however now used in pam4 signal simulation model, hence needs to be connected by user.
		output wire [3:0]   o_tx_pll_locked,          //      o_tx_pll_locked.o_tx_pll_locked,      Locked to reference clock within the PPM threshold status signal for fast/medium or slow PLL. 1`b1 - locked. 1'b0 - not locked.
		output wire [3:0]   o_rx_is_lockedtodata,     // o_rx_is_lockedtodata.o_rx_is_lockedtodata, RX CDR data lock status signal. 1`b0: CDR is not locked to data. 1`b1: CDR is locked to data.
		output wire [3:0]   o_rx_is_lockedtoref,      //  o_rx_is_lockedtoref.o_rx_is_lockedtoref,  CDR lock status signal. 1`b1 - CDR is frequency locked to reference clock within the PPM threshold, 1`b0 - CDR is not frequency locked within the PPM threshold.
		output wire [0:0]   o_refclk2core,            //        o_refclk2core.o_refclk2core,        Reference clock to core for HDMI use case
		input  wire [319:0] i_tx_parallel_data,       //   i_tx_parallel_data.i_tx_parallel_data,   TX parallel data.
		output wire [319:0] o_rx_parallel_data,       //   o_rx_parallel_data.o_rx_parallel_data,   RX parallel data.
		input  wire [0:0]   i_reconfig_clk,           //       i_reconfig_clk.clk,                  Reconfiguration interface clock.
		input  wire [0:0]   i_reconfig_reset,         //     i_reconfig_reset.reset,                Reconfiguration reset.
		input  wire [0:0]   i_reconfig_write,         //             reconfig.write,                Reconfiguration write.
		input  wire [0:0]   i_reconfig_read,          //                     .read,                 Reconfiguration read.
		input  wire [19:0]  i_reconfig_address,       //                     .address,              Reconfiguration word address.
		input  wire [3:0]   i_reconfig_byteenable,    //                     .byteenable,           Reconfiguration byte enable. If byteenable[3:0] is 4`b1111, 32-bit Dword Access is assumed; otherwise byte access will be used.
		input  wire [31:0]  i_reconfig_writedata,     //                     .writedata,            Reconfiguration write data.
		output wire [31:0]  o_reconfig_readdata,      //                     .readdata,             Reconfiguration read data.
		output wire [0:0]   o_reconfig_waitrequest,   //                     .waitrequest,          Reconfiguration wait request.
		output wire [0:0]   o_reconfig_readdatavalid  //                     .readdatavalid,        Reconfiguration read data valid. Optional port, available if the port is enabled in parameter editor.
	);
endmodule

