// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// synthesis translate_off
// synthesis translate_on

module dphy_gts_data_sync #(
    parameter WIDTH = 32
) (
    input   logic               aclr,

    input   logic               clk_in,
    input   logic   [WIDTH-1:0] data_in,
    input   logic               clk_out,
    output  logic   [WIDTH-1:0] data_out
);

    logic   reset_in;
    logic   valid;
    logic   valid_last;
    logic   valid_sync;

    logic   ack;
    logic   ack_last;
    logic   ack_sync;

    logic   [WIDTH-1:0] din_reg;

    always_ff @(posedge clk_in or posedge aclr) begin
        if (aclr) begin
		valid <= 1'b0;
        end else begin
            valid   <= ~ack_sync;
        end
    end

    always_ff @(posedge clk_in) begin
	    valid_last <= valid;
        if (valid && !valid_last) begin
            din_reg <= data_in;
        end else begin
            din_reg <= din_reg;
        end
    end

    always_ff @(posedge clk_out) begin
        ack         <= valid_sync;
        ack_last    <= ack;

        if (ack && !ack_last) begin
            data_out <= din_reg;
        end
    end

//    intel_eth_gts_reset_synchronizer rst_sync_0 (
//        .aclr       (aclr),
//        .clk        (clk_in),
//        .aclr_sync  (reset_in)
//    );

    dphy_gts_std_synchronizer_nocut rst_sync_0 (
        .clk     (clk_in),
        .reset_n (1'b1),
        .din     (aclr),
        .dout    (reset_in)
    );

    dphy_gts_std_synchronizer_nocut valid_sync_0 (
        .clk     (clk_out),
        .reset_n (1'b1),
        .din     (valid),
        .dout    (valid_sync)
    );

    dphy_gts_std_synchronizer_nocut ack_sync_0 (
        .clk     (clk_in),
        .reset_n (1'b1),
        .din     (ack),
        .dout    (ack_sync)
    );
endmodule


`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5Conti+gYNYo9cSL/gyDnw/m0Cu7CADdtO6YoN4G91pw+rbOEGOK98vhOwNwkl4AW674AE6MpJOjDkdGUtFAsBC2xNImiT/XyMfyEPyCWOM8ZpzbZM0QOzl/DgRH1iDvBEWZ8SIwvWC9QH/PsUWf5suzYwhMelcG6f3lg94mhnCkB2HTY9JeYYVIrUn6e3Gn2DNSg4KlNfi3zSU3SPv5miApSjh43Tk5sGHlkLyXvXVatYbrj3FuEV8LS/AxUd+KEADGWvFDML+u3naxpidhiSRBclDtybU5GLOMVSlfvray9ilGSTdpTswR2pRLSmj56tRZuwgAilM/H7TrEeHJ6wWfIUudetk0dC/1vDwzH4kLfMa2uKmBFZHHYNBP/IXt6umKxc7gyMnFhl2qC3tyZyOm+x7NaBcuzi+QVEsFPJdM0kqy8fafrOPG6IO0os750iigMThDtlWyji7InmJcVg6z8m55hiQZgwvTL05TqXuaZCwhRYfYMm4GwQe+OWIeA4h3MuNCo1lfuvFqinFSWgNT0+8qHPbTl2++OKDNtV7+a1bplj8u6tCNZ8ExC+alQ6q7TLzGWyDUif46zC7SbHDiM66j7q6RwaKf8XKQxpqjg7JOrg2zaF9rJEK+y5BNlwKCqCuw91k8iZVNazVu41e42FekAOwnMk5sQwlGDPgFJs5BPPqEOGoE8KTpIZ1lWptDgOquKI8TWGY58Dk2TS6AeTFHWMipjVJlPWAHUiHTTdsp9rlQkxdeggv1APt4HzhkH7nk7U/eChmuDslun2WklD+o6s1Am6JZwC47PGv1XcMsEnux0KP8wffUzbslrXlPaX+8SJxSYNRg0o6xAhgA8eWTp8taejCKGwxbGBa2cYwTAnhibfigJ+VVQ6ITnBE0x8/Y3lbfw4scZVF03g5ILqQz6w83bxyWlgCnYfZvZHXXCGgIRle5eHgbNC5JM24An94x96H+ODsZs9tbwNUD8cD5YObySMcYyiQVXlT0OfFif7oPAun9wswSAplD"
`endif