// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module directphy_port_lane_mapping #(
	parameter num_xcvr_per_sys	= 1,
	parameter mrip_mode		= 0
)
(
	
    input [3:0]                	    i_mr_ctrl3_reconfig_group_xcvr_per_fracture,
    input [3:0]                	    i_mr_ctrl3_reconfig_group_fracture_count,

    input [num_xcvr_per_sys-1:0]	i_rst_pld_adapter_tx_pld_rst_n,
    input [num_xcvr_per_sys-1:0]	i_rx_lane_out_of_reset,
    input [num_xcvr_per_sys-1:0]	i_tx_lane_out_of_reset,
    input [num_xcvr_per_sys-1:0]	i_tx_pll_locked,

    output [0:0]			        o_pld_ready_deskew,
    output [0:0]			        o_rx_ready,
    output [0:0]			        o_tx_ready

);


    reg [0:0]			pld_ready_deskew_mrip,pld_ready_deskew_srip;
    reg [0:0]			rx_ready_mrip,rx_ready_srip;
    reg [0:0]			tx_ready_mrip,tx_ready_srip;




	
	// MRIP Case
generate
	if (num_xcvr_per_sys == 2) begin
    	always @(*) begin
            case ({i_mr_ctrl3_reconfig_group_fracture_count,i_mr_ctrl3_reconfig_group_xcvr_per_fracture}) 
/*                 8'b0001_0001 : begin
                                pld_ready_deskew_mrip    = ((i_rst_pld_adapter_tx_pld_rst_n[0 +: 1]));  
                                rx_ready_mrip            = ((i_rx_lane_out_of_reset[0 +: 1]));
                                tx_ready_mrip            = ((i_tx_lane_out_of_reset[0 +: 1] && i_tx_pll_locked[0 +: 1]));
                               end */
                8'b0010_0001 : begin
                                pld_ready_deskew_mrip    = (&(i_rst_pld_adapter_tx_pld_rst_n[0 +: 1]));  
                                rx_ready_mrip            = (&(i_rx_lane_out_of_reset[0 +: 1]));
                                tx_ready_mrip            = (&(i_tx_lane_out_of_reset[0 +: 1] && i_tx_pll_locked[0 +: 1]));
                               end
                default :      begin
                                pld_ready_deskew_mrip    = (&(i_rst_pld_adapter_tx_pld_rst_n[0 +: num_xcvr_per_sys]));
                                rx_ready_mrip            = (&(i_rx_lane_out_of_reset[0 +: num_xcvr_per_sys]));
                                tx_ready_mrip            = (&(i_tx_lane_out_of_reset[0 +: num_xcvr_per_sys] && i_tx_pll_locked[0 +: num_xcvr_per_sys]));
                               end
            endcase
		end
	end
    else if (num_xcvr_per_sys == 4) begin
    	always @(*) begin
            case ({i_mr_ctrl3_reconfig_group_fracture_count,i_mr_ctrl3_reconfig_group_xcvr_per_fracture}) 
/*                 8'b0001_0001 : begin
                                pld_ready_deskew_mrip    = ((i_rst_pld_adapter_tx_pld_rst_n[0 +: 1]));  
                                rx_ready_mrip            = ((i_rx_lane_out_of_reset[0 +: 1]));
                                tx_ready_mrip            = ((i_tx_lane_out_of_reset[0 +: 1] && i_tx_pll_locked[0 +: 1]));
                               end
                8'b0001_0010 : begin
                                pld_ready_deskew_mrip    = ((i_rst_pld_adapter_tx_pld_rst_n[0 +: 2]));  
                                rx_ready_mrip            = ((i_rx_lane_out_of_reset[0 +: 2]));
                                tx_ready_mrip            = ((i_tx_lane_out_of_reset[0 +: 2] && i_tx_pll_locked[0 +: 2]));
                               end */                
                8'b0010_0010 : begin
                                pld_ready_deskew_mrip    = (&(i_rst_pld_adapter_tx_pld_rst_n[0 +: 2]));  
                                rx_ready_mrip            = (&(i_rx_lane_out_of_reset[0 +: 2]));
                                tx_ready_mrip            = (&(i_tx_lane_out_of_reset[0 +: 2] && i_tx_pll_locked[0 +: 2]));
                               end
                8'b0100_0001 : begin
                                pld_ready_deskew_mrip    = (&(i_rst_pld_adapter_tx_pld_rst_n[0 +: 1]));  
                                rx_ready_mrip            = (&(i_rx_lane_out_of_reset[0 +: 1]));
                                tx_ready_mrip            = (&(i_tx_lane_out_of_reset[0 +: 1] && i_tx_pll_locked[0 +: 1]));
                               end
                default :      begin
                                pld_ready_deskew_mrip    = (&(i_rst_pld_adapter_tx_pld_rst_n[0 +: num_xcvr_per_sys]));
                                rx_ready_mrip            = (&(i_rx_lane_out_of_reset[0 +: num_xcvr_per_sys]));
                                tx_ready_mrip            = (&(i_tx_lane_out_of_reset[0 +: num_xcvr_per_sys] && i_tx_pll_locked[0 +: num_xcvr_per_sys]));
                               end
            endcase
		end
	end
    else if (num_xcvr_per_sys == 8) begin
    	always @(*) begin
            case ({i_mr_ctrl3_reconfig_group_fracture_count,i_mr_ctrl3_reconfig_group_xcvr_per_fracture}) 
/*                 8'b0001_0001 : begin
                                pld_ready_deskew_mrip    = ((i_rst_pld_adapter_tx_pld_rst_n[0 +: 1]));  
                                rx_ready_mrip            = ((i_rx_lane_out_of_reset[0 +: 1]));
                                tx_ready_mrip            = ((i_tx_lane_out_of_reset[0 +: 1] && i_tx_pll_locked[0 +: 1]));
                               end
                8'b0001_0010 : begin
                                pld_ready_deskew_mrip    = ((i_rst_pld_adapter_tx_pld_rst_n[0 +: 2]));  
                                rx_ready_mrip            = ((i_rx_lane_out_of_reset[0 +: 2]));
                                tx_ready_mrip            = ((i_tx_lane_out_of_reset[0 +: 2] && i_tx_pll_locked[0 +: 2]));
                               end
                8'b0001_0100 : begin
                                pld_ready_deskew_mrip    = ((i_rst_pld_adapter_tx_pld_rst_n[0 +: 4]));  
                                rx_ready_mrip            = ((i_rx_lane_out_of_reset[0 +: 4]));
                                tx_ready_mrip            = ((i_tx_lane_out_of_reset[0 +: 4] && i_tx_pll_locked[0 +: 4]));
                               end */
                8'b0010_0100 : begin
                                pld_ready_deskew_mrip    = (&(i_rst_pld_adapter_tx_pld_rst_n[0 +: 4]));  
                                rx_ready_mrip            = (&(i_rx_lane_out_of_reset[0 +: 4]));
                                tx_ready_mrip            = (&(i_tx_lane_out_of_reset[0 +: 4] && i_tx_pll_locked[0 +: 4]));
                               end
                8'b0100_0010 : begin
                                pld_ready_deskew_mrip    = (&(i_rst_pld_adapter_tx_pld_rst_n[0 +: 2]));  
                                rx_ready_mrip            = (&(i_rx_lane_out_of_reset[0 +: 2]));
                                tx_ready_mrip            = (&(i_tx_lane_out_of_reset[0 +: 2] && i_tx_pll_locked[0 +: 2]));
                               end
                8'b1000_0001 : begin
                                pld_ready_deskew_mrip    = (&(i_rst_pld_adapter_tx_pld_rst_n[0 +: 1]));  
                                rx_ready_mrip            = (&(i_rx_lane_out_of_reset[0 +: 1]));
                                tx_ready_mrip            = (&(i_tx_lane_out_of_reset[0 +: 1] && i_tx_pll_locked[0 +: 1]));
                               end
                default :      begin
                                pld_ready_deskew_mrip    = (&(i_rst_pld_adapter_tx_pld_rst_n[0 +: num_xcvr_per_sys]));
                                rx_ready_mrip            = (&(i_rx_lane_out_of_reset[0 +: num_xcvr_per_sys]));
                                tx_ready_mrip            = (&(i_tx_lane_out_of_reset[0 +: num_xcvr_per_sys] && i_tx_pll_locked[0 +: num_xcvr_per_sys]));
                               end
            endcase
		end
	end
	else begin

	
		 always @(*) begin
		 case ({i_mr_ctrl3_reconfig_group_fracture_count,i_mr_ctrl3_reconfig_group_xcvr_per_fracture}) 
			  default :      begin
								  pld_ready_deskew_mrip    = (&(i_rst_pld_adapter_tx_pld_rst_n[0 +: num_xcvr_per_sys]));
								  rx_ready_mrip            = (&(i_rx_lane_out_of_reset[0 +: num_xcvr_per_sys]));
								  tx_ready_mrip            = (&(i_tx_lane_out_of_reset[0 +: num_xcvr_per_sys] && i_tx_pll_locked[0 +: num_xcvr_per_sys]));
								  end
		 endcase
		 end
	 end

endgenerate

	
	//SRIP Case
	assign pld_ready_deskew_srip = (&(i_rst_pld_adapter_tx_pld_rst_n[0 +: num_xcvr_per_sys]));
	assign rx_ready_srip	     = (&(i_rx_lane_out_of_reset[0 +: num_xcvr_per_sys]));
	assign tx_ready_srip         = (&(i_tx_lane_out_of_reset[0 +: num_xcvr_per_sys] && i_tx_pll_locked[0 +: num_xcvr_per_sys]));




//Final Output
assign o_pld_ready_deskew   = mrip_mode ? pld_ready_deskew_mrip : pld_ready_deskew_srip;
assign o_rx_ready	        = mrip_mode ? rx_ready_mrip : rx_ready_srip;
assign o_tx_ready	        = mrip_mode ? tx_ready_mrip : tx_ready_srip;


endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5Conti+gYNYo9cSL/gyDnw/m0Cu7CADdtO6YoN4G91pw+rbOEGOK98vhOwNwkl4AW674AE6MpJOjDkdGUtFAsBC2xNImiT/XyMfyEPyCWOM8ZpzbZM0QOzl/DgRH1iDvBEWZ8SIwvWC9QH/PsUWf5suzYwhMelcG6f3lg94mhnCkB2HTY9JeYYVIrUn6e3Gn2DNSg4KlNfi3zSU3SPv5miApSjh43Tk5sGHlkLyXvXV+tYzj17VMeE2UxfY7yftpWvRPfmEo/MdGqmO4vQ+1Wg9jpEO3bI4erb9z+nGVmXas0nACnK8uiuhyobn6VO9ykSNdnOX+dwG2vKl4H0RM95+oGF88xJKHtYoAsl+iYTebyvOYxi2KwP3qSMmN3mj7fm59yicv2iluhoX2/eRVUAXz5AMGuhf/C7JoIkBRXdkxwaYXcjIv3nZ0k4sMD7hobd5u7uYZO9C64ZvSgy4GQiQow94G5ZbvMoPOONKLlHHoV9APKS6DGfXmECv7HXY1y83AWKtrVnWeALkRwqMUbzZ3z5+aHPI3++V+Kc0cRtiJHEdtdO8azdgD9iyCyFsQiJjRHRQzb9Yw0lKbBA17IdwBglEhAvss+US9jKBYTDQjgn7rgF7scmrKGCNQ2b1btyBK4wlPzoVrnnes4gFbqGdWZvS8kKZ41lZol+bmIMcq6A7af7/+TgAdPobkmhq4L4Y+PV0z6cnoMRYGOP70I5L3BP1yaYOGW1nRjxakDhKfSvHKgcZ1wrCMq3PKDXJNM9jK4jnEOcmsAs9B0+tCsG84qthQKsNagQbBR4iD7DMKfEqBccohOshBQojdYeAWQhNC5qHxauTdHogsdl7jRzw+2CYlla+NE7fjXgbOggGXu3ZjvnLmav7Jh3FC112j2I2YRsDQfYf/P3hTJWuiYjrd42d+FSygw1NIslyB/x+/Mt/t/MMFCJMxvmWDcF7IB8x/iezfPwLHMtXEPPYINVepFdc5A1VadzKVwvMLmz1qFRSuzFyO2YyZ57Z1HUgx"
`endif