// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// Copyright 2012 Intel Corporation. All rights reserved.  
// Intel products are protected under numerous U.S. and foreign patents, 
// maskwork rights, copyrights and other intellectual property laws.  
//
// This reference design file, and your use thereof, is subject to and governed
// by the terms and conditions of the applicable Intel Reference Design 
// License Agreement (either as signed by you or found at www.altera.com).  By
// using this reference design file, you indicate your acceptance of such terms
// and conditions between you and Intel Corporation.  In the event that you do
// not agree with such terms and conditions, you may not use the reference 
// design file and please promptly destroy any copies you have made.
//
// This reference design file is being provided on an "as-is" basis and as an 
// accommodation and therefore all warranties, representations or guarantees of 
// any kind (whether express, implied or statutory) including, without 
// limitation, warranties of merchantability, non-infringement, or fitness for
// a particular purpose, are specifically disclaimed.  By making this reference
// design file available, Intel expressly does not recommend, suggest or 
// require that this reference design file be used in combination with any 
// other product not provided by Intel.
/////////////////////////////////////////////////////////////////////////////
 
`timescale 1ps/1ps
 
module directphy_gray_cntr_5_sl #(
	parameter SLD_VAL = 5'h0,
	parameter TARGET_CHIP = 2,
	parameter LOAD_IMPLIES_ENA = 1'b1
)(
	input clk,
	input ena,
	input sld,
	output [4:0] cntr
);
 
wire [5:0] din = {1'b1,cntr};
wire [4:0] dout_w;
 
directphy_wys_lut w0 (.a(din[5]),.b(din[4]),.c(din[3]),.d(din[2]),.e(din[1]),.f(din[0]),.out(dout_w[0]));
defparam w0 .MASK = 64'hc33c3cc3c33c3cc3;
defparam w0 .TARGET_CHIP = TARGET_CHIP;
 
directphy_wys_lut w1 (.a(din[5]),.b(din[4]),.c(din[3]),.d(din[2]),.e(din[1]),.f(din[0]),.out(dout_w[1]));
defparam w1 .MASK = 64'h3cc33cc3ffff0000;
defparam w1 .TARGET_CHIP = TARGET_CHIP;
 
directphy_wys_lut w2 (.a(din[5]),.b(din[4]),.c(din[3]),.d(din[2]),.e(din[1]),.f(din[0]),.out(dout_w[2]));
defparam w2 .MASK = 64'hff00ff00c3c3ff00;
defparam w2 .TARGET_CHIP = TARGET_CHIP;
 
directphy_wys_lut w3 (.a(din[5]),.b(din[4]),.c(din[3]),.d(din[2]),.e(din[1]),.f(din[0]),.out(dout_w[3]));
defparam w3 .MASK = 64'hf0f0f0f0f0f033f0;
defparam w3 .TARGET_CHIP = TARGET_CHIP;
 
directphy_wys_lut w4 (.a(din[5]),.b(din[4]),.c(din[3]),.d(din[2]),.e(din[1]),.f(din[0]),.out(dout_w[4]));
defparam w4 .MASK = 64'hccccccccccccccf0;
defparam w4 .TARGET_CHIP = TARGET_CHIP;
 
wire mod_ena = LOAD_IMPLIES_ENA ? (sld | ena) : ena;
 
genvar i;
 
generate
for (i=0; i<5; i=i+1) begin : rl
		if(i == 0) begin
		dffeas df (.d(dout_w[i]),
					.clk(clk),
					.ena(mod_ena),
					.sload(1'b0),
					.sclr(1'b0),
					.clrn(1'b1),
					.prn(~sld),
				// synthesis translate off
					.devclrn(1'b1),
					.devpor(1'b1),
				// synthesis translate on					
					.asdata(1'b0),
					.aload(1'b0),
					.q(cntr[i])
		);
		defparam df .power_up = "low";
		defparam df .is_wysiwyg = "false";					
		end else begin
		dffeas df (.d(dout_w[i]),
					.clk(clk),
					.ena(mod_ena),
					.sload(1'b0),
					.sclr(1'b0),
					.clrn(~sld),
					.prn(1'b1),
				// synthesis translate off
					.devclrn(1'b1),
					.devpor(1'b1),
				// synthesis translate on					
					.asdata(1'b0),
					.aload(1'b0),
					.q(cntr[i])
		);
		defparam df .power_up = "low";
		defparam df .is_wysiwyg = "false";
		end
end
endgenerate
 
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5Conti+gYNYo9cSL/gyDnw/m0Cu7CADdtO6YoN4G91pw+rbOEGOK98vhOwNwkl4AW674AE6MpJOjDkdGUtFAsBC2xNImiT/XyMfyEPyCWOM8ZpzbZM0QOzl/DgRH1iDvBEWZ8SIwvWC9QH/PsUWf5suzYwhMelcG6f3lg94mhnCkB2HTY9JeYYVIrUn6e3Gn2DNSg4KlNfi3zSU3SPv5miApSjh43Tk5sGHlkLyXvXVmqKl1WiPQiRgUlIH6W9dakv9UGXi5AMhgcp4Q/45iYVhgOfhysK/l6H2YTO3R+I6D/Z73Iwp3ZAgoCv+jCZsiJr/CVBjb7XVOISIY0YOiW4bFtbeeeRSq9e4KMBgqPVd4xhDBYmoHDfcFgKIFnCUzepYkq5ntMVSDwOzd7xWq3x7iMxexkzbcomu4z8lilFU39vNEbK4RUcsQ87V+lz/A2nz5jh4ngEUQvkWvt+AeFfzyHPuBi0EsN2wWcVw1h0MoV5jyUMypCWWdVcV6tg45Lvp0KQx+ODbHPW/1uTiqHeitsnmYaQg/4Fc6y03IyL8AAb7tPSI9HzcJEhDEr8uf5uKk5LkoeXkB1gTpyqHH0Daq95hGVov1WrkpBz9u+d1nZMaA1elamTa5VKQ1NnYaMDNb8h5UHZeMEvUrZTQ52zc+kUJ6UGCoVSiw58ri7V6p9Y+P8wAN0W1V7PtLeJ6vHQpCTdpOFDVdg3HDfm/obX/7gC+2jcTjwy8xDdl8PoJXlAaeTIy2Ffp28aTstCMCDtXYWRdLD8SnPP7wdhU6S7eVOYsbrY6aYjon7w54Yh+w6+4Kt8o3R1okTzUhWnVLpzJ8+MWZc4VPOBGciKko76507RoP+w+5P6YPcLwjOpbNpvIryS9aX/Hk5RYKSrFzOZ+lC7iYtyYJmiTzofYvuJQO4z3vHxktfnQZgNmG14A/R1SkSSAQcLYlw3YI5+x3TKJqe8suXeCMK5dc/AXydbaJGIBTdWR7on6Dkvefl3ojztzIxlPhcknKDdNIWnTO"
`endif