module Qsys_XCVR_CLK_intel_srcss_gts_0 (
		output wire [7:0] o_src_rs_grant,                 //                 o_src_rs_grant.src_rs_grant,          Grant from SRC_Shoreline_Sequencer to SRC_Lane, this will allow SRC_Lane to drive/toggle a reset
		input  wire [7:0] i_src_rs_priority,              //              i_src_rs_priority.src_rs_priority,       Binary Priority Input(0 - Less priority and 1 - high Priority). The user will have to tie this input to '0' unless the request is from an IP which needs fast reconfigurations.
		input  wire [7:0] i_src_rs_req,                   //                   i_src_rs_req.src_rs_req,            Request from SRC_Lane to the SRC_Shoreline_Sequencer when it wants to toggle a reset
		output wire [1:0] o_pma_cu_clk,                   //                   o_pma_cu_clk.clk,                   PMA control unit clock output, 1 per quad of a shoreline. For example, SPLL is used for QHIP/s across quads then 1 output port to be connected to each quad input.
		input  wire [9:0] i_src_rs_refclk_status_bus_out, // i_src_rs_refclk_status_bus_out.refclk_status_bus_out, Refclk fail status from 1 QHIP in this shoreline which gives the current status of all the refclocks
		output wire [7:0] o_refclk_fail_status,           //           o_refclk_fail_status.refclk_fail_status,    Refclk fail status to the user design which tells if the refclocks are failing (enabled initially but turned off now due to failure) or not; 0-Not failing; 1-Failing
		output wire       o_refclk_on_ack,                //                o_refclk_on_ack.refclk_on_ack,         Refclk on ack pulse (1 cycle @ avmm clk) to the user design which denotes that the last refclk turn on command was completed
		input  wire [9:0] i_refclk_on,                    //                    i_refclk_on.refclk_on,             Refclk on command from the user to turn on a refclk buffer
		output wire [9:0] o_src_rs_refclk_cmd_bus_in      //     o_src_rs_refclk_cmd_bus_in.refclk_cmd_bus_in,     Refclk on command to the QHIP to turn on a refclk buffer
	);
endmodule

