// ============================================================================
// Copyright (c) 2024 by Terasic Technologies Inc.
// ============================================================================
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development
//   Kits made by Terasic.  Other use of this code, including the selling
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use
//   or functionality of this code.
//
// ============================================================================
//
//  Terasic Technologies Inc
//  No.80, Fenggong Rd., Hukou Township, Hsinchu County 303035. Taiwan
//
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// ============================================================================
//Date:  Thu Oct 17 16:46:16 2024
// ============================================================================

//`define ENABLE_LPDDR4A
//`define ENABLE_LPDDR4B
//`define ENABLE_LPDDR4C
//`define ENABLE_HPS
//`define ENABLE_SLVS
//`define ENABLE_ENET
`define ENABLE_PCIE
`define ENABLE_QSFP
//`define ENABLE_CAM1
//`define ENABLE_CAM2
//`define ENABLE_GTSL1A
//`define ENABLE_GTSL1B
//`define ENABLE_GTSL1C
//`define ENABLE_GTSR4A
//`define ENABLE_GTSR4C

module golden_top(

      ///////// CLOCK /////////
      input              CLK_100_p,
      input              CLK_50_B5B,
      input              CLK_50_B6A,
      input              CLK_50_B6C,

      ///////// Buttons /////////
      input              USER_BUTTON, //USER_BUTTON is Low-Active
      input              BUTTON, //BUTTON is Low-Active

      ///////// Swtiches /////////
      input    [ 1: 0]   USER_SW,

      ///////// LED /////////
      output             USER_LED, //USER_LED is Low-Active
      output             LED, //LED is Low-Active

      ///////// SD Card /////////
      inout              SD_MMC_SEL,

`ifdef ENABLE_LPDDR4A
      ///////// LPDDR4A /////////
      input              LPDDR4A_REFCLK_p,
      output             LPDDR4A_CS_n,
      output   [ 5: 0]   LPDDR4A_CA,
      output             LPDDR4A_CK,
      output             LPDDR4A_CKE,
      output             LPDDR4A_CK_n,
      inout    [ 3: 0]   LPDDR4A_DM,
      inout    [31: 0]   LPDDR4A_DQ,
      inout    [ 3: 0]   LPDDR4A_DQS,
      inout    [ 3: 0]   LPDDR4A_DQS_n,
      output             LPDDR4A_RESET_n,
      input              LPDDR4A_RZQ,
`endif /*ENABLE_LPDDR4A*/

`ifdef ENABLE_LPDDR4B
      ///////// LPDDR4B /////////
      input              LPDDR4B_REFCLK_p,
      output             LPDDR4B_CS_n,
      output   [ 5: 0]   LPDDR4B_CA,
      output             LPDDR4B_CK,
      output             LPDDR4B_CKE,
      output             LPDDR4B_CK_n,
      inout    [ 3: 0]   LPDDR4B_DM,
      inout    [31: 0]   LPDDR4B_DQ,
      inout    [ 3: 0]   LPDDR4B_DQS,
      inout    [ 3: 0]   LPDDR4B_DQS_n,
      output             LPDDR4B_RESET_n,
      input              LPDDR4B_RZQ,
`endif /*ENABLE_LPDDR4B*/

`ifdef ENABLE_LPDDR4C
      ///////// LPDDR4C /////////
      input              LPDDR4C_REFCLK_p,
      output             LPDDR4C_CS_n,
      output   [ 5: 0]   LPDDR4C_CA,
      output             LPDDR4C_CK,
      output             LPDDR4C_CKE,
      output             LPDDR4C_CK_n,
      inout    [ 3: 0]   LPDDR4C_DM,
      inout    [31: 0]   LPDDR4C_DQ,
      inout    [ 3: 0]   LPDDR4C_DQS,
      inout    [ 3: 0]   LPDDR4C_DQS_n,
      output             LPDDR4C_RESET_n,
      input              LPDDR4C_RZQ,
`endif /*ENABLE_LPDDR4C*/


      ///////// HDMI ////////
      inout              DDC_I2C_SCL,
      inout              DDC_I2C_SDA,
      inout              HDMI_I2C_SCL,
      inout              HDMI_I2C_SDA,
      output             HDMI_TX_HS,
      output             HDMI_TX_VS,
      output   [23: 0]   HDMI_TX_D,
      output             HDMI_TX_DE,
      output             HDMI_TX_CLK_p,
      output             HDMI_EDGE_HPD,
      output             HDMI_ISEL,
      output             HDMI_PD_n,

      ///////// QTH /////////
      inout    [15: 0]   QTH_30_p,
      inout    [15: 0]   QTH_30_n,
      inout    [ 3: 0]   QTH_30_D,
	
`ifdef ENABLE_SLVS
      ///////// SLVS /////////
      input    [ 7: 0]   SLVS_EC_RX_p,
      input    [ 7: 0]   SLVS_EC_RX_n,
      input              SLVS_EC_SDO,
      input              SLVS_EC_REFCLK_p, //J1_GTSL1A_REFCLK_p
      output             SLVS_EC_INCK_OE,
      output             SLVS_EC_OMODE,
      inout              SLVS_EC_SCK_SCL,
      inout              SLVS_EC_SDI_SDA,
      input              SLVS_EC_SENSOR_PGOOD,
      output             SLVS_EC_SENSOR_PON,
      output             SLVS_EC_XCE,
      output             SLVS_EC_XCLR,
      output             SLVS_EC_XHS,
      output             SLVS_EC_XMASTER,
      output   [ 2: 1]   SLVS_EC_XTRIG,
      output             SLVS_EC_XVS,
`endif /*ENABLE_SLVS*/	

`ifdef ENABLE_ENET
      ///////// ENET /////////
      output             ENET_88E2110_TX_p,
      output             ENET_88E2110_TX_n,
      input              ENET_88E2110_RX_p,
      input              ENET_88E2110_RX_n,
      input              ENET_88E2110_REFCLK_125M_p, //GTSL1C_REFCLK_125M_p
      input              ENET_88E2110_INT_n,
      output             ENET_88E2110_MDC,
      inout              ENET_88E2110_MDIO,
      output             ENET_88E2110_RESET_n,
`endif /*ENABLE_ENET*/

      ///////// SI5332B /////////
      inout              SI5332B_I2C_SCL,
      inout              SI5332B_I2C_SDA,

      ///////// SI5340B /////////
      inout              SI5340B_I2C_SCL,
      inout              SI5340B_I2C_SDA,
      output             SI5340B_OE_n,
      output             SI5340B_RST_n,

      ///////// GPIO /////////
      inout    [35: 0]   GPIO_D,

////`ifdef ENABLE_FMCP  //<---1B
//      ///////// FMCP /////////
//     //output   [ 7: 0]   FMCP_DP_C2M_p,
//     //output   [ 7: 0]   FMCP_DP_C2M_n,
//     //input    [ 7: 0]   FMCP_DP_M2C_p,
//     //input    [ 7: 0]   FMCP_DP_M2C_n,
//		
//      output   [ 3: 0]   FMCP_DP_C2M_p,
//      output   [ 3: 0]   FMCP_DP_C2M_n,
//      input    [ 3: 0]   FMCP_DP_M2C_p,
//      input    [ 3: 0]   FMCP_DP_M2C_n,		
//		
//      inout              FMCP_HA_p0,
//      inout              FMCP_HA_n0,
//      inout              FMCP_HA_n1,
//      inout    [33: 0]   FMCP_LA_p,
//      inout    [33: 0]   FMCP_LA_n,
//      //input              FMCP_CLK_M2C_p0,
//      //input    [ 1: 0]   FMCP_GBTCLK_M2C_p,
//      //input    [ 1: 0]   FMCP_REFCLK_p, //GTSL1A_REFCLK_100M_p, : GTSL1B_REFCLK_156M25_p
//		input    [ 0: 0]   FMCP_REFCLK_p, //GTSL1A_REFCLK_100M_p, : GTSL1B_REFCLK_156M25_p
//      inout    [ 1: 0]   FMCP_RES,
//      inout              FMCP_SCL,
//      inout              FMCP_SDA,
////`endif /*ENABLE_FMCP*/

      ///////// SMA /////////
      input              SMA_CLKIN_p,

`ifdef ENABLE_PCIE //<------4A
      ///////// PCIE 4A /////////
      inout              PCIE_SMBCLK,
      inout              PCIE_SMBDAT,
      output   [ 3: 0]   PCIE_TX_p,
      output   [ 3: 0]   PCIE_TX_n,
      input    [ 3: 0]   PCIE_RX_p,
      input    [ 3: 0]   PCIE_RX_n,
      input              PCIE_REFCLK_p,
      input              PCIE_PERST_n,
`endif /*ENABLE_PCIE*/

`ifdef ENABLE_QSFP //4B
      ///////// QSFP /////////
      output   [ 3: 0]   QSFP_TX_p,
      output   [ 3: 0]   QSFP_TX_n,
      input    [ 3: 0]   QSFP_RX_p,
      input    [ 3: 0]   QSFP_RX_n,
     // input              CIPRI_REFCLK_p, //GTSR4B_REFCLK_184M32_p
      input              QSFP_REFCLK_p,    //Si5340B out1, GTSR4B_REFCLK_156M25_p
      input              QSFP_INTERRUPT_n,
      output             QSFP_LP_MODE,
      input              QSFP_MOD_PRS_n,
      output             QSFP_MOD_SEL_n,
      output             QSFP_RST_n,
      inout              QSFP_SCL,
      inout              QSFP_SDA,
`endif /*ENABLE_QSFP*/

      ///////// CAM /////////
      input              CAM_RZQ1, //RZQ_B_2A_T

`ifdef ENABLE_CAM1
      ///////// CAM1 /////////
      input              CAM1_CLK_p,
      input              CAM1_CLK_n,
      input    [ 3: 0]   CAM1_D_p,
      input    [ 3: 0]   CAM1_D_n,
      inout              CAM1_I2C_SCL,
      inout              CAM1_I2C_SDA,
      inout              CAM1_GPIO,
`endif /*ENABLE_CAM1*/

`ifdef ENABLE_CAM2
      ///////// CAM2 /////////
      input              CAM2_CLK_p,
      input              CAM2_CLK_n,
      input    [ 3: 0]   CAM2_D_p,
      input    [ 3: 0]   CAM2_D_n,
      inout              CAM2_I2C_SCL,
      inout              CAM2_I2C_SDA,
      inout              CAM2_GPIO,
`endif /*ENABLE_CAM2*/

`ifdef ENABLE_GTSL1A
      ///////// GTSL1A /////////
      input              GTSL1A_REFCLK_100M_p,
`endif /*ENABLE_GTSL1A*/

`ifdef ENABLE_GTSL1B
      ///////// GTSL1B /////////
      input              GTSL1B_REFCLK_156M25_p,
`endif /*ENABLE_GTSL1B*/

`ifdef ENABLE_GTSL1C
      ///////// GTSL1C /////////
      input              GTSL1C_REFCLK_100M_p,
`endif /*ENABLE_GTSL1C*/

`ifdef ENABLE_GTSR4A
      ///////// GTSR4A /////////
      input              GTSR4A_REFCLK_148M5_p,
`endif /*ENABLE_GTSR4A*/

`ifdef ENABLE_GTSR4C
      ///////// GTSR4C /////////
      input              GTSR4C_REFCLK_100M_p,
`endif /*ENABLE_GTSR4C*/


`ifdef ENABLE_HPS
      ///////// HPS /////////
      output             HPS_ENET_MDC,
      inout              HPS_ENET_MDIO,
      input              HPS_ENET_RX_CLK,
      input              HPS_ENET_RX_CTL,
      input    [ 3: 0]   HPS_ENET_RX_DATA,
      output             HPS_ENET_TX_CLK,
      output             HPS_ENET_TX_CTL,
      output   [ 3: 0]   HPS_ENET_TX_DATA,
      inout              HPS_IOA_10, //reserved for vendor test
      inout              HPS_IOA_11, //reserved for vendor test
      inout              HPS_IOA_12, //reserved for vendor test
      inout              HPS_IOA_5, //reserved for vendor test
      inout              HPS_IOA_6, //reserved for vendor test
      inout              HPS_IOA_9, //reserved for vendor test
      inout              HPS_IOB_10, //reserved for vendor test
      inout              HPS_IOB_11, //reserved for vendor test
      inout              HPS_IOB_12, //reserved for vendor test
      inout              HPS_IOB_9, //reserved for vendor test
      inout              HPS_KEY,
      inout    [ 1: 0]   HPS_LED,
      input              HPS_OSC_CLK,
      output             HPS_SDMMC_CLK,
      inout              HPS_SDMMC_CMD,
      inout    [ 3: 0]   HPS_SDMMC_DATA,
      input              HPS_UART_RX,
      output             HPS_UART_TX,
      input              HPS_USB3_REFCLK_100M_p, //GTSL1C_REFCLK_100M_p
      input              HPS_USB3_SS_RX_n,
      input              HPS_USB3_SS_RX_p,
      output             HPS_USB3_SS_TX_n,
      output             HPS_USB3_SS_TX_p,
      input              HPS_USB_CLK,
      inout    [ 7: 0]   HPS_USB_DATA,
      input              HPS_USB_DIR,
      input              HPS_USB_ID,
      input              HPS_USB_NXT,
      output             HPS_USB_STP,
      output             HPS_USB_VBUS_CTRL,
      input              HPS_USB_VBUS_DET,
      input              HPS_USB_VBUS_FLT_n,
`endif /*ENABLE_HPS*/

      ///////// INFO /////////
      output             INFO_SPI_SCLK,
      input              INFO_SPI_MISO,
      output             INFO_SPI_MOSI,
      output             INFO_SPI_CS_n

);


//=======================================================
//  Structural coding
//=======================================================


//----------------heart 1HZ -----------------
wire M50_HZ ;
CLOCKMEM                  ck0( .reset(~BUTTON), .CLK(CLK_50_B5B),       .CLK_FREQ  (50_000_000),.CK_1HZ (M50_HZ) ) ;
wire pcie_HZ ;
CLOCKMEM  ckpcie_xcvr_ref_clk( .reset(~BUTTON), .CLK(pcie_xcvr_ref_clk),.CLK_FREQ  (100_000_000),.CK_1HZ (pcie_HZ) ) ;
wire qsfp_HZ ;
CLOCKMEM ckqsfp_xcvr_ref_clk ( .reset(~BUTTON), .CLK(qsfp_xcvr_ref_clk),.CLK_FREQ  (184_320_000),.CK_1HZ (qsfp_HZ) ) ;


//----view frequency by SignalTapeII --------
FRE_MEASURE fGTSR4B_REFCLK_156M25_Si5340_out1   ( .RESET_n(1),.MES_CLK (qsfp_xcvr_ref_clk)    , .HZ1(M50_HZ) , .FREQ( ) );//Si5340B out1
//FRE_MEASURE fFMCP_GBTCLK_M2C_p0                 ( .RESET_n(1),.MES_CLK (FMCP_GBTCLK_M2C_p0)   , .HZ1(M50_HZ) , .FREQ( ) );
FRE_MEASURE fpcie_xcvr_ref_clk                  ( .RESET_n(1),.MES_CLK (pcie_xcvr_ref_clk )   , .HZ1(M50_HZ) , .FREQ( ) );

//
////----------------LED Display -----------
assign USER_LED      = I2C_VALID ? M50_HZ  :0;
assign LED           = I2C_VALID ? qsfp_HZ :0;

//---------------Si5340 ROM Downloader ------------
wire I2C_VALID ;
wire NO_ACK;
wire clk_ready ; 
Si5340B_IP Si5340B_IP_inst( 
   .CLK_50M     ( CLK_50_B5B         ),
   .RESET_N     ( USER_BUTTON        ),//--- Trigger USER_BUTTON ,will output OUT1 184.32Mhz
   .I2C_SCL     ( SI5340B_I2C_SCL    ), 
   .I2C_SDA     ( SI5340B_I2C_SDA    ),
	.I2C_VALID   ( I2C_VALID          ),	
   .NO_ACK      ( NO_ACK             ),
	.clk_ready   ( clk_ready          )
);

//--- Trigger BUTTON ,will output OUT1 156.25Mhz ( return to default frequence ) 
assign SI5340B_RST_n  = BUTTON;		

//--- SI5391B OE SET ---
assign SI5340B_OE_n   =0;
	
//============================== for xcvr refclock bypass to user logic =============================
////////////////////
// bank1 xcvr reset ip signal
wire [11:0] srcss_bank1_rs_grant;
wire [11:0] srcss_bank1_rs_priority;
wire [11:0] srcss_bank1_rc_rs_req;
wire [2:0] srcss_bank1_pma_cu_clk;
////////////////////
// bank4 xcvr reset ip signal

wire [11:0] srcss_bank4_rs_grant;
wire [11:0] srcss_bank4_rs_priority;
wire [11:0] srcss_bank4_rc_rs_req;
wire [2:0]  srcss_bank4_pma_cu_clk;


wire [0:0]  qsfp_tx_reset;
wire [0:0]  qsfp_rx_reset;
wire [0:0]	qsfp_tx_reset_ack;
wire [0:0]	qsfp_rx_reset_ack;
wire [0:0]	qsfp_tx_ready;
wire [0:0]	qsfp_rx_ready;
wire [3:0]	qsfp_tx_pll_locked;
wire [3:0]	qsfp_rx_is_lockedtodata;
wire [3:0]	qsfp_rx_is_lockedtoref;
//wire     	qsfp_systempll_lock;
wire     	qsfp_systempll_refclk_rdy;

wire [0:0]  pcie_tx_reset;
wire [0:0]  pcie_rx_reset;
wire [0:0]	pcie_tx_reset_ack;
wire [0:0]	pcie_rx_reset_ack;
wire [0:0]	pcie_tx_ready;
wire [0:0]	pcie_rx_ready;
wire [3:0]	pcie_tx_pll_locked;
wire [3:0]	pcie_rx_is_lockedtodata;
wire [3:0]	pcie_rx_is_lockedtoref;
//wire     	pcie_systempll_lock;
wire     	pcie_systempll_refclk_rdy;



wire [0:0]  usb3_tx_reset;
wire [0:0]  usb3_rx_reset;
wire [0:0]	usb3_tx_reset_ack;
wire [0:0]	usb3_rx_reset_ack;
wire [0:0]	usb3_tx_ready;
wire [0:0]	usb3_rx_ready;
wire [3:0]	usb3_tx_pll_locked;
wire [3:0]	usb3_rx_is_lockedtodata;
wire [3:0]	usb3_rx_is_lockedtoref;
wire     	usb3_systempll_lock;
wire     	usb3_systempll_refclk_rdy;

wire [0:0]  fmcp_4a_tx_reset;
wire [0:0]  fmcp_4a_rx_reset;
wire [0:0]	fmcp_4a_tx_reset_ack;
wire [0:0]	fmcp_4a_rx_reset_ack;
wire [0:0]	fmcp_4a_tx_ready;
wire [0:0]	fmcp_4a_rx_ready;
wire [3:0]	fmcp_4a_tx_pll_locked;
wire [3:0]	fmcp_4a_rx_is_lockedtodata;
wire [3:0]	fmcp_4a_rx_is_lockedtoref;
//wire     	fmcp_4a_systempll_lock;
wire     	fmcp_4a_systempll_refclk_rdy;


wire [0:0]  fmcp_4b_tx_reset;
wire [0:0]  fmcp_4b_rx_reset;
wire [0:0]	fmcp_4b_tx_reset_ack;
wire [0:0]	fmcp_4b_rx_reset_ack;
wire [0:0]	fmcp_4b_tx_ready;
wire [0:0]	fmcp_4b_rx_ready;
wire [3:0]	fmcp_4b_tx_pll_locked;
wire [3:0]	fmcp_4b_rx_is_lockedtodata;
wire [3:0]	fmcp_4b_rx_is_lockedtoref;
//wire     	fmcp_4b_systempll_lock;
wire     	fmcp_4b_systempll_refclk_rdy;




wire [0:0]  fmcp_4c_tx_reset;
wire [0:0]  fmcp_4c_rx_reset;
wire [0:0]	fmcp_4c_tx_reset_ack;
wire [0:0]	fmcp_4c_rx_reset_ack;
wire [0:0]	fmcp_4c_tx_ready;
wire [0:0]	fmcp_4c_rx_ready;
wire [3:0]	fmcp_4c_tx_pll_locked;
wire [3:0]	fmcp_4c_rx_is_lockedtodata;
wire [3:0]	fmcp_4c_rx_is_lockedtoref;
//wire     	fmcp_4c_systempll_lock;
wire     	fmcp_4c_systempll_refclk_rdy;



assign qsfp_systempll_refclk_rdy = 1'b1; //QSFP_REFCLK_p is free run. always ready
assign pcie_systempll_refclk_rdy = 1'b1; //PCIE_OB_REFCLK_p is free run. always ready
assign fmcp_4a_systempll_refclk_rdy = 1'b1; //QSFP_REFCLK_p is free run. always ready
assign fmcp_4b_systempll_refclk_rdy = 1'b1;
assign fmcp_4c_systempll_refclk_rdy = 1'b1;

/*
Binary priority input
• 0 - Low priority
• 1 - High priority
This port used to set priority for a channel that you need to prioritize the reset sequence
when there are multiple channels being reset simultaneously. You must tie the input to 0
except for the priority channel which needs to be set to 1.
*/
assign srcss_bank1_rs_priority = 8'h00; // 0: low priority
assign srcss_bank4_rs_priority = 12'h000; // 0: low priority


wire qsfp_xcvr_ref_clk;
wire pcie_xcvr_ref_clk;
wire usb3_xcvr_ref_clk;
wire FMCP_GBTCLK_M2C_p0;
wire FMCP_GBTCLK_M2C_p1;
wire FMCP_GBTCLK_M2C_p2;


//----reset ini
wire reset_n, ninit_done;
reset_release reset_release (
	.ninit_done(ninit_done)
	);

assign reset_n = !ninit_done;

//----do xcvr refclock by pass user logic 
Qsys_XCVR_CLK Qsys_XCVR_CLK_Inst (
    
		.clk_clk                                                                       (CLK_50_B5B),                                                                       //   input,    width = 1,                                                         clk.clk
		.reset_reset_n                                                                 (reset_n),                                                                 //   input,    width = 1,                                                       reset.reset_n
        
		///////////////// xcvr 1A/1B
		// xcvr phy, xcvr reset, system pll
		  
      .intel_srcss_gts_bank1_o_src_rs_grant_src_rs_grant                             (srcss_bank1_rs_grant),                          //  output,   width = 4,                  intel_srcss_gts_bank1_o_src_rs_grant.src_rs_grant
      .intel_srcss_gts_bank1_i_src_rs_priority_src_rs_priority                       (srcss_bank1_rs_priority),                    //   input,   width = 4,               intel_srcss_gts_bank1_i_src_rs_priority.src_rs_priority
      .intel_srcss_gts_bank1_i_src_rs_req_src_rs_req                                 (srcss_bank1_rc_rs_req),                              //   input,   width = 4,                    intel_srcss_gts_bank1_i_src_rs_req.src_rs_req
      .intel_srcss_gts_bank1_o_pma_cu_clk_clk                                        (srcss_bank1_pma_cu_clk),                                     //  output,   width = 1,                    intel_srcss_gts_bank1_o_pma_cu_clk.clk
		  
         // bank4 reset  		  
      .intel_srcss_gts_bank4_o_src_rs_grant_src_rs_grant                             (srcss_bank4_rs_grant),                             //  output,   width = 12,                     intel_srcss_gts_bank4_o_src_rs_grant.src_rs_grant
      .intel_srcss_gts_bank4_i_src_rs_priority_src_rs_priority                       (srcss_bank4_rs_priority),                       //   input,   width = 12,                  intel_srcss_gts_bank4_i_src_rs_priority.src_rs_priority
      .intel_srcss_gts_bank4_i_src_rs_req_src_rs_req                                 (srcss_bank4_rc_rs_req),                                 //   input,   width = 12,                       intel_srcss_gts_bank4_i_src_rs_req.src_rs_req
      .intel_srcss_gts_bank4_o_pma_cu_clk_clk                                        (srcss_bank4_pma_cu_clk),                                         //  output,   width = 3,                       intel_srcss_gts_bank4_o_pma_cu_clk.clk
			
		// 4A : PCIe  
		.xcvr_pcie_x4_clock_bridge_xcvr_pma_rx_refclk_in_clk_clk                       (PCIE_REFCLK_p),                       //   input,    width = 1,      xcvr_pcie_x4_clock_bridge_xcvr_pma_rx_refclk_in_clk.clk
		.xcvr_pcie_x4_clock_bridge_xcvr_pma_tx_refclk_in_clk_clk                       (PCIE_REFCLK_p),                       //   input,    width = 1,      xcvr_pcie_x4_clock_bridge_xcvr_pma_tx_refclk_in_clk.clk
		.xcvr_pcie_x4_intel_directphy_gts_x4_i_pma_cu_clk_clk                          (srcss_bank1_pma_cu_clk[0]),                          //   input,    width = 1,         xcvr_pcie_x4_intel_directphy_gts_x4_i_pma_cu_clk.clk
		.xcvr_pcie_x4_intel_directphy_gts_x4_i_system_pll_lock_system_pll_lock         (pcie_systempll_lock),         //   input,    width = 1,    xcvr_pcie_x4_intel_directphy_gts_x4_i_system_pll_lock.system_pll_lock
		.xcvr_pcie_x4_intel_directphy_gts_x4_i_tx_reset_tx_reset                       (pcie_tx_reset),                       //   input,    width = 1,           xcvr_pcie_x4_intel_directphy_gts_x4_i_tx_reset.tx_reset
		.xcvr_pcie_x4_intel_directphy_gts_x4_i_rx_reset_rx_reset                       (pcie_rx_reset),                       //   input,    width = 1,           xcvr_pcie_x4_intel_directphy_gts_x4_i_rx_reset.rx_reset
		.xcvr_pcie_x4_intel_directphy_gts_x4_o_tx_reset_ack_tx_reset_ack               (pcie_tx_reset_ack),               //  output,    width = 1,       xcvr_pcie_x4_intel_directphy_gts_x4_o_tx_reset_ack.tx_reset_ack
		.xcvr_pcie_x4_intel_directphy_gts_x4_o_rx_reset_ack_rx_reset_ack               (pcie_rx_reset_ack),               //  output,    width = 1,       xcvr_pcie_x4_intel_directphy_gts_x4_o_rx_reset_ack.rx_reset_ack
		.xcvr_pcie_x4_intel_directphy_gts_x4_o_tx_ready_tx_ready                       (pcie_tx_ready),                       //  output,    width = 1,           xcvr_pcie_x4_intel_directphy_gts_x4_o_tx_ready.tx_ready
		.xcvr_pcie_x4_intel_directphy_gts_x4_o_rx_ready_rx_ready                       (pcie_rx_ready),                       //  output,    width = 1,           xcvr_pcie_x4_intel_directphy_gts_x4_o_rx_ready.rx_ready
		.xcvr_pcie_x4_intel_directphy_gts_x4_i_src_rs_grant_src_rs_grant               (srcss_bank1_rs_grant[3:0]),               //   input,    width = 4,       xcvr_pcie_x4_intel_directphy_gts_x4_i_src_rs_grant.src_rs_grant
		.xcvr_pcie_x4_intel_directphy_gts_x4_o_src_rs_req_src_rs_req                   (srcss_bank1_rc_rs_req[3:0]),                   //  output,    width = 4,         xcvr_pcie_x4_intel_directphy_gts_x4_o_src_rs_req.src_rs_req
		.xcvr_pcie_x4_intel_directphy_gts_x4_o_tx_serial_data_o_tx_serial_data         (PCIE_TX_p),         //  output,    width = 4,     xcvr_pcie_x4_intel_directphy_gts_x4_o_tx_serial_data.o_tx_serial_data
		.xcvr_pcie_x4_intel_directphy_gts_x4_o_tx_serial_data_n_o_tx_serial_data_n     (PCIE_TX_n),     //  output,    width = 4,   xcvr_pcie_x4_intel_directphy_gts_x4_o_tx_serial_data_n.o_tx_serial_data_n
		.xcvr_pcie_x4_intel_directphy_gts_x4_i_rx_serial_data_i_rx_serial_data         (PCIE_RX_p),         //   input,    width = 4,     xcvr_pcie_x4_intel_directphy_gts_x4_i_rx_serial_data.i_rx_serial_data
		.xcvr_pcie_x4_intel_directphy_gts_x4_i_rx_serial_data_n_i_rx_serial_data_n     (PCIE_RX_n),     //   input,    width = 4,   xcvr_pcie_x4_intel_directphy_gts_x4_i_rx_serial_data_n.i_rx_serial_data_n
		.xcvr_pcie_x4_intel_directphy_gts_x4_o_tx_pll_locked_o_tx_pll_locked           (pcie_tx_pll_locked),           //  output,    width = 4,      xcvr_pcie_x4_intel_directphy_gts_x4_o_tx_pll_locked.o_tx_pll_locked
		.xcvr_pcie_x4_intel_directphy_gts_x4_o_rx_is_lockedtodata_o_rx_is_lockedtodata (pcie_rx_is_lockedtodata), //  output,    width = 4, xcvr_pcie_x4_intel_directphy_gts_x4_o_rx_is_lockedtodata.o_rx_is_lockedtodata
		.xcvr_pcie_x4_intel_directphy_gts_x4_o_rx_is_lockedtoref_o_rx_is_lockedtoref   (pcie_rx_is_lockedtoref),   //  output,    width = 4,  xcvr_pcie_x4_intel_directphy_gts_x4_o_rx_is_lockedtoref.o_rx_is_lockedtoref
		.xcvr_pcie_x4_intel_directphy_gts_x4_i_tx_parallel_data_i_tx_parallel_data     (),     //   input,  width = 320,   xcvr_pcie_x4_intel_directphy_gts_x4_i_tx_parallel_data.i_tx_parallel_data
		.xcvr_pcie_x4_intel_directphy_gts_x4_o_rx_parallel_data_o_rx_parallel_data     (),     //  output,  width = 320,   xcvr_pcie_x4_intel_directphy_gts_x4_o_rx_parallel_data.o_rx_parallel_data
		.xcvr_pcie_x4_intel_systemclk_gts_o_pll_lock_o_pll_lock                        (pcie_systempll_lock),                        //  output,    width = 1,              xcvr_pcie_x4_intel_systemclk_gts_o_pll_lock.o_pll_lock
		.xcvr_pcie_x4_intel_systemclk_gts_i_refclk_rdy_data                            (pcie_systempll_refclk_rdy),                            //   input,    width = 1,            xcvr_pcie_x4_intel_systemclk_gts_i_refclk_rdy.data
	   .xcvr_pcie_x4_intel_directphy_gts_x4_o_refclk2core_o_refclk2core               (pcie_xcvr_ref_clk),               //  output,    width = 1,        xcvr_pcie_x4_intel_directphy_gts_x4_o_refclk2core.o_refclk2core		  
		  
        
		  // 4B: qsfp
        .xcvr_qsfp_clock_bridge_xcvr_syspll_ref_in_clk_clk                          (QSFP_REFCLK_p   ),//CIPRI_REFCLK_p), //Si5340B out1                         //   input,   width = 1,         xcvr_qsfp_clock_bridge_xcvr_syspll_ref_in_clk.clk
        .xcvr_qsfp_intel_directphy_gts_x4_i_pma_cu_clk_clk                          (srcss_bank1_pma_cu_clk[1]),                          //   input,   width = 1,         xcvr_qsfp_intel_directphy_gts_x4_i_pma_cu_clk.clk
        .xcvr_qsfp_intel_directphy_gts_x4_i_system_pll_lock_system_pll_lock         (qsfp_systempll_lock),         //   input,   width = 1,    xcvr_qsfp_intel_directphy_gts_x4_i_system_pll_lock.system_pll_lock
        .xcvr_qsfp_intel_directphy_gts_x4_i_src_rs_grant_src_rs_grant               (srcss_bank1_rs_grant[7:4]),               //   input,   width = 4,       xcvr_qsfp_intel_directphy_gts_x4_i_src_rs_grant.src_rs_grant
        .xcvr_qsfp_intel_directphy_gts_x4_o_src_rs_req_src_rs_req                   (srcss_bank1_rc_rs_req[7:4]),                   //  output,   width = 4,         xcvr_qsfp_intel_directphy_gts_x4_o_src_rs_req.src_rs_req
		  .xcvr_qsfp_intel_directphy_gts_x4_o_refclk2core_o_refclk2core               (qsfp_xcvr_ref_clk),                  //  output,    width = 1,           xcvr_qsfp_intel_directphy_gts_x4_o_refclk2core.o_refclk2core		  
        .xcvr_qsfp_intel_directphy_gts_x4_i_tx_reset_tx_reset                       (qsfp_tx_reset),                       //   input,   width = 1,           xcvr_qsfp_intel_directphy_gts_x4_i_tx_reset.tx_reset
        .xcvr_qsfp_intel_directphy_gts_x4_i_rx_reset_rx_reset                       (qsfp_rx_reset),                       //   input,   width = 1,           xcvr_qsfp_intel_directphy_gts_x4_i_rx_reset.rx_reset
        .xcvr_qsfp_intel_directphy_gts_x4_o_tx_reset_ack_tx_reset_ack               (qsfp_tx_reset_ack),               //  output,   width = 1,       xcvr_qsfp_intel_directphy_gts_x4_o_tx_reset_ack.tx_reset_ack
        .xcvr_qsfp_intel_directphy_gts_x4_o_rx_reset_ack_rx_reset_ack               (qsfp_rx_reset_ack),               //  output,   width = 1,       xcvr_qsfp_intel_directphy_gts_x4_o_rx_reset_ack.rx_reset_ack
        .xcvr_qsfp_intel_directphy_gts_x4_o_tx_ready_tx_ready                       (qsfp_tx_ready),                       //  output,   width = 1,           xcvr_qsfp_intel_directphy_gts_x4_o_tx_ready.tx_ready
        .xcvr_qsfp_intel_directphy_gts_x4_o_rx_ready_rx_ready                       (qsfp_rx_ready),                       //  output,   width = 1,           xcvr_qsfp_intel_directphy_gts_x4_o_rx_ready.rx_ready
        .xcvr_qsfp_intel_directphy_gts_x4_o_tx_serial_data_o_tx_serial_data         (QSFP_TX_p),         //  output,   width = 4,     xcvr_qsfp_intel_directphy_gts_x4_o_tx_serial_data.o_tx_serial_data
        .xcvr_qsfp_intel_directphy_gts_x4_o_tx_serial_data_n_o_tx_serial_data_n     (QSFP_TX_n),     //  output,   width = 4,   xcvr_qsfp_intel_directphy_gts_x4_o_tx_serial_data_n.o_tx_serial_data_n
        .xcvr_qsfp_intel_directphy_gts_x4_i_rx_serial_data_i_rx_serial_data         (QSFP_RX_p),         //   input,   width = 4,     xcvr_qsfp_intel_directphy_gts_x4_i_rx_serial_data.i_rx_serial_data
        .xcvr_qsfp_intel_directphy_gts_x4_i_rx_serial_data_n_i_rx_serial_data_n     (QSFP_RX_n),     //   input,   width = 4,   xcvr_qsfp_intel_directphy_gts_x4_i_rx_serial_data_n.i_rx_serial_data_n
        .xcvr_qsfp_intel_directphy_gts_x4_o_tx_pll_locked_o_tx_pll_locked           (qsfp_tx_pll_locked),           //  output,   width = 4,      xcvr_qsfp_intel_directphy_gts_x4_o_tx_pll_locked.o_tx_pll_locked
        .xcvr_qsfp_intel_directphy_gts_x4_o_rx_is_lockedtodata_o_rx_is_lockedtodata (qsfp_rx_is_lockedtodata), //  output,   width = 4, xcvr_qsfp_intel_directphy_gts_x4_o_rx_is_lockedtodata.o_rx_is_lockedtodata
        .xcvr_qsfp_intel_directphy_gts_x4_o_rx_is_lockedtoref_o_rx_is_lockedtoref   (qsfp_rx_is_lockedtoref),   //  output,   width = 4,  xcvr_qsfp_intel_directphy_gts_x4_o_rx_is_lockedtoref.o_rx_is_lockedtoref
        .xcvr_qsfp_intel_systemclk_gts_o_pll_lock_o_pll_lock                        (qsfp_systempll_lock),                        //  output,   width = 1,              xcvr_qsfp_intel_systemclk_gts_o_pll_lock.o_pll_lock
        .xcvr_qsfp_intel_systemclk_gts_i_refclk_rdy_data                            (qsfp_systempll_refclk_rdy)                             //   input,   width = 1,            xcvr_qsfp_intel_systemclk_gts_i_refclk_rdy.data
		
		  
		  
		
		////	//////////////// FMCP 1B
		//	// 1B
      //  .xcvr_fmcp_x4_refclk0_clock_bridge_xcvr_pma_rx_refclk_in_clk_clk(GTSL1B_REFCLK_156M25_p ),//FMCP_GBTCLK_M2C_p[0]),                 //   input,    width = 1, xcvr_fmcp_x4_4a_clock_bridge_xcvr_pma_rx_refclk_in_clk.clk
      //  .xcvr_fmcp_x4_refclk0_clock_bridge_xcvr_pma_tx_refclk_in_clk_clk(GTSL1B_REFCLK_156M25_p ),//FMCP_GBTCLK_M2C_p[0]),                 //   input,    width = 1, xcvr_fmcp_x4_4a_clock_bridge_xcvr_pma_tx_refclk_in_clk.clk
      //  .xcvr_fmcp_x4_refclk0_i_pma_cu_clk_clk                          (srcss_bank4_pma_cu_clk[2]),                          //   input,   width = 1,         xcvr_fmcp_4a_intel_directphy_gts_x4_i_pma_cu_clk.clk
      //  .xcvr_fmcp_x4_refclk0_i_system_pll_lock_system_pll_lock         (fmcp_4a_systempll_lock),         //   input,   width = 1,    xcvr_fmcp_4a_intel_directphy_gts_x4_i_system_pll_lock.system_pll_lock
      //  .xcvr_fmcp_x4_refclk0_i_tx_reset_tx_reset                       (fmcp_4a_tx_reset),                       //   input,   width = 1,           xcvr_fmcp_4a_intel_directphy_gts_x4_i_tx_reset.tx_reset
      //  .xcvr_fmcp_x4_refclk0_i_rx_reset_rx_reset                       (fmcp_4a_rx_reset),                       //   input,   width = 1,           xcvr_fmcp_4a_intel_directphy_gts_x4_i_rx_reset.rx_reset
      //  .xcvr_fmcp_x4_refclk0_o_tx_reset_ack_tx_reset_ack               (fmcp_4a_tx_reset_ack),               //  output,   width = 1,       xcvr_fmcp_4a_intel_directphy_gts_x4_o_tx_reset_ack.tx_reset_ack
      //  .xcvr_fmcp_x4_refclk0_o_rx_reset_ack_rx_reset_ack               (fmcp_4a_rx_reset_ack),               //  output,   width = 1,       xcvr_fmcp_4a_intel_directphy_gts_x4_o_rx_reset_ack.rx_reset_ack
      //  .xcvr_fmcp_x4_refclk0_o_tx_ready_tx_ready                       (fmcp_4a_tx_ready),                       //  output,   width = 1,           xcvr_fmcp_4a_intel_directphy_gts_x4_o_tx_ready.tx_ready
      //  .xcvr_fmcp_x4_refclk0_o_rx_ready_rx_ready                       (fmcp_4a_rx_ready),                       //  output,   width = 1,           xcvr_fmcp_4a_intel_directphy_gts_x4_o_rx_ready.rx_ready
      //  .xcvr_fmcp_x4_refclk0_i_src_rs_grant_src_rs_grant               (srcss_bank4_rs_grant[11:8]),               //   input,   width = 4,       xcvr_fmcp_4a_intel_directphy_gts_x4_i_src_rs_grant.src_rs_grant
      //  .xcvr_fmcp_x4_refclk0_o_src_rs_req_src_rs_req                   (srcss_bank4_rc_rs_req[11:8]),                   //  output,   width = 4,         xcvr_fmcp_4a_intel_directphy_gts_x4_o_src_rs_req.src_rs_req
      //  .xcvr_fmcp_x4_refclk0_o_tx_serial_data_o_tx_serial_data         (FMCP_DP_C2M_p[3:0]),         //  output,   width = 4,     xcvr_fmcp_4a_intel_directphy_gts_x4_o_tx_serial_data.o_tx_serial_data
      //  .xcvr_fmcp_x4_refclk0_o_tx_serial_data_n_o_tx_serial_data_n     (FMCP_DP_C2M_n[3:0]),     //  output,   width = 4,   xcvr_fmcp_4a_intel_directphy_gts_x4_o_tx_serial_data_n.o_tx_serial_data_n
      //  .xcvr_fmcp_x4_refclk0_i_rx_serial_data_i_rx_serial_data         (FMCP_DP_M2C_p[3:0]),         //   input,   width = 4,     xcvr_fmcp_4a_intel_directphy_gts_x4_i_rx_serial_data.i_rx_serial_data
      //  .xcvr_fmcp_x4_refclk0_i_rx_serial_data_n_i_rx_serial_data_n     (FMCP_DP_M2C_n[3:0]),     //   input,   width = 4,   xcvr_fmcp_4a_intel_directphy_gts_x4_i_rx_serial_data_n.i_rx_serial_data_n
      //  .xcvr_fmcp_x4_refclk0_i_tx_parallel_data_i_tx_parallel_data     (),                      //   input,  width = 320,                    xcvr_fmcp_x4_4b_i_tx_parallel_data.i_tx_parallel_data
      //  .xcvr_fmcp_x4_refclk0_o_rx_parallel_data_o_rx_parallel_data     (),                      //  output,  width = 320,                    xcvr_fmcp_x4_4b_o_rx_parallel_data.o_rx_parallel_data
      //  .xcvr_fmcp_x4_refclk0_o_tx_pll_locked_o_tx_pll_locked           (fmcp_4a_tx_pll_locked),           //  output,   width = 4,      xcvr_fmcp_4a_intel_directphy_gts_x4_o_tx_pll_locked.o_tx_pll_locked
      //  .xcvr_fmcp_x4_refclk0_o_rx_is_lockedtodata_o_rx_is_lockedtodata (fmcp_4a_rx_is_lockedtodata), //  output,   width = 4, xcvr_fmcp_4a_intel_directphy_gts_x4_o_rx_is_lockedtodata.o_rx_is_lockedtodata
      //  .xcvr_fmcp_x4_refclk0_o_rx_is_lockedtoref_o_rx_is_lockedtoref   (fmcp_4a_rx_is_lockedtoref),   //  output,   width = 4,  xcvr_fmcp_4a_intel_directphy_gts_x4_o_rx_is_lockedtoref.o_rx_is_lockedtoref
      //  .xcvr_fmcp_x4_refclk0_intel_systemclk_gts_o_pll_lock_o_pll_lock (fmcp_4a_systempll_lock),                        //  output,   width = 1,              xcvr_fmcp_4a_intel_systemclk_gts_o_pll_lock.o_pll_lock
      //  .xcvr_fmcp_x4_refclk0_intel_systemclk_gts_i_refclk_rdy_data     (fmcp_4a_systempll_refclk_rdy),                            //   input,   width = 1,            xcvr_fmcp_4a_intel_systemclk_gts_i_refclk_rdy.data		 
		//  .xcvr_fmcp_x4_refclk0_intel_directphy_gts_x4_o_refclk2core_o_refclk2core    (FMCP_GBTCLK_M2C_p0)          //  output,    width = 1,     xcvr_fmcp_x4_4a_intel_directphy_gts_x4_o_refclk2core.o_refclk2core 		  		  
		//  
		//  		  
		     
	);

	 

endmodule


