// si5340B_rom_rom_1port_intel_mce_arb_2022_swx6o7y.v

// Generated using ACDS version 25.3 109

`timescale 1 ps / 1 ps
module si5340B_rom_rom_1port_intel_mce_arb_2022_swx6o7y #(
		parameter LATENCY           = 2,
		parameter DATA_WIDTH        = 24,
		parameter WIDTHAD           = 10,
		parameter BYTE_ENABLE_WIDTH = 1
	) (
		input  wire        clk,               //      mm_clk.clk
		input  wire        reset,             //       reset.reset
		input  wire [9:0]  uaddr,             //    user_slv.address
		input  wire [0:0]  ubyteena,          //            .byteenable
		input  wire [23:0] uwdata,            //            .write
		input  wire        urden,             //            .read
		input  wire        uwren,             //            .writeenable
		input  wire        uaddressstall,     //            .addressstall
		output wire [23:0] urdata,            //            .readdata
		input  wire [9:0]  ismce_addr,        // ismce_slave.address
		input  wire [0:0]  ismce_byteena,     //            .byteenable
		input  wire [23:0] ismce_wdata,       //            .writedata
		input  wire        ismce_wren,        //            .write
		input  wire        ismce_rden,        //            .read
		output wire [23:0] ismce_rdata,       //            .readdata
		output wire        ismce_waitrequest, //            .waitrequest
		output wire [9:0]  addr,              //  ram_master.address
		output wire [0:0]  byteena,           //            .byteenable
		output wire [23:0] wdata,             //            .writedata
		output wire        rden,              //            .read
		output wire        wren,              //            .write
		output wire        addressstall,      //            .addressstall
		input  wire [23:0] rdata              //            .readdata
	);

	generate
		// If any of the display statements (or deliberately broken
		// instantiations) within this generate block triggers then this module
		// has been instantiated this module with a set of parameters different
		// from those it was generated for.  This will usually result in a
		// non-functioning system.
		if (LATENCY != 2)
		begin
		// synthesis translate_off
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
		// synthesis translate_on
			instantiated_with_wrong_parameters_error_see_comment_above
					latency_check ( .error(1'b1) );
		end
		if (DATA_WIDTH != 24)
		begin
		// synthesis translate_off
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
		// synthesis translate_on
			instantiated_with_wrong_parameters_error_see_comment_above
					data_width_check ( .error(1'b1) );
		end
		if (WIDTHAD != 10)
		begin
		// synthesis translate_off
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
		// synthesis translate_on
			instantiated_with_wrong_parameters_error_see_comment_above
					widthad_check ( .error(1'b1) );
		end
		if (BYTE_ENABLE_WIDTH != 1)
		begin
		// synthesis translate_off
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
		// synthesis translate_on
			instantiated_with_wrong_parameters_error_see_comment_above
					byte_enable_width_check ( .error(1'b1) );
		end
	endgenerate

	altera_sld_arbiter_top #(
		.LATENCY           (2),
		.DATA_WIDTH        (24),
		.WIDTHAD           (10),
		.BYTE_ENABLE_WIDTH (1)
	) intel_mce_arb_inst (
		.clk               (clk),               //   input,   width = 1,      mm_clk.clk
		.reset             (reset),             //   input,   width = 1,       reset.reset
		.uaddr             (uaddr),             //   input,  width = 10,    user_slv.address
		.ubyteena          (ubyteena),          //   input,   width = 1,            .byteenable
		.uwdata            (uwdata),            //   input,  width = 24,            .write
		.urden             (urden),             //   input,   width = 1,            .read
		.uwren             (uwren),             //   input,   width = 1,            .writeenable
		.uaddressstall     (uaddressstall),     //   input,   width = 1,            .addressstall
		.urdata            (urdata),            //  output,  width = 24,            .readdata
		.ismce_addr        (ismce_addr),        //   input,  width = 10, ismce_slave.address
		.ismce_byteena     (ismce_byteena),     //   input,   width = 1,            .byteenable
		.ismce_wdata       (ismce_wdata),       //   input,  width = 24,            .writedata
		.ismce_wren        (ismce_wren),        //   input,   width = 1,            .write
		.ismce_rden        (ismce_rden),        //   input,   width = 1,            .read
		.ismce_rdata       (ismce_rdata),       //  output,  width = 24,            .readdata
		.ismce_waitrequest (ismce_waitrequest), //  output,   width = 1,            .waitrequest
		.addr              (addr),              //  output,  width = 10,  ram_master.address
		.byteena           (byteena),           //  output,   width = 1,            .byteenable
		.wdata             (wdata),             //  output,  width = 24,            .writedata
		.rden              (rden),              //  output,   width = 1,            .read
		.wren              (wren),              //  output,   width = 1,            .write
		.addressstall      (addressstall),      //  output,   width = 1,            .addressstall
		.rdata             (rdata)              //   input,  width = 24,            .readdata
	);

endmodule
