// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


//--------------------------------------------------------------------
//--
//--  Copyright (C) 1991-2015 Altera Corporation. All rights reserved.
//--
//--  Your use of Altera Corporation's design tools, logic functions  
//--  and other software and tools, and its AMPP partner logic  
//--  functions, and any output files from any of the foregoing  
//--  (including device programming or simulation files), and any  
//--  associated documentation or information are expressly subject  
//--  to the terms and conditions of the Altera Program License  
//--  Subscription Agreement, Altera MegaCore Function License  
//--  Agreement, or other applicable license agreement, including,  
//--  without limitation, that your use is for the sole purpose of  
//--  programming logic devices manufactured by Altera and sold by  
//--  Altera or its authorized distributors.  Please refer to the  
//--  applicable agreement for further details. 
//--
//--------------------------------------------------------------------

//-------------------------------------------------------------------
// Filename    : altera_sld_arbiter_top.v
//
// Description : Muxing user_read/write and ismce_read/write with user signals has priority.
//
// Limitation  : Meant for Stratix 10 and beyond
//
//-------------------------------------------------------------------

module altera_sld_arbiter_top
    #(
        parameter LATENCY = 2,
        parameter DATA_WIDTH = 32,
        parameter WIDTHAD = 8,
        parameter BYTE_ENABLE_WIDTH = 1
    )
    (
        // Clocks / Reset
        input clk,
        // reset not used but keep for future    
        input reset,

        // User mem signals
        input[WIDTHAD-1:0] uaddr,
        input[BYTE_ENABLE_WIDTH-1:0] ubyteena,
        input[DATA_WIDTH-1:0] uwdata,
        input urden,
        input uwren,
        input uaddressstall,
        output[DATA_WIDTH-1:0] urdata,

        // ISMCE mem signals to arbiter
        input [WIDTHAD-1:0]  ismce_addr,
        input [BYTE_ENABLE_WIDTH-1:0] ismce_byteena,
        input [DATA_WIDTH-1:0]  ismce_wdata,
        input                   ismce_wren,
        input                   ismce_rden,
        output[DATA_WIDTH-1:0]  ismce_rdata,
        output                  ismce_waitrequest,

        // Ram signals
        output[WIDTHAD-1:0] addr,
        output[BYTE_ENABLE_WIDTH-1:0] byteena,
        output[DATA_WIDTH-1:0] wdata,
        output rden,
        output wren,
        output addressstall,
        input[DATA_WIDTH-1:0] rdata
    );

altera_sld_arbiter #(
        .LATENCY           (LATENCY          ),
        .DATA_WIDTH        (DATA_WIDTH       ),
        .WIDTHAD           (WIDTHAD          ),
        .BYTE_ENABLE_WIDTH (BYTE_ENABLE_WIDTH)
    ) altera_sld_arbiter_inst  (
        .clk               (clk              ),
        .reset             (reset            ),
        .uaddr             (uaddr            ),
        .ubyteena          (ubyteena         ),
        .uwdata            (uwdata           ),
        .urden             (urden            ),
        .uwren             (uwren            ),
        .uaddressstall     (uaddressstall    ),
        .urdata            (urdata           ),
        .ismce_addr        (ismce_addr       ),
        .ismce_byteena     (ismce_byteena    ),
        .ismce_wdata       (ismce_wdata      ),
        .ismce_wren        (ismce_wren       ),
        .ismce_rden        (ismce_rden       ),
        .ismce_rdata       (ismce_rdata      ),
        .ismce_waitrequest (ismce_waitrequest),
        .addr              (addr             ),
        .byteena           (byteena          ),
        .wdata             (wdata            ),
        .rden              (rden             ),
        .wren              (wren             ),
        .addressstall      (addressstall     ),
        .rdata             (rdata            )
    );
    

endmodule 
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "gxUC0uHYGh5iTQS8ia15YhsMdiQ/QO3FIgn/CTziZ81FfcVb1wIu1TUDtUSAlPhrI8sFn2gLVFPYIAWgXa1CDIAxu7+Mu95EspuhkTIiZDKiE84F2bHA++ET8wpXBxIIzmaIhNXoKrqjdVZK86WH9pgYZAAHPFZVidAScxF2oS+ZuawRq7tLosd7KKtmNPpGbid6ZD6+4i3ffC0mporV3iLa8AJf3f5c/wtX4oOh5Pqvm0JvTZykjTnbkwISb5ne/S11Vgy0yTDhwfkpQG7+h/88QFNrqRj9vZhXN//5gUasWFisa5HlY96f/dGiMiOwFWLgMacG9s70jljbZTlzREFxYdVyspRm7c0xIOnsWQs4Fd9qBVQH79C5dH0Gc4nguYASWGA9iM4hHp1mvLkz8ORJt2ysauWuaE0DJ/v+WDi6s9gKjHbx3MDx7OY0ZU98qODoy730XQKfDQnTMZKUkefhn3t8ycipvStF6HjH+YFKF2EHQuhm3WVJAHZdeVY5uv8cPgRvKSIGiBEQYnWg0LL270XRxJGtMx9NNbTIKZPpx3Kk13VyYhwzroQELhN71oelhoyyhtb8mSkRvrdCaXPxHV+JbagDkh9mPjc3p3ac4VWQAbkJ5NXbZ+ZSvCQEpickf384JPAcaCIhVy9lqZ6E6bLML5Hf2nCik2p1M9XJAs0seIO+JaOGGeQMtPQFwxkob0UwXQLvi0YmbW/DBaYc2UxGDPPzqRJwgANp7QGsZ762gjyn5Bb0xFu/vzT5n86LNJDvqp5H6og/+Toi9pMKO78xsVA82X+YxAeCzlY1BmvZ8J4wUhHCUrnPxZGRhx6R+8LlMe0YUld56sVPSP/Ae5OUx7h3vY2XnDXv7/A2uqbpeMvgYA2Nyqqx3xo3yE74VGOcd4EEK+LYy6Cv1vZsLx4dSDGIQcKHC8lt/aKEKK4WCh3+dePWO51D++eW4J7wPYMyKUnbNLvSh8zP4B5N5wfFGYjKlkwZViGQFnXijCz4gAA2BpdUJOCcGyPz"
`endif