module Si5340B_IP( 
   input               CLK_50M,
   input               RESET_N, 
   inout               I2C_SCL, 
   inout               I2C_SDA,	
	output reg 		     I2C_VALID,	
	output reg          clk_ready ,
   output reg          time_VALID	,
	output reg [7:0]    Status,
	output              LOL_n , 
   output              CLK_400K,
   output              NO_ACK , //1 no_ack
	//-
	output reg [7:0] SLAVE_ADDR , 
   output reg [7:0] ST ,
   output reg [7:0] W_WORD_DATA,
   output reg [7:0] W_POINTER_REG,
	
	output           W_WORD_END ,
   output reg       W_WORD_GO ,
	
   output     [7:0]  R_DATA,
	
   output reg[23:0]  STEP1_NM,
   output reg[23:0]  STEP2_NM,
   output reg[23:0]  STEP3_NM,
   output reg[1:0]   STEPP,
   output reg        BYTE =0,
	output      [23:0]rom_q      ,
   output reg  [9:0 ]rom_address,
   output            rom_clock  ,
   output  [7:0]     PAGE    ,
   output  [7:0]     REG_ADR ,
   output  [7:0]     REG_DAT ,
	output  reg [31:0]DELAY ,
	
	//----
	output       reg [19:0] timer   =0,
   output       reg        timer_on=0,
	
	output                  enddd
	
);

	assign LOL_n =~Status[3] ;// LOL_n=0 is unlock ,LOL_n=1 is lock


//=======================================================
//  WIRE /REGISETER 
//=======================================================
reg  [7:0] rPAGE ;
//-----I2C-BUS-I/O----
wire   SDAO;
wire   W_WORD_SCL; 
wire   W_WORD_SDAO;  
wire   W_POINTER_SCL; 
wire   W_POINTER_END; 
reg    W_POINTER_GO; 
wire   W_POINTER_SDAO; 
wire   R_SCL; 
wire   R_END; 
reg    R_GO; 
wire   R_SDAO;



//=======================================================
//  Parameter  
//=======================================================

//---  CLOCK GEN IC (Si5340B) Slave addresss for Atum-A5-----    
parameter    SLAVE_ADDR_CK = 8'hEE;

//-----PAGE  Selection register 
parameter    P_PAGE        = 8'h01;

//-----Status
parameter    P_Status      = 8'h0c;//0x000C bit3 LOL=1 if the DSPLL is out of lock.
 
 //--LOL_n must go hi
parameter   NON_VALID_TIME   = 9600; //24ms  ;    //from i2c end //real 20.71ms



//0x000C Status Bits
//Reg Address Bit Field Type Setting Name Description
//0x000C 0 R SYSINCAL 1 if the device is calibrating.
//0x000C 1 R LOSXAXB 1 if there is no signal at the XA pin as the LOS detector
//is only connected to the XA pin.
//0x000C 2 R LOSREF 1 if the Phase Frequency detector does not have a
//signal from XAXB, IN2, IN1, or IN0.
//0x000C 3 R LOL 1 if the DSPLL is out of lock.
//0x000C 5 R SMBUS_TIMEOUT 1 if there is an SMBus timeout error.


//=======================================================
//  Structural coding
//======================================================= 

//------------timer ----
always @(negedge RESET_N or posedge CLK_400K )begin 
if (!RESET_N  ) timer     <=0; 
else if ( timer_on  & (timer< NON_VALID_TIME )) timer<=timer+1; 
	 
end 

//------400k
CLOCKMEM ck0( .CLK(CLK_50M),.CLK_FREQ (125),.CK_1HZ (CLK_400K) ) ;

//----ROM STEP -------			
reg [31:0] DELY ; 
//--I2C Main Controller--- 
always @(negedge RESET_N or posedge CLK_400K )begin 
if (!RESET_N  ) begin 
    ST           <=0;
 	 W_POINTER_GO <=1;
    R_GO         <=1;		 
	 W_WORD_GO    <=1;
	 DELAY        <=0; 
	 I2C_VALID        <=0;
	 clk_ready    <=0;
    time_VALID	  <=0;
	 rom_address  <=0;
	 STEPP        <=1;
	 rPAGE        <=8'hff; 
	 timer_on     <=0;

end 
else 
case (ST)
0: 
   begin 
    ST           <=9; 
	 W_POINTER_GO <=1;
    R_GO         <=1;		 
	 W_WORD_GO    <=1;
	 DELAY        <=0; 	
	 rom_address  <=0;
	 STEPP        <=1; 
	 rPAGE        <=8'hff; 
   end
9:  ST<=10; 
10: ST<=11; 
11: 
   begin 
	        if (rom_address==0) STEP1_NM<= 3        +rom_q;
	   else if (rom_address==1) STEP2_NM<= STEP1_NM +rom_q;
	   else if (rom_address==2) STEP3_NM<= STEP2_NM +rom_q;		
      ST <= 12; 
    end
	 
12: 
   begin 
	        rom_address<=rom_address+1 ;
	        if (rom_address==2) ST<=29; 
			  else begin  ST<=9; end 
    end
//----  
29: begin 
	  //------------step decide-----------
	        if  (rom_address ==3        ) begin STEPP <=1;ST<=30;end
		else if  (rom_address ==STEP1_NM ) begin STEPP <=2;
										   DELAY <= DELAY +1;				  
											if  (DELAY == 120000) ST<=30; // delay 300mS
										end
		else if  (rom_address ==STEP2_NM ) begin STEPP <=3;ST<=30;end
		else if  (rom_address ==STEP3_NM ) ST<=36 ; //GO_END
		else ST<=30;			 
    end	
30: begin 
	  //----------write PAGE or not--------
	  if ( rPAGE != PAGE ) begin rPAGE <= PAGE ; BYTE  <=0; end
	  else BYTE  <=1;
	  ST<=31; 
	 end 
31: begin 
           if ( BYTE==0 ) {SLAVE_ADDR,W_POINTER_REG ,W_WORD_DATA} <= { SLAVE_ADDR_CK ,P_PAGE , PAGE  } ;    //write page
		else if ( BYTE==1 ) {SLAVE_ADDR,W_POINTER_REG ,W_WORD_DATA} <= { SLAVE_ADDR_CK ,REG_ADR, REG_DAT} ;//write register 
	 if (  W_WORD_END ) begin  
	        W_WORD_GO  <=0 ; 
		           ST   <=32;  
		           DELAY <=0 ;  
	 end
	end           
32: begin 
    DELAY  <=DELAY +1;
    if ( DELAY ==3 ) begin //30
		W_WORD_GO  <=1 ;
		       ST  <=33; 
	 end	 
	end       
33: begin 
    ST<=34 ; 
	end       	
34: begin 
     if  ( W_WORD_END )  begin 	
			   if (BYTE ==0 ) begin ST  <=31 ; BYTE<=1  ; end 
				else  ST  <=35 ; 		 
	  end
	end              
35: begin 
         rom_address<=rom_address+1;			
	      ST   <=29; 	  
         DELAY<=0;
	 end 
//-----end-----
36: begin 
	         ST   <=40; 
				I2C_VALID<=1; 
	 end 
	 
//-----read :Polling LOL_n
//-------------------------------set page0
40: begin 
     {SLAVE_ADDR,W_POINTER_REG ,W_WORD_DATA} <= { SLAVE_ADDR_CK ,P_PAGE , 8'h00  } ;    //set page0
	 if (  W_WORD_END ) begin  
	        W_WORD_GO  <=0 ; 
		           ST   <=41;  
		           DELAY <=0 ;  
	 end
	end           
41: begin 
    DELAY  <=DELAY +1;
    if ( DELAY ==3 ) begin //30
		W_WORD_GO  <=1 ;
		       ST  <=42; 
	 end	 
	end       
42: begin 
    ST <= 43 ; 
	end       	
43: begin 
     if  ( W_WORD_END )  ST  <= 50 ; 		 
	 end
//------------- READ -------	
50: begin 
    ST<=51; 
	end	
51: begin
        // READ status
	     {SLAVE_ADDR,W_POINTER_REG } <= { SLAVE_ADDR_CK ,P_Status } ;
	if ( W_POINTER_END ) begin  
	   W_POINTER_GO  <=0; 
		ST  <=52 ; 
		DELY<=0;  
	 end
	end                
	//------- Write Pointer
52: begin 
    DELY  <=DELY +1;
    if ( DELY ==2 ) begin 
      W_POINTER_GO  <=1;
      ST<=53 ; 
	 end
	end       
53: begin 
    if  ( W_POINTER_END ) ST<=54 ; 	
	end              
54: begin 
    ST<=55 ; 
	end 
	//------- Read DATA  		 
55: begin 
	 if ( R_END ) begin  
	  R_GO  <=0; 
	  ST  <=56 ; 
	  DELY<=0; 
	 end
	end                
56: begin 
    DELY  <=DELY +1;
    if ( DELY ==2 ) begin 	 
      R_GO  <=1;
      ST<=57 ; 
	 end
	end       
57: begin 
     ST<=58 ; 
	end       
58: begin 
   if  ( R_END ) 
	 begin 		
    //READ DATA 	 
		   Status   <=R_DATA;
	      ST       <=59 ; 
			timer_on <=1;
	 end 
  end	
  
59: ST<=60 ; 
60: ST<=61 ; 
61: ST<=62 ; 
62: ST<=63 ; 
63: ST<=64 ; 
64: ST<=65 ; 
	
  
  
  
65: begin    
	 if ((NON_VALID_TIME	== timer ) || ( !Status[3] )) ST <=66;  //polling end  ,Status[3]=1 is unlock ,0 is lock
	     else  ST <=50; //repeat read status
		  DELY         <=0;
	     W_POINTER_GO <=1;
        R_GO         <=1 ;		 
	     W_WORD_GO    <=1; 		    		 		  
	 end 
66: begin ST <=ST ;
          timer_on   <=0; 
          time_VALID  <=1; 
			 if (!Status[3]) clk_ready <= 1;//bit3=0 lock ,bit3=1 unlock					  					 
		end   
//---- READ END ----
	 

	 
	 
endcase
end

//---------------Si5397 ram table-----------------
assign PAGE      = rom_q[23:16];//page
assign REG_ADR   = rom_q[15:8 ];//register
assign REG_DAT   = rom_q[7:0  ];//data 
assign rom_clock = CLK_50M     ;

si5340B_rom si5340B_rom_inst(
		.q       (rom_q      ),       
		.address (rom_address), 
		.clock   (rom_clock  )    
	);
//============inout  i2c  q15(a10) example ===============  
// wire const_zero_sig /* synthesis keep */;
// assign const_zero_sig = 1\'b0;
// assign TRI_PIN = enable? const_zero_sig : \'bz;
//========================================================
wire   const_zero_sig/* synthesis keep */ ; 
assign I2C_SDA       = (SDAO)?1'bz :const_zero_sig;
assign I2C_SCL       = W_POINTER_SCL  & R_SCL   & W_WORD_SCL;
assign SDAO          = W_POINTER_SDAO & R_SDAO  & W_WORD_SDAO;

assign const_zero_sig = 0 ; 
assign I2C_SDA = (SDAO)?1'bz : const_zero_sig ; 

wire NO_ACK1,NO_ACK2,NO_ACK3 ; 
assign  NO_ACK  = NO_ACK1 | NO_ACK2 | NO_ACK3; 


//==== I2C WRITE WORD ===
I2C_WRITE_BYTE  wrd(
   .NO_ACK (NO_ACK1),
   .RESET_N      ( RESET_N),
	.PT_CK        ( CLK_400K),
	.GO           ( W_WORD_GO),
	.POINTER      ( W_POINTER_REG),
   .WDATA8	     ( W_WORD_DATA),
	.SLAVE_ADDRESS( SLAVE_ADDR ),
	.SDAI         ( I2C_SDA),
	.SDAO         ( W_WORD_SDAO),
	.SCLO         ( W_WORD_SCL ),
	.END_OK       ( W_WORD_END)
);

//==== I2C WRITE POINTER ===
I2C_WRITE_POINTER  wpt(
   .NO_ACK (NO_ACK2),
   .RESET_N      (RESET_N),
	.PT_CK        ( CLK_400K      ),
	.GO           ( W_POINTER_GO  ),
	.POINTER      ( W_POINTER_REG ) ,
	.SLAVE_ADDRESS( SLAVE_ADDR    ),
	.SDAI         ( I2C_SDA       ),
	.SDAO         ( W_POINTER_SDAO),
	.SCLO         ( W_POINTER_SCL ),
	.END_OK       ( W_POINTER_END)
);

//-----I2C TO READ---- 
I2C_READ_DATA rd( 
   .NO_ACK       (NO_ACK3),
   .RESET_N      ( RESET_N),
	.PT_CK        ( CLK_400K),
	.GO           ( R_GO),
	.SLAVE_ADDRESS( SLAVE_ADDR ),
 	.BYTE_NUM     ( 0 ) , // I2C read 8 bit data 
	.SDAI         ( I2C_SDA),
	.SDAO         ( R_SDAO),
	.SCLO         ( R_SCL),
	.END_OK       ( R_END),
	.DATA         ( R_DATA)
);
	
endmodule
	