#include "stdio.h"
#include "../bsp/system.h"
#include "../bsp/HAL/inc/io.h"
#include "../bsp/drivers/inc/altera_avalon_spi.h"
#include "./reg_offset_def.h"
#include <unistd.h>


int imx901_spi_write( alt_u8 chip_id , alt_u8 addr , alt_u8 data )
{
	
	alt_u32  txdata;
	alt_u16  status;
	
    txdata = 0;
	txdata = ( ( data << 16 ) | ( addr << 8 ) | chip_id ) ;
	
	do{
		status = IORD_16DIRECT(SPI_BASE , SPI_STATUS);
	}while ( 0 == ( status & TXRDY_MSK ) );
		
	
	IOWR_32DIRECT(SPI_BASE , SPI_TXDAT , txdata);
		
	return 0;
}

alt_u8 imx901_spi_read( alt_u8 chip_id , alt_u8 addr)
{

	alt_u32  txdata;
	alt_u16  status;

	alt_u32   rdata32;
	alt_u8    rdata8;
	int    i;


    txdata = 0;
	txdata = ( ( addr << 8 ) | 0x80 | chip_id ) ;

	do{
		status = IORD_16DIRECT(SPI_BASE , SPI_STATUS);
	}while ( 0 == ( status & TXRDY_MSK ) );


	IOWR_32DIRECT(SPI_BASE , SPI_TXDAT , txdata);

	for (i = 0 ; i < 100  ; i++){
		asm("nop");
	}

	rdata32 = IORD_32DIRECT(SPI_BASE , 0x00 );
	rdata8 = ((rdata32 & 0x00FF0000) >> 16 );

	return rdata8;

}

int main() 
{

	int                    i;

	IOWR_32DIRECT(SLEC_RX_CSR_BASE, CONFIG , 0x1F500220 ); // 4Lane RAW12 8016
	IOWR_32DIRECT(SLEC_RX_CSR_BASE, CTRL   , 0x0000000F );

	//-----------------------------------------------------
	//--- Assert and Diassert XCLR
	//-----------------------------------------------------
	IOWR_32DIRECT(PIO_0_BASE, 0x00 ,  0x00000000  );
	while(IORD_32DIRECT(PIO_1_BASE,0x00));
	IOWR_32DIRECT(PIO_0_BASE, 0x00 ,  0x20000000  );
	while(!IORD_32DIRECT(PIO_1_BASE,0x00));
	usleep(1*1000*1000);
	IOWR_32DIRECT(PIO_0_BASE, 0x00 ,  0x30000000  );
	usleep(1);
	IOWR_32DIRECT(PIO_0_BASE, 0x00 ,  0xB0000000  );
	usleep(1);
	IOWR_32DIRECT(PIO_0_BASE, 0x00 ,  0xF0000000  );
	
	//-----------------------------------------------------
	//--- IMX901 Basic Register Setting1 Start
	//-----------------------------------------------------
	while(!imx901_spi_read(0x02, 0x00));

	imx901_spi_write(0x02, 0xD4, 0x62); // VMAX
	imx901_spi_write(0x02, 0xD5, 0x08); // VMAX
	imx901_spi_write(0x02, 0xD6, 0x00); // VMAX
	imx901_spi_write(0x02, 0xD8, 0xDC); // HMAX
	imx901_spi_write(0x02, 0xD9, 0x03); // HMAX
	imx901_spi_write(0x02, 0xE2, 0x04); // GMRWT
	imx901_spi_write(0x02, 0xE3, 0x04); // GMTWT
	imx901_spi_write(0x02, 0xE6, 0x04); // GSDLY
	imx901_spi_write(0x0B, 0x04, 0x02); // LANE_SEL
	imx901_spi_write(0x04, 0x00, 0x15); // ADBIT
	imx901_spi_write(0x06, 0x30, 0x01); // ODBIT
//	imx901_spi_write(0x07, 0xA6, 0xBB);
	imx901_spi_write(0x07, 0xA6, 0xF0);
	imx901_spi_write(0x07, 0xB4, 0xF0); // BLKLEVEL
	imx901_spi_write(0x0C, 0x00, 0xE1); // CRC_ECC_MODE ECC 2byte
	imx901_spi_write(0x04, 0x04, 0x00); // VHREVERSE
	imx901_spi_write(0x07, 0x02, 0x09); // GAIN_RTS
//	imx901_spi_write(0x05, 0x08, 0x87);
	imx901_spi_write(0x05, 0x08, 0x4A);
	imx901_spi_write(0x07, 0x14, 0x00); // GAIN
	imx901_spi_write(0x07, 0x15, 0x00); // GAIN
	imx901_spi_write(0x04, 0x2A, 0x88);
	imx901_spi_write(0x02, 0x3A, 0x19); // I2CSPICK
//	imx901_spi_write(0x11, 0x3A, 0x3B);
	imx901_spi_write(0x11, 0x3A, 0x0B);
//	imx901_spi_write(0x11, 0x3C, 0x66);
	imx901_spi_write(0x11, 0x3C, 0x36);
	imx901_spi_write(0x04, 0x40, 0x00); // INCKSEL_ST30
	imx901_spi_write(0x04, 0x4C, 0x70); // SHS
	imx901_spi_write(0x04, 0x4D, 0x00); // SHS
	imx901_spi_write(0x04, 0x4E, 0x00); // SHS
	imx901_spi_write(0x1A, 0x64, 0xF5);
	imx901_spi_write(0x16, 0x66, 0xCA);
	imx901_spi_write(0x1A, 0x68, 0xF5);
	imx901_spi_write(0x1A, 0x6C, 0xF5);
//	imx901_spi_write(0x13, 0x84, 0x7E);
	imx901_spi_write(0x13, 0x84, 0x46);
	imx901_spi_write(0x19, 0x88, 0x04);
	imx901_spi_write(0x19, 0x89, 0x10);
//	imx901_spi_write(0x0c, 0x90, 0x0F);
	imx901_spi_write(0x0E, 0x98, 0x90); // BASECK_FREQ
//	imx901_spi_write(0x10, 0x98, 0x7D);
	imx901_spi_write(0x10, 0x98, 0x45);
	imx901_spi_write(0x0E, 0x99, 0x12); // BASECK_FREQ
	imx901_spi_write(0x07, 0x9C, 0x0F);
//	imx901_spi_write(0x13, 0xA2, 0x3A);
	imx901_spi_write(0x13, 0xA2, 0x0A);
	imx901_spi_write(0x07, 0xA4, 0x2B);
//	imx901_spi_write(0x13, 0xA4, 0x67);
	imx901_spi_write(0x13, 0xA4, 0x37);
	imx901_spi_write(0x1A, 0xA4, 0x13);
//	imx901_spi_write(0x07, 0xA5, 0x12);
	imx901_spi_write(0x07, 0xA5, 0x02);
	imx901_spi_write(0x07, 0xA8, 0x2B);
	imx901_spi_write(0x1A, 0xA8, 0x13);
	imx901_spi_write(0x07, 0xA9, 0x42);
//	imx901_spi_write(0x07, 0xAA, 0x6A); 
//	imx901_spi_write(0x04, 0xAC, 0x88); 
	imx901_spi_write(0x04, 0xAC, 0x4B); 
	imx901_spi_write(0x1A, 0xAC, 0x13); 
	imx901_spi_write(0x02, 0xDC, 0x01); // FREQ
	imx901_spi_write(0x02, 0xE5, 0x02); // GAINDLY
	imx901_spi_write(0x07, 0xEC, 0x2B);
	imx901_spi_write(0x07, 0xED, 0x12);
	imx901_spi_write(0x07, 0xEE, 0x1C);
//	imx901_spi_write(0x07, 0xFD, 0xEC);
	imx901_spi_write(0x07, 0xFD, 0xC0);
//	imx901_spi_write(0x07, 0xFD, 0x02);
	imx901_spi_write(0x07, 0xFE, 0x03);

//imx901 added
	imx901_spi_write(0x06, 0x40, 0x01);

	imx901_spi_write(0x07, 0x42, 0x27);

	imx901_spi_write(0x08, 0x2c, 0x71);
	imx901_spi_write(0x08, 0x2e, 0xD8);
	imx901_spi_write(0x08, 0x2f, 0x1F);
	imx901_spi_write(0x08, 0x42, 0xF4);
	imx901_spi_write(0x08, 0x43, 0x1F);
	imx901_spi_write(0x08, 0x48, 0x61);
	imx901_spi_write(0x08, 0x49, 0x01);
	imx901_spi_write(0x08, 0x4A, 0x0A);
	imx901_spi_write(0x08, 0x54, 0x71);
	imx901_spi_write(0x08, 0x56, 0xFC);
	imx901_spi_write(0x08, 0x57, 0x1F);
	imx901_spi_write(0x08, 0x6A, 0x0A);
	imx901_spi_write(0x08, 0x70, 0x61);
	imx901_spi_write(0x08, 0x71, 0x01);
	imx901_spi_write(0x08, 0x72, 0x0A);
	imx901_spi_write(0x08, 0xE4, 0x01);

	imx901_spi_write(0x14, 0x34, 0x0A);
	imx901_spi_write(0x14, 0x32, 0x3C);

	imx901_spi_write(0x15, 0x10, 0x06);
	imx901_spi_write(0x15, 0x2c, 0x0B);
	imx901_spi_write(0x15, 0x2e, 0x19);
	imx901_spi_write(0x15, 0x34, 0x0C);
	imx901_spi_write(0x15, 0x36, 0x1A);

	imx901_spi_write(0x19, 0x18, 0x9A);
	imx901_spi_write(0x19, 0x22, 0x9A);
	imx901_spi_write(0x19, 0x70, 0x9A);
	imx901_spi_write(0x19, 0x76, 0x9A);
//end of added registers

	imx901_spi_write(0x02, 0x00, 0x00); // STNADBY
	usleep(10*1000);
	imx901_spi_write(0x02, 0x10, 0x00); // XMASTER

	//-----------------------------------------------------
	//--- Error Status Check
	//-----------------------------------------------------

	for (i = 0 ; i <= WAIT_10MS_LOOP ; i ++ ){
		asm("nop");
	}

	// Clear Error Count
	IOWR_32DIRECT(SLEC_RX_CSR_BASE, CTRL , 0x0000010F );

	while (1){
		printf("STAT          : %08x\n", IORD_32DIRECT(SLEC_RX_CSR_BASE, STAT));
		printf("ECC_STAT      : %08x\n", IORD_32DIRECT(SLEC_RX_CSR_BASE, ECC_STAT));

		for (i = 0 ; i <= WAIT_10MS_LOOP ; i ++ ){
			asm("nop");
		}

	}

	return 0;
}
