//----------------------------------------------------------------------------------------
//Copyright (C) 2012 Macnica Inc. All Rights Reserved.
//
//Use in source and binary forms, with or without modification, are permitted provided
//by agreeing to the following terms and conditions:
//
//REDISTRIBUTIONS OR SUBLICENSING IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS "AS IS"
//AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE
//FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
//SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
//CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
//OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//AND ALSO REGARDING THE REFERENCE SOFTWARE, REDISTRIBUTION OR SUBLICENSING
//IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//----------------------------------------------------------------------------------------
// DESCRIPTION
//		Single read & single write RAM
//----------------------------------------------------------------------------------------
// REVISION HISTORY
//		v1.0 Jan. 17 2012	: Initial Version Release
//----------------------------------------------------------------------------------------
// PARAMETERS
//		ADR_BIT		: Address bit width.
//		DATA_BIT	: Data bit width.
//		DATA_DEPTH	: Data depth.
//----------------------------------------------------------------------------------------
// I/O PORTS
//		wclk	: Write clock.
//		rclk	: Read clock.
//
//		wadr_i	: Write address.
//		radr_i	: Read address.
//		wen_i	: Write enable.
//		ren_i	: Read enable.
//
//		wdata_i	: Write data.
//		rdata_o	: Read data.
//----------------------------------------------------------------------------------------
`default_nettype none
`timescale 1ps / 1ps

module vtg11_srd_swr_ram
	#(
		parameter	ADR_BIT				= 16	,
		parameter	DATA_BIT			= 8		,
		parameter	DATA_DEPTH			= 4096
	)
	(
		input	wire							wclk	,
		input	wire							rclk	,

		input	wire	[ ADR_BIT-1 : 0 ]		wadr_i	,
		input	wire	[ ADR_BIT-1 : 0 ]		radr_i	,
		input	wire							wen_i	,
		input	wire							ren_i	,

		input	wire	[ DATA_BIT-1 : 0 ]		wdata_i	,
		output	wire	[ DATA_BIT-1 : 0 ]		rdata_o
	) ;

// =============================================================================
// REG / WIRE DECLARATION
// =============================================================================

	reg		[	DATA_BIT-1 : 0 ]	mem_ff	[DATA_DEPTH-1:0] ;
	reg		[	 ADR_BIT-1 : 0 ]	radr_ff ;

// =============================================================================
// FUNCTION DESCRIPTION
// =============================================================================

	always @( posedge wclk ) begin
		if ( wen_i ) begin
			mem_ff[wadr_i]	<= wdata_i ;
		end
	end

	always @( posedge rclk ) begin
		if ( ren_i ) begin
			radr_ff		<= radr_i ;
		end
	end

	assign rdata_o		= mem_ff[radr_ff] ;

endmodule
`default_nettype wire