//----------------------------------------------------------------------------------------
//Copyright (C) 2012 Macnica Inc. All Rights Reserved.
//
//Use in source and binary forms, with or without modification, are permitted provided
//by agreeing to the following terms and conditions:
//
//REDISTRIBUTIONS OR SUBLICENSING IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS "AS IS"
//AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE
//FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
//SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
//CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
//OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//AND ALSO REGARDING THE REFERENCE SOFTWARE, REDISTRIBUTION OR SUBLICENSING
//IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//----------------------------------------------------------------------------------------
// DESCRIPTION
//		bi-linearr scaling filter coefficient table for scaler adaptive
//----------------------------------------------------------------------------------------
// REVISION HISTORY
//		v1.0 Mar. 13 2012	: Initial Version Release
//----------------------------------------------------------------------------------------
// PARAMETERS
//		Q_BIT		: quantized bit width per color plane
//
//		DLT_BIT		: delta bit width
//		COEFF_BIT	: coefficient bit width
//
//----------------------------------------------------------------------------------------
// I/O PORTS
//		clk;		: clock for all circuit
//		rst_n;		: asynchronous reset ( low active )
//		enable;		: clock enable
//
//		x_i;		: table index
//
//		coeff_zr_o;	: table value ( -1 -> 0 section coefficient )
//		coeff_p1_o;	: table value (  0 -> 1 section coefficient )
//
//----------------------------------------------------------------------------------------
`timescale 1ps/1ps
`default_nettype none

module	scl16_bilinear_ph32_func (
	clk			,
	rst_n		,
	enable		,

	x_i			,

	coeff_zr_o	,
	coeff_p1_o
) ;

// =============================================================================
// PARAMETER DEFINITION
// =============================================================================

	// ---------------------------------------------------------------------
	// Below parameters have to be defined from upper module
	// ---------------------------------------------------------------------
	parameter Q_BIT					= 8			;

	// ---------------------------------------------------------------------
	// Please do not change the following parameters
	// ---------------------------------------------------------------------
	parameter DLT_BIT				= 5			;
	parameter COEFF_BIT				= Q_BIT + 1	;

// =============================================================================
// PORT DECLARATION
// =============================================================================
	input	wire							clk			;
	input	wire							rst_n		;
	input	wire							enable		;

	input	wire	[ DLT_BIT-1 : 0 ]		x_i			;

	output	wire	[ COEFF_BIT-1 : 0 ]		coeff_zr_o	;
	output	wire	[ COEFF_BIT-1 : 0 ]		coeff_p1_o	;

// =============================================================================
// REG / WIRE DECLARATION
// =============================================================================
	reg		[ COEFF_BIT-1 : 0 ]		coeff_zr_ff	;
	reg		[ COEFF_BIT-1 : 0 ]		coeff_p1_ff	;

// =============================================================================
// FUNCTION DESCRIPTION
// =============================================================================
	generate
		if ( Q_BIT == 6 ) begin: table_6bit
			//-------------------- Table Value Format -----------------------//
			//	 { Sign(1bit), Integral Part(1bit), Fraction Part(5bit) }	 //
			//---------------------------------------------------------------//
			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_zr_ff		<= 7'h20 ;
				end
				else if ( enable ) begin
					case ( x_i )
						5'b0_0000	: coeff_zr_ff	<= 7'h20 ;
						5'b0_0001	: coeff_zr_ff	<= 7'h1f ;
						5'b0_0010	: coeff_zr_ff	<= 7'h1e ;
						5'b0_0011	: coeff_zr_ff	<= 7'h1d ;
						5'b0_0100	: coeff_zr_ff	<= 7'h1c ;
						5'b0_0101	: coeff_zr_ff	<= 7'h1b ;
						5'b0_0110	: coeff_zr_ff	<= 7'h1a ;
						5'b0_0111	: coeff_zr_ff	<= 7'h19 ;
						5'b0_1000	: coeff_zr_ff	<= 7'h18 ;
						5'b0_1001	: coeff_zr_ff	<= 7'h17 ;
						5'b0_1010	: coeff_zr_ff	<= 7'h16 ;
						5'b0_1011	: coeff_zr_ff	<= 7'h15 ;
						5'b0_1100	: coeff_zr_ff	<= 7'h14 ;
						5'b0_1101	: coeff_zr_ff	<= 7'h13 ;
						5'b0_1110	: coeff_zr_ff	<= 7'h12 ;
						5'b0_1111	: coeff_zr_ff	<= 7'h11 ;
						5'b1_0000	: coeff_zr_ff	<= 7'h10 ;
						5'b1_0001	: coeff_zr_ff	<= 7'h0f ;
						5'b1_0010	: coeff_zr_ff	<= 7'h0e ;
						5'b1_0011	: coeff_zr_ff	<= 7'h0d ;
						5'b1_0100	: coeff_zr_ff	<= 7'h0c ;
						5'b1_0101	: coeff_zr_ff	<= 7'h0b ;
						5'b1_0110	: coeff_zr_ff	<= 7'h0a ;
						5'b1_0111	: coeff_zr_ff	<= 7'h09 ;
						5'b1_1000	: coeff_zr_ff	<= 7'h08 ;
						5'b1_1001	: coeff_zr_ff	<= 7'h07 ;
						5'b1_1010	: coeff_zr_ff	<= 7'h06 ;
						5'b1_1011	: coeff_zr_ff	<= 7'h05 ;
						5'b1_1100	: coeff_zr_ff	<= 7'h04 ;
						5'b1_1101	: coeff_zr_ff	<= 7'h03 ;
						5'b1_1110	: coeff_zr_ff	<= 7'h02 ;
						5'b1_1111	: coeff_zr_ff	<= 7'h01 ;
						default		: coeff_zr_ff	<= {7{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p1_ff		<= 7'h00 ;
				end
				else if ( enable ) begin
					case ( x_i )
						5'b0_0000	: coeff_p1_ff	<= 7'h00 ;
						5'b0_0001	: coeff_p1_ff	<= 7'h01 ;
						5'b0_0010	: coeff_p1_ff	<= 7'h02 ;
						5'b0_0011	: coeff_p1_ff	<= 7'h03 ;
						5'b0_0100	: coeff_p1_ff	<= 7'h04 ;
						5'b0_0101	: coeff_p1_ff	<= 7'h05 ;
						5'b0_0110	: coeff_p1_ff	<= 7'h06 ;
						5'b0_0111	: coeff_p1_ff	<= 7'h07 ;
						5'b0_1000	: coeff_p1_ff	<= 7'h08 ;
						5'b0_1001	: coeff_p1_ff	<= 7'h09 ;
						5'b0_1010	: coeff_p1_ff	<= 7'h0a ;
						5'b0_1011	: coeff_p1_ff	<= 7'h0b ;
						5'b0_1100	: coeff_p1_ff	<= 7'h0c ;
						5'b0_1101	: coeff_p1_ff	<= 7'h0d ;
						5'b0_1110	: coeff_p1_ff	<= 7'h0e ;
						5'b0_1111	: coeff_p1_ff	<= 7'h0f ;
						5'b1_0000	: coeff_p1_ff	<= 7'h10 ;
						5'b1_0001	: coeff_p1_ff	<= 7'h11 ;
						5'b1_0010	: coeff_p1_ff	<= 7'h12 ;
						5'b1_0011	: coeff_p1_ff	<= 7'h13 ;
						5'b1_0100	: coeff_p1_ff	<= 7'h14 ;
						5'b1_0101	: coeff_p1_ff	<= 7'h15 ;
						5'b1_0110	: coeff_p1_ff	<= 7'h16 ;
						5'b1_0111	: coeff_p1_ff	<= 7'h17 ;
						5'b1_1000	: coeff_p1_ff	<= 7'h18 ;
						5'b1_1001	: coeff_p1_ff	<= 7'h19 ;
						5'b1_1010	: coeff_p1_ff	<= 7'h1a ;
						5'b1_1011	: coeff_p1_ff	<= 7'h1b ;
						5'b1_1100	: coeff_p1_ff	<= 7'h1c ;
						5'b1_1101	: coeff_p1_ff	<= 7'h1d ;
						5'b1_1110	: coeff_p1_ff	<= 7'h1e ;
						5'b1_1111	: coeff_p1_ff	<= 7'h1f ;
						default		: coeff_p1_ff	<= {7{1'bx}} ;
					endcase
				end
			end
		end
		else if ( Q_BIT == 8 ) begin : table_8bit
			//-------------------- Table Value Format -----------------------//
			//	 { Sign(1bit), Integral Part(1bit), Fraction Part(7bit) }	 //
			//---------------------------------------------------------------//
			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_zr_ff		<= 9'h080 ;
				end
				else if ( enable ) begin
					case ( x_i )
						5'b0_0000	: coeff_zr_ff	<= 9'h080 ;
						5'b0_0001	: coeff_zr_ff	<= 9'h07c ;
						5'b0_0010	: coeff_zr_ff	<= 9'h078 ;
						5'b0_0011	: coeff_zr_ff	<= 9'h074 ;
						5'b0_0100	: coeff_zr_ff	<= 9'h070 ;
						5'b0_0101	: coeff_zr_ff	<= 9'h06c ;
						5'b0_0110	: coeff_zr_ff	<= 9'h068 ;
						5'b0_0111	: coeff_zr_ff	<= 9'h064 ;
						5'b0_1000	: coeff_zr_ff	<= 9'h060 ;
						5'b0_1001	: coeff_zr_ff	<= 9'h05c ;
						5'b0_1010	: coeff_zr_ff	<= 9'h058 ;
						5'b0_1011	: coeff_zr_ff	<= 9'h054 ;
						5'b0_1100	: coeff_zr_ff	<= 9'h050 ;
						5'b0_1101	: coeff_zr_ff	<= 9'h04c ;
						5'b0_1110	: coeff_zr_ff	<= 9'h048 ;
						5'b0_1111	: coeff_zr_ff	<= 9'h044 ;
						5'b1_0000	: coeff_zr_ff	<= 9'h040 ;
						5'b1_0001	: coeff_zr_ff	<= 9'h03c ;
						5'b1_0010	: coeff_zr_ff	<= 9'h038 ;
						5'b1_0011	: coeff_zr_ff	<= 9'h034 ;
						5'b1_0100	: coeff_zr_ff	<= 9'h030 ;
						5'b1_0101	: coeff_zr_ff	<= 9'h02c ;
						5'b1_0110	: coeff_zr_ff	<= 9'h028 ;
						5'b1_0111	: coeff_zr_ff	<= 9'h024 ;
						5'b1_1000	: coeff_zr_ff	<= 9'h020 ;
						5'b1_1001	: coeff_zr_ff	<= 9'h01c ;
						5'b1_1010	: coeff_zr_ff	<= 9'h018 ;
						5'b1_1011	: coeff_zr_ff	<= 9'h014 ;
						5'b1_1100	: coeff_zr_ff	<= 9'h010 ;
						5'b1_1101	: coeff_zr_ff	<= 9'h00c ;
						5'b1_1110	: coeff_zr_ff	<= 9'h008 ;
						5'b1_1111	: coeff_zr_ff	<= 9'h004 ;
						default		: coeff_zr_ff	<= {9{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p1_ff		<= 9'h000 ;
				end
				else if ( enable ) begin
					case ( x_i )
						5'b0_0000	: coeff_p1_ff	<= 9'h000 ;
						5'b0_0001	: coeff_p1_ff	<= 9'h004 ;
						5'b0_0010	: coeff_p1_ff	<= 9'h008 ;
						5'b0_0011	: coeff_p1_ff	<= 9'h00c ;
						5'b0_0100	: coeff_p1_ff	<= 9'h010 ;
						5'b0_0101	: coeff_p1_ff	<= 9'h014 ;
						5'b0_0110	: coeff_p1_ff	<= 9'h018 ;
						5'b0_0111	: coeff_p1_ff	<= 9'h01c ;
						5'b0_1000	: coeff_p1_ff	<= 9'h020 ;
						5'b0_1001	: coeff_p1_ff	<= 9'h024 ;
						5'b0_1010	: coeff_p1_ff	<= 9'h028 ;
						5'b0_1011	: coeff_p1_ff	<= 9'h02c ;
						5'b0_1100	: coeff_p1_ff	<= 9'h030 ;
						5'b0_1101	: coeff_p1_ff	<= 9'h034 ;
						5'b0_1110	: coeff_p1_ff	<= 9'h038 ;
						5'b0_1111	: coeff_p1_ff	<= 9'h03c ;
						5'b1_0000	: coeff_p1_ff	<= 9'h040 ;
						5'b1_0001	: coeff_p1_ff	<= 9'h044 ;
						5'b1_0010	: coeff_p1_ff	<= 9'h048 ;
						5'b1_0011	: coeff_p1_ff	<= 9'h04c ;
						5'b1_0100	: coeff_p1_ff	<= 9'h050 ;
						5'b1_0101	: coeff_p1_ff	<= 9'h054 ;
						5'b1_0110	: coeff_p1_ff	<= 9'h058 ;
						5'b1_0111	: coeff_p1_ff	<= 9'h05c ;
						5'b1_1000	: coeff_p1_ff	<= 9'h060 ;
						5'b1_1001	: coeff_p1_ff	<= 9'h064 ;
						5'b1_1010	: coeff_p1_ff	<= 9'h068 ;
						5'b1_1011	: coeff_p1_ff	<= 9'h06c ;
						5'b1_1100	: coeff_p1_ff	<= 9'h070 ;
						5'b1_1101	: coeff_p1_ff	<= 9'h074 ;
						5'b1_1110	: coeff_p1_ff	<= 9'h078 ;
						5'b1_1111	: coeff_p1_ff	<= 9'h07c ;
						default		: coeff_p1_ff	<= {9{1'bx}} ;
					endcase
				end
			end
		end
		else if ( Q_BIT == 10 ) begin : table_10bit
			//-------------------- Table Value Format -----------------------//
			//	 { Sign(1bit), Integral Part(1bit), Fraction Part(9bit) }	 //
			//---------------------------------------------------------------//
			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_zr_ff		<= 11'h200 ;
				end
				else if ( enable ) begin
					case ( x_i )
						5'b0_0000	: coeff_zr_ff	<= 11'h200 ;
						5'b0_0001	: coeff_zr_ff	<= 11'h1f0 ;
						5'b0_0010	: coeff_zr_ff	<= 11'h1e0 ;
						5'b0_0011	: coeff_zr_ff	<= 11'h1d0 ;
						5'b0_0100	: coeff_zr_ff	<= 11'h1c0 ;
						5'b0_0101	: coeff_zr_ff	<= 11'h1b0 ;
						5'b0_0110	: coeff_zr_ff	<= 11'h1a0 ;
						5'b0_0111	: coeff_zr_ff	<= 11'h190 ;
						5'b0_1000	: coeff_zr_ff	<= 11'h180 ;
						5'b0_1001	: coeff_zr_ff	<= 11'h170 ;
						5'b0_1010	: coeff_zr_ff	<= 11'h160 ;
						5'b0_1011	: coeff_zr_ff	<= 11'h150 ;
						5'b0_1100	: coeff_zr_ff	<= 11'h140 ;
						5'b0_1101	: coeff_zr_ff	<= 11'h130 ;
						5'b0_1110	: coeff_zr_ff	<= 11'h120 ;
						5'b0_1111	: coeff_zr_ff	<= 11'h110 ;
						5'b1_0000	: coeff_zr_ff	<= 11'h100 ;
						5'b1_0001	: coeff_zr_ff	<= 11'h0f0 ;
						5'b1_0010	: coeff_zr_ff	<= 11'h0e0 ;
						5'b1_0011	: coeff_zr_ff	<= 11'h0d0 ;
						5'b1_0100	: coeff_zr_ff	<= 11'h0c0 ;
						5'b1_0101	: coeff_zr_ff	<= 11'h0b0 ;
						5'b1_0110	: coeff_zr_ff	<= 11'h0a0 ;
						5'b1_0111	: coeff_zr_ff	<= 11'h090 ;
						5'b1_1000	: coeff_zr_ff	<= 11'h080 ;
						5'b1_1001	: coeff_zr_ff	<= 11'h070 ;
						5'b1_1010	: coeff_zr_ff	<= 11'h060 ;
						5'b1_1011	: coeff_zr_ff	<= 11'h050 ;
						5'b1_1100	: coeff_zr_ff	<= 11'h040 ;
						5'b1_1101	: coeff_zr_ff	<= 11'h030 ;
						5'b1_1110	: coeff_zr_ff	<= 11'h020 ;
						5'b1_1111	: coeff_zr_ff	<= 11'h010 ;
						default		: coeff_zr_ff	<= {11{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p1_ff		<= 11'h000 ;
				end
				else if ( enable ) begin
					case ( x_i )
						5'b0_0000	: coeff_p1_ff	<= 11'h000 ;
						5'b0_0001	: coeff_p1_ff	<= 11'h010 ;
						5'b0_0010	: coeff_p1_ff	<= 11'h020 ;
						5'b0_0011	: coeff_p1_ff	<= 11'h030 ;
						5'b0_0100	: coeff_p1_ff	<= 11'h040 ;
						5'b0_0101	: coeff_p1_ff	<= 11'h050 ;
						5'b0_0110	: coeff_p1_ff	<= 11'h060 ;
						5'b0_0111	: coeff_p1_ff	<= 11'h070 ;
						5'b0_1000	: coeff_p1_ff	<= 11'h080 ;
						5'b0_1001	: coeff_p1_ff	<= 11'h090 ;
						5'b0_1010	: coeff_p1_ff	<= 11'h0a0 ;
						5'b0_1011	: coeff_p1_ff	<= 11'h0b0 ;
						5'b0_1100	: coeff_p1_ff	<= 11'h0c0 ;
						5'b0_1101	: coeff_p1_ff	<= 11'h0d0 ;
						5'b0_1110	: coeff_p1_ff	<= 11'h0e0 ;
						5'b0_1111	: coeff_p1_ff	<= 11'h0f0 ;
						5'b1_0000	: coeff_p1_ff	<= 11'h100 ;
						5'b1_0001	: coeff_p1_ff	<= 11'h110 ;
						5'b1_0010	: coeff_p1_ff	<= 11'h120 ;
						5'b1_0011	: coeff_p1_ff	<= 11'h130 ;
						5'b1_0100	: coeff_p1_ff	<= 11'h140 ;
						5'b1_0101	: coeff_p1_ff	<= 11'h150 ;
						5'b1_0110	: coeff_p1_ff	<= 11'h160 ;
						5'b1_0111	: coeff_p1_ff	<= 11'h170 ;
						5'b1_1000	: coeff_p1_ff	<= 11'h180 ;
						5'b1_1001	: coeff_p1_ff	<= 11'h190 ;
						5'b1_1010	: coeff_p1_ff	<= 11'h1a0 ;
						5'b1_1011	: coeff_p1_ff	<= 11'h1b0 ;
						5'b1_1100	: coeff_p1_ff	<= 11'h1c0 ;
						5'b1_1101	: coeff_p1_ff	<= 11'h1d0 ;
						5'b1_1110	: coeff_p1_ff	<= 11'h1e0 ;
						5'b1_1111	: coeff_p1_ff	<= 11'h1f0 ;
						default		: coeff_p1_ff	<= {11{1'bx}} ;
					endcase
				end
			end
		end
		else if ( Q_BIT == 12 ) begin : table_12bit
			//-------------------- Table Value Format -----------------------//
			//	 { Sign(1bit), Integral Part(1bit), Fraction Part(11bit) }	 //
			//---------------------------------------------------------------//
			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_zr_ff		<= 13'h0800 ;
				end
				else if ( enable ) begin
					case ( x_i )
						5'b0_0000	: coeff_zr_ff	<= 13'h0800 ;
						5'b0_0001	: coeff_zr_ff	<= 13'h07c0 ;
						5'b0_0010	: coeff_zr_ff	<= 13'h0780 ;
						5'b0_0011	: coeff_zr_ff	<= 13'h0740 ;
						5'b0_0100	: coeff_zr_ff	<= 13'h0700 ;
						5'b0_0101	: coeff_zr_ff	<= 13'h06c0 ;
						5'b0_0110	: coeff_zr_ff	<= 13'h0680 ;
						5'b0_0111	: coeff_zr_ff	<= 13'h0640 ;
						5'b0_1000	: coeff_zr_ff	<= 13'h0600 ;
						5'b0_1001	: coeff_zr_ff	<= 13'h05c0 ;
						5'b0_1010	: coeff_zr_ff	<= 13'h0580 ;
						5'b0_1011	: coeff_zr_ff	<= 13'h0540 ;
						5'b0_1100	: coeff_zr_ff	<= 13'h0500 ;
						5'b0_1101	: coeff_zr_ff	<= 13'h04c0 ;
						5'b0_1110	: coeff_zr_ff	<= 13'h0480 ;
						5'b0_1111	: coeff_zr_ff	<= 13'h0440 ;
						5'b1_0000	: coeff_zr_ff	<= 13'h0400 ;
						5'b1_0001	: coeff_zr_ff	<= 13'h03c0 ;
						5'b1_0010	: coeff_zr_ff	<= 13'h0380 ;
						5'b1_0011	: coeff_zr_ff	<= 13'h0340 ;
						5'b1_0100	: coeff_zr_ff	<= 13'h0300 ;
						5'b1_0101	: coeff_zr_ff	<= 13'h02c0 ;
						5'b1_0110	: coeff_zr_ff	<= 13'h0280 ;
						5'b1_0111	: coeff_zr_ff	<= 13'h0240 ;
						5'b1_1000	: coeff_zr_ff	<= 13'h0200 ;
						5'b1_1001	: coeff_zr_ff	<= 13'h01c0 ;
						5'b1_1010	: coeff_zr_ff	<= 13'h0180 ;
						5'b1_1011	: coeff_zr_ff	<= 13'h0140 ;
						5'b1_1100	: coeff_zr_ff	<= 13'h0100 ;
						5'b1_1101	: coeff_zr_ff	<= 13'h00c0 ;
						5'b1_1110	: coeff_zr_ff	<= 13'h0080 ;
						5'b1_1111	: coeff_zr_ff	<= 13'h0040 ;
						default		: coeff_zr_ff	<= {13{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p1_ff		<= 13'h0000 ;
				end
				else if ( enable ) begin
					case ( x_i )
						5'b0_0000	: coeff_p1_ff	<= 13'h0000 ;
						5'b0_0001	: coeff_p1_ff	<= 13'h0040 ;
						5'b0_0010	: coeff_p1_ff	<= 13'h0080 ;
						5'b0_0011	: coeff_p1_ff	<= 13'h00c0 ;
						5'b0_0100	: coeff_p1_ff	<= 13'h0100 ;
						5'b0_0101	: coeff_p1_ff	<= 13'h0140 ;
						5'b0_0110	: coeff_p1_ff	<= 13'h0180 ;
						5'b0_0111	: coeff_p1_ff	<= 13'h01c0 ;
						5'b0_1000	: coeff_p1_ff	<= 13'h0200 ;
						5'b0_1001	: coeff_p1_ff	<= 13'h0240 ;
						5'b0_1010	: coeff_p1_ff	<= 13'h0280 ;
						5'b0_1011	: coeff_p1_ff	<= 13'h02c0 ;
						5'b0_1100	: coeff_p1_ff	<= 13'h0300 ;
						5'b0_1101	: coeff_p1_ff	<= 13'h0340 ;
						5'b0_1110	: coeff_p1_ff	<= 13'h0380 ;
						5'b0_1111	: coeff_p1_ff	<= 13'h03c0 ;
						5'b1_0000	: coeff_p1_ff	<= 13'h0400 ;
						5'b1_0001	: coeff_p1_ff	<= 13'h0440 ;
						5'b1_0010	: coeff_p1_ff	<= 13'h0480 ;
						5'b1_0011	: coeff_p1_ff	<= 13'h04c0 ;
						5'b1_0100	: coeff_p1_ff	<= 13'h0500 ;
						5'b1_0101	: coeff_p1_ff	<= 13'h0540 ;
						5'b1_0110	: coeff_p1_ff	<= 13'h0580 ;
						5'b1_0111	: coeff_p1_ff	<= 13'h05c0 ;
						5'b1_1000	: coeff_p1_ff	<= 13'h0600 ;
						5'b1_1001	: coeff_p1_ff	<= 13'h0640 ;
						5'b1_1010	: coeff_p1_ff	<= 13'h0680 ;
						5'b1_1011	: coeff_p1_ff	<= 13'h06c0 ;
						5'b1_1100	: coeff_p1_ff	<= 13'h0700 ;
						5'b1_1101	: coeff_p1_ff	<= 13'h0740 ;
						5'b1_1110	: coeff_p1_ff	<= 13'h0780 ;
						5'b1_1111	: coeff_p1_ff	<= 13'h07c0 ;
						default		: coeff_p1_ff	<= {13{1'bx}} ;
					endcase
				end
			end
		end
	endgenerate

	assign coeff_zr_o	= coeff_zr_ff ;
	assign coeff_p1_o	= coeff_p1_ff ;



endmodule

`default_nettype wire
