//----------------------------------------------------------------------------------------
//Copyright (C) 2015 Macnica Inc. All Rights Reserved.
//
//Use in source and binary forms, with or without modification, are permitted provided
//by agreeing to the following terms and conditions:
//
//REDISTRIBUTIONS OR SUBLICENSING IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS "AS IS"
//AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE
//FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
//SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
//CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
//OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//AND ALSO REGARDING THE REFERENCE SOFTWARE, REDISTRIBUTION OR SUBLICENSING
//IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//----------------------------------------------------------------------------------------
// DESCRIPTION
//		Synchronous reset release
//----------------------------------------------------------------------------------------
// REVISION HISTORY
//		v1.0 Dec. 11 2015	: Initial Version Release
//----------------------------------------------------------------------------------------
// PARAMETERS
//		BIT_WIDTH			: Synchronizer register bit width
//----------------------------------------------------------------------------------------
// I/O PORTS
//		clk					: Clock
//		async_rst_n			: Asynchronous reset input
//		sync_rst_n			: Synchronously released reset output
//----------------------------------------------------------------------------------------
`timescale 1ps/1ps
`default_nettype none

module rst_gen
	#(
		parameter						BIT_WIDTH = 4
	)
	(
		input	wire					clk				,
		input	wire					async_rst_n		,
		output	wire					sync_rst_no
	);

// =============================================================================
// REG / WIRE DECLARATION
// =============================================================================

	reg		[ BIT_WIDTH-1 : 0 ]		rst_ff ;

// =============================================================================
// FUNCTION DESCRIPTION
// =============================================================================

	always @( posedge clk or negedge async_rst_n ) begin
		if ( ~async_rst_n ) begin
			rst_ff[ BIT_WIDTH-1 : 0 ]	<=	{ BIT_WIDTH{1'b0} };
		end
		else begin
			rst_ff[ BIT_WIDTH-1 : 0 ]	<=	{ rst_ff[ BIT_WIDTH-2 : 0 ] , 1'b1 };
		end
    end

    assign sync_rst_no = rst_ff[ BIT_WIDTH-1 ];

endmodule
`default_nettype wire