//----------------------------------------------------------------------------------------
//Copyright (C) 2012 Macnica Inc. All Rights Reserved.
//
//Use in source and binary forms, with or without modification, are permitted provided
//by agreeing to the following terms and conditions:
//
//REDISTRIBUTIONS OR SUBLICENSING IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS "AS IS"
//AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE
//FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
//SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
//CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
//OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//AND ALSO REGARDING THE REFERENCE SOFTWARE, REDISTRIBUTION OR SUBLICENSING
//IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//----------------------------------------------------------------------------------------
// DESCRIPTION
//		multiplication circuit
//----------------------------------------------------------------------------------------
// REVISION HISTORY
//		v1.0 Nov. 13 2012	: Initial Version Release
//----------------------------------------------------------------------------------------
// PARAMETERS
//		APORT_BIT	: "dataa_i" port bit width
//		BPORT_BIT	: "datab_i" port bit width
//
//----------------------------------------------------------------------------------------
// I/O PORTS
//		clk 		: clock for all circuit
//		rst_n		: asynchronous reset ( low active )
//		enable		: clock enable
//
//		dataa_i		: multiplicand
//		datab_i		: multiplier
//
//		result_o	: result
//
//----------------------------------------------------------------------------------------
`timescale 1ps/1ps
`default_nettype none

module	pc11_unsigned_mult (
	clk		,
	rst_n	,
	enable	,

	dataa_i	,
	datab_i	,

	result_o
	) ;


// =============================================================================
// PARAMETER DEFINITION
// =============================================================================

	// ---------------------------------------------------------------------
	// Below parameters have to be defined from upper module
	// ---------------------------------------------------------------------

	parameter	APORT_BIT		= 8						;
	parameter	BPORT_BIT		= 8						;

	// ---------------------------------------------------------------------
	// Please do not change the following parameters
	// ---------------------------------------------------------------------

	parameter	YPORT_BIT		= APORT_BIT + BPORT_BIT	;


// =============================================================================
// PORT DECLARATION
// =============================================================================

	input	wire							clk			;
	input	wire							rst_n		;
	input	wire							enable		;

	input	wire	[ APORT_BIT - 1 : 0 ]	dataa_i		;
	input	wire	[ BPORT_BIT - 1 : 0 ]	datab_i		;

	output	wire	[ YPORT_BIT - 1 : 0 ]	result_o	;


// =============================================================================
// REG / WIRE DECLARATION
// =============================================================================

	reg 	[ APORT_BIT - 1 : 0 ]	dataa_ff	;
	reg 	[ BPORT_BIT - 1 : 0 ]	datab_ff	;

	wire	[ YPORT_BIT - 1 : 0 ]	result		;

	reg		[ YPORT_BIT - 1 : 0 ]	result_ff	;


// =============================================================================
// FUNCTION DESCRIPTION
// =============================================================================

	always @( posedge clk or negedge rst_n ) begin
		if ( !rst_n ) begin
			dataa_ff	<= { APORT_BIT{1'b0} } ;
			datab_ff	<= { BPORT_BIT{1'b0} } ;
		end
		else if ( enable ) begin
			dataa_ff	<= dataa_i ;
			datab_ff	<= datab_i ;
		end
	end

	assign result		= dataa_ff * datab_ff ;

	always @( posedge clk or negedge rst_n ) begin
		if ( !rst_n ) begin
			result_ff	<= { YPORT_BIT{1'b0} } ;
		end
		else if ( enable ) begin
			result_ff	<= result ;
		end
	end

	assign	result_o	= result_ff ;


endmodule

`default_nettype wire
