
namespace eval xcvr_rx {
  proc get_design_libraries {} {
    set libraries [dict create]
    dict set libraries intel_adme_gts_100       1
    dict set libraries intel_directphy_gts_1000 1
    dict set libraries pcs_hal_2100             1
    dict set libraries one_lane_hal_2100        1
    dict set libraries fec_hal_2100             1
    dict set libraries pldif_hal_2100           1
    dict set libraries phy_hal_2100             1
    dict set libraries hal_top_2100             1
    dict set libraries n_channel_superset_2100  1
    dict set libraries xcvr_rx                  1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set memory_files [list]
    lappend memory_files "[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/SM_SRC_VLIW_MIF.mif"]"
    return $memory_files
  }
  
  proc get_common_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [dict create]
    return $design_files
  }
  
  proc get_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set design_files [list]
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_adme_gts_100/sim/xcvr_rx_intel_adme_gts_100_im7qd5a.sv"]\"  -work intel_adme_gts_100"                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_adme_gts_100/sim/alt_xcvr_avmm_arb.sv"]\"  -work intel_adme_gts_100"                                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_adme_gts_100/sim/alt_xcvr_arbiter.sv"]\"  -work intel_adme_gts_100"                                                           
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/xcvr_rx_intel_directphy_gts_intel_adme_gts_1000_qfi2nly.v"]\"  -work intel_directphy_gts_1000"    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../pcs_hal_2100/sim/xcvr_rx_pcs_hal_2100_i6srn2q.sv"]\"  -work pcs_hal_2100"                                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../pcs_hal_2100/sim/ch4_pcs.sv"]\"  -work pcs_hal_2100"                                                                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../pcs_hal_2100/sim/pcs_hal_coreip.sv"]\"  -work pcs_hal_2100"                                                                         
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../one_lane_hal_2100/sim/xcvr_rx_one_lane_hal_pcs_hal_2100_ij4zeoi.v"]\"  -work one_lane_hal_2100"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../fec_hal_2100/sim/xcvr_rx_fec_hal_2100_lxszoea.sv"]\"  -work fec_hal_2100"                                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../fec_hal_2100/sim/ch4_fec.sv"]\"  -work fec_hal_2100"                                                                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../fec_hal_2100/sim/fec_hal_coreip.sv"]\"  -work fec_hal_2100"                                                                         
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../one_lane_hal_2100/sim/xcvr_rx_one_lane_hal_fec_hal_2100_hmiwnzy.v"]\"  -work one_lane_hal_2100"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../pldif_hal_2100/sim/xcvr_rx_pldif_hal_2100_pvald3a.sv"]\"  -work pldif_hal_2100"                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../pldif_hal_2100/sim/pldif_hal_coreip.sv"]\"  -work pldif_hal_2100"                                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../pldif_hal_2100/sim/ch4_pldif.sv"]\"  -work pldif_hal_2100"                                                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../pldif_hal_2100/sim/ch4_pldif_no_deskew.sv"]\"  -work pldif_hal_2100"                                                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../pldif_hal_2100/sim/pldif_staticmux.sv"]\"  -work pldif_hal_2100"                                                                    
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../one_lane_hal_2100/sim/xcvr_rx_one_lane_hal_pldif_hal_2100_5j5f5ry.v"]\"  -work one_lane_hal_2100"                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../phy_hal_2100/sim/xcvr_rx_phy_hal_2100_wxgv76q.sv"]\"  -work phy_hal_2100"                                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../phy_hal_2100/sim/phy_staticmux.sv"]\"  -work phy_hal_2100"                                                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../phy_hal_2100/sim/phy_hal_coreip.sv"]\"  -work phy_hal_2100"                                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../phy_hal_2100/sim/ch4_phy.sv"]\"  -work phy_hal_2100"                                                                                
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../one_lane_hal_2100/sim/xcvr_rx_one_lane_hal_phy_hal_2100_7otcomy.v"]\"  -work one_lane_hal_2100"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../one_lane_hal_2100/sim/xcvr_rx_one_lane_hal_2100_6tkwgpa.sv"]\"  -work one_lane_hal_2100"                                            
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../hal_top_2100/sim/xcvr_rx_hal_top_one_lane_hal_2100_rw6juwa.v"]\"  -work hal_top_2100"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../hal_top_2100/sim/xcvr_rx_hal_top_2100_bp4uusq.sv"]\"  -work hal_top_2100"                                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../hal_top_2100/sim/hip_sip_boundary_bp4uusq.sv"]\"  -work hal_top_2100"                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../hal_top_2100/sim/shared_ptp.sv"]\"  -work hal_top_2100"                                                                             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../hal_top_2100/sim/mc.sv"]\"  -work hal_top_2100"                                                                                     
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../hal_top_2100/sim/shared_hal_coreip.v"]\"  -work hal_top_2100"                                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../hal_top_2100/sim/chptp.sv"]\"  -work hal_top_2100"                                                                                  
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/xcvr_rx_n_channel_superset_hal_top_2100_l6lnsqy.v"]\"  -work n_channel_superset_2100"              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/xcvr_rx_n_channel_superset_2100_jlfulcy.sv"]\"  -work n_channel_superset_2100"                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/ncss_avmm_decoder.sv"]\"  -work n_channel_superset_2100"                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_addr_gen.sv"]\"  -work n_channel_superset_2100"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_csr.sv"]\"  -work n_channel_superset_2100"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_data_sync.sv"]\"  -work n_channel_superset_2100"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_flow_ctrl.sv"]\"  -work n_channel_superset_2100"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_lane.sv"]\"  -work n_channel_superset_2100"                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_lane2lane.sv"]\"  -work n_channel_superset_2100"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_lane_rst_sequence_fsm.sv"]\"  -work n_channel_superset_2100"                        
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_lane_wrapper.sv"]\"  -work n_channel_superset_2100"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_monitor.sv"]\"  -work n_channel_superset_2100"                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_stagger_block.sv"]\"  -work n_channel_superset_2100"                                
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_std_synchronizer_nocut.v"]\"  -work n_channel_superset_2100"                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/intel_src_synchronizers.sv"]\"  -work n_channel_superset_2100"                                
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/sopc_synchronizer.v"]\"  -work n_channel_superset_2100"                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/ncss_common_ptp_top.sv"]\"  -work n_channel_superset_2100"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/tennm_sm_hssi_pld_chnl_dp_sip_atom.sv"]\"  -work n_channel_superset_2100"                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/ff_macro_init.sv"]\"  -work n_channel_superset_2100"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/refclk_recovery_sm.sv"]\"  -work n_channel_superset_2100"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/refclk_recovery_arb.sv"]\"  -work n_channel_superset_2100"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/refclk_recovery_arbiter.sv"]\"  -work n_channel_superset_2100"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/refclk_recovery_xcvr_resync_std.sv"]\"  -work n_channel_superset_2100"                        
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/refclk_recovery_altera_std_synchronizer_nocut.v"]\"  -work n_channel_superset_2100"      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/tennm_sm_hssi_pld_chnl_dp_sip_atom_lavmm_arbiter.sv"]\"  -work n_channel_superset_2100"       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/tennm_sm_hssi_pld_chnl_dp_sip_atom_mux_arbiter.sv"]\"  -work n_channel_superset_2100"         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/tennm_sm_hssi_pld_chnl_dp_sip_atom_mux_rx.sv"]\"  -work n_channel_superset_2100"              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/tennm_sm_hssi_pld_chnl_dp_sip_atom_mux_tx.sv"]\"  -work n_channel_superset_2100"              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/tennm_sm_hssi_pld_chnl_dp_sip_atom_mux_tx_rx.sv"]\"  -work n_channel_superset_2100"           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../n_channel_superset_2100/sim/intelfpga/tennm_sm_hssi.std_func.sv"]\"  -work n_channel_superset_2100"                                 
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/xcvr_rx_intel_directphy_gts_n_channel_superset_1000_up3kipa.v"]\"  -work intel_directphy_gts_1000"
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/sip_async_mapping.sv"]\"  -work intel_directphy_gts_1000"                                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/directphy_port_lane_mapping.sv"]\"  -work intel_directphy_gts_1000"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/intel_directphy_avmm.sv"]\"  -work intel_directphy_gts_1000"                                           
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/intel_directphy_csr_wrap.v"]\"  -work intel_directphy_gts_1000"                                   
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/dphy_ccg.v"]\"  -work intel_directphy_gts_1000"                                                   
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/directphy_gray_cntr_3.v"]\"  -work intel_directphy_gts_1000"                                      
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/directphy_gray_cntr_5_sl.v"]\"  -work intel_directphy_gts_1000"                                   
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/dphy_gts_std_synchronizer_nocut.v"]\"  -work intel_directphy_gts_1000"                            
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/directphy_eq_5_ena.v"]\"  -work intel_directphy_gts_1000"                                         
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/directphy_neq_5_ena.v"]\"  -work intel_directphy_gts_1000"                                        
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/directphy_wys_lut.v"]\"  -work intel_directphy_gts_1000"                                          
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/intel_directphy_sip_csr.v"]\"  -work intel_directphy_gts_1000"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/dphy_tx_dsk_gen.sv"]\"  -work intel_directphy_gts_1000"                                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/directphy_rx_deskew.sv"]\"  -work intel_directphy_gts_1000"                                            
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/directphy_word_delay.v"]\"  -work intel_directphy_gts_1000"                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/directphy_mlab.v"]\"  -work intel_directphy_gts_1000"                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/dphy_gts_xcvr_resync_std.sv"]\"  -work intel_directphy_gts_1000"                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/dphy_gts_data_sync.sv"]\"  -work intel_directphy_gts_1000"                                             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/alt_xcvr_resync_etile.sv"]\"  -work intel_directphy_gts_1000"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/altera_std_synchronizer_nocut_etile.v"]\"  -work intel_directphy_gts_1000"                             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/xcvr_rx_intel_directphy_gts_1000_wcjebnq.sv"]\"  -work intel_directphy_gts_1000"                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../intel_directphy_gts_1000/sim/xcvr_rx_intel_directphy_gts_1000_wcjebnq_sip.sv"]\"  -work intel_directphy_gts_1000"                   
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/xcvr_rx.v"]\"  -work xcvr_rx"                                                                                                     
    return $design_files
  }
  
  proc get_non_duplicate_elab_option {ELAB_OPTIONS NEW_ELAB_OPTION} {
    set IS_DUPLICATE [string first $NEW_ELAB_OPTION $ELAB_OPTIONS]
    if {$IS_DUPLICATE == -1} {
      return $NEW_ELAB_OPTION
    } else {
      return ""
    }
  }
  
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    
    return $libraries
  }
  
}
