// niosv_ss.v

// Generated using ACDS version 25.3 109

`timescale 1 ps / 1 ps
module niosv_ss (
		input  wire        clk_clk,                   //         clk.clk
		output wire [31:0] pio_0_export,              //       pio_0.export
		input  wire [31:0] pio_1_export,              //       pio_1.export
		input  wire        rst_n_reset_n,             //       rst_n.reset_n
		output wire [7:0]  slec_rx_csr_address,       // slec_rx_csr.address
		output wire [3:0]  slec_rx_csr_byteenable,    //            .byteenable
		output wire        slec_rx_csr_write,         //            .write
		output wire [31:0] slec_rx_csr_writedata,     //            .writedata
		output wire        slec_rx_csr_read,          //            .read
		input  wire [31:0] slec_rx_csr_readdata,      //            .readdata
		input  wire        slec_rx_csr_readdatavalid, //            .readdatavalid
		input  wire        slec_rx_csr_waitrequest,   //            .waitrequest
		input  wire        spi_MISO,                  //         spi.MISO
		output wire        spi_MOSI,                  //            .MOSI
		output wire        spi_SCLK,                  //            .SCLK
		output wire        spi_SS_n                   //            .SS_n
	);

	wire         clk_out_clk_clk;                                           // clk:out_clk -> [irq_mapper:clk, jtag_uart:clk, mm_interconnect_0:clk_out_clk_clk, niosv:clk, pio_0:clk, pio_1:clk, ram:clk, rst_controller:clk, rst_controller_001:clk, rst_controller_002:clk, slec_rx_csr:clk, spi:clk]
	wire  [31:0] niosv_data_manager_awaddr;                                 // niosv:data_manager_awaddr -> mm_interconnect_0:niosv_data_manager_awaddr
	wire   [1:0] niosv_data_manager_bresp;                                  // mm_interconnect_0:niosv_data_manager_bresp -> niosv:data_manager_bresp
	wire         niosv_data_manager_arready;                                // mm_interconnect_0:niosv_data_manager_arready -> niosv:data_manager_arready
	wire  [31:0] niosv_data_manager_rdata;                                  // mm_interconnect_0:niosv_data_manager_rdata -> niosv:data_manager_rdata
	wire   [3:0] niosv_data_manager_wstrb;                                  // niosv:data_manager_wstrb -> mm_interconnect_0:niosv_data_manager_wstrb
	wire         niosv_data_manager_wready;                                 // mm_interconnect_0:niosv_data_manager_wready -> niosv:data_manager_wready
	wire         niosv_data_manager_awready;                                // mm_interconnect_0:niosv_data_manager_awready -> niosv:data_manager_awready
	wire         niosv_data_manager_rready;                                 // niosv:data_manager_rready -> mm_interconnect_0:niosv_data_manager_rready
	wire         niosv_data_manager_bready;                                 // niosv:data_manager_bready -> mm_interconnect_0:niosv_data_manager_bready
	wire         niosv_data_manager_wvalid;                                 // niosv:data_manager_wvalid -> mm_interconnect_0:niosv_data_manager_wvalid
	wire  [31:0] niosv_data_manager_araddr;                                 // niosv:data_manager_araddr -> mm_interconnect_0:niosv_data_manager_araddr
	wire   [2:0] niosv_data_manager_arprot;                                 // niosv:data_manager_arprot -> mm_interconnect_0:niosv_data_manager_arprot
	wire   [1:0] niosv_data_manager_rresp;                                  // mm_interconnect_0:niosv_data_manager_rresp -> niosv:data_manager_rresp
	wire   [2:0] niosv_data_manager_awprot;                                 // niosv:data_manager_awprot -> mm_interconnect_0:niosv_data_manager_awprot
	wire  [31:0] niosv_data_manager_wdata;                                  // niosv:data_manager_wdata -> mm_interconnect_0:niosv_data_manager_wdata
	wire         niosv_data_manager_arvalid;                                // niosv:data_manager_arvalid -> mm_interconnect_0:niosv_data_manager_arvalid
	wire         niosv_data_manager_bvalid;                                 // mm_interconnect_0:niosv_data_manager_bvalid -> niosv:data_manager_bvalid
	wire         niosv_data_manager_awvalid;                                // niosv:data_manager_awvalid -> mm_interconnect_0:niosv_data_manager_awvalid
	wire         niosv_data_manager_rvalid;                                 // mm_interconnect_0:niosv_data_manager_rvalid -> niosv:data_manager_rvalid
	wire  [31:0] niosv_instruction_manager_awaddr;                          // niosv:instruction_manager_awaddr -> mm_interconnect_0:niosv_instruction_manager_awaddr
	wire   [1:0] niosv_instruction_manager_bresp;                           // mm_interconnect_0:niosv_instruction_manager_bresp -> niosv:instruction_manager_bresp
	wire         niosv_instruction_manager_arready;                         // mm_interconnect_0:niosv_instruction_manager_arready -> niosv:instruction_manager_arready
	wire  [31:0] niosv_instruction_manager_rdata;                           // mm_interconnect_0:niosv_instruction_manager_rdata -> niosv:instruction_manager_rdata
	wire   [3:0] niosv_instruction_manager_wstrb;                           // niosv:instruction_manager_wstrb -> mm_interconnect_0:niosv_instruction_manager_wstrb
	wire         niosv_instruction_manager_wready;                          // mm_interconnect_0:niosv_instruction_manager_wready -> niosv:instruction_manager_wready
	wire         niosv_instruction_manager_awready;                         // mm_interconnect_0:niosv_instruction_manager_awready -> niosv:instruction_manager_awready
	wire         niosv_instruction_manager_rready;                          // niosv:instruction_manager_rready -> mm_interconnect_0:niosv_instruction_manager_rready
	wire         niosv_instruction_manager_bready;                          // niosv:instruction_manager_bready -> mm_interconnect_0:niosv_instruction_manager_bready
	wire         niosv_instruction_manager_wvalid;                          // niosv:instruction_manager_wvalid -> mm_interconnect_0:niosv_instruction_manager_wvalid
	wire  [31:0] niosv_instruction_manager_araddr;                          // niosv:instruction_manager_araddr -> mm_interconnect_0:niosv_instruction_manager_araddr
	wire   [2:0] niosv_instruction_manager_arprot;                          // niosv:instruction_manager_arprot -> mm_interconnect_0:niosv_instruction_manager_arprot
	wire   [1:0] niosv_instruction_manager_rresp;                           // mm_interconnect_0:niosv_instruction_manager_rresp -> niosv:instruction_manager_rresp
	wire   [2:0] niosv_instruction_manager_awprot;                          // niosv:instruction_manager_awprot -> mm_interconnect_0:niosv_instruction_manager_awprot
	wire  [31:0] niosv_instruction_manager_wdata;                           // niosv:instruction_manager_wdata -> mm_interconnect_0:niosv_instruction_manager_wdata
	wire         niosv_instruction_manager_arvalid;                         // niosv:instruction_manager_arvalid -> mm_interconnect_0:niosv_instruction_manager_arvalid
	wire         niosv_instruction_manager_bvalid;                          // mm_interconnect_0:niosv_instruction_manager_bvalid -> niosv:instruction_manager_bvalid
	wire         niosv_instruction_manager_awvalid;                         // niosv:instruction_manager_awvalid -> mm_interconnect_0:niosv_instruction_manager_awvalid
	wire         niosv_instruction_manager_rvalid;                          // mm_interconnect_0:niosv_instruction_manager_rvalid -> niosv:instruction_manager_rvalid
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect;  // mm_interconnect_0:jtag_uart_avalon_jtag_slave_chipselect -> jtag_uart:av_chipselect
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata;    // jtag_uart:av_readdata -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_readdata
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest; // jtag_uart:av_waitrequest -> mm_interconnect_0:jtag_uart_avalon_jtag_slave_waitrequest
	wire   [0:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_address;     // mm_interconnect_0:jtag_uart_avalon_jtag_slave_address -> jtag_uart:av_address
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_read;        // mm_interconnect_0:jtag_uart_avalon_jtag_slave_read -> jtag_uart:av_read_n
	wire         mm_interconnect_0_jtag_uart_avalon_jtag_slave_write;       // mm_interconnect_0:jtag_uart_avalon_jtag_slave_write -> jtag_uart:av_write_n
	wire  [31:0] mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata;   // mm_interconnect_0:jtag_uart_avalon_jtag_slave_writedata -> jtag_uart:av_writedata
	wire  [31:0] mm_interconnect_0_slec_rx_csr_avsi_csr_readdata;           // slec_rx_csr:avsi_csr_readdata -> mm_interconnect_0:slec_rx_csr_avsi_csr_readdata
	wire         mm_interconnect_0_slec_rx_csr_avsi_csr_waitrequest;        // slec_rx_csr:avsi_csr_waitrequest -> mm_interconnect_0:slec_rx_csr_avsi_csr_waitrequest
	wire   [7:0] mm_interconnect_0_slec_rx_csr_avsi_csr_address;            // mm_interconnect_0:slec_rx_csr_avsi_csr_address -> slec_rx_csr:avsi_csr_address
	wire         mm_interconnect_0_slec_rx_csr_avsi_csr_read;               // mm_interconnect_0:slec_rx_csr_avsi_csr_read -> slec_rx_csr:avsi_csr_read
	wire   [3:0] mm_interconnect_0_slec_rx_csr_avsi_csr_byteenable;         // mm_interconnect_0:slec_rx_csr_avsi_csr_byteenable -> slec_rx_csr:avsi_csr_byteenable
	wire         mm_interconnect_0_slec_rx_csr_avsi_csr_readdatavalid;      // slec_rx_csr:avsi_csr_readdatavalid -> mm_interconnect_0:slec_rx_csr_avsi_csr_readdatavalid
	wire         mm_interconnect_0_slec_rx_csr_avsi_csr_write;              // mm_interconnect_0:slec_rx_csr_avsi_csr_write -> slec_rx_csr:avsi_csr_write
	wire  [31:0] mm_interconnect_0_slec_rx_csr_avsi_csr_writedata;          // mm_interconnect_0:slec_rx_csr_avsi_csr_writedata -> slec_rx_csr:avsi_csr_writedata
	wire  [31:0] mm_interconnect_0_niosv_dm_agent_readdata;                 // niosv:dm_agent_readdata -> mm_interconnect_0:niosv_dm_agent_readdata
	wire         mm_interconnect_0_niosv_dm_agent_waitrequest;              // niosv:dm_agent_waitrequest -> mm_interconnect_0:niosv_dm_agent_waitrequest
	wire  [15:0] mm_interconnect_0_niosv_dm_agent_address;                  // mm_interconnect_0:niosv_dm_agent_address -> niosv:dm_agent_address
	wire         mm_interconnect_0_niosv_dm_agent_read;                     // mm_interconnect_0:niosv_dm_agent_read -> niosv:dm_agent_read
	wire         mm_interconnect_0_niosv_dm_agent_readdatavalid;            // niosv:dm_agent_readdatavalid -> mm_interconnect_0:niosv_dm_agent_readdatavalid
	wire         mm_interconnect_0_niosv_dm_agent_write;                    // mm_interconnect_0:niosv_dm_agent_write -> niosv:dm_agent_write
	wire  [31:0] mm_interconnect_0_niosv_dm_agent_writedata;                // mm_interconnect_0:niosv_dm_agent_writedata -> niosv:dm_agent_writedata
	wire  [31:0] mm_interconnect_0_ram_s1_readdata;                         // ram:readdata -> mm_interconnect_0:ram_s1_readdata
	wire  [16:0] mm_interconnect_0_ram_s1_address;                          // mm_interconnect_0:ram_s1_address -> ram:address
	wire         mm_interconnect_0_ram_s1_read;                             // mm_interconnect_0:ram_s1_read -> ram:read
	wire   [3:0] mm_interconnect_0_ram_s1_byteenable;                       // mm_interconnect_0:ram_s1_byteenable -> ram:byteenable
	wire         mm_interconnect_0_ram_s1_write;                            // mm_interconnect_0:ram_s1_write -> ram:write
	wire  [31:0] mm_interconnect_0_ram_s1_writedata;                        // mm_interconnect_0:ram_s1_writedata -> ram:writedata
	wire         mm_interconnect_0_pio_0_s1_chipselect;                     // mm_interconnect_0:pio_0_s1_chipselect -> pio_0:chipselect
	wire  [31:0] mm_interconnect_0_pio_0_s1_readdata;                       // pio_0:readdata -> mm_interconnect_0:pio_0_s1_readdata
	wire   [1:0] mm_interconnect_0_pio_0_s1_address;                        // mm_interconnect_0:pio_0_s1_address -> pio_0:address
	wire         mm_interconnect_0_pio_0_s1_write;                          // mm_interconnect_0:pio_0_s1_write -> pio_0:write_n
	wire  [31:0] mm_interconnect_0_pio_0_s1_writedata;                      // mm_interconnect_0:pio_0_s1_writedata -> pio_0:writedata
	wire  [31:0] mm_interconnect_0_pio_1_s1_readdata;                       // pio_1:readdata -> mm_interconnect_0:pio_1_s1_readdata
	wire   [1:0] mm_interconnect_0_pio_1_s1_address;                        // mm_interconnect_0:pio_1_s1_address -> pio_1:address
	wire         mm_interconnect_0_spi_spi_control_port_chipselect;         // mm_interconnect_0:spi_spi_control_port_chipselect -> spi:spi_select
	wire  [31:0] mm_interconnect_0_spi_spi_control_port_readdata;           // spi:data_to_cpu -> mm_interconnect_0:spi_spi_control_port_readdata
	wire   [2:0] mm_interconnect_0_spi_spi_control_port_address;            // mm_interconnect_0:spi_spi_control_port_address -> spi:mem_addr
	wire         mm_interconnect_0_spi_spi_control_port_read;               // mm_interconnect_0:spi_spi_control_port_read -> spi:read_n
	wire         mm_interconnect_0_spi_spi_control_port_write;              // mm_interconnect_0:spi_spi_control_port_write -> spi:write_n
	wire  [31:0] mm_interconnect_0_spi_spi_control_port_writedata;          // mm_interconnect_0:spi_spi_control_port_writedata -> spi:data_from_cpu
	wire  [31:0] mm_interconnect_0_niosv_timer_sw_agent_readdata;           // niosv:timer_sw_agent_readdata -> mm_interconnect_0:niosv_timer_sw_agent_readdata
	wire         mm_interconnect_0_niosv_timer_sw_agent_waitrequest;        // niosv:timer_sw_agent_waitrequest -> mm_interconnect_0:niosv_timer_sw_agent_waitrequest
	wire   [5:0] mm_interconnect_0_niosv_timer_sw_agent_address;            // mm_interconnect_0:niosv_timer_sw_agent_address -> niosv:timer_sw_agent_address
	wire         mm_interconnect_0_niosv_timer_sw_agent_read;               // mm_interconnect_0:niosv_timer_sw_agent_read -> niosv:timer_sw_agent_read
	wire   [3:0] mm_interconnect_0_niosv_timer_sw_agent_byteenable;         // mm_interconnect_0:niosv_timer_sw_agent_byteenable -> niosv:timer_sw_agent_byteenable
	wire         mm_interconnect_0_niosv_timer_sw_agent_readdatavalid;      // niosv:timer_sw_agent_readdatavalid -> mm_interconnect_0:niosv_timer_sw_agent_readdatavalid
	wire         mm_interconnect_0_niosv_timer_sw_agent_write;              // mm_interconnect_0:niosv_timer_sw_agent_write -> niosv:timer_sw_agent_write
	wire  [31:0] mm_interconnect_0_niosv_timer_sw_agent_writedata;          // mm_interconnect_0:niosv_timer_sw_agent_writedata -> niosv:timer_sw_agent_writedata
	wire         irq_mapper_receiver0_irq;                                  // spi:irq -> irq_mapper:receiver0_irq
	wire         irq_mapper_receiver1_irq;                                  // jtag_uart:av_irq -> irq_mapper:receiver1_irq
	wire  [15:0] niosv_platform_irq_rx_irq;                                 // irq_mapper:sender_irq -> niosv:platform_irq_rx_irq
	wire         rst_controller_reset_out_reset;                            // rst_controller:reset_out -> [irq_mapper:reset, jtag_uart:rst_n, niosv:reset_reset, pio_0:reset_n, pio_1:reset_n, ram:reset, rst_translator:in_reset, slec_rx_csr:rst_n, spi:reset_n]
	wire         rst_controller_reset_out_reset_req;                        // rst_controller:reset_req -> [ram:reset_req, rst_translator:reset_req_in]
	wire         rst_n_out_reset_reset;                                     // rst_n:out_reset_n -> [rst_controller:reset_in0, rst_controller_001:reset_in1, rst_controller_002:reset_in0]
	wire         rst_controller_001_reset_out_reset;                        // rst_controller_001:reset_out -> niosv:ndm_reset_in_reset
	wire         niosv_dbg_reset_out_reset;                                 // niosv:dbg_reset_out_reset -> rst_controller_001:reset_in0
	wire         rst_controller_002_reset_out_reset;                        // rst_controller_002:reset_out -> [mm_interconnect_0:niosv_data_manager_translator_clk_reset_reset_bridge_in_reset_reset, mm_interconnect_0:niosv_reset_reset_bridge_in_reset_reset]

	niosv_ss_clock_in clk (
		.in_clk  (clk_clk),         //   input,  width = 1,  in_clk.clk
		.out_clk (clk_out_clk_clk)  //  output,  width = 1, out_clk.clk
	);

	niosv_ss_jtag_uart_0 jtag_uart (
		.clk            (clk_out_clk_clk),                                           //   input,   width = 1,               clk.clk
		.rst_n          (~rst_controller_reset_out_reset),                           //   input,   width = 1,             reset.reset_n
		.av_chipselect  (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),  //   input,   width = 1, avalon_jtag_slave.chipselect
		.av_address     (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),     //   input,   width = 1,                  .address
		.av_read_n      (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),       //   input,   width = 1,                  .read_n
		.av_readdata    (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),    //  output,  width = 32,                  .readdata
		.av_write_n     (~mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),      //   input,   width = 1,                  .write_n
		.av_writedata   (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),   //   input,  width = 32,                  .writedata
		.av_waitrequest (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest), //  output,   width = 1,                  .waitrequest
		.av_irq         (irq_mapper_receiver1_irq)                                   //  output,   width = 1,               irq.irq
	);

	niosv_ss_intel_niosv_m_0 niosv (
		.clk                          (clk_out_clk_clk),                                      //   input,   width = 1,                 clk.clk
		.reset_reset                  (rst_controller_reset_out_reset),                       //   input,   width = 1,               reset.reset
		.platform_irq_rx_irq          (niosv_platform_irq_rx_irq),                            //   input,  width = 16,     platform_irq_rx.irq
		.instruction_manager_awaddr   (niosv_instruction_manager_awaddr),                     //  output,  width = 32, instruction_manager.awaddr
		.instruction_manager_awprot   (niosv_instruction_manager_awprot),                     //  output,   width = 3,                    .awprot
		.instruction_manager_awvalid  (niosv_instruction_manager_awvalid),                    //  output,   width = 1,                    .awvalid
		.instruction_manager_awready  (niosv_instruction_manager_awready),                    //   input,   width = 1,                    .awready
		.instruction_manager_wdata    (niosv_instruction_manager_wdata),                      //  output,  width = 32,                    .wdata
		.instruction_manager_wstrb    (niosv_instruction_manager_wstrb),                      //  output,   width = 4,                    .wstrb
		.instruction_manager_wvalid   (niosv_instruction_manager_wvalid),                     //  output,   width = 1,                    .wvalid
		.instruction_manager_wready   (niosv_instruction_manager_wready),                     //   input,   width = 1,                    .wready
		.instruction_manager_bresp    (niosv_instruction_manager_bresp),                      //   input,   width = 2,                    .bresp
		.instruction_manager_bvalid   (niosv_instruction_manager_bvalid),                     //   input,   width = 1,                    .bvalid
		.instruction_manager_bready   (niosv_instruction_manager_bready),                     //  output,   width = 1,                    .bready
		.instruction_manager_araddr   (niosv_instruction_manager_araddr),                     //  output,  width = 32,                    .araddr
		.instruction_manager_arprot   (niosv_instruction_manager_arprot),                     //  output,   width = 3,                    .arprot
		.instruction_manager_arvalid  (niosv_instruction_manager_arvalid),                    //  output,   width = 1,                    .arvalid
		.instruction_manager_arready  (niosv_instruction_manager_arready),                    //   input,   width = 1,                    .arready
		.instruction_manager_rdata    (niosv_instruction_manager_rdata),                      //   input,  width = 32,                    .rdata
		.instruction_manager_rresp    (niosv_instruction_manager_rresp),                      //   input,   width = 2,                    .rresp
		.instruction_manager_rvalid   (niosv_instruction_manager_rvalid),                     //   input,   width = 1,                    .rvalid
		.instruction_manager_rready   (niosv_instruction_manager_rready),                     //  output,   width = 1,                    .rready
		.data_manager_awaddr          (niosv_data_manager_awaddr),                            //  output,  width = 32,        data_manager.awaddr
		.data_manager_awprot          (niosv_data_manager_awprot),                            //  output,   width = 3,                    .awprot
		.data_manager_awvalid         (niosv_data_manager_awvalid),                           //  output,   width = 1,                    .awvalid
		.data_manager_awready         (niosv_data_manager_awready),                           //   input,   width = 1,                    .awready
		.data_manager_wdata           (niosv_data_manager_wdata),                             //  output,  width = 32,                    .wdata
		.data_manager_wstrb           (niosv_data_manager_wstrb),                             //  output,   width = 4,                    .wstrb
		.data_manager_wvalid          (niosv_data_manager_wvalid),                            //  output,   width = 1,                    .wvalid
		.data_manager_wready          (niosv_data_manager_wready),                            //   input,   width = 1,                    .wready
		.data_manager_bresp           (niosv_data_manager_bresp),                             //   input,   width = 2,                    .bresp
		.data_manager_bvalid          (niosv_data_manager_bvalid),                            //   input,   width = 1,                    .bvalid
		.data_manager_bready          (niosv_data_manager_bready),                            //  output,   width = 1,                    .bready
		.data_manager_araddr          (niosv_data_manager_araddr),                            //  output,  width = 32,                    .araddr
		.data_manager_arprot          (niosv_data_manager_arprot),                            //  output,   width = 3,                    .arprot
		.data_manager_arvalid         (niosv_data_manager_arvalid),                           //  output,   width = 1,                    .arvalid
		.data_manager_arready         (niosv_data_manager_arready),                           //   input,   width = 1,                    .arready
		.data_manager_rdata           (niosv_data_manager_rdata),                             //   input,  width = 32,                    .rdata
		.data_manager_rresp           (niosv_data_manager_rresp),                             //   input,   width = 2,                    .rresp
		.data_manager_rvalid          (niosv_data_manager_rvalid),                            //   input,   width = 1,                    .rvalid
		.data_manager_rready          (niosv_data_manager_rready),                            //  output,   width = 1,                    .rready
		.timer_sw_agent_address       (mm_interconnect_0_niosv_timer_sw_agent_address),       //   input,   width = 6,      timer_sw_agent.address
		.timer_sw_agent_byteenable    (mm_interconnect_0_niosv_timer_sw_agent_byteenable),    //   input,   width = 4,                    .byteenable
		.timer_sw_agent_read          (mm_interconnect_0_niosv_timer_sw_agent_read),          //   input,   width = 1,                    .read
		.timer_sw_agent_readdata      (mm_interconnect_0_niosv_timer_sw_agent_readdata),      //  output,  width = 32,                    .readdata
		.timer_sw_agent_write         (mm_interconnect_0_niosv_timer_sw_agent_write),         //   input,   width = 1,                    .write
		.timer_sw_agent_writedata     (mm_interconnect_0_niosv_timer_sw_agent_writedata),     //   input,  width = 32,                    .writedata
		.timer_sw_agent_waitrequest   (mm_interconnect_0_niosv_timer_sw_agent_waitrequest),   //  output,   width = 1,                    .waitrequest
		.timer_sw_agent_readdatavalid (mm_interconnect_0_niosv_timer_sw_agent_readdatavalid), //  output,   width = 1,                    .readdatavalid
		.dm_agent_address             (mm_interconnect_0_niosv_dm_agent_address),             //   input,  width = 16,            dm_agent.address
		.dm_agent_read                (mm_interconnect_0_niosv_dm_agent_read),                //   input,   width = 1,                    .read
		.dm_agent_readdata            (mm_interconnect_0_niosv_dm_agent_readdata),            //  output,  width = 32,                    .readdata
		.dm_agent_write               (mm_interconnect_0_niosv_dm_agent_write),               //   input,   width = 1,                    .write
		.dm_agent_writedata           (mm_interconnect_0_niosv_dm_agent_writedata),           //   input,  width = 32,                    .writedata
		.dm_agent_waitrequest         (mm_interconnect_0_niosv_dm_agent_waitrequest),         //  output,   width = 1,                    .waitrequest
		.dm_agent_readdatavalid       (mm_interconnect_0_niosv_dm_agent_readdatavalid),       //  output,   width = 1,                    .readdatavalid
		.dbg_reset_out_reset          (niosv_dbg_reset_out_reset),                            //  output,   width = 1,       dbg_reset_out.reset
		.ndm_reset_in_reset           (rst_controller_001_reset_out_reset)                    //   input,   width = 1,        ndm_reset_in.reset
	);

	niosv_ss_pio_0 pio_0 (
		.clk        (clk_out_clk_clk),                       //   input,   width = 1,                 clk.clk
		.reset_n    (~rst_controller_reset_out_reset),       //   input,   width = 1,               reset.reset_n
		.address    (mm_interconnect_0_pio_0_s1_address),    //   input,   width = 2,                  s1.address
		.write_n    (~mm_interconnect_0_pio_0_s1_write),     //   input,   width = 1,                    .write_n
		.writedata  (mm_interconnect_0_pio_0_s1_writedata),  //   input,  width = 32,                    .writedata
		.chipselect (mm_interconnect_0_pio_0_s1_chipselect), //   input,   width = 1,                    .chipselect
		.readdata   (mm_interconnect_0_pio_0_s1_readdata),   //  output,  width = 32,                    .readdata
		.out_port   (pio_0_export)                           //  output,  width = 32, external_connection.export
	);

	niosv_ss_pio_1 pio_1 (
		.clk      (clk_out_clk_clk),                     //   input,   width = 1,                 clk.clk
		.reset_n  (~rst_controller_reset_out_reset),     //   input,   width = 1,               reset.reset_n
		.address  (mm_interconnect_0_pio_1_s1_address),  //   input,   width = 2,                  s1.address
		.readdata (mm_interconnect_0_pio_1_s1_readdata), //  output,  width = 32,                    .readdata
		.in_port  (pio_1_export)                         //   input,  width = 32, external_connection.export
	);

	niosv_ss_intel_onchip_memory_0 ram (
		.clk        (clk_out_clk_clk),                     //   input,   width = 1,   clk1.clk
		.address    (mm_interconnect_0_ram_s1_address),    //   input,  width = 17,     s1.address
		.read       (mm_interconnect_0_ram_s1_read),       //   input,   width = 1,       .read
		.readdata   (mm_interconnect_0_ram_s1_readdata),   //  output,  width = 32,       .readdata
		.byteenable (mm_interconnect_0_ram_s1_byteenable), //   input,   width = 4,       .byteenable
		.write      (mm_interconnect_0_ram_s1_write),      //   input,   width = 1,       .write
		.writedata  (mm_interconnect_0_ram_s1_writedata),  //   input,  width = 32,       .writedata
		.reset      (rst_controller_reset_out_reset),      //   input,   width = 1, reset1.reset
		.reset_req  (rst_controller_reset_out_reset_req)   //   input,   width = 1,       .reset_req
	);

	niosv_ss_reset_in rst_n (
		.in_reset_n  (rst_n_reset_n),         //   input,  width = 1,  in_reset.reset_n
		.out_reset_n (rst_n_out_reset_reset)  //  output,  width = 1, out_reset.reset_n
	);

	niosv_ss_slec_rx_csr_0 slec_rx_csr (
		.clk                    (clk_out_clk_clk),                                      //   input,   width = 1,      clk.clk
		.rst_n                  (~rst_controller_reset_out_reset),                      //   input,   width = 1,    rst_n.reset_n
		.avsi_csr_address       (mm_interconnect_0_slec_rx_csr_avsi_csr_address),       //   input,   width = 8, avsi_csr.address
		.avsi_csr_byteenable    (mm_interconnect_0_slec_rx_csr_avsi_csr_byteenable),    //   input,   width = 4,         .byteenable
		.avsi_csr_write         (mm_interconnect_0_slec_rx_csr_avsi_csr_write),         //   input,   width = 1,         .write
		.avsi_csr_writedata     (mm_interconnect_0_slec_rx_csr_avsi_csr_writedata),     //   input,  width = 32,         .writedata
		.avsi_csr_read          (mm_interconnect_0_slec_rx_csr_avsi_csr_read),          //   input,   width = 1,         .read
		.avsi_csr_readdata      (mm_interconnect_0_slec_rx_csr_avsi_csr_readdata),      //  output,  width = 32,         .readdata
		.avsi_csr_readdatavalid (mm_interconnect_0_slec_rx_csr_avsi_csr_readdatavalid), //  output,   width = 1,         .readdatavalid
		.avsi_csr_waitrequest   (mm_interconnect_0_slec_rx_csr_avsi_csr_waitrequest),   //  output,   width = 1,         .waitrequest
		.avso_csr_address       (slec_rx_csr_address),                                  //  output,   width = 8, avso_csr.address
		.avso_csr_byteenable    (slec_rx_csr_byteenable),                               //  output,   width = 4,         .byteenable
		.avso_csr_write         (slec_rx_csr_write),                                    //  output,   width = 1,         .write
		.avso_csr_writedata     (slec_rx_csr_writedata),                                //  output,  width = 32,         .writedata
		.avso_csr_read          (slec_rx_csr_read),                                     //  output,   width = 1,         .read
		.avso_csr_readdata      (slec_rx_csr_readdata),                                 //   input,  width = 32,         .readdata
		.avso_csr_readdatavalid (slec_rx_csr_readdatavalid),                            //   input,   width = 1,         .readdatavalid
		.avso_csr_waitrequest   (slec_rx_csr_waitrequest)                               //   input,   width = 1,         .waitrequest
	);

	niosv_ss_spi_0 spi (
		.clk           (clk_out_clk_clk),                                   //   input,   width = 1,              clk.clk
		.reset_n       (~rst_controller_reset_out_reset),                   //   input,   width = 1,            reset.reset_n
		.data_from_cpu (mm_interconnect_0_spi_spi_control_port_writedata),  //   input,  width = 32, spi_control_port.writedata
		.data_to_cpu   (mm_interconnect_0_spi_spi_control_port_readdata),   //  output,  width = 32,                 .readdata
		.mem_addr      (mm_interconnect_0_spi_spi_control_port_address),    //   input,   width = 3,                 .address
		.read_n        (~mm_interconnect_0_spi_spi_control_port_read),      //   input,   width = 1,                 .read_n
		.spi_select    (mm_interconnect_0_spi_spi_control_port_chipselect), //   input,   width = 1,                 .chipselect
		.write_n       (~mm_interconnect_0_spi_spi_control_port_write),     //   input,   width = 1,                 .write_n
		.irq           (irq_mapper_receiver0_irq),                          //  output,   width = 1,              irq.irq
		.MISO          (spi_MISO),                                          //   input,   width = 1,         external.MISO
		.MOSI          (spi_MOSI),                                          //  output,   width = 1,                 .MOSI
		.SCLK          (spi_SCLK),                                          //  output,   width = 1,                 .SCLK
		.SS_n          (spi_SS_n)                                           //  output,   width = 1,                 .SS_n
	);

	niosv_ss_altera_mm_interconnect_1920_3sbqlwy mm_interconnect_0 (
		.niosv_data_manager_awaddr                                           (niosv_data_manager_awaddr),                                 //   input,  width = 32,                                            niosv_data_manager.awaddr
		.niosv_data_manager_awprot                                           (niosv_data_manager_awprot),                                 //   input,   width = 3,                                                              .awprot
		.niosv_data_manager_awvalid                                          (niosv_data_manager_awvalid),                                //   input,   width = 1,                                                              .awvalid
		.niosv_data_manager_awready                                          (niosv_data_manager_awready),                                //  output,   width = 1,                                                              .awready
		.niosv_data_manager_wdata                                            (niosv_data_manager_wdata),                                  //   input,  width = 32,                                                              .wdata
		.niosv_data_manager_wstrb                                            (niosv_data_manager_wstrb),                                  //   input,   width = 4,                                                              .wstrb
		.niosv_data_manager_wvalid                                           (niosv_data_manager_wvalid),                                 //   input,   width = 1,                                                              .wvalid
		.niosv_data_manager_wready                                           (niosv_data_manager_wready),                                 //  output,   width = 1,                                                              .wready
		.niosv_data_manager_bresp                                            (niosv_data_manager_bresp),                                  //  output,   width = 2,                                                              .bresp
		.niosv_data_manager_bvalid                                           (niosv_data_manager_bvalid),                                 //  output,   width = 1,                                                              .bvalid
		.niosv_data_manager_bready                                           (niosv_data_manager_bready),                                 //   input,   width = 1,                                                              .bready
		.niosv_data_manager_araddr                                           (niosv_data_manager_araddr),                                 //   input,  width = 32,                                                              .araddr
		.niosv_data_manager_arprot                                           (niosv_data_manager_arprot),                                 //   input,   width = 3,                                                              .arprot
		.niosv_data_manager_arvalid                                          (niosv_data_manager_arvalid),                                //   input,   width = 1,                                                              .arvalid
		.niosv_data_manager_arready                                          (niosv_data_manager_arready),                                //  output,   width = 1,                                                              .arready
		.niosv_data_manager_rdata                                            (niosv_data_manager_rdata),                                  //  output,  width = 32,                                                              .rdata
		.niosv_data_manager_rresp                                            (niosv_data_manager_rresp),                                  //  output,   width = 2,                                                              .rresp
		.niosv_data_manager_rvalid                                           (niosv_data_manager_rvalid),                                 //  output,   width = 1,                                                              .rvalid
		.niosv_data_manager_rready                                           (niosv_data_manager_rready),                                 //   input,   width = 1,                                                              .rready
		.niosv_instruction_manager_awaddr                                    (niosv_instruction_manager_awaddr),                          //   input,  width = 32,                                     niosv_instruction_manager.awaddr
		.niosv_instruction_manager_awprot                                    (niosv_instruction_manager_awprot),                          //   input,   width = 3,                                                              .awprot
		.niosv_instruction_manager_awvalid                                   (niosv_instruction_manager_awvalid),                         //   input,   width = 1,                                                              .awvalid
		.niosv_instruction_manager_awready                                   (niosv_instruction_manager_awready),                         //  output,   width = 1,                                                              .awready
		.niosv_instruction_manager_wdata                                     (niosv_instruction_manager_wdata),                           //   input,  width = 32,                                                              .wdata
		.niosv_instruction_manager_wstrb                                     (niosv_instruction_manager_wstrb),                           //   input,   width = 4,                                                              .wstrb
		.niosv_instruction_manager_wvalid                                    (niosv_instruction_manager_wvalid),                          //   input,   width = 1,                                                              .wvalid
		.niosv_instruction_manager_wready                                    (niosv_instruction_manager_wready),                          //  output,   width = 1,                                                              .wready
		.niosv_instruction_manager_bresp                                     (niosv_instruction_manager_bresp),                           //  output,   width = 2,                                                              .bresp
		.niosv_instruction_manager_bvalid                                    (niosv_instruction_manager_bvalid),                          //  output,   width = 1,                                                              .bvalid
		.niosv_instruction_manager_bready                                    (niosv_instruction_manager_bready),                          //   input,   width = 1,                                                              .bready
		.niosv_instruction_manager_araddr                                    (niosv_instruction_manager_araddr),                          //   input,  width = 32,                                                              .araddr
		.niosv_instruction_manager_arprot                                    (niosv_instruction_manager_arprot),                          //   input,   width = 3,                                                              .arprot
		.niosv_instruction_manager_arvalid                                   (niosv_instruction_manager_arvalid),                         //   input,   width = 1,                                                              .arvalid
		.niosv_instruction_manager_arready                                   (niosv_instruction_manager_arready),                         //  output,   width = 1,                                                              .arready
		.niosv_instruction_manager_rdata                                     (niosv_instruction_manager_rdata),                           //  output,  width = 32,                                                              .rdata
		.niosv_instruction_manager_rresp                                     (niosv_instruction_manager_rresp),                           //  output,   width = 2,                                                              .rresp
		.niosv_instruction_manager_rvalid                                    (niosv_instruction_manager_rvalid),                          //  output,   width = 1,                                                              .rvalid
		.niosv_instruction_manager_rready                                    (niosv_instruction_manager_rready),                          //   input,   width = 1,                                                              .rready
		.jtag_uart_avalon_jtag_slave_address                                 (mm_interconnect_0_jtag_uart_avalon_jtag_slave_address),     //  output,   width = 1,                                   jtag_uart_avalon_jtag_slave.address
		.jtag_uart_avalon_jtag_slave_write                                   (mm_interconnect_0_jtag_uart_avalon_jtag_slave_write),       //  output,   width = 1,                                                              .write
		.jtag_uart_avalon_jtag_slave_read                                    (mm_interconnect_0_jtag_uart_avalon_jtag_slave_read),        //  output,   width = 1,                                                              .read
		.jtag_uart_avalon_jtag_slave_readdata                                (mm_interconnect_0_jtag_uart_avalon_jtag_slave_readdata),    //   input,  width = 32,                                                              .readdata
		.jtag_uart_avalon_jtag_slave_writedata                               (mm_interconnect_0_jtag_uart_avalon_jtag_slave_writedata),   //  output,  width = 32,                                                              .writedata
		.jtag_uart_avalon_jtag_slave_waitrequest                             (mm_interconnect_0_jtag_uart_avalon_jtag_slave_waitrequest), //   input,   width = 1,                                                              .waitrequest
		.jtag_uart_avalon_jtag_slave_chipselect                              (mm_interconnect_0_jtag_uart_avalon_jtag_slave_chipselect),  //  output,   width = 1,                                                              .chipselect
		.slec_rx_csr_avsi_csr_address                                        (mm_interconnect_0_slec_rx_csr_avsi_csr_address),            //  output,   width = 8,                                          slec_rx_csr_avsi_csr.address
		.slec_rx_csr_avsi_csr_write                                          (mm_interconnect_0_slec_rx_csr_avsi_csr_write),              //  output,   width = 1,                                                              .write
		.slec_rx_csr_avsi_csr_read                                           (mm_interconnect_0_slec_rx_csr_avsi_csr_read),               //  output,   width = 1,                                                              .read
		.slec_rx_csr_avsi_csr_readdata                                       (mm_interconnect_0_slec_rx_csr_avsi_csr_readdata),           //   input,  width = 32,                                                              .readdata
		.slec_rx_csr_avsi_csr_writedata                                      (mm_interconnect_0_slec_rx_csr_avsi_csr_writedata),          //  output,  width = 32,                                                              .writedata
		.slec_rx_csr_avsi_csr_byteenable                                     (mm_interconnect_0_slec_rx_csr_avsi_csr_byteenable),         //  output,   width = 4,                                                              .byteenable
		.slec_rx_csr_avsi_csr_readdatavalid                                  (mm_interconnect_0_slec_rx_csr_avsi_csr_readdatavalid),      //   input,   width = 1,                                                              .readdatavalid
		.slec_rx_csr_avsi_csr_waitrequest                                    (mm_interconnect_0_slec_rx_csr_avsi_csr_waitrequest),        //   input,   width = 1,                                                              .waitrequest
		.niosv_dm_agent_address                                              (mm_interconnect_0_niosv_dm_agent_address),                  //  output,  width = 16,                                                niosv_dm_agent.address
		.niosv_dm_agent_write                                                (mm_interconnect_0_niosv_dm_agent_write),                    //  output,   width = 1,                                                              .write
		.niosv_dm_agent_read                                                 (mm_interconnect_0_niosv_dm_agent_read),                     //  output,   width = 1,                                                              .read
		.niosv_dm_agent_readdata                                             (mm_interconnect_0_niosv_dm_agent_readdata),                 //   input,  width = 32,                                                              .readdata
		.niosv_dm_agent_writedata                                            (mm_interconnect_0_niosv_dm_agent_writedata),                //  output,  width = 32,                                                              .writedata
		.niosv_dm_agent_readdatavalid                                        (mm_interconnect_0_niosv_dm_agent_readdatavalid),            //   input,   width = 1,                                                              .readdatavalid
		.niosv_dm_agent_waitrequest                                          (mm_interconnect_0_niosv_dm_agent_waitrequest),              //   input,   width = 1,                                                              .waitrequest
		.ram_s1_address                                                      (mm_interconnect_0_ram_s1_address),                          //  output,  width = 17,                                                        ram_s1.address
		.ram_s1_write                                                        (mm_interconnect_0_ram_s1_write),                            //  output,   width = 1,                                                              .write
		.ram_s1_read                                                         (mm_interconnect_0_ram_s1_read),                             //  output,   width = 1,                                                              .read
		.ram_s1_readdata                                                     (mm_interconnect_0_ram_s1_readdata),                         //   input,  width = 32,                                                              .readdata
		.ram_s1_writedata                                                    (mm_interconnect_0_ram_s1_writedata),                        //  output,  width = 32,                                                              .writedata
		.ram_s1_byteenable                                                   (mm_interconnect_0_ram_s1_byteenable),                       //  output,   width = 4,                                                              .byteenable
		.pio_0_s1_address                                                    (mm_interconnect_0_pio_0_s1_address),                        //  output,   width = 2,                                                      pio_0_s1.address
		.pio_0_s1_write                                                      (mm_interconnect_0_pio_0_s1_write),                          //  output,   width = 1,                                                              .write
		.pio_0_s1_readdata                                                   (mm_interconnect_0_pio_0_s1_readdata),                       //   input,  width = 32,                                                              .readdata
		.pio_0_s1_writedata                                                  (mm_interconnect_0_pio_0_s1_writedata),                      //  output,  width = 32,                                                              .writedata
		.pio_0_s1_chipselect                                                 (mm_interconnect_0_pio_0_s1_chipselect),                     //  output,   width = 1,                                                              .chipselect
		.pio_1_s1_address                                                    (mm_interconnect_0_pio_1_s1_address),                        //  output,   width = 2,                                                      pio_1_s1.address
		.pio_1_s1_readdata                                                   (mm_interconnect_0_pio_1_s1_readdata),                       //   input,  width = 32,                                                              .readdata
		.spi_spi_control_port_address                                        (mm_interconnect_0_spi_spi_control_port_address),            //  output,   width = 3,                                          spi_spi_control_port.address
		.spi_spi_control_port_write                                          (mm_interconnect_0_spi_spi_control_port_write),              //  output,   width = 1,                                                              .write
		.spi_spi_control_port_read                                           (mm_interconnect_0_spi_spi_control_port_read),               //  output,   width = 1,                                                              .read
		.spi_spi_control_port_readdata                                       (mm_interconnect_0_spi_spi_control_port_readdata),           //   input,  width = 32,                                                              .readdata
		.spi_spi_control_port_writedata                                      (mm_interconnect_0_spi_spi_control_port_writedata),          //  output,  width = 32,                                                              .writedata
		.spi_spi_control_port_chipselect                                     (mm_interconnect_0_spi_spi_control_port_chipselect),         //  output,   width = 1,                                                              .chipselect
		.niosv_timer_sw_agent_address                                        (mm_interconnect_0_niosv_timer_sw_agent_address),            //  output,   width = 6,                                          niosv_timer_sw_agent.address
		.niosv_timer_sw_agent_write                                          (mm_interconnect_0_niosv_timer_sw_agent_write),              //  output,   width = 1,                                                              .write
		.niosv_timer_sw_agent_read                                           (mm_interconnect_0_niosv_timer_sw_agent_read),               //  output,   width = 1,                                                              .read
		.niosv_timer_sw_agent_readdata                                       (mm_interconnect_0_niosv_timer_sw_agent_readdata),           //   input,  width = 32,                                                              .readdata
		.niosv_timer_sw_agent_writedata                                      (mm_interconnect_0_niosv_timer_sw_agent_writedata),          //  output,  width = 32,                                                              .writedata
		.niosv_timer_sw_agent_byteenable                                     (mm_interconnect_0_niosv_timer_sw_agent_byteenable),         //  output,   width = 4,                                                              .byteenable
		.niosv_timer_sw_agent_readdatavalid                                  (mm_interconnect_0_niosv_timer_sw_agent_readdatavalid),      //   input,   width = 1,                                                              .readdatavalid
		.niosv_timer_sw_agent_waitrequest                                    (mm_interconnect_0_niosv_timer_sw_agent_waitrequest),        //   input,   width = 1,                                                              .waitrequest
		.niosv_reset_reset_bridge_in_reset_reset                             (rst_controller_002_reset_out_reset),                        //   input,   width = 1,                             niosv_reset_reset_bridge_in_reset.reset
		.niosv_data_manager_translator_clk_reset_reset_bridge_in_reset_reset (rst_controller_002_reset_out_reset),                        //   input,   width = 1, niosv_data_manager_translator_clk_reset_reset_bridge_in_reset.reset
		.clk_out_clk_clk                                                     (clk_out_clk_clk)                                            //   input,   width = 1,                                                   clk_out_clk.clk
	);

	niosv_ss_altera_irq_mapper_2001_dvakrki irq_mapper (
		.clk           (clk_out_clk_clk),                //   input,   width = 1,       clk.clk
		.reset         (rst_controller_reset_out_reset), //   input,   width = 1, clk_reset.reset
		.receiver0_irq (irq_mapper_receiver0_irq),       //   input,   width = 1, receiver0.irq
		.receiver1_irq (irq_mapper_receiver1_irq),       //   input,   width = 1, receiver1.irq
		.sender_irq    (niosv_platform_irq_rx_irq)       //  output,  width = 16,    sender.irq
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (1),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller (
		.reset_in0      (~rst_n_out_reset_reset),             //   input,  width = 1, reset_in0.reset
		.clk            (clk_out_clk_clk),                    //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_reset_out_reset),     //  output,  width = 1, reset_out.reset
		.reset_req      (rst_controller_reset_out_reset_req), //  output,  width = 1,          .reset_req
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (2),
		.OUTPUT_RESET_SYNC_EDGES   ("deassert"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_001 (
		.reset_in0      (niosv_dbg_reset_out_reset),          //   input,  width = 1, reset_in0.reset
		.reset_in1      (~rst_n_out_reset_reset),             //   input,  width = 1, reset_in1.reset
		.clk            (clk_out_clk_clk),                    //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_001_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

	altera_reset_controller #(
		.NUM_RESET_INPUTS          (1),
		.OUTPUT_RESET_SYNC_EDGES   ("both"),
		.SYNC_DEPTH                (2),
		.RESET_REQUEST_PRESENT     (0),
		.RESET_REQ_WAIT_TIME       (1),
		.MIN_RST_ASSERTION_TIME    (3),
		.RESET_REQ_EARLY_DSRT_TIME (1),
		.USE_RESET_REQUEST_IN0     (0),
		.USE_RESET_REQUEST_IN1     (0),
		.USE_RESET_REQUEST_IN2     (0),
		.USE_RESET_REQUEST_IN3     (0),
		.USE_RESET_REQUEST_IN4     (0),
		.USE_RESET_REQUEST_IN5     (0),
		.USE_RESET_REQUEST_IN6     (0),
		.USE_RESET_REQUEST_IN7     (0),
		.USE_RESET_REQUEST_IN8     (0),
		.USE_RESET_REQUEST_IN9     (0),
		.USE_RESET_REQUEST_IN10    (0),
		.USE_RESET_REQUEST_IN11    (0),
		.USE_RESET_REQUEST_IN12    (0),
		.USE_RESET_REQUEST_IN13    (0),
		.USE_RESET_REQUEST_IN14    (0),
		.USE_RESET_REQUEST_IN15    (0),
		.ADAPT_RESET_REQUEST       (0)
	) rst_controller_002 (
		.reset_in0      (~rst_n_out_reset_reset),             //   input,  width = 1, reset_in0.reset
		.clk            (clk_out_clk_clk),                    //   input,  width = 1,       clk.clk
		.reset_out      (rst_controller_002_reset_out_reset), //  output,  width = 1, reset_out.reset
		.reset_req      (),                                   // (terminated),                       
		.reset_req_in0  (1'b0),                               // (terminated),                       
		.reset_in1      (1'b0),                               // (terminated),                       
		.reset_req_in1  (1'b0),                               // (terminated),                       
		.reset_in2      (1'b0),                               // (terminated),                       
		.reset_req_in2  (1'b0),                               // (terminated),                       
		.reset_in3      (1'b0),                               // (terminated),                       
		.reset_req_in3  (1'b0),                               // (terminated),                       
		.reset_in4      (1'b0),                               // (terminated),                       
		.reset_req_in4  (1'b0),                               // (terminated),                       
		.reset_in5      (1'b0),                               // (terminated),                       
		.reset_req_in5  (1'b0),                               // (terminated),                       
		.reset_in6      (1'b0),                               // (terminated),                       
		.reset_req_in6  (1'b0),                               // (terminated),                       
		.reset_in7      (1'b0),                               // (terminated),                       
		.reset_req_in7  (1'b0),                               // (terminated),                       
		.reset_in8      (1'b0),                               // (terminated),                       
		.reset_req_in8  (1'b0),                               // (terminated),                       
		.reset_in9      (1'b0),                               // (terminated),                       
		.reset_req_in9  (1'b0),                               // (terminated),                       
		.reset_in10     (1'b0),                               // (terminated),                       
		.reset_req_in10 (1'b0),                               // (terminated),                       
		.reset_in11     (1'b0),                               // (terminated),                       
		.reset_req_in11 (1'b0),                               // (terminated),                       
		.reset_in12     (1'b0),                               // (terminated),                       
		.reset_req_in12 (1'b0),                               // (terminated),                       
		.reset_in13     (1'b0),                               // (terminated),                       
		.reset_req_in13 (1'b0),                               // (terminated),                       
		.reset_in14     (1'b0),                               // (terminated),                       
		.reset_req_in14 (1'b0),                               // (terminated),                       
		.reset_in15     (1'b0),                               // (terminated),                       
		.reset_req_in15 (1'b0)                                // (terminated),                       
	);

endmodule
