source [file join [file dirname [info script]] ./../../../ip/niosv_ss/niosv_ss_pio_1/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/niosv_ss/niosv_ss_pio_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/niosv_ss/niosv_ss_slec_rx_csr_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/niosv_ss/niosv_ss_clock_in/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/niosv_ss/niosv_ss_intel_onchip_memory_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/niosv_ss/niosv_ss_jtag_uart_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/niosv_ss/niosv_ss_reset_in/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/niosv_ss/niosv_ss_spi_0/sim/common/modelsim_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/niosv_ss/niosv_ss_intel_niosv_m_0/sim/common/modelsim_files.tcl]

namespace eval niosv_ss {
  proc get_design_libraries {} {
    set libraries [dict create]
    set libraries [dict merge $libraries [niosv_ss_pio_1::get_design_libraries]]
    set libraries [dict merge $libraries [niosv_ss_pio_0::get_design_libraries]]
    set libraries [dict merge $libraries [niosv_ss_slec_rx_csr_0::get_design_libraries]]
    set libraries [dict merge $libraries [niosv_ss_clock_in::get_design_libraries]]
    set libraries [dict merge $libraries [niosv_ss_intel_onchip_memory_0::get_design_libraries]]
    set libraries [dict merge $libraries [niosv_ss_jtag_uart_0::get_design_libraries]]
    set libraries [dict merge $libraries [niosv_ss_reset_in::get_design_libraries]]
    set libraries [dict merge $libraries [niosv_ss_spi_0::get_design_libraries]]
    set libraries [dict merge $libraries [niosv_ss_intel_niosv_m_0::get_design_libraries]]
    dict set libraries altera_merlin_axi_translator_1983  1
    dict set libraries altera_merlin_slave_translator_191 1
    dict set libraries altera_merlin_axi_master_ni_19113  1
    dict set libraries altera_merlin_slave_agent_1930     1
    dict set libraries altera_avalon_sc_fifo_1932         1
    dict set libraries altera_merlin_router_1921          1
    dict set libraries altera_merlin_traffic_limiter_1921 1
    dict set libraries altera_merlin_demultiplexer_1921   1
    dict set libraries altera_merlin_multiplexer_1922     1
    dict set libraries altera_mm_interconnect_1920        1
    dict set libraries altera_irq_mapper_2001             1
    dict set libraries altera_reset_controller_1924       1
    dict set libraries niosv_ss                           1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set memory_files [list]
    set memory_files [concat $memory_files [niosv_ss_pio_1::get_memory_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_pio_1/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [niosv_ss_pio_0::get_memory_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_pio_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [niosv_ss_slec_rx_csr_0::get_memory_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_slec_rx_csr_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [niosv_ss_clock_in::get_memory_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_clock_in/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [niosv_ss_intel_onchip_memory_0::get_memory_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_intel_onchip_memory_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [niosv_ss_jtag_uart_0::get_memory_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_jtag_uart_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [niosv_ss_reset_in::get_memory_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_reset_in/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [niosv_ss_spi_0::get_memory_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_spi_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [niosv_ss_intel_niosv_m_0::get_memory_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_intel_niosv_m_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    return $memory_files
  }
  
  proc get_common_design_files {QSYS_SIMDIR} {
    set design_files [dict create]
    set design_files [dict merge $design_files [niosv_ss_pio_1::get_common_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_pio_1/sim/"]]
    set design_files [dict merge $design_files [niosv_ss_pio_0::get_common_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_pio_0/sim/"]]
    set design_files [dict merge $design_files [niosv_ss_slec_rx_csr_0::get_common_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_slec_rx_csr_0/sim/"]]
    set design_files [dict merge $design_files [niosv_ss_clock_in::get_common_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_clock_in/sim/"]]
    set design_files [dict merge $design_files [niosv_ss_intel_onchip_memory_0::get_common_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_intel_onchip_memory_0/sim/"]]
    set design_files [dict merge $design_files [niosv_ss_jtag_uart_0::get_common_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_jtag_uart_0/sim/"]]
    set design_files [dict merge $design_files [niosv_ss_reset_in::get_common_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_reset_in/sim/"]]
    set design_files [dict merge $design_files [niosv_ss_spi_0::get_common_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_spi_0/sim/"]]
    set design_files [dict merge $design_files [niosv_ss_intel_niosv_m_0::get_common_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_intel_niosv_m_0/sim/"]]
    return $design_files
  }
  
  proc get_design_files {QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set design_files [list]
    set design_files [concat $design_files [niosv_ss_pio_1::get_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_pio_1/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [niosv_ss_pio_0::get_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_pio_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [niosv_ss_slec_rx_csr_0::get_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_slec_rx_csr_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [niosv_ss_clock_in::get_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_clock_in/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [niosv_ss_intel_onchip_memory_0::get_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_intel_onchip_memory_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [niosv_ss_jtag_uart_0::get_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_jtag_uart_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [niosv_ss_reset_in::get_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_reset_in/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [niosv_ss_spi_0::get_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_spi_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [niosv_ss_intel_niosv_m_0::get_design_files "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_intel_niosv_m_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    lappend design_files "-makelib altera_merlin_axi_translator_1983 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_translator_1983/sim/niosv_ss_altera_merlin_axi_translator_1983_ay2bjbi.sv"]\"   -end"                        
    lappend design_files "-makelib altera_merlin_slave_translator_191 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_translator_191/sim/niosv_ss_altera_merlin_slave_translator_191_xg7rzxi.sv"]\"   -end"                     
    lappend design_files "-makelib altera_merlin_axi_master_ni_19113 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_master_ni_19113/sim/altera_merlin_address_alignment.sv"]\"   -end"                                           
    lappend design_files "-makelib altera_merlin_axi_master_ni_19113 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_master_ni_19113/sim/niosv_ss_altera_merlin_axi_master_ni_19113_7p7b7si.sv"]\"   -end"                        
    lappend design_files "-makelib altera_merlin_slave_agent_1930 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_agent_1930/sim/niosv_ss_altera_merlin_slave_agent_1930_jxauz3i.sv"]\"   -end"                                 
    lappend design_files "-makelib altera_merlin_slave_agent_1930 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_slave_agent_1930/sim/altera_merlin_burst_uncompressor.sv"]\"   -end"                                                
    lappend design_files "-makelib altera_avalon_sc_fifo_1932 \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_sc_fifo_1932/sim/niosv_ss_altera_avalon_sc_fifo_1932_22gxxgi.v"]\"   -end"                                              
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/niosv_ss_altera_merlin_router_1921_vbmpw5i.sv"]\"   -end"                                                
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/niosv_ss_altera_merlin_router_1921_pd6jhiq.sv"]\"   -end"                                                
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/niosv_ss_altera_merlin_router_1921_2i655uq.sv"]\"   -end"                                                
    lappend design_files "-makelib altera_merlin_router_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/niosv_ss_altera_merlin_router_1921_tazy3sy.sv"]\"   -end"                                                
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/niosv_ss_altera_merlin_traffic_limiter_altera_avalon_sc_fifo_1921_jyjty3i.v"]\"   -end"
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_merlin_reorder_memory.sv"]\"   -end"                                            
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_avalon_st_pipeline_base.v"]\"   -end"                                           
    lappend design_files "-makelib altera_merlin_traffic_limiter_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/niosv_ss_altera_merlin_traffic_limiter_1921_2thi65i.sv"]\"   -end"                     
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/niosv_ss_altera_merlin_demultiplexer_1921_feouyxa.sv"]\"   -end"                           
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/niosv_ss_altera_merlin_demultiplexer_1921_bmj2nwy.sv"]\"   -end"                           
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/niosv_ss_altera_merlin_multiplexer_1922_r4ye4pa.sv"]\"   -end"                                 
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                        
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/niosv_ss_altera_merlin_multiplexer_1922_isv3q2y.sv"]\"   -end"                                 
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                        
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/niosv_ss_altera_merlin_demultiplexer_1921_ynbkt7a.sv"]\"   -end"                           
    lappend design_files "-makelib altera_merlin_demultiplexer_1921 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/niosv_ss_altera_merlin_demultiplexer_1921_mweplha.sv"]\"   -end"                           
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/niosv_ss_altera_merlin_multiplexer_1922_pv7zubq.sv"]\"   -end"                                 
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                        
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/niosv_ss_altera_merlin_multiplexer_1922_3zypodi.sv"]\"   -end"                                 
    lappend design_files "-makelib altera_merlin_multiplexer_1922 \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"   -end"                                                        
    lappend design_files "-makelib altera_mm_interconnect_1920 \"[normalize_path "$QSYS_SIMDIR/../altera_mm_interconnect_1920/sim/niosv_ss_altera_mm_interconnect_1920_3sbqlwy.v"]\"   -end"                                           
    lappend design_files "-makelib altera_irq_mapper_2001 \"[normalize_path "$QSYS_SIMDIR/../altera_irq_mapper_2001/sim/niosv_ss_altera_irq_mapper_2001_dvakrki.sv"]\"   -end"                                                         
    lappend design_files "-makelib altera_reset_controller_1924 \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_controller.v"]\"   -end"                                                              
    lappend design_files "-makelib altera_reset_controller_1924 \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_synchronizer.v"]\"   -end"                                                            
    lappend design_files "-makelib niosv_ss \"[normalize_path "$QSYS_SIMDIR/niosv_ss.v"]\"   -end"                                                                                                                                     
    return $design_files
  }
  
  proc get_non_duplicate_elab_option {ELAB_OPTIONS NEW_ELAB_OPTION} {
    set IS_DUPLICATE [string first $NEW_ELAB_OPTION $ELAB_OPTIONS]
    if {$IS_DUPLICATE == -1} {
      return $NEW_ELAB_OPTION
    } else {
      return ""
    }
  }
  
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [niosv_ss_pio_1::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [niosv_ss_pio_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [niosv_ss_slec_rx_csr_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [niosv_ss_clock_in::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [niosv_ss_intel_onchip_memory_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [niosv_ss_jtag_uart_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [niosv_ss_reset_in::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [niosv_ss_spi_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [niosv_ss_intel_niosv_m_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    append SIM_OPTIONS [niosv_ss_pio_1::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [niosv_ss_pio_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [niosv_ss_slec_rx_csr_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [niosv_ss_clock_in::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [niosv_ss_intel_onchip_memory_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [niosv_ss_jtag_uart_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [niosv_ss_reset_in::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [niosv_ss_spi_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [niosv_ss_intel_niosv_m_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [niosv_ss_pio_1::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [niosv_ss_pio_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [niosv_ss_slec_rx_csr_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [niosv_ss_clock_in::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [niosv_ss_intel_onchip_memory_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [niosv_ss_jtag_uart_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [niosv_ss_reset_in::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [niosv_ss_spi_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [niosv_ss_intel_niosv_m_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    set libraries [dict merge $libraries [niosv_ss_pio_1::get_dpi_libraries "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_pio_1/sim/"]]
    set libraries [dict merge $libraries [niosv_ss_pio_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_pio_0/sim/"]]
    set libraries [dict merge $libraries [niosv_ss_slec_rx_csr_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_slec_rx_csr_0/sim/"]]
    set libraries [dict merge $libraries [niosv_ss_clock_in::get_dpi_libraries "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_clock_in/sim/"]]
    set libraries [dict merge $libraries [niosv_ss_intel_onchip_memory_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_intel_onchip_memory_0/sim/"]]
    set libraries [dict merge $libraries [niosv_ss_jtag_uart_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_jtag_uart_0/sim/"]]
    set libraries [dict merge $libraries [niosv_ss_reset_in::get_dpi_libraries "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_reset_in/sim/"]]
    set libraries [dict merge $libraries [niosv_ss_spi_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_spi_0/sim/"]]
    set libraries [dict merge $libraries [niosv_ss_intel_niosv_m_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/niosv_ss/niosv_ss_intel_niosv_m_0/sim/"]]
    
    return $libraries
  }
  
}
