	component niosv_ss_slec_rx_csr_0 is
		generic (
			AW : integer := 8
		);
		port (
			clk                    : in  std_logic                       := 'X';             -- clk
			rst_n                  : in  std_logic                       := 'X';             -- reset_n
			avsi_csr_address       : in  std_logic_vector(AW-1 downto 0) := (others => 'X'); -- address
			avsi_csr_byteenable    : in  std_logic_vector(3 downto 0)    := (others => 'X'); -- byteenable
			avsi_csr_write         : in  std_logic                       := 'X';             -- write
			avsi_csr_writedata     : in  std_logic_vector(31 downto 0)   := (others => 'X'); -- writedata
			avsi_csr_read          : in  std_logic                       := 'X';             -- read
			avsi_csr_readdata      : out std_logic_vector(31 downto 0);                      -- readdata
			avsi_csr_readdatavalid : out std_logic;                                          -- readdatavalid
			avsi_csr_waitrequest   : out std_logic;                                          -- waitrequest
			avso_csr_address       : out std_logic_vector(AW-1 downto 0);                    -- address
			avso_csr_byteenable    : out std_logic_vector(3 downto 0);                       -- byteenable
			avso_csr_write         : out std_logic;                                          -- write
			avso_csr_writedata     : out std_logic_vector(31 downto 0);                      -- writedata
			avso_csr_read          : out std_logic;                                          -- read
			avso_csr_readdata      : in  std_logic_vector(31 downto 0)   := (others => 'X'); -- readdata
			avso_csr_readdatavalid : in  std_logic                       := 'X';             -- readdatavalid
			avso_csr_waitrequest   : in  std_logic                       := 'X'              -- waitrequest
		);
	end component niosv_ss_slec_rx_csr_0;

	u0 : component niosv_ss_slec_rx_csr_0
		generic map (
			AW => INTEGER_VALUE_FOR_AW
		)
		port map (
			clk                    => CONNECTED_TO_clk,                    --      clk.clk
			rst_n                  => CONNECTED_TO_rst_n,                  --    rst_n.reset_n
			avsi_csr_address       => CONNECTED_TO_avsi_csr_address,       -- avsi_csr.address
			avsi_csr_byteenable    => CONNECTED_TO_avsi_csr_byteenable,    --         .byteenable
			avsi_csr_write         => CONNECTED_TO_avsi_csr_write,         --         .write
			avsi_csr_writedata     => CONNECTED_TO_avsi_csr_writedata,     --         .writedata
			avsi_csr_read          => CONNECTED_TO_avsi_csr_read,          --         .read
			avsi_csr_readdata      => CONNECTED_TO_avsi_csr_readdata,      --         .readdata
			avsi_csr_readdatavalid => CONNECTED_TO_avsi_csr_readdatavalid, --         .readdatavalid
			avsi_csr_waitrequest   => CONNECTED_TO_avsi_csr_waitrequest,   --         .waitrequest
			avso_csr_address       => CONNECTED_TO_avso_csr_address,       -- avso_csr.address
			avso_csr_byteenable    => CONNECTED_TO_avso_csr_byteenable,    --         .byteenable
			avso_csr_write         => CONNECTED_TO_avso_csr_write,         --         .write
			avso_csr_writedata     => CONNECTED_TO_avso_csr_writedata,     --         .writedata
			avso_csr_read          => CONNECTED_TO_avso_csr_read,          --         .read
			avso_csr_readdata      => CONNECTED_TO_avso_csr_readdata,      --         .readdata
			avso_csr_readdatavalid => CONNECTED_TO_avso_csr_readdatavalid, --         .readdatavalid
			avso_csr_waitrequest   => CONNECTED_TO_avso_csr_waitrequest    --         .waitrequest
		);

