
namespace eval ed_synth_emif_io96b_lpddr4b {
  proc get_design_libraries {} {
    set libraries [dict create]
    dict set libraries altera_jtag_dc_streaming_191           1
    dict set libraries timing_adapter_1950                    1
    dict set libraries altera_avalon_sc_fifo_1932             1
    dict set libraries altera_avalon_st_bytes_to_packets_1922 1
    dict set libraries altera_avalon_st_packets_to_bytes_1922 1
    dict set libraries altera_avalon_packets_to_master_1922   1
    dict set libraries channel_adapter_1922                   1
    dict set libraries altera_reset_controller_1924           1
    dict set libraries alt_mem_if_jtag_master_191             1
    dict set libraries emif_io96b_cal_230                     1
    dict set libraries emif_io96b_lpddr4_410                  1
    dict set libraries ed_synth_emif_io96b_lpddr4b            1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set memory_files [list]
    lappend memory_files "[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/iossm_cal_boot.hex"]"
    lappend memory_files "[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/iossm_cal.hex"]"
    lappend memory_files "[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_mc_wide_seq_pt_sim.hex"]"
    return $memory_files
  }
  
  proc get_common_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [dict create]
    return $design_files
  }
  
  proc get_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set design_files [list]
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_jtag_dc_streaming_191/sim/altera_avalon_st_jtag_interface.v"]\"  -work altera_jtag_dc_streaming_191"                                                                                                                       
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_jtag_dc_streaming_191/sim/altera_jtag_dc_streaming.v"]\"  -work altera_jtag_dc_streaming_191"                                                                                                                              
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_jtag_dc_streaming_191/sim/altera_jtag_sld_node.v"]\"  -work altera_jtag_dc_streaming_191"                                                                                                                                  
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_jtag_dc_streaming_191/sim/altera_jtag_streaming.v"]\"  -work altera_jtag_dc_streaming_191"                                                                                                                                 
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_jtag_dc_streaming_191/sim/altera_avalon_st_clock_crosser.v"]\"  -work altera_jtag_dc_streaming_191"                                                                                                                        
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_jtag_dc_streaming_191/sim/altera_reset_synchronizer.v"]\"  -work altera_jtag_dc_streaming_191"                                                                                                                             
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_jtag_dc_streaming_191/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_jtag_dc_streaming_191"                                                                                                                         
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_jtag_dc_streaming_191/sim/altera_avalon_st_pipeline_base.v"]\"  -work altera_jtag_dc_streaming_191"                                                                                                                        
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_jtag_dc_streaming_191/sim/altera_avalon_st_idle_remover.v"]\"  -work altera_jtag_dc_streaming_191"                                                                                                                         
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_jtag_dc_streaming_191/sim/altera_avalon_st_idle_inserter.v"]\"  -work altera_jtag_dc_streaming_191"                                                                                                                        
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_jtag_dc_streaming_191/sim/altera_avalon_st_pipeline_stage.sv"]\"  -work altera_jtag_dc_streaming_191"                                                                                                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../timing_adapter_1950/sim/ed_synth_emif_io96b_lpddr4b_timing_adapter_1950_bbjt6kq.sv"]\"  -work timing_adapter_1950"                                                                                                                     
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_sc_fifo_1932/sim/ed_synth_emif_io96b_lpddr4b_altera_avalon_sc_fifo_1932_onpcouq.v"]\"  -work altera_avalon_sc_fifo_1932"                                                                                            
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_st_bytes_to_packets_1922/sim/altera_avalon_st_bytes_to_packets.v"]\"  -work altera_avalon_st_bytes_to_packets_1922"                                                                                                 
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_st_packets_to_bytes_1922/sim/altera_avalon_st_packets_to_bytes.v"]\"  -work altera_avalon_st_packets_to_bytes_1922"                                                                                                 
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_packets_to_master_1922/sim/altera_avalon_packets_to_master.v"]\"  -work altera_avalon_packets_to_master_1922"                                                                                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../channel_adapter_1922/sim/ed_synth_emif_io96b_lpddr4b_channel_adapter_1922_rd56ufy.sv"]\"  -work channel_adapter_1922"                                                                                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../channel_adapter_1922/sim/ed_synth_emif_io96b_lpddr4b_channel_adapter_1922_5vp3d5a.sv"]\"  -work channel_adapter_1922"                                                                                                                  
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_controller.v"]\"  -work altera_reset_controller_1924"                                                                                                                               
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_synchronizer.v"]\"  -work altera_reset_controller_1924"                                                                                                                             
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../alt_mem_if_jtag_master_191/sim/ed_synth_emif_io96b_lpddr4b_alt_mem_if_jtag_master_191_2xbfrbi.v"]\"  -work alt_mem_if_jtag_master_191"                                                                                            
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_alt_mem_if_jtag_master_230_unux2ky.v"]\"  -work emif_io96b_cal_230"                                                                                             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_230_wsiollq_atom_attr_fa_c2p_ssm.sv"]\"  -work emif_io96b_cal_230"                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_230_wsiollq_atom_attr_fa_p2c_ssm.sv"]\"  -work emif_io96b_cal_230"                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_230_wsiollq_atom_attr_iossm.sv"]\"  -work emif_io96b_cal_230"                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_230_wsiollq_atom_attr_seq.sv"]\"  -work emif_io96b_cal_230"                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_230_wsiollq.sv"]\"  -work emif_io96b_cal_230"                                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_230_wsiollq_arbitrator.sv"]\"  -work emif_io96b_cal_230"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_230_wsiollq_cal_arch_fp_top.sv"]\"  -work emif_io96b_cal_230"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_230_wsiollq_cal_arch_fp_atom_inst_iossm.sv"]\"  -work emif_io96b_cal_230"                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_230_wsiollq_cal_arch_fp_atom_inst_seq.sv"]\"  -work emif_io96b_cal_230"                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_230_wsiollq_cal_arch_fp_atom_inst_fa.sv"]\"  -work emif_io96b_cal_230"                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_cal_230_wsiollq_cal_arch_fp_atom_inst_comp.sv"]\"  -work emif_io96b_cal_230"                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/altera_emif_cal_gearbox.sv"]\"  -work emif_io96b_cal_230"                                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/altera_emif_cal_gearbox_bidir.sv"]\"  -work emif_io96b_cal_230"                                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_axi_translator_1931_d46vvwa.sv"]\"  -work emif_io96b_cal_230"                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_reset_controller.v"]\"  -work emif_io96b_cal_230"                                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_avalon_st_bytes_to_packets.v"]\"  -work emif_io96b_cal_230"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_avalon_packets_to_master.v"]\"  -work emif_io96b_cal_230"                                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_axi_master_ni_1962_2kryw2a.sv"]\"  -work emif_io96b_cal_230"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_merlin_reorder_memory.sv"]\"  -work emif_io96b_cal_230"                                                             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_traffic_limiter_altera_avalon_sc_fifo_1921_7ekoqry.v"]\"  -work emif_io96b_cal_230"             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_traffic_limiter_1921_bk6lvda.sv"]\"  -work emif_io96b_cal_230"                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_channel_adapter_1921_fkajlia.sv"]\"  -work emif_io96b_cal_230"                                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_multiplexer_1922_jy53pgi.sv"]\"  -work emif_io96b_cal_230"                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_multiplexer_1922_ctb2miq.sv"]\"  -work emif_io96b_cal_230"                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_multiplexer_1922_7b7u3ni.sv"]\"  -work emif_io96b_cal_230"                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_multiplexer_1922_252f2xa.sv"]\"  -work emif_io96b_cal_230"                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_merlin_arbitrator.sv"]\"  -work emif_io96b_cal_230"                                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/rd_pri_mux_cwyib4q.sv"]\"  -work emif_io96b_cal_230"                                                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/rd_comp_sel_kt2puei.sv"]\"  -work emif_io96b_cal_230"                                                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_channel_adapter_1921_5wnzrci.sv"]\"  -work emif_io96b_cal_230"                                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_avalon_st_pipeline_stage_1930_bv2ucky.sv"]\"  -work emif_io96b_cal_230"                                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_avalon_st_packets_to_bytes.v"]\"  -work emif_io96b_cal_230"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/wr_sipo_plus_kt2puei.sv"]\"  -work emif_io96b_cal_230"                                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/wr_response_mem_kt2puei.sv"]\"  -work emif_io96b_cal_230"                                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/wr_comp_sel_kt2puei.sv"]\"  -work emif_io96b_cal_230"                                                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/rd_response_mem_kt2puei.sv"]\"  -work emif_io96b_cal_230"                                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/wr_sipo_plus_cwyib4q.sv"]\"  -work emif_io96b_cal_230"                                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/wr_comp_sel_cwyib4q.sv"]\"  -work emif_io96b_cal_230"                                                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/rd_sipo_plus_kt2puei.sv"]\"  -work emif_io96b_cal_230"                                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/rd_sipo_plus_cwyib4q.sv"]\"  -work emif_io96b_cal_230"                                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_axi_slave_ni_altera_avalon_st_pipeline_stage_1971_vnonqiy.v"]\"  -work emif_io96b_cal_230"      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_axi_slave_ni_altera_avalon_st_pipeline_stage_1971_alj3kza.v"]\"  -work emif_io96b_cal_230"      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_axi_slave_ni_altera_avalon_sc_fifo_1971_ysgnmwa.v"]\"  -work emif_io96b_cal_230"                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/compare_eq.sv"]\"  -work emif_io96b_cal_230"                                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/wr_response_mem_cwyib4q.sv"]\"  -work emif_io96b_cal_230"                                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/rd_response_mem_cwyib4q.sv"]\"  -work emif_io96b_cal_230"                                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/rd_pri_mux_kt2puei.sv"]\"  -work emif_io96b_cal_230"                                                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/rd_comp_sel_cwyib4q.sv"]\"  -work emif_io96b_cal_230"                                                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_axi_slave_ni_altera_avalon_sc_fifo_1971_o34766q.v"]\"  -work emif_io96b_cal_230"                
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_axi_slave_ni_1971_kt2puei.sv"]\"  -work emif_io96b_cal_230"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_axi_slave_ni_1971_cwyib4q.sv"]\"  -work emif_io96b_cal_230"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/wr_pri_mux_kt2puei.sv"]\"  -work emif_io96b_cal_230"                                                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/wr_pri_mux_cwyib4q.sv"]\"  -work emif_io96b_cal_230"                                                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_axi_slave_ni_altera_avalon_st_pipeline_stage_1971_h6wexfa.v"]\"  -work emif_io96b_cal_230"      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_axi_slave_ni_altera_avalon_st_pipeline_stage_1971_cgpn6xq.v"]\"  -work emif_io96b_cal_230"      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_avalon_sc_fifo_1931_fzgstwy.v"]\"  -work emif_io96b_cal_230"                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_merlin_burst_uncompressor.sv"]\"  -work emif_io96b_cal_230"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_width_adapter_1933_2qdsena.sv"]\"  -work emif_io96b_cal_230"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_master_agent_1921_2inlndi.sv"]\"  -work emif_io96b_cal_230"                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_demultiplexer_1921_rcor4va.sv"]\"  -work emif_io96b_cal_230"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_demultiplexer_1921_ekcygpi.sv"]\"  -work emif_io96b_cal_230"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_demultiplexer_1921_c2mlp5i.sv"]\"  -work emif_io96b_cal_230"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_merlin_address_alignment.sv"]\"  -work emif_io96b_cal_230"                                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_width_adapter_1933_sqfzewq.sv"]\"  -work emif_io96b_cal_230"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_burst_adapter_altera_avalon_st_pipeline_stage_1931_glj62si.v"]\"  -work emif_io96b_cal_230"     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_merlin_burst_adapter_uncmpr.sv"]\"  -work emif_io96b_cal_230"                                                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_merlin_burst_adapter_new.sv"]\"  -work emif_io96b_cal_230"                                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_burst_adapter_1931_hbsisni.sv"]\"  -work emif_io96b_cal_230"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_wrap_burst_converter.sv"]\"  -work emif_io96b_cal_230"                                                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_merlin_burst_adapter_13_1.sv"]\"  -work emif_io96b_cal_230"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_incr_burst_converter.sv"]\"  -work emif_io96b_cal_230"                                                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_default_burst_converter.sv"]\"  -work emif_io96b_cal_230"                                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_timing_adapter_1940_5ju4ddy.sv"]\"  -work emif_io96b_cal_230"                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/intel_axi4lite_injector_dcfifo_s.sv"]\"  -work emif_io96b_cal_230"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/intel_axi4lite_injector_util.sv"]\"  -work emif_io96b_cal_230"                                                             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/intel_axi4lite_injector_ph2.sv"]\"  -work emif_io96b_cal_230"                                                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_intel_axi4lite_injector_100_2yowc3a.sv"]\"  -work emif_io96b_cal_230"                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_hs_clk_xer_1940_hvja46q.v"]\"  -work emif_io96b_cal_230"                                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_hs_clk_xer_1940_4s7hdhy.v"]\"  -work emif_io96b_cal_230"                                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_mm_interconnect_1920_jmzr6ly.v"]\"  -work emif_io96b_cal_230"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_mm_interconnect_1920_5sovoyi.v"]\"  -work emif_io96b_cal_230"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_master_translator_192_lykd4la.sv"]\"  -work emif_io96b_cal_230"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_std_synchronizer_nocut.v"]\"  -work emif_io96b_cal_230"                                                             
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_reset_synchronizer.v"]\"  -work emif_io96b_cal_230"                                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_avalon_st_pipeline_base.v"]\"  -work emif_io96b_cal_230"                                                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/altera_avalon_st_clock_crosser.v"]\"  -work emif_io96b_cal_230"                                                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_router_1921_vbaxzva.sv"]\"  -work emif_io96b_cal_230"                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_router_1921_nxsnrbi.sv"]\"  -work emif_io96b_cal_230"                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_router_1921_irryw4q.sv"]\"  -work emif_io96b_cal_230"                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_router_1921_wqohhgi.sv"]\"  -work emif_io96b_cal_230"                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_router_1921_4ytgf2y.sv"]\"  -work emif_io96b_cal_230"                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_cal_230/sim/interconnect/ed_synth_dut_altera_merlin_router_1921_2jqun3q.sv"]\"  -work emif_io96b_cal_230"                                           
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_emif_io96b_cal_410_pa6y5ri.v"]\"  -work emif_io96b_lpddr4_410"                                                                                            
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay.sv"]\"  -work emif_io96b_lpddr4_410"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_arch_top.sv"]\"  -work emif_io96b_lpddr4_410"                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/altera_std_synchronizer_nocut.v"]\"  -work emif_io96b_lpddr4_410"                                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/emif_io96b_lib.sv"]\"  -work emif_io96b_lpddr4_410"                                                                               
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/emif_io96b_clk_div.sv"]\"  -work emif_io96b_lpddr4_410"                                                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_jedec_params.sv"]\"  -work emif_io96b_lpddr4_410"                       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_pin_locations.sv"]\"  -work emif_io96b_lpddr4_410"
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_byte.sv"]\"  -work emif_io96b_lpddr4_410"         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_byte_ctrl.sv"]\"  -work emif_io96b_lpddr4_410"    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_cpa.sv"]\"  -work emif_io96b_lpddr4_410"          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_fa_c2p_hmc.sv"]\"  -work emif_io96b_lpddr4_410"   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_fa_p2c_hmc.sv"]\"  -work emif_io96b_lpddr4_410"   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_fa_c2p_lane.sv"]\"  -work emif_io96b_lpddr4_410"  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_fa_p2c_lane.sv"]\"  -work emif_io96b_lpddr4_410"  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_fa_noc.sv"]\"  -work emif_io96b_lpddr4_410"       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_hmc_wide.sv"]\"  -work emif_io96b_lpddr4_410"     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_hmc_slim.sv"]\"  -work emif_io96b_lpddr4_410"     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_pa.sv"]\"  -work emif_io96b_lpddr4_410"           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_pll.sv"]\"  -work emif_io96b_lpddr4_410"          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_attr_bufs_mem.sv"]\"  -work emif_io96b_lpddr4_410"     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_bufs_mem.sv"]\"  -work emif_io96b_lpddr4_410"     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_byte.sv"]\"  -work emif_io96b_lpddr4_410"         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_byte_ctrl.sv"]\"  -work emif_io96b_lpddr4_410"    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_cpa.sv"]\"  -work emif_io96b_lpddr4_410"          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_fa_noc.sv"]\"  -work emif_io96b_lpddr4_410"       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_hmc_wide.sv"]\"  -work emif_io96b_lpddr4_410"     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_hmc_slim.sv"]\"  -work emif_io96b_lpddr4_410"     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_pa.sv"]\"  -work emif_io96b_lpddr4_410"           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_pll.sv"]\"  -work emif_io96b_lpddr4_410"          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_reftree.sv"]\"  -work emif_io96b_lpddr4_410"      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_fa_hmc.sv"]\"  -work emif_io96b_lpddr4_410"       
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_atom_inst_fa_lane.sv"]\"  -work emif_io96b_lpddr4_410"      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_fbr_axi_adapter_wide.sv"]\"  -work emif_io96b_lpddr4_410"   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_fbr_axi_adapter_slim.sv"]\"  -work emif_io96b_lpddr4_410"   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS {\"+incdir+[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/"]\"} \"[normalize_path "$QSYS_SIMDIR/../emif_io96b_lpddr4_410/sim/io96b_0/io0_ed_synth_emif_io96b_lpddr4b_emif_io96b_lpddr4_410_oln6iay_io96b_top.sv"]\"  -work emif_io96b_lpddr4_410"              
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/ed_synth_emif_io96b_lpddr4b.v"]\"  -work ed_synth_emif_io96b_lpddr4b"                                                                                                                                                                
    return $design_files
  }
  
  proc get_non_duplicate_elab_option {ELAB_OPTIONS NEW_ELAB_OPTION} {
    set IS_DUPLICATE [string first $NEW_ELAB_OPTION $ELAB_OPTIONS]
    if {$IS_DUPLICATE == -1} {
      return $NEW_ELAB_OPTION
    } else {
      return ""
    }
  }
  
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    
    return $libraries
  }
  
}
