source [file join [file dirname [info script]] ./../../../ip/ed_synth/ed_synth_clock_bridge_0/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/ed_synth/ed_synth_rrip/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/ed_synth/ed_synth_mm_ccb_0/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/ed_synth/ed_synth_user_pll/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/ed_synth/ed_synth_emif_io96b_lpddr4b/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/ed_synth/ed_synth_reset_bridge_0/sim/common/riviera_files.tcl]
source [file join [file dirname [info script]] ./../../../ip/ed_synth/ed_synth_reset_handler/sim/common/riviera_files.tcl]

namespace eval ed_synth {
  proc get_design_libraries {} {
    set libraries [dict create]
    set libraries [dict merge $libraries [ed_synth_clock_bridge_0::get_design_libraries]]
    set libraries [dict merge $libraries [ed_synth_rrip::get_design_libraries]]
    set libraries [dict merge $libraries [ed_synth_mm_ccb_0::get_design_libraries]]
    set libraries [dict merge $libraries [ed_synth_user_pll::get_design_libraries]]
    set libraries [dict merge $libraries [ed_synth_emif_io96b_lpddr4b::get_design_libraries]]
    set libraries [dict merge $libraries [ed_synth_reset_bridge_0::get_design_libraries]]
    set libraries [dict merge $libraries [ed_synth_reset_handler::get_design_libraries]]
    dict set libraries altera_merlin_master_translator_193  1
    dict set libraries altera_merlin_axi_translator_1983    1
    dict set libraries altera_merlin_master_agent_1940      1
    dict set libraries altera_avalon_sc_fifo_1932           1
    dict set libraries altera_merlin_axi_slave_ni_19123     1
    dict set libraries altera_avalon_st_pipeline_stage_1930 1
    dict set libraries altera_merlin_router_1921            1
    dict set libraries altera_merlin_traffic_limiter_1921   1
    dict set libraries altera_merlin_demultiplexer_1921     1
    dict set libraries altera_merlin_multiplexer_1922       1
    dict set libraries altera_mm_interconnect_1920          1
    dict set libraries altera_reset_controller_1924         1
    dict set libraries ed_synth                             1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set memory_files [list]
    set memory_files [concat $memory_files [ed_synth_clock_bridge_0::get_memory_files "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_clock_bridge_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [ed_synth_rrip::get_memory_files "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_rrip/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [ed_synth_mm_ccb_0::get_memory_files "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_mm_ccb_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [ed_synth_user_pll::get_memory_files "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_user_pll/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [ed_synth_emif_io96b_lpddr4b::get_memory_files "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_emif_io96b_lpddr4b/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [ed_synth_reset_bridge_0::get_memory_files "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_reset_bridge_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set memory_files [concat $memory_files [ed_synth_reset_handler::get_memory_files "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_reset_handler/sim/" "$QUARTUS_INSTALL_DIR"]]
    return $memory_files
  }
  
  proc get_common_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [dict create]
    set design_files [dict merge $design_files [ed_synth_clock_bridge_0::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_clock_bridge_0/sim/"]]
    set design_files [dict merge $design_files [ed_synth_rrip::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_rrip/sim/"]]
    set design_files [dict merge $design_files [ed_synth_mm_ccb_0::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_mm_ccb_0/sim/"]]
    set design_files [dict merge $design_files [ed_synth_user_pll::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_user_pll/sim/"]]
    set design_files [dict merge $design_files [ed_synth_emif_io96b_lpddr4b::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_emif_io96b_lpddr4b/sim/"]]
    set design_files [dict merge $design_files [ed_synth_reset_bridge_0::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_reset_bridge_0/sim/"]]
    set design_files [dict merge $design_files [ed_synth_reset_handler::get_common_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_reset_handler/sim/"]]
    return $design_files
  }
  
  proc get_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR QUARTUS_INSTALL_DIR} {
    set design_files [list]
    set design_files [concat $design_files [ed_synth_clock_bridge_0::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_clock_bridge_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [ed_synth_rrip::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_rrip/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [ed_synth_mm_ccb_0::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_mm_ccb_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [ed_synth_user_pll::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_user_pll/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [ed_synth_emif_io96b_lpddr4b::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_emif_io96b_lpddr4b/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [ed_synth_reset_bridge_0::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_reset_bridge_0/sim/" "$QUARTUS_INSTALL_DIR"]]
    set design_files [concat $design_files [ed_synth_reset_handler::get_design_files $USER_DEFINED_COMPILE_OPTIONS $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_VHDL_COMPILE_OPTIONS "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_reset_handler/sim/" "$QUARTUS_INSTALL_DIR"]]
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_master_translator_193/sim/ed_synth_altera_merlin_master_translator_193_lgcew2q.sv"]\"  -work altera_merlin_master_translator_193"                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_translator_1983/sim/ed_synth_altera_merlin_axi_translator_1983_7ic4h3a.sv"]\"  -work altera_merlin_axi_translator_1983"                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_master_agent_1940/sim/ed_synth_altera_merlin_master_agent_1940_pqs4u4y.sv"]\"  -work altera_merlin_master_agent_1940"                                       
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_sc_fifo_1932/sim/ed_synth_altera_avalon_sc_fifo_1932_22gxxgi.v"]\"  -work altera_avalon_sc_fifo_1932"                                                  
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/ed_synth_altera_merlin_axi_slave_ni_altera_avalon_sc_fifo_19123_jsmhjva.v"]\"  -work altera_merlin_axi_slave_ni_19123"          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_st_pipeline_stage_1930/sim/ed_synth_altera_avalon_st_pipeline_stage_1930_oiupeiq.sv"]\"  -work altera_avalon_st_pipeline_stage_1930"                        
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_avalon_st_pipeline_stage_1930/sim/altera_avalon_st_pipeline_base.v"]\"  -work altera_avalon_st_pipeline_stage_1930"                                                
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/ed_synth_altera_merlin_axi_slave_ni_altera_avalon_st_pipeline_stage_19123_7i3ohjy.v"]\"  -work altera_merlin_axi_slave_ni_19123"
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/ed_synth_altera_merlin_axi_slave_ni_altera_avalon_st_pipeline_stage_19123_otjekoy.v"]\"  -work altera_merlin_axi_slave_ni_19123"
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/ed_synth_altera_merlin_axi_slave_ni_altera_avalon_st_pipeline_stage_19123_ejavthy.v"]\"  -work altera_merlin_axi_slave_ni_19123"
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/altera_merlin_burst_uncompressor.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/altera_merlin_address_alignment.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                                      
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/compare_eq.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                                                           
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/rd_response_mem_dabxo4q.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/rd_comp_sel_dabxo4q.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/rd_pri_mux_dabxo4q.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/rd_sipo_plus_dabxo4q.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/wr_response_mem_dabxo4q.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/wr_comp_sel_dabxo4q.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                                                  
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/wr_pri_mux_dabxo4q.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                                                   
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/wr_sipo_plus_dabxo4q.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_axi_slave_ni_19123/sim/ed_synth_altera_merlin_axi_slave_ni_19123_dabxo4q.sv"]\"  -work altera_merlin_axi_slave_ni_19123"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/ed_synth_altera_merlin_router_1921_sftjgni.sv"]\"  -work altera_merlin_router_1921"                                                         
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_router_1921/sim/ed_synth_altera_merlin_router_1921_wnwlnwy.sv"]\"  -work altera_merlin_router_1921"                                                         
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/ed_synth_altera_merlin_traffic_limiter_altera_avalon_sc_fifo_1921_sgbx5nq.v"]\"  -work altera_merlin_traffic_limiter_1921"    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_merlin_reorder_memory.sv"]\"  -work altera_merlin_traffic_limiter_1921"                                                     
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/altera_avalon_st_pipeline_base.v"]\"  -work altera_merlin_traffic_limiter_1921"                                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_traffic_limiter_1921/sim/ed_synth_altera_merlin_traffic_limiter_1921_4dc4eqq.sv"]\"  -work altera_merlin_traffic_limiter_1921"                              
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/ed_synth_altera_merlin_demultiplexer_1921_edss4by.sv"]\"  -work altera_merlin_demultiplexer_1921"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/ed_synth_altera_merlin_multiplexer_1922_xlwyvha.sv"]\"  -work altera_merlin_multiplexer_1922"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                                                 
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_demultiplexer_1921/sim/ed_synth_altera_merlin_demultiplexer_1921_ooaaany.sv"]\"  -work altera_merlin_demultiplexer_1921"                                    
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/ed_synth_altera_merlin_multiplexer_1922_6dcil5i.sv"]\"  -work altera_merlin_multiplexer_1922"                                          
    lappend design_files "vlog  $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_merlin_multiplexer_1922/sim/altera_merlin_arbitrator.sv"]\"  -work altera_merlin_multiplexer_1922"                                                                 
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_mm_interconnect_1920/sim/ed_synth_altera_mm_interconnect_1920_cb67x6i.v"]\"  -work altera_mm_interconnect_1920"                                               
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_controller.v"]\"  -work altera_reset_controller_1924"                                                                  
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_reset_controller_1924/sim/altera_reset_synchronizer.v"]\"  -work altera_reset_controller_1924"                                                                
    lappend design_files "vlog -v2k5 $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/ed_synth.v"]\"  -work ed_synth"                                                                                                                                         
    return $design_files
  }
  
  proc get_non_duplicate_elab_option {ELAB_OPTIONS NEW_ELAB_OPTION} {
    set IS_DUPLICATE [string first $NEW_ELAB_OPTION $ELAB_OPTIONS]
    if {$IS_DUPLICATE == -1} {
      return $NEW_ELAB_OPTION
    } else {
      return ""
    }
  }
  
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [ed_synth_clock_bridge_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [ed_synth_rrip::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [ed_synth_mm_ccb_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [ed_synth_user_pll::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [ed_synth_emif_io96b_lpddr4b::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [ed_synth_reset_bridge_0::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    append ELAB_OPTIONS [get_non_duplicate_elab_option $ELAB_OPTIONS [ed_synth_reset_handler::get_elab_options $SIMULATOR_TOOL_BITNESS]]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    append SIM_OPTIONS [ed_synth_clock_bridge_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [ed_synth_rrip::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [ed_synth_mm_ccb_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [ed_synth_user_pll::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [ed_synth_emif_io96b_lpddr4b::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [ed_synth_reset_bridge_0::get_sim_options $SIMULATOR_TOOL_BITNESS]
    append SIM_OPTIONS [ed_synth_reset_handler::get_sim_options $SIMULATOR_TOOL_BITNESS]
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [ed_synth_clock_bridge_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [ed_synth_rrip::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [ed_synth_mm_ccb_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [ed_synth_user_pll::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [ed_synth_emif_io96b_lpddr4b::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [ed_synth_reset_bridge_0::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    set LD_LIBRARY_PATH [dict merge $LD_LIBRARY_PATH [dict get [ed_synth_reset_handler::get_env_variables $SIMULATOR_TOOL_BITNESS] "LD_LIBRARY_PATH"]]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
  proc get_dpi_libraries {QSYS_SIMDIR} {
    set libraries [dict create]
    set libraries [dict merge $libraries [ed_synth_clock_bridge_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_clock_bridge_0/sim/"]]
    set libraries [dict merge $libraries [ed_synth_rrip::get_dpi_libraries "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_rrip/sim/"]]
    set libraries [dict merge $libraries [ed_synth_mm_ccb_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_mm_ccb_0/sim/"]]
    set libraries [dict merge $libraries [ed_synth_user_pll::get_dpi_libraries "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_user_pll/sim/"]]
    set libraries [dict merge $libraries [ed_synth_emif_io96b_lpddr4b::get_dpi_libraries "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_emif_io96b_lpddr4b/sim/"]]
    set libraries [dict merge $libraries [ed_synth_reset_bridge_0::get_dpi_libraries "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_reset_bridge_0/sim/"]]
    set libraries [dict merge $libraries [ed_synth_reset_handler::get_dpi_libraries "$QSYS_SIMDIR/../../ip/ed_synth/ed_synth_reset_handler/sim/"]]
    
    return $libraries
  }
  
}
