#include "stdio.h"
#include "../bsp/system.h"
#include "../bsp/HAL/inc/io.h"
#include "../bsp/drivers/inc/altera_avalon_spi.h"
#include "./reg_offset_def.h"
#include <unistd.h>


int imx537_spi_write( alt_u8 chip_id , alt_u8 addr , alt_u8 data )
{
	
	alt_u32  txdata;
	alt_u16  status;
	
    txdata = 0;
	txdata = ( ( data << 16 ) | ( addr << 8 ) | chip_id ) ;
	
	do{
		status = IORD_16DIRECT(SPI_BASE , SPI_STATUS);
	}while ( 0 == ( status & TXRDY_MSK ) );
		
	
	IOWR_32DIRECT(SPI_BASE , SPI_TXDAT , txdata);
		
	return 0;
}

alt_u8 imx537_spi_read( alt_u8 chip_id , alt_u8 addr)
{

	alt_u32  txdata;
	alt_u16  status;

	alt_u32   rdata32;
	alt_u8    rdata8;
	int    i;


    txdata = 0;
	txdata = ( ( addr << 8 ) | 0x80 | chip_id ) ;

	do{
		status = IORD_16DIRECT(SPI_BASE , SPI_STATUS);
	}while ( 0 == ( status & TXRDY_MSK ) );


	IOWR_32DIRECT(SPI_BASE , SPI_TXDAT , txdata);

	for (i = 0 ; i < 100  ; i++){
		asm("nop");
	}

	rdata32 = IORD_32DIRECT(SPI_BASE , 0x00 );
	rdata8 = ((rdata32 & 0x00FF0000) >> 16 );

	return rdata8;

}

int main() 
{

	int                    i;

	IOWR_32DIRECT(SLEC_RX_CSR_BASE, CONFIG , 0x09A80220 ); // 8Lane RAW12 2472
	IOWR_32DIRECT(SLEC_RX_CSR_BASE, CTRL   , 0x0000000F );

	//-----------------------------------------------------
	//--- Assert and Diassert XCLR
	//-----------------------------------------------------
	IOWR_32DIRECT(PIO_0_BASE, 0x00 ,  0x00000000  );
	while(IORD_32DIRECT(PIO_1_BASE,0x00));
	IOWR_32DIRECT(PIO_0_BASE, 0x00 ,  0x20000000  );
	while(!IORD_32DIRECT(PIO_1_BASE,0x00));
	usleep(1*1000*1000);
	IOWR_32DIRECT(PIO_0_BASE, 0x00 ,  0x30000000  );
	usleep(1);
	IOWR_32DIRECT(PIO_0_BASE, 0x00 ,  0xB0000000  );
	usleep(1);
	IOWR_32DIRECT(PIO_0_BASE, 0x00 ,  0xF0000000  );
	
	//-----------------------------------------------------
	//--- IMX537 Basic Register Setting1 Start
	//-----------------------------------------------------
	while(!imx537_spi_read(0x02, 0x00));

	imx537_spi_write(0x02, 0xD4, 0x9C); // VMAX
	imx537_spi_write(0x02, 0xD5, 0x08); // VMAX
	imx537_spi_write(0x02, 0xD6, 0x00); // VMAX
	imx537_spi_write(0x02, 0xD8, 0x72); // HMAX
	imx537_spi_write(0x02, 0xD9, 0x02); // HMAX
	imx537_spi_write(0x02, 0xE2, 0x04); // GMRWT
	imx537_spi_write(0x02, 0xE3, 0x18); // GMTWT
	imx537_spi_write(0x02, 0xE6, 0x0C); // GSDLY
	imx537_spi_write(0x04, 0x00, 0x14); // ADBIT 12bit
	imx537_spi_write(0x04, 0x33, 0x00); // 
	imx537_spi_write(0x06, 0x30, 0x01); // ODBIT
	imx537_spi_write(0x07, 0x21, 0x21); // 
	imx537_spi_write(0x07, 0x46, 0x08); // 
	imx537_spi_write(0x07, 0xB4, 0xF0); // BLKLEVEL
	imx537_spi_write(0x07, 0xB5, 0x00); // BLKLEVEL
	imx537_spi_write(0x0B, 0x04, 0x00); // LANESEL 8LANE
	imx537_spi_write(0x0C, 0x0C, 0x18); // 

	imx537_spi_write(0x0C, 0x00, 0xE1); // CRC_ECC_MODE ECC 2byte
	imx537_spi_write(0x04, 0x04, 0x00); // VHREVERSE
	imx537_spi_write(0x1B, 0x00, 0x6C); // 
	imx537_spi_write(0x1B, 0x01, 0x0A); // 
	imx537_spi_write(0x07, 0x02, 0x08); // GAIN_RTS same frame
	imx537_spi_write(0x1B, 0x02, 0x01); // 
	imx537_spi_write(0x15, 0x06, 0x00); // 
	imx537_spi_write(0x15, 0x07, 0x00); // 
	imx537_spi_write(0x15, 0x08, 0x00); // 
	imx537_spi_write(0x1B, 0x08, 0x68); // 
	imx537_spi_write(0x15, 0x09, 0x00); // 
	imx537_spi_write(0x15, 0x10, 0x04); // 
	imx537_spi_write(0x17, 0x10, 0x3F); // 
	imx537_spi_write(0x15, 0x11, 0x04); // 
	imx537_spi_write(0x15, 0x12, 0x04); // 
	imx537_spi_write(0x15, 0x13, 0x04); // 
	imx537_spi_write(0x02, 0x14, 0x0A); // INCKSEL_ST0
	imx537_spi_write(0x07, 0x14, 0x00); // GAIN Default Value Set
	imx537_spi_write(0x17, 0x14, 0x44); // 
	imx537_spi_write(0x02, 0x15, 0x22); // INCKSEL_ST1
	imx537_spi_write(0x07, 0x15, 0x00); // 
	imx537_spi_write(0x02, 0x16, 0xB1); // INCKSEL_ST2
	imx537_spi_write(0x1B, 0x16, 0x00); // 
	imx537_spi_write(0x1B, 0x17, 0x00); // 
	imx537_spi_write(0x02, 0x18, 0x3F); // INCKSEL_ST3
	imx537_spi_write(0x17, 0x18, 0x4A); // 
	imx537_spi_write(0x1B, 0x18, 0xFF); // 
	imx537_spi_write(0x02, 0x19, 0x04); // INCKSEL_ST4
	imx537_spi_write(0x1B, 0x19, 0x0F); // 
	imx537_spi_write(0x02, 0x1B, 0x3A); // INCKSEL_ST5
	imx537_spi_write(0x04, 0x1C, 0x80); // INCKSEL_N0
	imx537_spi_write(0x04, 0x1D, 0x05); // INCKSEL_N1
	imx537_spi_write(0x04, 0x1E, 0xE0); // INCKSEL_N2
	imx537_spi_write(0x1B, 0x1E, 0xFF); // 
	imx537_spi_write(0x04, 0x1F, 0x00); // INCKSEL_N3
	imx537_spi_write(0x1B, 0x1F, 0x0F); // 
	imx537_spi_write(0x04, 0x20, 0x80); // INCKSEL_S0
	imx537_spi_write(0x1B, 0x20, 0x00); // 
	imx537_spi_write(0x04, 0x21, 0x05); // INCKSEL_S1
	imx537_spi_write(0x07, 0x21, 0x21); // 
	imx537_spi_write(0x1B, 0x21, 0x00); // 
	imx537_spi_write(0x04, 0x22, 0xE0); // INCKSEL_S2
	imx537_spi_write(0x04, 0x23, 0x00); // INCKSEL_S3
	imx537_spi_write(0x04, 0x24, 0x10); // INCKSEL_D0
	imx537_spi_write(0x04, 0x25, 0x14); // INCKSEL_D1
	imx537_spi_write(0x04, 0x26, 0x20); // INCKSEL_D2
	imx537_spi_write(0x1B, 0x26, 0xFF); // 
	imx537_spi_write(0x04, 0x27, 0xC0); // INCKSEL_D3
	imx537_spi_write(0x1B, 0x27, 0x0F); // 
	imx537_spi_write(0x1B, 0x28, 0x00); // 
	imx537_spi_write(0x1B, 0x29, 0x00); // 
	imx537_spi_write(0x04, 0x2B, 0x02); // SLVS_EN
	imx537_spi_write(0x10, 0x2E, 0x07); // 
	imx537_spi_write(0x19, 0x2E, 0x06); // 
	imx537_spi_write(0x19, 0x2F, 0x06); // 
	imx537_spi_write(0x10, 0x30, 0x4E); // 
	imx537_spi_write(0x19, 0x30, 0x06); // 
	imx537_spi_write(0x19, 0x31, 0x06); // 
	imx537_spi_write(0x14, 0x32, 0x3C); // 
	imx537_spi_write(0x1B, 0x34, 0x0A); // 
	imx537_spi_write(0x07, 0x35, 0x00); // 
	imx537_spi_write(0x14, 0x35, 0x22); // 
	imx537_spi_write(0x11, 0x3A, 0x04); // 
	imx537_spi_write(0x02, 0x3C, 0x03); // HVMODE
	imx537_spi_write(0x04, 0x3C, 0x31); // LLBLANK
	imx537_spi_write(0x15, 0x3C, 0x8A); // 
	imx537_spi_write(0x19, 0x3C, 0x06); // 
	imx537_spi_write(0x04, 0x3D, 0x00); // LLBLANK
	imx537_spi_write(0x15, 0x3D, 0x02); // 
	imx537_spi_write(0x19, 0x3D, 0x06); // 
	imx537_spi_write(0x04, 0x3E, 0x5B); // VINT Default Value Set
	imx537_spi_write(0x15, 0x3E, 0xE8); // 
	imx537_spi_write(0x19, 0x3E, 0x06); // 
	imx537_spi_write(0x15, 0x3F, 0x05); // 
	imx537_spi_write(0x19, 0x3F, 0x06); // 
	imx537_spi_write(0x04, 0x40, 0x70); // SHS Default Value Set
	imx537_spi_write(0x15, 0x40, 0x9E); // 
	imx537_spi_write(0x04, 0x41, 0x00); // SHS Default Value Set
	imx537_spi_write(0x15, 0x41, 0x0C); // 
	imx537_spi_write(0x04, 0x42, 0x00); // SHS Default Value Set
	imx537_spi_write(0x07, 0x42, 0x27); // 
	imx537_spi_write(0x07, 0x46, 0x08); // 
	imx537_spi_write(0x19, 0x49, 0x9F); // 
	imx537_spi_write(0x07, 0x4A, 0x20); // 
	imx537_spi_write(0x19, 0x4A, 0x99); // 
	imx537_spi_write(0x19, 0x4B, 0x09); // 
	imx537_spi_write(0x19, 0x53, 0x90); // 
	imx537_spi_write(0x19, 0x54, 0x99); // 
	imx537_spi_write(0x19, 0x55, 0x09); // 
	imx537_spi_write(0x12, 0x56, 0x23); // 
	imx537_spi_write(0x1A, 0x64, 0xDC); // 
	imx537_spi_write(0x1A, 0x68, 0xDC); // 
	imx537_spi_write(0x08, 0x6A, 0x1B); // 
	imx537_spi_write(0x16, 0x6A, 0x4C); // 
	imx537_spi_write(0x1A, 0x6C, 0xDC); // 
	imx537_spi_write(0x10, 0x6E, 0x07); // 
	imx537_spi_write(0x16, 0x6E, 0x51); // 
	imx537_spi_write(0x08, 0x70, 0xC3); // 
	imx537_spi_write(0x10, 0x70, 0x35); // 
	imx537_spi_write(0x08, 0x72, 0x05); // 
	imx537_spi_write(0x16, 0x72, 0x57); // 
	imx537_spi_write(0x08, 0x74, 0xB6); // 
	imx537_spi_write(0x1A, 0x74, 0xDC); // 
	imx537_spi_write(0x08, 0x75, 0x01); // 
	imx537_spi_write(0x08, 0x76, 0x05); // 
	imx537_spi_write(0x16, 0x76, 0x79); // 
	imx537_spi_write(0x17, 0x76, 0xBE); // 
	imx537_spi_write(0x1A, 0x78, 0xDC); // 
	imx537_spi_write(0x17, 0x7A, 0xB1); // 
	imx537_spi_write(0x1A, 0x7C, 0xDC); // 
	imx537_spi_write(0x17, 0x80, 0xBC); // 
	imx537_spi_write(0x13, 0x82, 0x00); // 
	imx537_spi_write(0x17, 0x84, 0xAF); // 
	imx537_spi_write(0x19, 0x88, 0x04); // 
	imx537_spi_write(0x16, 0x8A, 0x4C); // 
	imx537_spi_write(0x16, 0x8E, 0x51); // 
	imx537_spi_write(0x16, 0x92, 0x57); // 
	imx537_spi_write(0x10, 0x96, 0x01); // 
	imx537_spi_write(0x12, 0x96, 0x23); // 
	imx537_spi_write(0x16, 0x96, 0x79); // 
//	imx537_spi_write(0x09, 0x97, 0x00); // DCMP_SEL Default Value Set
	imx537_spi_write(0x09, 0x97, 0x20); // DCMP_SEL Default Value Set
	imx537_spi_write(0x07, 0x9C, 0x0F); // 
	imx537_spi_write(0x07, 0x9D, 0x02); // 
	imx537_spi_write(0x10, 0x9E, 0x38); // 
	imx537_spi_write(0x10, 0xA0, 0x4C); // 
	imx537_spi_write(0x13, 0xA2, 0x03); // 
	imx537_spi_write(0x07, 0xA4, 0x08); // 
	imx537_spi_write(0x1A, 0xA4, 0xF4); // 
	imx537_spi_write(0x07, 0xA5, 0x12); // 
	imx537_spi_write(0x07, 0xA8, 0x08); // 
	imx537_spi_write(0x1A, 0xA8, 0xF4); // 
	imx537_spi_write(0x07, 0xA9, 0x62); // 
	imx537_spi_write(0x1A, 0xAC, 0xF4); // 
	imx537_spi_write(0x07, 0xB4, 0xF0); // 
	imx537_spi_write(0x1A, 0xB4, 0xF4); // 
	imx537_spi_write(0x1A, 0xB8, 0xF4); // 
	imx537_spi_write(0x1A, 0xBC, 0xF4); // 
	imx537_spi_write(0x07, 0xCE, 0x0E); // 
	imx537_spi_write(0x02, 0xD0, 0xA8); // VOPB_VBLK_HWIDTH
	imx537_spi_write(0x02, 0xD1, 0x09); // VOPB_VBLK_HWIDTH
	imx537_spi_write(0x02, 0xD2, 0xA8); // FIFO_HWIDTH
	imx537_spi_write(0x02, 0xD3, 0x09); // FIFO_HWIDTH
	imx537_spi_write(0x02, 0xDC, 0x00); // FREQ
//	imx537_spi_write(0x02, 0xE0, 0x08); //
//	imx537_spi_write(0x02, 0xE1, 0x08); //
//	imx537_spi_write(0x02, 0xE5, 0x04); // GAINDLY
	imx537_spi_write(0x08, 0xE8, 0x13); // 
	imx537_spi_write(0x07, 0xEC, 0x08); // 
	imx537_spi_write(0x16, 0xEC, 0x3F); // 
	imx537_spi_write(0x07, 0xED, 0x12); // 
	imx537_spi_write(0x07, 0xF0, 0xFB); // 
	imx537_spi_write(0x16, 0xF0, 0x44); // 
	imx537_spi_write(0x07, 0xF1, 0x0B); // 
	imx537_spi_write(0x07, 0xF2, 0xFB); // 
	imx537_spi_write(0x07, 0xF3, 0x0B); // 
	imx537_spi_write(0x16, 0xF4, 0x4A); // 
	imx537_spi_write(0x08, 0xF5, 0x0F); // 

	imx537_spi_write(0x02, 0x00, 0x00); // STNADBY
	usleep(10*1000);
	imx537_spi_write(0x02, 0x10, 0x00); // XMASTER

	//-----------------------------------------------------
	//--- Error Status Check
	//-----------------------------------------------------

	for (i = 0 ; i <= WAIT_10MS_LOOP ; i ++ ){
		asm("nop");
	}

	// Clear Error Count
	IOWR_32DIRECT(SLEC_RX_CSR_BASE, CTRL , 0x0000010F );

	while (1){
		printf("STAT          : %08x\n", IORD_32DIRECT(SLEC_RX_CSR_BASE, STAT));
		printf("ECC_STAT      : %08x\n", IORD_32DIRECT(SLEC_RX_CSR_BASE, ECC_STAT));

		for (i = 0 ; i <= WAIT_10MS_LOOP ; i ++ ){
			asm("nop");
		}

	}

	return 0;
}
