//----------------------------------------------------------------------------------------
//Copyright (C) 2012 Macnica Inc. All Rights Reserved.
//
//Use in source and binary forms, with or without modification, are permitted provided
//by agreeing to the following terms and conditions:
//
//REDISTRIBUTIONS OR SUBLICENSING IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS "AS IS"
//AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE
//FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
//SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
//CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
//OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//AND ALSO REGARDING THE REFERENCE SOFTWARE, REDISTRIBUTION OR SUBLICENSING
//IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//----------------------------------------------------------------------------------------
// DESCRIPTION
//		gaussian scaling filter coefficient table for scaler adaptive
//----------------------------------------------------------------------------------------
// REVISION HISTORY
//		v1.0 Mar. 13 2012	: Initial Version Release
//----------------------------------------------------------------------------------------
// PARAMETERS
//		Q_BIT		: quantized bit width per color plane
//
//		DLT_BIT		: delta bit width
//		COEFF_BIT	: coefficient bit width
//
//----------------------------------------------------------------------------------------
// I/O PORTS
//		clk;		: clock for all circuit
//		rst_n;		: asynchronous reset ( low active )
//		enable;		: clock enable
//
//		a_i			: scaling filter function coefficient
//						0:sigma=0.5 / 1:sigma=0.8 / 2:sigma=1 / 3:sigma=1.5
//		x_i			: table index
//
//		coeff_m1_o	: table value ( -2 -> -1 section coefficient )
//		coeff_zr_o	: table value ( -1 ->  0 section coefficient )
//		coeff_p1_o	: table value (  0 ->  1 section coefficient )
//		coeff_p2_o	: table value (  1 ->  2 section coefficient )
//
//----------------------------------------------------------------------------------------
`timescale 1ps/1ps
`default_nettype none

module	scl16_gaussian_ph32_func (
	clk			,
	rst_n		,
	enable		,

	s_i			,
	x_i			,

	coeff_m1_o	,
	coeff_zr_o	,
	coeff_p1_o	,
	coeff_p2_o
) ;

// =============================================================================
// DEFINE INCLUDE
// =============================================================================

// =============================================================================
// PARAMETER DEFINITION
// =============================================================================

	// ---------------------------------------------------------------------
	// Below parameters have to be defined from upper module
	// ---------------------------------------------------------------------
	parameter Q_BIT					= 8			;

	// ---------------------------------------------------------------------
	// Please do not change the following parameters
	// ---------------------------------------------------------------------
	parameter DLT_BIT				= 5			;
	parameter COEFF_BIT				= Q_BIT + 1	;

// =============================================================================
// PORT DECLARATION
// =============================================================================
	input	wire							clk			;
	input	wire							rst_n		;
	input	wire							enable		;

	input	wire	[ 1 : 0 ]				s_i			;
	input	wire	[ DLT_BIT-1 : 0 ]		x_i			;

	output	wire	[ COEFF_BIT-1 : 0 ]		coeff_m1_o	;
	output	wire	[ COEFF_BIT-1 : 0 ]		coeff_zr_o	;
	output	wire	[ COEFF_BIT-1 : 0 ]		coeff_p1_o	;
	output	wire	[ COEFF_BIT-1 : 0 ]		coeff_p2_o	;

// =============================================================================
// REG / WIRE DECLARATION
// =============================================================================
	reg		[ COEFF_BIT-1 : 0 ]		coeff_m1_ff	;
	reg		[ COEFF_BIT-1 : 0 ]		coeff_zr_ff	;
	reg		[ COEFF_BIT-1 : 0 ]		coeff_p1_ff	;
	reg		[ COEFF_BIT-1 : 0 ]		coeff_p2_ff	;

// =============================================================================
// FUNCTION DESCRIPTION
// =============================================================================
	generate
		if ( Q_BIT == 6 ) begin : table_6bit
			//-------------------- Table Value Format -----------------------//
			//	 { Sign(1bit), Integral Part(1bit), Fraction Part(5bit) }	 //
			//---------------------------------------------------------------//
			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_m1_ff		<= 7'h00 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_m1_ff	<= 7'h03 ;
						7'b00_0_0001	: coeff_m1_ff	<= 7'h03 ;
						7'b00_0_0010	: coeff_m1_ff	<= 7'h02 ;
						7'b00_0_0011	: coeff_m1_ff	<= 7'h02 ;
						7'b00_0_0100	: coeff_m1_ff	<= 7'h02 ;
						7'b00_0_0101	: coeff_m1_ff	<= 7'h01 ;
						7'b00_0_0110	: coeff_m1_ff	<= 7'h01 ;
						7'b00_0_0111	: coeff_m1_ff	<= 7'h01 ;
						7'b00_0_1000	: coeff_m1_ff	<= 7'h01 ;
						7'b00_0_1001	: coeff_m1_ff	<= 7'h01 ;
						7'b00_0_1010	: coeff_m1_ff	<= 7'h01 ;
						7'b00_0_1011	: coeff_m1_ff	<= 7'h01 ;
						7'b00_0_1100	: coeff_m1_ff	<= 7'h00 ;
						7'b00_0_1101	: coeff_m1_ff	<= 7'h00 ;
						7'b00_0_1110	: coeff_m1_ff	<= 7'h00 ;
						7'b00_0_1111	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_0000	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_0001	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_0010	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_0011	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_0100	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_0101	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_0110	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_0111	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_1000	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_1001	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_1010	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_1011	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_1100	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_1101	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_1110	: coeff_m1_ff	<= 7'h00 ;
						7'b00_1_1111	: coeff_m1_ff	<= 7'h00 ;

						7'b01_0_0000	: coeff_m1_ff	<= 7'h07 ;
						7'b01_0_0001	: coeff_m1_ff	<= 7'h07 ;
						7'b01_0_0010	: coeff_m1_ff	<= 7'h07 ;
						7'b01_0_0011	: coeff_m1_ff	<= 7'h07 ;
						7'b01_0_0100	: coeff_m1_ff	<= 7'h06 ;
						7'b01_0_0101	: coeff_m1_ff	<= 7'h05 ;
						7'b01_0_0110	: coeff_m1_ff	<= 7'h05 ;
						7'b01_0_0111	: coeff_m1_ff	<= 7'h05 ;
						7'b01_0_1000	: coeff_m1_ff	<= 7'h04 ;
						7'b01_0_1001	: coeff_m1_ff	<= 7'h04 ;
						7'b01_0_1010	: coeff_m1_ff	<= 7'h04 ;
						7'b01_0_1011	: coeff_m1_ff	<= 7'h04 ;
						7'b01_0_1100	: coeff_m1_ff	<= 7'h03 ;
						7'b01_0_1101	: coeff_m1_ff	<= 7'h03 ;
						7'b01_0_1110	: coeff_m1_ff	<= 7'h03 ;
						7'b01_0_1111	: coeff_m1_ff	<= 7'h03 ;
						7'b01_1_0000	: coeff_m1_ff	<= 7'h02 ;
						7'b01_1_0001	: coeff_m1_ff	<= 7'h02 ;
						7'b01_1_0010	: coeff_m1_ff	<= 7'h02 ;
						7'b01_1_0011	: coeff_m1_ff	<= 7'h02 ;
						7'b01_1_0100	: coeff_m1_ff	<= 7'h02 ;
						7'b01_1_0101	: coeff_m1_ff	<= 7'h01 ;
						7'b01_1_0110	: coeff_m1_ff	<= 7'h01 ;
						7'b01_1_0111	: coeff_m1_ff	<= 7'h01 ;
						7'b01_1_1000	: coeff_m1_ff	<= 7'h01 ;
						7'b01_1_1001	: coeff_m1_ff	<= 7'h01 ;
						7'b01_1_1010	: coeff_m1_ff	<= 7'h01 ;
						7'b01_1_1011	: coeff_m1_ff	<= 7'h01 ;
						7'b01_1_1100	: coeff_m1_ff	<= 7'h01 ;
						7'b01_1_1101	: coeff_m1_ff	<= 7'h00 ;
						7'b01_1_1110	: coeff_m1_ff	<= 7'h00 ;
						7'b01_1_1111	: coeff_m1_ff	<= 7'h00 ;

						7'b10_0_0000	: coeff_m1_ff	<= 7'h08 ;
						7'b10_0_0001	: coeff_m1_ff	<= 7'h08 ;
						7'b10_0_0010	: coeff_m1_ff	<= 7'h08 ;
						7'b10_0_0011	: coeff_m1_ff	<= 7'h07 ;
						7'b10_0_0100	: coeff_m1_ff	<= 7'h07 ;
						7'b10_0_0101	: coeff_m1_ff	<= 7'h07 ;
						7'b10_0_0110	: coeff_m1_ff	<= 7'h07 ;
						7'b10_0_0111	: coeff_m1_ff	<= 7'h06 ;
						7'b10_0_1000	: coeff_m1_ff	<= 7'h06 ;
						7'b10_0_1001	: coeff_m1_ff	<= 7'h06 ;
						7'b10_0_1010	: coeff_m1_ff	<= 7'h06 ;
						7'b10_0_1011	: coeff_m1_ff	<= 7'h06 ;
						7'b10_0_1100	: coeff_m1_ff	<= 7'h05 ;
						7'b10_0_1101	: coeff_m1_ff	<= 7'h05 ;
						7'b10_0_1110	: coeff_m1_ff	<= 7'h05 ;
						7'b10_0_1111	: coeff_m1_ff	<= 7'h05 ;
						7'b10_1_0000	: coeff_m1_ff	<= 7'h05 ;
						7'b10_1_0001	: coeff_m1_ff	<= 7'h04 ;
						7'b10_1_0010	: coeff_m1_ff	<= 7'h04 ;
						7'b10_1_0011	: coeff_m1_ff	<= 7'h04 ;
						7'b10_1_0100	: coeff_m1_ff	<= 7'h04 ;
						7'b10_1_0101	: coeff_m1_ff	<= 7'h04 ;
						7'b10_1_0110	: coeff_m1_ff	<= 7'h04 ;
						7'b10_1_0111	: coeff_m1_ff	<= 7'h04 ;
						7'b10_1_1000	: coeff_m1_ff	<= 7'h03 ;
						7'b10_1_1001	: coeff_m1_ff	<= 7'h03 ;
						7'b10_1_1010	: coeff_m1_ff	<= 7'h03 ;
						7'b10_1_1011	: coeff_m1_ff	<= 7'h03 ;
						7'b10_1_1100	: coeff_m1_ff	<= 7'h03 ;
						7'b10_1_1101	: coeff_m1_ff	<= 7'h03 ;
						7'b10_1_1110	: coeff_m1_ff	<= 7'h03 ;
						7'b10_1_1111	: coeff_m1_ff	<= 7'h03 ;

						7'b11_0_0000	: coeff_m1_ff	<= 7'h08 ;
						7'b11_0_0001	: coeff_m1_ff	<= 7'h08 ;
						7'b11_0_0010	: coeff_m1_ff	<= 7'h08 ;
						7'b11_0_0011	: coeff_m1_ff	<= 7'h08 ;
						7'b11_0_0100	: coeff_m1_ff	<= 7'h08 ;
						7'b11_0_0101	: coeff_m1_ff	<= 7'h08 ;
						7'b11_0_0110	: coeff_m1_ff	<= 7'h07 ;
						7'b11_0_0111	: coeff_m1_ff	<= 7'h07 ;
						7'b11_0_1000	: coeff_m1_ff	<= 7'h07 ;
						7'b11_0_1001	: coeff_m1_ff	<= 7'h07 ;
						7'b11_0_1010	: coeff_m1_ff	<= 7'h07 ;
						7'b11_0_1011	: coeff_m1_ff	<= 7'h07 ;
						7'b11_0_1100	: coeff_m1_ff	<= 7'h07 ;
						7'b11_0_1101	: coeff_m1_ff	<= 7'h07 ;
						7'b11_0_1110	: coeff_m1_ff	<= 7'h07 ;
						7'b11_0_1111	: coeff_m1_ff	<= 7'h07 ;
						7'b11_1_0000	: coeff_m1_ff	<= 7'h07 ;
						7'b11_1_0001	: coeff_m1_ff	<= 7'h07 ;
						7'b11_1_0010	: coeff_m1_ff	<= 7'h07 ;
						7'b11_1_0011	: coeff_m1_ff	<= 7'h07 ;
						7'b11_1_0100	: coeff_m1_ff	<= 7'h07 ;
						7'b11_1_0101	: coeff_m1_ff	<= 7'h07 ;
						7'b11_1_0110	: coeff_m1_ff	<= 7'h06 ;
						7'b11_1_0111	: coeff_m1_ff	<= 7'h06 ;
						7'b11_1_1000	: coeff_m1_ff	<= 7'h06 ;
						7'b11_1_1001	: coeff_m1_ff	<= 7'h06 ;
						7'b11_1_1010	: coeff_m1_ff	<= 7'h06 ;
						7'b11_1_1011	: coeff_m1_ff	<= 7'h06 ;
						7'b11_1_1100	: coeff_m1_ff	<= 7'h06 ;
						7'b11_1_1101	: coeff_m1_ff	<= 7'h06 ;
						7'b11_1_1110	: coeff_m1_ff	<= 7'h06 ;
						7'b11_1_1111	: coeff_m1_ff	<= 7'h06 ;
						default			: coeff_m1_ff	<= {7{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_zr_ff		<= 7'h20 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_zr_ff	<= 7'h1a ;
						7'b00_0_0001	: coeff_zr_ff	<= 7'h1a ;
						7'b00_0_0010	: coeff_zr_ff	<= 7'h1a ;
						7'b00_0_0011	: coeff_zr_ff	<= 7'h19 ;
						7'b00_0_0100	: coeff_zr_ff	<= 7'h19 ;
						7'b00_0_0101	: coeff_zr_ff	<= 7'h19 ;
						7'b00_0_0110	: coeff_zr_ff	<= 7'h18 ;
						7'b00_0_0111	: coeff_zr_ff	<= 7'h17 ;
						7'b00_0_1000	: coeff_zr_ff	<= 7'h17 ;
						7'b00_0_1001	: coeff_zr_ff	<= 7'h16 ;
						7'b00_0_1010	: coeff_zr_ff	<= 7'h15 ;
						7'b00_0_1011	: coeff_zr_ff	<= 7'h14 ;
						7'b00_0_1100	: coeff_zr_ff	<= 7'h14 ;
						7'b00_0_1101	: coeff_zr_ff	<= 7'h13 ;
						7'b00_0_1110	: coeff_zr_ff	<= 7'h12 ;
						7'b00_0_1111	: coeff_zr_ff	<= 7'h11 ;
						7'b00_1_0000	: coeff_zr_ff	<= 7'h10 ;
						7'b00_1_0001	: coeff_zr_ff	<= 7'h0f ;
						7'b00_1_0010	: coeff_zr_ff	<= 7'h0e ;
						7'b00_1_0011	: coeff_zr_ff	<= 7'h0d ;
						7'b00_1_0100	: coeff_zr_ff	<= 7'h0c ;
						7'b00_1_0101	: coeff_zr_ff	<= 7'h0b ;
						7'b00_1_0110	: coeff_zr_ff	<= 7'h0a ;
						7'b00_1_0111	: coeff_zr_ff	<= 7'h09 ;
						7'b00_1_1000	: coeff_zr_ff	<= 7'h09 ;
						7'b00_1_1001	: coeff_zr_ff	<= 7'h08 ;
						7'b00_1_1010	: coeff_zr_ff	<= 7'h07 ;
						7'b00_1_1011	: coeff_zr_ff	<= 7'h07 ;
						7'b00_1_1100	: coeff_zr_ff	<= 7'h06 ;
						7'b00_1_1101	: coeff_zr_ff	<= 7'h05 ;
						7'b00_1_1110	: coeff_zr_ff	<= 7'h05 ;
						7'b00_1_1111	: coeff_zr_ff	<= 7'h04 ;

						7'b01_0_0000	: coeff_zr_ff	<= 7'h11 ;
						7'b01_0_0001	: coeff_zr_ff	<= 7'h11 ;
						7'b01_0_0010	: coeff_zr_ff	<= 7'h10 ;
						7'b01_0_0011	: coeff_zr_ff	<= 7'h10 ;
						7'b01_0_0100	: coeff_zr_ff	<= 7'h10 ;
						7'b01_0_0101	: coeff_zr_ff	<= 7'h10 ;
						7'b01_0_0110	: coeff_zr_ff	<= 7'h10 ;
						7'b01_0_0111	: coeff_zr_ff	<= 7'h10 ;
						7'b01_0_1000	: coeff_zr_ff	<= 7'h10 ;
						7'b01_0_1001	: coeff_zr_ff	<= 7'h10 ;
						7'b01_0_1010	: coeff_zr_ff	<= 7'h0f ;
						7'b01_0_1011	: coeff_zr_ff	<= 7'h0f ;
						7'b01_0_1100	: coeff_zr_ff	<= 7'h0f ;
						7'b01_0_1101	: coeff_zr_ff	<= 7'h0f ;
						7'b01_0_1110	: coeff_zr_ff	<= 7'h0e ;
						7'b01_0_1111	: coeff_zr_ff	<= 7'h0e ;
						7'b01_1_0000	: coeff_zr_ff	<= 7'h0e ;
						7'b01_1_0001	: coeff_zr_ff	<= 7'h0d ;
						7'b01_1_0010	: coeff_zr_ff	<= 7'h0d ;
						7'b01_1_0011	: coeff_zr_ff	<= 7'h0d ;
						7'b01_1_0100	: coeff_zr_ff	<= 7'h0c ;
						7'b01_1_0101	: coeff_zr_ff	<= 7'h0c ;
						7'b01_1_0110	: coeff_zr_ff	<= 7'h0c ;
						7'b01_1_0111	: coeff_zr_ff	<= 7'h0b ;
						7'b01_1_1000	: coeff_zr_ff	<= 7'h0b ;
						7'b01_1_1001	: coeff_zr_ff	<= 7'h0a ;
						7'b01_1_1010	: coeff_zr_ff	<= 7'h0a ;
						7'b01_1_1011	: coeff_zr_ff	<= 7'h0a ;
						7'b01_1_1100	: coeff_zr_ff	<= 7'h09 ;
						7'b01_1_1101	: coeff_zr_ff	<= 7'h09 ;
						7'b01_1_1110	: coeff_zr_ff	<= 7'h09 ;
						7'b01_1_1111	: coeff_zr_ff	<= 7'h08 ;

						7'b10_0_0000	: coeff_zr_ff	<= 7'h0d ;
						7'b10_0_0001	: coeff_zr_ff	<= 7'h0d ;
						7'b10_0_0010	: coeff_zr_ff	<= 7'h0d ;
						7'b10_0_0011	: coeff_zr_ff	<= 7'h0d ;
						7'b10_0_0100	: coeff_zr_ff	<= 7'h0d ;
						7'b10_0_0101	: coeff_zr_ff	<= 7'h0d ;
						7'b10_0_0110	: coeff_zr_ff	<= 7'h0d ;
						7'b10_0_0111	: coeff_zr_ff	<= 7'h0d ;
						7'b10_0_1000	: coeff_zr_ff	<= 7'h0d ;
						7'b10_0_1001	: coeff_zr_ff	<= 7'h0c ;
						7'b10_0_1010	: coeff_zr_ff	<= 7'h0c ;
						7'b10_0_1011	: coeff_zr_ff	<= 7'h0c ;
						7'b10_0_1100	: coeff_zr_ff	<= 7'h0c ;
						7'b10_0_1101	: coeff_zr_ff	<= 7'h0c ;
						7'b10_0_1110	: coeff_zr_ff	<= 7'h0c ;
						7'b10_0_1111	: coeff_zr_ff	<= 7'h0c ;
						7'b10_1_0000	: coeff_zr_ff	<= 7'h0b ;
						7'b10_1_0001	: coeff_zr_ff	<= 7'h0b ;
						7'b10_1_0010	: coeff_zr_ff	<= 7'h0b ;
						7'b10_1_0011	: coeff_zr_ff	<= 7'h0b ;
						7'b10_1_0100	: coeff_zr_ff	<= 7'h0b ;
						7'b10_1_0101	: coeff_zr_ff	<= 7'h0a ;
						7'b10_1_0110	: coeff_zr_ff	<= 7'h0a ;
						7'b10_1_0111	: coeff_zr_ff	<= 7'h0a ;
						7'b10_1_1000	: coeff_zr_ff	<= 7'h0a ;
						7'b10_1_1001	: coeff_zr_ff	<= 7'h0a ;
						7'b10_1_1010	: coeff_zr_ff	<= 7'h09 ;
						7'b10_1_1011	: coeff_zr_ff	<= 7'h09 ;
						7'b10_1_1100	: coeff_zr_ff	<= 7'h09 ;
						7'b10_1_1101	: coeff_zr_ff	<= 7'h09 ;
						7'b10_1_1110	: coeff_zr_ff	<= 7'h08 ;
						7'b10_1_1111	: coeff_zr_ff	<= 7'h08 ;

						7'b11_0_0000	: coeff_zr_ff	<= 7'h0a ;
						7'b11_0_0001	: coeff_zr_ff	<= 7'h0a ;
						7'b11_0_0010	: coeff_zr_ff	<= 7'h0a ;
						7'b11_0_0011	: coeff_zr_ff	<= 7'h0a ;
						7'b11_0_0100	: coeff_zr_ff	<= 7'h0a ;
						7'b11_0_0101	: coeff_zr_ff	<= 7'h0a ;
						7'b11_0_0110	: coeff_zr_ff	<= 7'h0a ;
						7'b11_0_0111	: coeff_zr_ff	<= 7'h0a ;
						7'b11_0_1000	: coeff_zr_ff	<= 7'h0a ;
						7'b11_0_1001	: coeff_zr_ff	<= 7'h0a ;
						7'b11_0_1010	: coeff_zr_ff	<= 7'h0a ;
						7'b11_0_1011	: coeff_zr_ff	<= 7'h09 ;
						7'b11_0_1100	: coeff_zr_ff	<= 7'h09 ;
						7'b11_0_1101	: coeff_zr_ff	<= 7'h09 ;
						7'b11_0_1110	: coeff_zr_ff	<= 7'h09 ;
						7'b11_0_1111	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_0000	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_0001	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_0010	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_0011	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_0100	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_0101	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_0110	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_0111	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_1000	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_1001	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_1010	: coeff_zr_ff	<= 7'h09 ;
						7'b11_1_1011	: coeff_zr_ff	<= 7'h08 ;
						7'b11_1_1100	: coeff_zr_ff	<= 7'h08 ;
						7'b11_1_1101	: coeff_zr_ff	<= 7'h08 ;
						7'b11_1_1110	: coeff_zr_ff	<= 7'h08 ;
						7'b11_1_1111	: coeff_zr_ff	<= 7'h08 ;
						default			: coeff_zr_ff	<= {7{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p1_ff		<= 7'h00 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_p1_ff	<= 7'h03 ;
						7'b00_0_0001	: coeff_p1_ff	<= 7'h03 ;
						7'b00_0_0010	: coeff_p1_ff	<= 7'h04 ;
						7'b00_0_0011	: coeff_p1_ff	<= 7'h05 ;
						7'b00_0_0100	: coeff_p1_ff	<= 7'h05 ;
						7'b00_0_0101	: coeff_p1_ff	<= 7'h06 ;
						7'b00_0_0110	: coeff_p1_ff	<= 7'h07 ;
						7'b00_0_0111	: coeff_p1_ff	<= 7'h08 ;
						7'b00_0_1000	: coeff_p1_ff	<= 7'h08 ;
						7'b00_0_1001	: coeff_p1_ff	<= 7'h09 ;
						7'b00_0_1010	: coeff_p1_ff	<= 7'h0a ;
						7'b00_0_1011	: coeff_p1_ff	<= 7'h0b ;
						7'b00_0_1100	: coeff_p1_ff	<= 7'h0c ;
						7'b00_0_1101	: coeff_p1_ff	<= 7'h0d ;
						7'b00_0_1110	: coeff_p1_ff	<= 7'h0e ;
						7'b00_0_1111	: coeff_p1_ff	<= 7'h0f ;
						7'b00_1_0000	: coeff_p1_ff	<= 7'h10 ;
						7'b00_1_0001	: coeff_p1_ff	<= 7'h11 ;
						7'b00_1_0010	: coeff_p1_ff	<= 7'h12 ;
						7'b00_1_0011	: coeff_p1_ff	<= 7'h13 ;
						7'b00_1_0100	: coeff_p1_ff	<= 7'h14 ;
						7'b00_1_0101	: coeff_p1_ff	<= 7'h14 ;
						7'b00_1_0110	: coeff_p1_ff	<= 7'h15 ;
						7'b00_1_0111	: coeff_p1_ff	<= 7'h16 ;
						7'b00_1_1000	: coeff_p1_ff	<= 7'h16 ;
						7'b00_1_1001	: coeff_p1_ff	<= 7'h17 ;
						7'b00_1_1010	: coeff_p1_ff	<= 7'h18 ;
						7'b00_1_1011	: coeff_p1_ff	<= 7'h18 ;
						7'b00_1_1100	: coeff_p1_ff	<= 7'h18 ;
						7'b00_1_1101	: coeff_p1_ff	<= 7'h19 ;
						7'b00_1_1110	: coeff_p1_ff	<= 7'h19 ;
						7'b00_1_1111	: coeff_p1_ff	<= 7'h19 ;

						7'b01_0_0000	: coeff_p1_ff	<= 7'h08 ;
						7'b01_0_0001	: coeff_p1_ff	<= 7'h08 ;
						7'b01_0_0010	: coeff_p1_ff	<= 7'h09 ;
						7'b01_0_0011	: coeff_p1_ff	<= 7'h09 ;
						7'b01_0_0100	: coeff_p1_ff	<= 7'h09 ;
						7'b01_0_0101	: coeff_p1_ff	<= 7'h0a ;
						7'b01_0_0110	: coeff_p1_ff	<= 7'h0a ;
						7'b01_0_0111	: coeff_p1_ff	<= 7'h0a ;
						7'b01_0_1000	: coeff_p1_ff	<= 7'h0b ;
						7'b01_0_1001	: coeff_p1_ff	<= 7'h0b ;
						7'b01_0_1010	: coeff_p1_ff	<= 7'h0c ;
						7'b01_0_1011	: coeff_p1_ff	<= 7'h0c ;
						7'b01_0_1100	: coeff_p1_ff	<= 7'h0c ;
						7'b01_0_1101	: coeff_p1_ff	<= 7'h0c ;
						7'b01_0_1110	: coeff_p1_ff	<= 7'h0d ;
						7'b01_0_1111	: coeff_p1_ff	<= 7'h0d ;
						7'b01_1_0000	: coeff_p1_ff	<= 7'h0e ;
						7'b01_1_0001	: coeff_p1_ff	<= 7'h0e ;
						7'b01_1_0010	: coeff_p1_ff	<= 7'h0e ;
						7'b01_1_0011	: coeff_p1_ff	<= 7'h0e ;
						7'b01_1_0100	: coeff_p1_ff	<= 7'h0f ;
						7'b01_1_0101	: coeff_p1_ff	<= 7'h0f ;
						7'b01_1_0110	: coeff_p1_ff	<= 7'h0f ;
						7'b01_1_0111	: coeff_p1_ff	<= 7'h10 ;
						7'b01_1_1000	: coeff_p1_ff	<= 7'h10 ;
						7'b01_1_1001	: coeff_p1_ff	<= 7'h10 ;
						7'b01_1_1010	: coeff_p1_ff	<= 7'h10 ;
						7'b01_1_1011	: coeff_p1_ff	<= 7'h10 ;
						7'b01_1_1100	: coeff_p1_ff	<= 7'h10 ;
						7'b01_1_1101	: coeff_p1_ff	<= 7'h10 ;
						7'b01_1_1110	: coeff_p1_ff	<= 7'h10 ;
						7'b01_1_1111	: coeff_p1_ff	<= 7'h11 ;

						7'b10_0_0000	: coeff_p1_ff	<= 7'h08 ;
						7'b10_0_0001	: coeff_p1_ff	<= 7'h08 ;
						7'b10_0_0010	: coeff_p1_ff	<= 7'h08 ;
						7'b10_0_0011	: coeff_p1_ff	<= 7'h09 ;
						7'b10_0_0100	: coeff_p1_ff	<= 7'h09 ;
						7'b10_0_0101	: coeff_p1_ff	<= 7'h09 ;
						7'b10_0_0110	: coeff_p1_ff	<= 7'h09 ;
						7'b10_0_0111	: coeff_p1_ff	<= 7'h0a ;
						7'b10_0_1000	: coeff_p1_ff	<= 7'h0a ;
						7'b10_0_1001	: coeff_p1_ff	<= 7'h0a ;
						7'b10_0_1010	: coeff_p1_ff	<= 7'h0a ;
						7'b10_0_1011	: coeff_p1_ff	<= 7'h0a ;
						7'b10_0_1100	: coeff_p1_ff	<= 7'h0b ;
						7'b10_0_1101	: coeff_p1_ff	<= 7'h0b ;
						7'b10_0_1110	: coeff_p1_ff	<= 7'h0b ;
						7'b10_0_1111	: coeff_p1_ff	<= 7'h0b ;
						7'b10_1_0000	: coeff_p1_ff	<= 7'h0b ;
						7'b10_1_0001	: coeff_p1_ff	<= 7'h0c ;
						7'b10_1_0010	: coeff_p1_ff	<= 7'h0c ;
						7'b10_1_0011	: coeff_p1_ff	<= 7'h0c ;
						7'b10_1_0100	: coeff_p1_ff	<= 7'h0c ;
						7'b10_1_0101	: coeff_p1_ff	<= 7'h0c ;
						7'b10_1_0110	: coeff_p1_ff	<= 7'h0c ;
						7'b10_1_0111	: coeff_p1_ff	<= 7'h0c ;
						7'b10_1_1000	: coeff_p1_ff	<= 7'h0d ;
						7'b10_1_1001	: coeff_p1_ff	<= 7'h0d ;
						7'b10_1_1010	: coeff_p1_ff	<= 7'h0d ;
						7'b10_1_1011	: coeff_p1_ff	<= 7'h0d ;
						7'b10_1_1100	: coeff_p1_ff	<= 7'h0d ;
						7'b10_1_1101	: coeff_p1_ff	<= 7'h0d ;
						7'b10_1_1110	: coeff_p1_ff	<= 7'h0d ;
						7'b10_1_1111	: coeff_p1_ff	<= 7'h0d ;

						7'b11_0_0000	: coeff_p1_ff	<= 7'h08 ;
						7'b11_0_0001	: coeff_p1_ff	<= 7'h08 ;
						7'b11_0_0010	: coeff_p1_ff	<= 7'h08 ;
						7'b11_0_0011	: coeff_p1_ff	<= 7'h08 ;
						7'b11_0_0100	: coeff_p1_ff	<= 7'h08 ;
						7'b11_0_0101	: coeff_p1_ff	<= 7'h08 ;
						7'b11_0_0110	: coeff_p1_ff	<= 7'h09 ;
						7'b11_0_0111	: coeff_p1_ff	<= 7'h09 ;
						7'b11_0_1000	: coeff_p1_ff	<= 7'h09 ;
						7'b11_0_1001	: coeff_p1_ff	<= 7'h09 ;
						7'b11_0_1010	: coeff_p1_ff	<= 7'h09 ;
						7'b11_0_1011	: coeff_p1_ff	<= 7'h09 ;
						7'b11_0_1100	: coeff_p1_ff	<= 7'h09 ;
						7'b11_0_1101	: coeff_p1_ff	<= 7'h09 ;
						7'b11_0_1110	: coeff_p1_ff	<= 7'h09 ;
						7'b11_0_1111	: coeff_p1_ff	<= 7'h09 ;
						7'b11_1_0000	: coeff_p1_ff	<= 7'h09 ;
						7'b11_1_0001	: coeff_p1_ff	<= 7'h09 ;
						7'b11_1_0010	: coeff_p1_ff	<= 7'h09 ;
						7'b11_1_0011	: coeff_p1_ff	<= 7'h09 ;
						7'b11_1_0100	: coeff_p1_ff	<= 7'h09 ;
						7'b11_1_0101	: coeff_p1_ff	<= 7'h09 ;
						7'b11_1_0110	: coeff_p1_ff	<= 7'h0a ;
						7'b11_1_0111	: coeff_p1_ff	<= 7'h0a ;
						7'b11_1_1000	: coeff_p1_ff	<= 7'h0a ;
						7'b11_1_1001	: coeff_p1_ff	<= 7'h0a ;
						7'b11_1_1010	: coeff_p1_ff	<= 7'h0a ;
						7'b11_1_1011	: coeff_p1_ff	<= 7'h0a ;
						7'b11_1_1100	: coeff_p1_ff	<= 7'h0a ;
						7'b11_1_1101	: coeff_p1_ff	<= 7'h0a ;
						7'b11_1_1110	: coeff_p1_ff	<= 7'h0a ;
						7'b11_1_1111	: coeff_p1_ff	<= 7'h0a ;
						default			: coeff_p1_ff	<= {7{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p2_ff		<= 7'h00 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_0001	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_0010	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_0011	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_0100	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_0101	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_0110	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_0111	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_1000	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_1001	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_1010	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_1011	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_1100	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_1101	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_1110	: coeff_p2_ff	<= 7'h00 ;
						7'b00_0_1111	: coeff_p2_ff	<= 7'h00 ;
						7'b00_1_0000	: coeff_p2_ff	<= 7'h00 ;
						7'b00_1_0001	: coeff_p2_ff	<= 7'h00 ;
						7'b00_1_0010	: coeff_p2_ff	<= 7'h00 ;
						7'b00_1_0011	: coeff_p2_ff	<= 7'h00 ;
						7'b00_1_0100	: coeff_p2_ff	<= 7'h00 ;
						7'b00_1_0101	: coeff_p2_ff	<= 7'h01 ;
						7'b00_1_0110	: coeff_p2_ff	<= 7'h01 ;
						7'b00_1_0111	: coeff_p2_ff	<= 7'h01 ;
						7'b00_1_1000	: coeff_p2_ff	<= 7'h01 ;
						7'b00_1_1001	: coeff_p2_ff	<= 7'h01 ;
						7'b00_1_1010	: coeff_p2_ff	<= 7'h01 ;
						7'b00_1_1011	: coeff_p2_ff	<= 7'h01 ;
						7'b00_1_1100	: coeff_p2_ff	<= 7'h02 ;
						7'b00_1_1101	: coeff_p2_ff	<= 7'h02 ;
						7'b00_1_1110	: coeff_p2_ff	<= 7'h02 ;
						7'b00_1_1111	: coeff_p2_ff	<= 7'h03 ;

						7'b01_0_0000	: coeff_p2_ff	<= 7'h00 ;
						7'b01_0_0001	: coeff_p2_ff	<= 7'h00 ;
						7'b01_0_0010	: coeff_p2_ff	<= 7'h00 ;
						7'b01_0_0011	: coeff_p2_ff	<= 7'h00 ;
						7'b01_0_0100	: coeff_p2_ff	<= 7'h01 ;
						7'b01_0_0101	: coeff_p2_ff	<= 7'h01 ;
						7'b01_0_0110	: coeff_p2_ff	<= 7'h01 ;
						7'b01_0_0111	: coeff_p2_ff	<= 7'h01 ;
						7'b01_0_1000	: coeff_p2_ff	<= 7'h01 ;
						7'b01_0_1001	: coeff_p2_ff	<= 7'h01 ;
						7'b01_0_1010	: coeff_p2_ff	<= 7'h01 ;
						7'b01_0_1011	: coeff_p2_ff	<= 7'h01 ;
						7'b01_0_1100	: coeff_p2_ff	<= 7'h02 ;
						7'b01_0_1101	: coeff_p2_ff	<= 7'h02 ;
						7'b01_0_1110	: coeff_p2_ff	<= 7'h02 ;
						7'b01_0_1111	: coeff_p2_ff	<= 7'h02 ;
						7'b01_1_0000	: coeff_p2_ff	<= 7'h02 ;
						7'b01_1_0001	: coeff_p2_ff	<= 7'h03 ;
						7'b01_1_0010	: coeff_p2_ff	<= 7'h03 ;
						7'b01_1_0011	: coeff_p2_ff	<= 7'h03 ;
						7'b01_1_0100	: coeff_p2_ff	<= 7'h03 ;
						7'b01_1_0101	: coeff_p2_ff	<= 7'h04 ;
						7'b01_1_0110	: coeff_p2_ff	<= 7'h04 ;
						7'b01_1_0111	: coeff_p2_ff	<= 7'h04 ;
						7'b01_1_1000	: coeff_p2_ff	<= 7'h04 ;
						7'b01_1_1001	: coeff_p2_ff	<= 7'h05 ;
						7'b01_1_1010	: coeff_p2_ff	<= 7'h05 ;
						7'b01_1_1011	: coeff_p2_ff	<= 7'h05 ;
						7'b01_1_1100	: coeff_p2_ff	<= 7'h06 ;
						7'b01_1_1101	: coeff_p2_ff	<= 7'h07 ;
						7'b01_1_1110	: coeff_p2_ff	<= 7'h07 ;
						7'b01_1_1111	: coeff_p2_ff	<= 7'h07 ;

						7'b10_0_0000	: coeff_p2_ff	<= 7'h03 ;
						7'b10_0_0001	: coeff_p2_ff	<= 7'h03 ;
						7'b10_0_0010	: coeff_p2_ff	<= 7'h03 ;
						7'b10_0_0011	: coeff_p2_ff	<= 7'h03 ;
						7'b10_0_0100	: coeff_p2_ff	<= 7'h03 ;
						7'b10_0_0101	: coeff_p2_ff	<= 7'h03 ;
						7'b10_0_0110	: coeff_p2_ff	<= 7'h03 ;
						7'b10_0_0111	: coeff_p2_ff	<= 7'h03 ;
						7'b10_0_1000	: coeff_p2_ff	<= 7'h03 ;
						7'b10_0_1001	: coeff_p2_ff	<= 7'h04 ;
						7'b10_0_1010	: coeff_p2_ff	<= 7'h04 ;
						7'b10_0_1011	: coeff_p2_ff	<= 7'h04 ;
						7'b10_0_1100	: coeff_p2_ff	<= 7'h04 ;
						7'b10_0_1101	: coeff_p2_ff	<= 7'h04 ;
						7'b10_0_1110	: coeff_p2_ff	<= 7'h04 ;
						7'b10_0_1111	: coeff_p2_ff	<= 7'h04 ;
						7'b10_1_0000	: coeff_p2_ff	<= 7'h05 ;
						7'b10_1_0001	: coeff_p2_ff	<= 7'h05 ;
						7'b10_1_0010	: coeff_p2_ff	<= 7'h05 ;
						7'b10_1_0011	: coeff_p2_ff	<= 7'h05 ;
						7'b10_1_0100	: coeff_p2_ff	<= 7'h05 ;
						7'b10_1_0101	: coeff_p2_ff	<= 7'h06 ;
						7'b10_1_0110	: coeff_p2_ff	<= 7'h06 ;
						7'b10_1_0111	: coeff_p2_ff	<= 7'h06 ;
						7'b10_1_1000	: coeff_p2_ff	<= 7'h06 ;
						7'b10_1_1001	: coeff_p2_ff	<= 7'h06 ;
						7'b10_1_1010	: coeff_p2_ff	<= 7'h07 ;
						7'b10_1_1011	: coeff_p2_ff	<= 7'h07 ;
						7'b10_1_1100	: coeff_p2_ff	<= 7'h07 ;
						7'b10_1_1101	: coeff_p2_ff	<= 7'h07 ;
						7'b10_1_1110	: coeff_p2_ff	<= 7'h08 ;
						7'b10_1_1111	: coeff_p2_ff	<= 7'h08 ;

						7'b11_0_0000	: coeff_p2_ff	<= 7'h06 ;
						7'b11_0_0001	: coeff_p2_ff	<= 7'h06 ;
						7'b11_0_0010	: coeff_p2_ff	<= 7'h06 ;
						7'b11_0_0011	: coeff_p2_ff	<= 7'h06 ;
						7'b11_0_0100	: coeff_p2_ff	<= 7'h06 ;
						7'b11_0_0101	: coeff_p2_ff	<= 7'h06 ;
						7'b11_0_0110	: coeff_p2_ff	<= 7'h06 ;
						7'b11_0_0111	: coeff_p2_ff	<= 7'h06 ;
						7'b11_0_1000	: coeff_p2_ff	<= 7'h06 ;
						7'b11_0_1001	: coeff_p2_ff	<= 7'h06 ;
						7'b11_0_1010	: coeff_p2_ff	<= 7'h06 ;
						7'b11_0_1011	: coeff_p2_ff	<= 7'h07 ;
						7'b11_0_1100	: coeff_p2_ff	<= 7'h07 ;
						7'b11_0_1101	: coeff_p2_ff	<= 7'h07 ;
						7'b11_0_1110	: coeff_p2_ff	<= 7'h07 ;
						7'b11_0_1111	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_0000	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_0001	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_0010	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_0011	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_0100	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_0101	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_0110	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_0111	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_1000	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_1001	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_1010	: coeff_p2_ff	<= 7'h07 ;
						7'b11_1_1011	: coeff_p2_ff	<= 7'h08 ;
						7'b11_1_1100	: coeff_p2_ff	<= 7'h08 ;
						7'b11_1_1101	: coeff_p2_ff	<= 7'h08 ;
						7'b11_1_1110	: coeff_p2_ff	<= 7'h08 ;
						7'b11_1_1111	: coeff_p2_ff	<= 7'h08 ;
						default			: coeff_p2_ff	<= {7{1'bx}} ;
					endcase
				end
			end
		end
		else if ( Q_BIT == 8 ) begin : table_8bit
			//-------------------- Table Value Format -----------------------//
			//	 { Sign(1bit), Integral Part(1bit), Fraction Part(7bit) }	 //
			//---------------------------------------------------------------//
			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_m1_ff		<= 9'h000 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_m1_ff	<= 9'h00d ;
						7'b00_0_0001	: coeff_m1_ff	<= 9'h00c ;
						7'b00_0_0010	: coeff_m1_ff	<= 9'h00a ;
						7'b00_0_0011	: coeff_m1_ff	<= 9'h009 ;
						7'b00_0_0100	: coeff_m1_ff	<= 9'h008 ;
						7'b00_0_0101	: coeff_m1_ff	<= 9'h007 ;
						7'b00_0_0110	: coeff_m1_ff	<= 9'h006 ;
						7'b00_0_0111	: coeff_m1_ff	<= 9'h005 ;
						7'b00_0_1000	: coeff_m1_ff	<= 9'h004 ;
						7'b00_0_1001	: coeff_m1_ff	<= 9'h003 ;
						7'b00_0_1010	: coeff_m1_ff	<= 9'h003 ;
						7'b00_0_1011	: coeff_m1_ff	<= 9'h003 ;
						7'b00_0_1100	: coeff_m1_ff	<= 9'h003 ;
						7'b00_0_1101	: coeff_m1_ff	<= 9'h002 ;
						7'b00_0_1110	: coeff_m1_ff	<= 9'h002 ;
						7'b00_0_1111	: coeff_m1_ff	<= 9'h002 ;
						7'b00_1_0000	: coeff_m1_ff	<= 9'h002 ;
						7'b00_1_0001	: coeff_m1_ff	<= 9'h001 ;
						7'b00_1_0010	: coeff_m1_ff	<= 9'h001 ;
						7'b00_1_0011	: coeff_m1_ff	<= 9'h001 ;
						7'b00_1_0100	: coeff_m1_ff	<= 9'h000 ;
						7'b00_1_0101	: coeff_m1_ff	<= 9'h000 ;
						7'b00_1_0110	: coeff_m1_ff	<= 9'h000 ;
						7'b00_1_0111	: coeff_m1_ff	<= 9'h000 ;
						7'b00_1_1000	: coeff_m1_ff	<= 9'h000 ;
						7'b00_1_1001	: coeff_m1_ff	<= 9'h000 ;
						7'b00_1_1010	: coeff_m1_ff	<= 9'h000 ;
						7'b00_1_1011	: coeff_m1_ff	<= 9'h000 ;
						7'b00_1_1100	: coeff_m1_ff	<= 9'h000 ;
						7'b00_1_1101	: coeff_m1_ff	<= 9'h000 ;
						7'b00_1_1110	: coeff_m1_ff	<= 9'h000 ;
						7'b00_1_1111	: coeff_m1_ff	<= 9'h000 ;

						7'b01_0_0000	: coeff_m1_ff	<= 9'h01e ;
						7'b01_0_0001	: coeff_m1_ff	<= 9'h01d ;
						7'b01_0_0010	: coeff_m1_ff	<= 9'h01b ;
						7'b01_0_0011	: coeff_m1_ff	<= 9'h01a ;
						7'b01_0_0100	: coeff_m1_ff	<= 9'h018 ;
						7'b01_0_0101	: coeff_m1_ff	<= 9'h017 ;
						7'b01_0_0110	: coeff_m1_ff	<= 9'h016 ;
						7'b01_0_0111	: coeff_m1_ff	<= 9'h015 ;
						7'b01_0_1000	: coeff_m1_ff	<= 9'h013 ;
						7'b01_0_1001	: coeff_m1_ff	<= 9'h012 ;
						7'b01_0_1010	: coeff_m1_ff	<= 9'h011 ;
						7'b01_0_1011	: coeff_m1_ff	<= 9'h010 ;
						7'b01_0_1100	: coeff_m1_ff	<= 9'h00e ;
						7'b01_0_1101	: coeff_m1_ff	<= 9'h00e ;
						7'b01_0_1110	: coeff_m1_ff	<= 9'h00c ;
						7'b01_0_1111	: coeff_m1_ff	<= 9'h00b ;
						7'b01_1_0000	: coeff_m1_ff	<= 9'h00b ;
						7'b01_1_0001	: coeff_m1_ff	<= 9'h00a ;
						7'b01_1_0010	: coeff_m1_ff	<= 9'h009 ;
						7'b01_1_0011	: coeff_m1_ff	<= 9'h008 ;
						7'b01_1_0100	: coeff_m1_ff	<= 9'h008 ;
						7'b01_1_0101	: coeff_m1_ff	<= 9'h007 ;
						7'b01_1_0110	: coeff_m1_ff	<= 9'h006 ;
						7'b01_1_0111	: coeff_m1_ff	<= 9'h006 ;
						7'b01_1_1000	: coeff_m1_ff	<= 9'h005 ;
						7'b01_1_1001	: coeff_m1_ff	<= 9'h005 ;
						7'b01_1_1010	: coeff_m1_ff	<= 9'h004 ;
						7'b01_1_1011	: coeff_m1_ff	<= 9'h004 ;
						7'b01_1_1100	: coeff_m1_ff	<= 9'h004 ;
						7'b01_1_1101	: coeff_m1_ff	<= 9'h004 ;
						7'b01_1_1110	: coeff_m1_ff	<= 9'h003 ;
						7'b01_1_1111	: coeff_m1_ff	<= 9'h003 ;

						7'b10_0_0000	: coeff_m1_ff	<= 9'h021 ;
						7'b10_0_0001	: coeff_m1_ff	<= 9'h020 ;
						7'b10_0_0010	: coeff_m1_ff	<= 9'h020 ;
						7'b10_0_0011	: coeff_m1_ff	<= 9'h01e ;
						7'b10_0_0100	: coeff_m1_ff	<= 9'h01d ;
						7'b10_0_0101	: coeff_m1_ff	<= 9'h01c ;
						7'b10_0_0110	: coeff_m1_ff	<= 9'h01b ;
						7'b10_0_0111	: coeff_m1_ff	<= 9'h01a ;
						7'b10_0_1000	: coeff_m1_ff	<= 9'h019 ;
						7'b10_0_1001	: coeff_m1_ff	<= 9'h018 ;
						7'b10_0_1010	: coeff_m1_ff	<= 9'h017 ;
						7'b10_0_1011	: coeff_m1_ff	<= 9'h016 ;
						7'b10_0_1100	: coeff_m1_ff	<= 9'h015 ;
						7'b10_0_1101	: coeff_m1_ff	<= 9'h014 ;
						7'b10_0_1110	: coeff_m1_ff	<= 9'h014 ;
						7'b10_0_1111	: coeff_m1_ff	<= 9'h013 ;
						7'b10_1_0000	: coeff_m1_ff	<= 9'h012 ;
						7'b10_1_0001	: coeff_m1_ff	<= 9'h011 ;
						7'b10_1_0010	: coeff_m1_ff	<= 9'h011 ;
						7'b10_1_0011	: coeff_m1_ff	<= 9'h010 ;
						7'b10_1_0100	: coeff_m1_ff	<= 9'h00f ;
						7'b10_1_0101	: coeff_m1_ff	<= 9'h00e ;
						7'b10_1_0110	: coeff_m1_ff	<= 9'h00e ;
						7'b10_1_0111	: coeff_m1_ff	<= 9'h00d ;
						7'b10_1_1000	: coeff_m1_ff	<= 9'h00d ;
						7'b10_1_1001	: coeff_m1_ff	<= 9'h00c ;
						7'b10_1_1010	: coeff_m1_ff	<= 9'h00b ;
						7'b10_1_1011	: coeff_m1_ff	<= 9'h00b ;
						7'b10_1_1100	: coeff_m1_ff	<= 9'h00b ;
						7'b10_1_1101	: coeff_m1_ff	<= 9'h00b ;
						7'b10_1_1110	: coeff_m1_ff	<= 9'h00a ;
						7'b10_1_1111	: coeff_m1_ff	<= 9'h00a ;

						7'b11_0_0000	: coeff_m1_ff	<= 9'h022 ;
						7'b11_0_0001	: coeff_m1_ff	<= 9'h021 ;
						7'b11_0_0010	: coeff_m1_ff	<= 9'h021 ;
						7'b11_0_0011	: coeff_m1_ff	<= 9'h020 ;
						7'b11_0_0100	: coeff_m1_ff	<= 9'h020 ;
						7'b11_0_0101	: coeff_m1_ff	<= 9'h01f ;
						7'b11_0_0110	: coeff_m1_ff	<= 9'h01f ;
						7'b11_0_0111	: coeff_m1_ff	<= 9'h01f ;
						7'b11_0_1000	: coeff_m1_ff	<= 9'h01e ;
						7'b11_0_1001	: coeff_m1_ff	<= 9'h01e ;
						7'b11_0_1010	: coeff_m1_ff	<= 9'h01d ;
						7'b11_0_1011	: coeff_m1_ff	<= 9'h01c ;
						7'b11_0_1100	: coeff_m1_ff	<= 9'h01b ;
						7'b11_0_1101	: coeff_m1_ff	<= 9'h01b ;
						7'b11_0_1110	: coeff_m1_ff	<= 9'h01b ;
						7'b11_0_1111	: coeff_m1_ff	<= 9'h01a ;
						7'b11_1_0000	: coeff_m1_ff	<= 9'h01a ;
						7'b11_1_0001	: coeff_m1_ff	<= 9'h01a ;
						7'b11_1_0010	: coeff_m1_ff	<= 9'h01a ;
						7'b11_1_0011	: coeff_m1_ff	<= 9'h019 ;
						7'b11_1_0100	: coeff_m1_ff	<= 9'h019 ;
						7'b11_1_0101	: coeff_m1_ff	<= 9'h018 ;
						7'b11_1_0110	: coeff_m1_ff	<= 9'h018 ;
						7'b11_1_0111	: coeff_m1_ff	<= 9'h017 ;
						7'b11_1_1000	: coeff_m1_ff	<= 9'h017 ;
						7'b11_1_1001	: coeff_m1_ff	<= 9'h016 ;
						7'b11_1_1010	: coeff_m1_ff	<= 9'h016 ;
						7'b11_1_1011	: coeff_m1_ff	<= 9'h016 ;
						7'b11_1_1100	: coeff_m1_ff	<= 9'h015 ;
						7'b11_1_1101	: coeff_m1_ff	<= 9'h015 ;
						7'b11_1_1110	: coeff_m1_ff	<= 9'h014 ;
						7'b11_1_1111	: coeff_m1_ff	<= 9'h014 ;
						default			: coeff_m1_ff	<= {9{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_zr_ff		<= 9'h080 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_zr_ff	<= 9'h066 ;
						7'b00_0_0001	: coeff_zr_ff	<= 9'h065 ;
						7'b00_0_0010	: coeff_zr_ff	<= 9'h065 ;
						7'b00_0_0011	: coeff_zr_ff	<= 9'h064 ;
						7'b00_0_0100	: coeff_zr_ff	<= 9'h062 ;
						7'b00_0_0101	: coeff_zr_ff	<= 9'h061 ;
						7'b00_0_0110	: coeff_zr_ff	<= 9'h05f ;
						7'b00_0_0111	: coeff_zr_ff	<= 9'h05d ;
						7'b00_0_1000	: coeff_zr_ff	<= 9'h05b ;
						7'b00_0_1001	: coeff_zr_ff	<= 9'h058 ;
						7'b00_0_1010	: coeff_zr_ff	<= 9'h055 ;
						7'b00_0_1011	: coeff_zr_ff	<= 9'h051 ;
						7'b00_0_1100	: coeff_zr_ff	<= 9'h04e ;
						7'b00_0_1101	: coeff_zr_ff	<= 9'h04a ;
						7'b00_0_1110	: coeff_zr_ff	<= 9'h046 ;
						7'b00_0_1111	: coeff_zr_ff	<= 9'h042 ;
						7'b00_1_0000	: coeff_zr_ff	<= 9'h03e ;
						7'b00_1_0001	: coeff_zr_ff	<= 9'h03b ;
						7'b00_1_0010	: coeff_zr_ff	<= 9'h037 ;
						7'b00_1_0011	: coeff_zr_ff	<= 9'h033 ;
						7'b00_1_0100	: coeff_zr_ff	<= 9'h02f ;
						7'b00_1_0101	: coeff_zr_ff	<= 9'h02c ;
						7'b00_1_0110	: coeff_zr_ff	<= 9'h028 ;
						7'b00_1_0111	: coeff_zr_ff	<= 9'h025 ;
						7'b00_1_1000	: coeff_zr_ff	<= 9'h022 ;
						7'b00_1_1001	: coeff_zr_ff	<= 9'h01f ;
						7'b00_1_1010	: coeff_zr_ff	<= 9'h01b ;
						7'b00_1_1011	: coeff_zr_ff	<= 9'h018 ;
						7'b00_1_1100	: coeff_zr_ff	<= 9'h016 ;
						7'b00_1_1101	: coeff_zr_ff	<= 9'h013 ;
						7'b00_1_1110	: coeff_zr_ff	<= 9'h011 ;
						7'b00_1_1111	: coeff_zr_ff	<= 9'h00f ;

						7'b01_0_0000	: coeff_zr_ff	<= 9'h041 ;
						7'b01_0_0001	: coeff_zr_ff	<= 9'h041 ;
						7'b01_0_0010	: coeff_zr_ff	<= 9'h041 ;
						7'b01_0_0011	: coeff_zr_ff	<= 9'h040 ;
						7'b01_0_0100	: coeff_zr_ff	<= 9'h040 ;
						7'b01_0_0101	: coeff_zr_ff	<= 9'h040 ;
						7'b01_0_0110	: coeff_zr_ff	<= 9'h03f ;
						7'b01_0_0111	: coeff_zr_ff	<= 9'h03e ;
						7'b01_0_1000	: coeff_zr_ff	<= 9'h03e ;
						7'b01_0_1001	: coeff_zr_ff	<= 9'h03d ;
						7'b01_0_1010	: coeff_zr_ff	<= 9'h03c ;
						7'b01_0_1011	: coeff_zr_ff	<= 9'h03b ;
						7'b01_0_1100	: coeff_zr_ff	<= 9'h03a ;
						7'b01_0_1101	: coeff_zr_ff	<= 9'h039 ;
						7'b01_0_1110	: coeff_zr_ff	<= 9'h038 ;
						7'b01_0_1111	: coeff_zr_ff	<= 9'h037 ;
						7'b01_1_0000	: coeff_zr_ff	<= 9'h035 ;
						7'b01_1_0001	: coeff_zr_ff	<= 9'h034 ;
						7'b01_1_0010	: coeff_zr_ff	<= 9'h033 ;
						7'b01_1_0011	: coeff_zr_ff	<= 9'h031 ;
						7'b01_1_0100	: coeff_zr_ff	<= 9'h030 ;
						7'b01_1_0101	: coeff_zr_ff	<= 9'h02e ;
						7'b01_1_0110	: coeff_zr_ff	<= 9'h02d ;
						7'b01_1_0111	: coeff_zr_ff	<= 9'h02b ;
						7'b01_1_1000	: coeff_zr_ff	<= 9'h02a ;
						7'b01_1_1001	: coeff_zr_ff	<= 9'h028 ;
						7'b01_1_1010	: coeff_zr_ff	<= 9'h027 ;
						7'b01_1_1011	: coeff_zr_ff	<= 9'h025 ;
						7'b01_1_1100	: coeff_zr_ff	<= 9'h024 ;
						7'b01_1_1101	: coeff_zr_ff	<= 9'h022 ;
						7'b01_1_1110	: coeff_zr_ff	<= 9'h021 ;
						7'b01_1_1111	: coeff_zr_ff	<= 9'h01f ;

						7'b10_0_0000	: coeff_zr_ff	<= 9'h035 ;
						7'b10_0_0001	: coeff_zr_ff	<= 9'h035 ;
						7'b10_0_0010	: coeff_zr_ff	<= 9'h034 ;
						7'b10_0_0011	: coeff_zr_ff	<= 9'h034 ;
						7'b10_0_0100	: coeff_zr_ff	<= 9'h034 ;
						7'b10_0_0101	: coeff_zr_ff	<= 9'h034 ;
						7'b10_0_0110	: coeff_zr_ff	<= 9'h034 ;
						7'b10_0_0111	: coeff_zr_ff	<= 9'h033 ;
						7'b10_0_1000	: coeff_zr_ff	<= 9'h032 ;
						7'b10_0_1001	: coeff_zr_ff	<= 9'h032 ;
						7'b10_0_1010	: coeff_zr_ff	<= 9'h031 ;
						7'b10_0_1011	: coeff_zr_ff	<= 9'h031 ;
						7'b10_0_1100	: coeff_zr_ff	<= 9'h031 ;
						7'b10_0_1101	: coeff_zr_ff	<= 9'h030 ;
						7'b10_0_1110	: coeff_zr_ff	<= 9'h02f ;
						7'b10_0_1111	: coeff_zr_ff	<= 9'h02e ;
						7'b10_1_0000	: coeff_zr_ff	<= 9'h02e ;
						7'b10_1_0001	: coeff_zr_ff	<= 9'h02d ;
						7'b10_1_0010	: coeff_zr_ff	<= 9'h02c ;
						7'b10_1_0011	: coeff_zr_ff	<= 9'h02b ;
						7'b10_1_0100	: coeff_zr_ff	<= 9'h02b ;
						7'b10_1_0101	: coeff_zr_ff	<= 9'h02a ;
						7'b10_1_0110	: coeff_zr_ff	<= 9'h029 ;
						7'b10_1_0111	: coeff_zr_ff	<= 9'h028 ;
						7'b10_1_1000	: coeff_zr_ff	<= 9'h027 ;
						7'b10_1_1001	: coeff_zr_ff	<= 9'h027 ;
						7'b10_1_1010	: coeff_zr_ff	<= 9'h026 ;
						7'b10_1_1011	: coeff_zr_ff	<= 9'h025 ;
						7'b10_1_1100	: coeff_zr_ff	<= 9'h024 ;
						7'b10_1_1101	: coeff_zr_ff	<= 9'h023 ;
						7'b10_1_1110	: coeff_zr_ff	<= 9'h022 ;
						7'b10_1_1111	: coeff_zr_ff	<= 9'h021 ;

						7'b11_0_0000	: coeff_zr_ff	<= 9'h029 ;
						7'b11_0_0001	: coeff_zr_ff	<= 9'h029 ;
						7'b11_0_0010	: coeff_zr_ff	<= 9'h029 ;
						7'b11_0_0011	: coeff_zr_ff	<= 9'h028 ;
						7'b11_0_0100	: coeff_zr_ff	<= 9'h028 ;
						7'b11_0_0101	: coeff_zr_ff	<= 9'h028 ;
						7'b11_0_0110	: coeff_zr_ff	<= 9'h028 ;
						7'b11_0_0111	: coeff_zr_ff	<= 9'h027 ;
						7'b11_0_1000	: coeff_zr_ff	<= 9'h027 ;
						7'b11_0_1001	: coeff_zr_ff	<= 9'h027 ;
						7'b11_0_1010	: coeff_zr_ff	<= 9'h027 ;
						7'b11_0_1011	: coeff_zr_ff	<= 9'h027 ;
						7'b11_0_1100	: coeff_zr_ff	<= 9'h027 ;
						7'b11_0_1101	: coeff_zr_ff	<= 9'h027 ;
						7'b11_0_1110	: coeff_zr_ff	<= 9'h026 ;
						7'b11_0_1111	: coeff_zr_ff	<= 9'h026 ;
						7'b11_1_0000	: coeff_zr_ff	<= 9'h026 ;
						7'b11_1_0001	: coeff_zr_ff	<= 9'h026 ;
						7'b11_1_0010	: coeff_zr_ff	<= 9'h025 ;
						7'b11_1_0011	: coeff_zr_ff	<= 9'h025 ;
						7'b11_1_0100	: coeff_zr_ff	<= 9'h025 ;
						7'b11_1_0101	: coeff_zr_ff	<= 9'h025 ;
						7'b11_1_0110	: coeff_zr_ff	<= 9'h024 ;
						7'b11_1_0111	: coeff_zr_ff	<= 9'h024 ;
						7'b11_1_1000	: coeff_zr_ff	<= 9'h024 ;
						7'b11_1_1001	: coeff_zr_ff	<= 9'h023 ;
						7'b11_1_1010	: coeff_zr_ff	<= 9'h023 ;
						7'b11_1_1011	: coeff_zr_ff	<= 9'h023 ;
						7'b11_1_1100	: coeff_zr_ff	<= 9'h022 ;
						7'b11_1_1101	: coeff_zr_ff	<= 9'h022 ;
						7'b11_1_1110	: coeff_zr_ff	<= 9'h022 ;
						7'b11_1_1111	: coeff_zr_ff	<= 9'h022 ;
						default			: coeff_zr_ff	<= {9{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p1_ff		<= 9'h000 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_p1_ff	<= 9'h00d ;
						7'b00_0_0001	: coeff_p1_ff	<= 9'h00f ;
						7'b00_0_0010	: coeff_p1_ff	<= 9'h011 ;
						7'b00_0_0011	: coeff_p1_ff	<= 9'h013 ;
						7'b00_0_0100	: coeff_p1_ff	<= 9'h016 ;
						7'b00_0_0101	: coeff_p1_ff	<= 9'h018 ;
						7'b00_0_0110	: coeff_p1_ff	<= 9'h01b ;
						7'b00_0_0111	: coeff_p1_ff	<= 9'h01e ;
						7'b00_0_1000	: coeff_p1_ff	<= 9'h021 ;
						7'b00_0_1001	: coeff_p1_ff	<= 9'h025 ;
						7'b00_0_1010	: coeff_p1_ff	<= 9'h028 ;
						7'b00_0_1011	: coeff_p1_ff	<= 9'h02c ;
						7'b00_0_1100	: coeff_p1_ff	<= 9'h02f ;
						7'b00_0_1101	: coeff_p1_ff	<= 9'h033 ;
						7'b00_0_1110	: coeff_p1_ff	<= 9'h037 ;
						7'b00_0_1111	: coeff_p1_ff	<= 9'h03b ;
						7'b00_1_0000	: coeff_p1_ff	<= 9'h03e ;
						7'b00_1_0001	: coeff_p1_ff	<= 9'h042 ;
						7'b00_1_0010	: coeff_p1_ff	<= 9'h046 ;
						7'b00_1_0011	: coeff_p1_ff	<= 9'h04a ;
						7'b00_1_0100	: coeff_p1_ff	<= 9'h04e ;
						7'b00_1_0101	: coeff_p1_ff	<= 9'h051 ;
						7'b00_1_0110	: coeff_p1_ff	<= 9'h055 ;
						7'b00_1_0111	: coeff_p1_ff	<= 9'h058 ;
						7'b00_1_1000	: coeff_p1_ff	<= 9'h05a ;
						7'b00_1_1001	: coeff_p1_ff	<= 9'h05c ;
						7'b00_1_1010	: coeff_p1_ff	<= 9'h05f ;
						7'b00_1_1011	: coeff_p1_ff	<= 9'h061 ;
						7'b00_1_1100	: coeff_p1_ff	<= 9'h062 ;
						7'b00_1_1101	: coeff_p1_ff	<= 9'h064 ;
						7'b00_1_1110	: coeff_p1_ff	<= 9'h065 ;
						7'b00_1_1111	: coeff_p1_ff	<= 9'h065 ;

						7'b01_0_0000	: coeff_p1_ff	<= 9'h01e ;
						7'b01_0_0001	: coeff_p1_ff	<= 9'h01f ;
						7'b01_0_0010	: coeff_p1_ff	<= 9'h021 ;
						7'b01_0_0011	: coeff_p1_ff	<= 9'h022 ;
						7'b01_0_0100	: coeff_p1_ff	<= 9'h024 ;
						7'b01_0_0101	: coeff_p1_ff	<= 9'h025 ;
						7'b01_0_0110	: coeff_p1_ff	<= 9'h027 ;
						7'b01_0_0111	: coeff_p1_ff	<= 9'h028 ;
						7'b01_0_1000	: coeff_p1_ff	<= 9'h02a ;
						7'b01_0_1001	: coeff_p1_ff	<= 9'h02b ;
						7'b01_0_1010	: coeff_p1_ff	<= 9'h02d ;
						7'b01_0_1011	: coeff_p1_ff	<= 9'h02e ;
						7'b01_0_1100	: coeff_p1_ff	<= 9'h030 ;
						7'b01_0_1101	: coeff_p1_ff	<= 9'h031 ;
						7'b01_0_1110	: coeff_p1_ff	<= 9'h033 ;
						7'b01_0_1111	: coeff_p1_ff	<= 9'h034 ;
						7'b01_1_0000	: coeff_p1_ff	<= 9'h035 ;
						7'b01_1_0001	: coeff_p1_ff	<= 9'h037 ;
						7'b01_1_0010	: coeff_p1_ff	<= 9'h038 ;
						7'b01_1_0011	: coeff_p1_ff	<= 9'h039 ;
						7'b01_1_0100	: coeff_p1_ff	<= 9'h03a ;
						7'b01_1_0101	: coeff_p1_ff	<= 9'h03b ;
						7'b01_1_0110	: coeff_p1_ff	<= 9'h03c ;
						7'b01_1_0111	: coeff_p1_ff	<= 9'h03d ;
						7'b01_1_1000	: coeff_p1_ff	<= 9'h03e ;
						7'b01_1_1001	: coeff_p1_ff	<= 9'h03e ;
						7'b01_1_1010	: coeff_p1_ff	<= 9'h03f ;
						7'b01_1_1011	: coeff_p1_ff	<= 9'h040 ;
						7'b01_1_1100	: coeff_p1_ff	<= 9'h040 ;
						7'b01_1_1101	: coeff_p1_ff	<= 9'h040 ;
						7'b01_1_1110	: coeff_p1_ff	<= 9'h041 ;
						7'b01_1_1111	: coeff_p1_ff	<= 9'h041 ;

						7'b10_0_0000	: coeff_p1_ff	<= 9'h021 ;
						7'b10_0_0001	: coeff_p1_ff	<= 9'h021 ;
						7'b10_0_0010	: coeff_p1_ff	<= 9'h022 ;
						7'b10_0_0011	: coeff_p1_ff	<= 9'h023 ;
						7'b10_0_0100	: coeff_p1_ff	<= 9'h024 ;
						7'b10_0_0101	: coeff_p1_ff	<= 9'h025 ;
						7'b10_0_0110	: coeff_p1_ff	<= 9'h026 ;
						7'b10_0_0111	: coeff_p1_ff	<= 9'h027 ;
						7'b10_0_1000	: coeff_p1_ff	<= 9'h028 ;
						7'b10_0_1001	: coeff_p1_ff	<= 9'h029 ;
						7'b10_0_1010	: coeff_p1_ff	<= 9'h02a ;
						7'b10_0_1011	: coeff_p1_ff	<= 9'h02b ;
						7'b10_0_1100	: coeff_p1_ff	<= 9'h02b ;
						7'b10_0_1101	: coeff_p1_ff	<= 9'h02c ;
						7'b10_0_1110	: coeff_p1_ff	<= 9'h02c ;
						7'b10_0_1111	: coeff_p1_ff	<= 9'h02e ;
						7'b10_1_0000	: coeff_p1_ff	<= 9'h02e ;
						7'b10_1_0001	: coeff_p1_ff	<= 9'h02f ;
						7'b10_1_0010	: coeff_p1_ff	<= 9'h02f ;
						7'b10_1_0011	: coeff_p1_ff	<= 9'h031 ;
						7'b10_1_0100	: coeff_p1_ff	<= 9'h031 ;
						7'b10_1_0101	: coeff_p1_ff	<= 9'h032 ;
						7'b10_1_0110	: coeff_p1_ff	<= 9'h032 ;
						7'b10_1_0111	: coeff_p1_ff	<= 9'h033 ;
						7'b10_1_1000	: coeff_p1_ff	<= 9'h033 ;
						7'b10_1_1001	: coeff_p1_ff	<= 9'h033 ;
						7'b10_1_1010	: coeff_p1_ff	<= 9'h034 ;
						7'b10_1_1011	: coeff_p1_ff	<= 9'h034 ;
						7'b10_1_1100	: coeff_p1_ff	<= 9'h034 ;
						7'b10_1_1101	: coeff_p1_ff	<= 9'h034 ;
						7'b10_1_1110	: coeff_p1_ff	<= 9'h034 ;
						7'b10_1_1111	: coeff_p1_ff	<= 9'h035 ;

						7'b11_0_0000	: coeff_p1_ff	<= 9'h022 ;
						7'b11_0_0001	: coeff_p1_ff	<= 9'h022 ;
						7'b11_0_0010	: coeff_p1_ff	<= 9'h022 ;
						7'b11_0_0011	: coeff_p1_ff	<= 9'h023 ;
						7'b11_0_0100	: coeff_p1_ff	<= 9'h023 ;
						7'b11_0_0101	: coeff_p1_ff	<= 9'h023 ;
						7'b11_0_0110	: coeff_p1_ff	<= 9'h023 ;
						7'b11_0_0111	: coeff_p1_ff	<= 9'h024 ;
						7'b11_0_1000	: coeff_p1_ff	<= 9'h024 ;
						7'b11_0_1001	: coeff_p1_ff	<= 9'h024 ;
						7'b11_0_1010	: coeff_p1_ff	<= 9'h024 ;
						7'b11_0_1011	: coeff_p1_ff	<= 9'h025 ;
						7'b11_0_1100	: coeff_p1_ff	<= 9'h025 ;
						7'b11_0_1101	: coeff_p1_ff	<= 9'h025 ;
						7'b11_0_1110	: coeff_p1_ff	<= 9'h025 ;
						7'b11_0_1111	: coeff_p1_ff	<= 9'h026 ;
						7'b11_1_0000	: coeff_p1_ff	<= 9'h026 ;
						7'b11_1_0001	: coeff_p1_ff	<= 9'h026 ;
						7'b11_1_0010	: coeff_p1_ff	<= 9'h026 ;
						7'b11_1_0011	: coeff_p1_ff	<= 9'h027 ;
						7'b11_1_0100	: coeff_p1_ff	<= 9'h027 ;
						7'b11_1_0101	: coeff_p1_ff	<= 9'h027 ;
						7'b11_1_0110	: coeff_p1_ff	<= 9'h027 ;
						7'b11_1_0111	: coeff_p1_ff	<= 9'h027 ;
						7'b11_1_1000	: coeff_p1_ff	<= 9'h027 ;
						7'b11_1_1001	: coeff_p1_ff	<= 9'h028 ;
						7'b11_1_1010	: coeff_p1_ff	<= 9'h028 ;
						7'b11_1_1011	: coeff_p1_ff	<= 9'h028 ;
						7'b11_1_1100	: coeff_p1_ff	<= 9'h029 ;
						7'b11_1_1101	: coeff_p1_ff	<= 9'h029 ;
						7'b11_1_1110	: coeff_p1_ff	<= 9'h029 ;
						7'b11_1_1111	: coeff_p1_ff	<= 9'h029 ;
						default			: coeff_p1_ff	<= {9{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p2_ff		<= 9'h000 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_0001	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_0010	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_0011	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_0100	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_0101	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_0110	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_0111	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_1000	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_1001	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_1010	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_1011	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_1100	: coeff_p2_ff	<= 9'h000 ;
						7'b00_0_1101	: coeff_p2_ff	<= 9'h001 ;
						7'b00_0_1110	: coeff_p2_ff	<= 9'h001 ;
						7'b00_0_1111	: coeff_p2_ff	<= 9'h001 ;
						7'b00_1_0000	: coeff_p2_ff	<= 9'h002 ;
						7'b00_1_0001	: coeff_p2_ff	<= 9'h002 ;
						7'b00_1_0010	: coeff_p2_ff	<= 9'h002 ;
						7'b00_1_0011	: coeff_p2_ff	<= 9'h002 ;
						7'b00_1_0100	: coeff_p2_ff	<= 9'h003 ;
						7'b00_1_0101	: coeff_p2_ff	<= 9'h003 ;
						7'b00_1_0110	: coeff_p2_ff	<= 9'h003 ;
						7'b00_1_0111	: coeff_p2_ff	<= 9'h003 ;
						7'b00_1_1000	: coeff_p2_ff	<= 9'h004 ;
						7'b00_1_1001	: coeff_p2_ff	<= 9'h005 ;
						7'b00_1_1010	: coeff_p2_ff	<= 9'h006 ;
						7'b00_1_1011	: coeff_p2_ff	<= 9'h007 ;
						7'b00_1_1100	: coeff_p2_ff	<= 9'h008 ;
						7'b00_1_1101	: coeff_p2_ff	<= 9'h009 ;
						7'b00_1_1110	: coeff_p2_ff	<= 9'h00a ;
						7'b00_1_1111	: coeff_p2_ff	<= 9'h00c ;

						7'b01_0_0000	: coeff_p2_ff	<= 9'h003 ;
						7'b01_0_0001	: coeff_p2_ff	<= 9'h003 ;
						7'b01_0_0010	: coeff_p2_ff	<= 9'h003 ;
						7'b01_0_0011	: coeff_p2_ff	<= 9'h004 ;
						7'b01_0_0100	: coeff_p2_ff	<= 9'h004 ;
						7'b01_0_0101	: coeff_p2_ff	<= 9'h004 ;
						7'b01_0_0110	: coeff_p2_ff	<= 9'h004 ;
						7'b01_0_0111	: coeff_p2_ff	<= 9'h005 ;
						7'b01_0_1000	: coeff_p2_ff	<= 9'h005 ;
						7'b01_0_1001	: coeff_p2_ff	<= 9'h006 ;
						7'b01_0_1010	: coeff_p2_ff	<= 9'h006 ;
						7'b01_0_1011	: coeff_p2_ff	<= 9'h007 ;
						7'b01_0_1100	: coeff_p2_ff	<= 9'h008 ;
						7'b01_0_1101	: coeff_p2_ff	<= 9'h008 ;
						7'b01_0_1110	: coeff_p2_ff	<= 9'h009 ;
						7'b01_0_1111	: coeff_p2_ff	<= 9'h00a ;
						7'b01_1_0000	: coeff_p2_ff	<= 9'h00b ;
						7'b01_1_0001	: coeff_p2_ff	<= 9'h00b ;
						7'b01_1_0010	: coeff_p2_ff	<= 9'h00c ;
						7'b01_1_0011	: coeff_p2_ff	<= 9'h00e ;
						7'b01_1_0100	: coeff_p2_ff	<= 9'h00e ;
						7'b01_1_0101	: coeff_p2_ff	<= 9'h010 ;
						7'b01_1_0110	: coeff_p2_ff	<= 9'h011 ;
						7'b01_1_0111	: coeff_p2_ff	<= 9'h012 ;
						7'b01_1_1000	: coeff_p2_ff	<= 9'h013 ;
						7'b01_1_1001	: coeff_p2_ff	<= 9'h015 ;
						7'b01_1_1010	: coeff_p2_ff	<= 9'h016 ;
						7'b01_1_1011	: coeff_p2_ff	<= 9'h017 ;
						7'b01_1_1100	: coeff_p2_ff	<= 9'h018 ;
						7'b01_1_1101	: coeff_p2_ff	<= 9'h01a ;
						7'b01_1_1110	: coeff_p2_ff	<= 9'h01b ;
						7'b01_1_1111	: coeff_p2_ff	<= 9'h01d ;

						7'b10_0_0000	: coeff_p2_ff	<= 9'h009 ;
						7'b10_0_0001	: coeff_p2_ff	<= 9'h00a ;
						7'b10_0_0010	: coeff_p2_ff	<= 9'h00a ;
						7'b10_0_0011	: coeff_p2_ff	<= 9'h00b ;
						7'b10_0_0100	: coeff_p2_ff	<= 9'h00b ;
						7'b10_0_0101	: coeff_p2_ff	<= 9'h00b ;
						7'b10_0_0110	: coeff_p2_ff	<= 9'h00b ;
						7'b10_0_0111	: coeff_p2_ff	<= 9'h00c ;
						7'b10_0_1000	: coeff_p2_ff	<= 9'h00d ;
						7'b10_0_1001	: coeff_p2_ff	<= 9'h00d ;
						7'b10_0_1010	: coeff_p2_ff	<= 9'h00e ;
						7'b10_0_1011	: coeff_p2_ff	<= 9'h00e ;
						7'b10_0_1100	: coeff_p2_ff	<= 9'h00f ;
						7'b10_0_1101	: coeff_p2_ff	<= 9'h010 ;
						7'b10_0_1110	: coeff_p2_ff	<= 9'h011 ;
						7'b10_0_1111	: coeff_p2_ff	<= 9'h011 ;
						7'b10_1_0000	: coeff_p2_ff	<= 9'h012 ;
						7'b10_1_0001	: coeff_p2_ff	<= 9'h013 ;
						7'b10_1_0010	: coeff_p2_ff	<= 9'h014 ;
						7'b10_1_0011	: coeff_p2_ff	<= 9'h014 ;
						7'b10_1_0100	: coeff_p2_ff	<= 9'h015 ;
						7'b10_1_0101	: coeff_p2_ff	<= 9'h016 ;
						7'b10_1_0110	: coeff_p2_ff	<= 9'h017 ;
						7'b10_1_0111	: coeff_p2_ff	<= 9'h018 ;
						7'b10_1_1000	: coeff_p2_ff	<= 9'h019 ;
						7'b10_1_1001	: coeff_p2_ff	<= 9'h01a ;
						7'b10_1_1010	: coeff_p2_ff	<= 9'h01b ;
						7'b10_1_1011	: coeff_p2_ff	<= 9'h01c ;
						7'b10_1_1100	: coeff_p2_ff	<= 9'h01d ;
						7'b10_1_1101	: coeff_p2_ff	<= 9'h01e ;
						7'b10_1_1110	: coeff_p2_ff	<= 9'h020 ;
						7'b10_1_1111	: coeff_p2_ff	<= 9'h020 ;

						7'b11_0_0000	: coeff_p2_ff	<= 9'h013 ;
						7'b11_0_0001	: coeff_p2_ff	<= 9'h014 ;
						7'b11_0_0010	: coeff_p2_ff	<= 9'h014 ;
						7'b11_0_0011	: coeff_p2_ff	<= 9'h015 ;
						7'b11_0_0100	: coeff_p2_ff	<= 9'h015 ;
						7'b11_0_0101	: coeff_p2_ff	<= 9'h016 ;
						7'b11_0_0110	: coeff_p2_ff	<= 9'h016 ;
						7'b11_0_0111	: coeff_p2_ff	<= 9'h016 ;
						7'b11_0_1000	: coeff_p2_ff	<= 9'h017 ;
						7'b11_0_1001	: coeff_p2_ff	<= 9'h017 ;
						7'b11_0_1010	: coeff_p2_ff	<= 9'h018 ;
						7'b11_0_1011	: coeff_p2_ff	<= 9'h018 ;
						7'b11_0_1100	: coeff_p2_ff	<= 9'h019 ;
						7'b11_0_1101	: coeff_p2_ff	<= 9'h019 ;
						7'b11_0_1110	: coeff_p2_ff	<= 9'h01a ;
						7'b11_0_1111	: coeff_p2_ff	<= 9'h01a ;
						7'b11_1_0000	: coeff_p2_ff	<= 9'h01a ;
						7'b11_1_0001	: coeff_p2_ff	<= 9'h01a ;
						7'b11_1_0010	: coeff_p2_ff	<= 9'h01b ;
						7'b11_1_0011	: coeff_p2_ff	<= 9'h01b ;
						7'b11_1_0100	: coeff_p2_ff	<= 9'h01b ;
						7'b11_1_0101	: coeff_p2_ff	<= 9'h01c ;
						7'b11_1_0110	: coeff_p2_ff	<= 9'h01d ;
						7'b11_1_0111	: coeff_p2_ff	<= 9'h01e ;
						7'b11_1_1000	: coeff_p2_ff	<= 9'h01e ;
						7'b11_1_1001	: coeff_p2_ff	<= 9'h01f ;
						7'b11_1_1010	: coeff_p2_ff	<= 9'h01f ;
						7'b11_1_1011	: coeff_p2_ff	<= 9'h01f ;
						7'b11_1_1100	: coeff_p2_ff	<= 9'h020 ;
						7'b11_1_1101	: coeff_p2_ff	<= 9'h020 ;
						7'b11_1_1110	: coeff_p2_ff	<= 9'h021 ;
						7'b11_1_1111	: coeff_p2_ff	<= 9'h021 ;
						default			: coeff_p2_ff	<= {9{1'bx}} ;
					endcase
				end
			end
		end
		else if ( Q_BIT == 10 ) begin : table_10bit
			//-------------------- Table Value Format -----------------------//
			//	 { Sign(1bit), Integral Part(1bit), Fraction Part(9bit) }	 //
			//---------------------------------------------------------------//
			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_m1_ff		<= 11'h000 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_m1_ff	<= 11'h036 ;
						7'b00_0_0001	: coeff_m1_ff	<= 11'h030 ;
						7'b00_0_0010	: coeff_m1_ff	<= 11'h02a ;
						7'b00_0_0011	: coeff_m1_ff	<= 11'h024 ;
						7'b00_0_0100	: coeff_m1_ff	<= 11'h020 ;
						7'b00_0_0101	: coeff_m1_ff	<= 11'h01c ;
						7'b00_0_0110	: coeff_m1_ff	<= 11'h019 ;
						7'b00_0_0111	: coeff_m1_ff	<= 11'h016 ;
						7'b00_0_1000	: coeff_m1_ff	<= 11'h013 ;
						7'b00_0_1001	: coeff_m1_ff	<= 11'h011 ;
						7'b00_0_1010	: coeff_m1_ff	<= 11'h00f ;
						7'b00_0_1011	: coeff_m1_ff	<= 11'h00d ;
						7'b00_0_1100	: coeff_m1_ff	<= 11'h00c ;
						7'b00_0_1101	: coeff_m1_ff	<= 11'h00b ;
						7'b00_0_1110	: coeff_m1_ff	<= 11'h00a ;
						7'b00_0_1111	: coeff_m1_ff	<= 11'h009 ;
						7'b00_1_0000	: coeff_m1_ff	<= 11'h008 ;
						7'b00_1_0001	: coeff_m1_ff	<= 11'h007 ;
						7'b00_1_0010	: coeff_m1_ff	<= 11'h007 ;
						7'b00_1_0011	: coeff_m1_ff	<= 11'h006 ;
						7'b00_1_0100	: coeff_m1_ff	<= 11'h005 ;
						7'b00_1_0101	: coeff_m1_ff	<= 11'h004 ;
						7'b00_1_0110	: coeff_m1_ff	<= 11'h004 ;
						7'b00_1_0111	: coeff_m1_ff	<= 11'h003 ;
						7'b00_1_1000	: coeff_m1_ff	<= 11'h002 ;
						7'b00_1_1001	: coeff_m1_ff	<= 11'h002 ;
						7'b00_1_1010	: coeff_m1_ff	<= 11'h002 ;
						7'b00_1_1011	: coeff_m1_ff	<= 11'h000 ;
						7'b00_1_1100	: coeff_m1_ff	<= 11'h000 ;
						7'b00_1_1101	: coeff_m1_ff	<= 11'h000 ;
						7'b00_1_1110	: coeff_m1_ff	<= 11'h000 ;
						7'b00_1_1111	: coeff_m1_ff	<= 11'h000 ;

						7'b01_0_0000	: coeff_m1_ff	<= 11'h078 ;
						7'b01_0_0001	: coeff_m1_ff	<= 11'h072 ;
						7'b01_0_0010	: coeff_m1_ff	<= 11'h06c ;
						7'b01_0_0011	: coeff_m1_ff	<= 11'h067 ;
						7'b01_0_0100	: coeff_m1_ff	<= 11'h061 ;
						7'b01_0_0101	: coeff_m1_ff	<= 11'h05c ;
						7'b01_0_0110	: coeff_m1_ff	<= 11'h056 ;
						7'b01_0_0111	: coeff_m1_ff	<= 11'h051 ;
						7'b01_0_1000	: coeff_m1_ff	<= 11'h04d ;
						7'b01_0_1001	: coeff_m1_ff	<= 11'h048 ;
						7'b01_0_1010	: coeff_m1_ff	<= 11'h044 ;
						7'b01_0_1011	: coeff_m1_ff	<= 11'h040 ;
						7'b01_0_1100	: coeff_m1_ff	<= 11'h03c ;
						7'b01_0_1101	: coeff_m1_ff	<= 11'h038 ;
						7'b01_0_1110	: coeff_m1_ff	<= 11'h034 ;
						7'b01_0_1111	: coeff_m1_ff	<= 11'h031 ;
						7'b01_1_0000	: coeff_m1_ff	<= 11'h02d ;
						7'b01_1_0001	: coeff_m1_ff	<= 11'h02a ;
						7'b01_1_0010	: coeff_m1_ff	<= 11'h027 ;
						7'b01_1_0011	: coeff_m1_ff	<= 11'h025 ;
						7'b01_1_0100	: coeff_m1_ff	<= 11'h022 ;
						7'b01_1_0101	: coeff_m1_ff	<= 11'h01f ;
						7'b01_1_0110	: coeff_m1_ff	<= 11'h01d ;
						7'b01_1_0111	: coeff_m1_ff	<= 11'h01b ;
						7'b01_1_1000	: coeff_m1_ff	<= 11'h019 ;
						7'b01_1_1001	: coeff_m1_ff	<= 11'h018 ;
						7'b01_1_1010	: coeff_m1_ff	<= 11'h016 ;
						7'b01_1_1011	: coeff_m1_ff	<= 11'h014 ;
						7'b01_1_1100	: coeff_m1_ff	<= 11'h013 ;
						7'b01_1_1101	: coeff_m1_ff	<= 11'h011 ;
						7'b01_1_1110	: coeff_m1_ff	<= 11'h010 ;
						7'b01_1_1111	: coeff_m1_ff	<= 11'h00f ;

						7'b10_0_0000	: coeff_m1_ff	<= 11'h084 ;
						7'b10_0_0001	: coeff_m1_ff	<= 11'h080 ;
						7'b10_0_0010	: coeff_m1_ff	<= 11'h07c ;
						7'b10_0_0011	: coeff_m1_ff	<= 11'h077 ;
						7'b10_0_0100	: coeff_m1_ff	<= 11'h073 ;
						7'b10_0_0101	: coeff_m1_ff	<= 11'h06f ;
						7'b10_0_0110	: coeff_m1_ff	<= 11'h06b ;
						7'b10_0_0111	: coeff_m1_ff	<= 11'h067 ;
						7'b10_0_1000	: coeff_m1_ff	<= 11'h063 ;
						7'b10_0_1001	: coeff_m1_ff	<= 11'h05f ;
						7'b10_0_1010	: coeff_m1_ff	<= 11'h05c ;
						7'b10_0_1011	: coeff_m1_ff	<= 11'h058 ;
						7'b10_0_1100	: coeff_m1_ff	<= 11'h054 ;
						7'b10_0_1101	: coeff_m1_ff	<= 11'h050 ;
						7'b10_0_1110	: coeff_m1_ff	<= 11'h04d ;
						7'b10_0_1111	: coeff_m1_ff	<= 11'h04a ;
						7'b10_1_0000	: coeff_m1_ff	<= 11'h047 ;
						7'b10_1_0001	: coeff_m1_ff	<= 11'h045 ;
						7'b10_1_0010	: coeff_m1_ff	<= 11'h042 ;
						7'b10_1_0011	: coeff_m1_ff	<= 11'h03f ;
						7'b10_1_0100	: coeff_m1_ff	<= 11'h03c ;
						7'b10_1_0101	: coeff_m1_ff	<= 11'h039 ;
						7'b10_1_0110	: coeff_m1_ff	<= 11'h037 ;
						7'b10_1_0111	: coeff_m1_ff	<= 11'h034 ;
						7'b10_1_1000	: coeff_m1_ff	<= 11'h032 ;
						7'b10_1_1001	: coeff_m1_ff	<= 11'h030 ;
						7'b10_1_1010	: coeff_m1_ff	<= 11'h02e ;
						7'b10_1_1011	: coeff_m1_ff	<= 11'h02c ;
						7'b10_1_1100	: coeff_m1_ff	<= 11'h02a ;
						7'b10_1_1101	: coeff_m1_ff	<= 11'h029 ;
						7'b10_1_1110	: coeff_m1_ff	<= 11'h027 ;
						7'b10_1_1111	: coeff_m1_ff	<= 11'h025 ;

						7'b11_0_0000	: coeff_m1_ff	<= 11'h087 ;
						7'b11_0_0001	: coeff_m1_ff	<= 11'h085 ;
						7'b11_0_0010	: coeff_m1_ff	<= 11'h082 ;
						7'b11_0_0011	: coeff_m1_ff	<= 11'h081 ;
						7'b11_0_0100	: coeff_m1_ff	<= 11'h07f ;
						7'b11_0_0101	: coeff_m1_ff	<= 11'h07d ;
						7'b11_0_0110	: coeff_m1_ff	<= 11'h07b ;
						7'b11_0_0111	: coeff_m1_ff	<= 11'h079 ;
						7'b11_0_1000	: coeff_m1_ff	<= 11'h078 ;
						7'b11_0_1001	: coeff_m1_ff	<= 11'h076 ;
						7'b11_0_1010	: coeff_m1_ff	<= 11'h073 ;
						7'b11_0_1011	: coeff_m1_ff	<= 11'h072 ;
						7'b11_0_1100	: coeff_m1_ff	<= 11'h070 ;
						7'b11_0_1101	: coeff_m1_ff	<= 11'h06e ;
						7'b11_0_1110	: coeff_m1_ff	<= 11'h06d ;
						7'b11_0_1111	: coeff_m1_ff	<= 11'h06b ;
						7'b11_1_0000	: coeff_m1_ff	<= 11'h069 ;
						7'b11_1_0001	: coeff_m1_ff	<= 11'h067 ;
						7'b11_1_0010	: coeff_m1_ff	<= 11'h066 ;
						7'b11_1_0011	: coeff_m1_ff	<= 11'h064 ;
						7'b11_1_0100	: coeff_m1_ff	<= 11'h063 ;
						7'b11_1_0101	: coeff_m1_ff	<= 11'h061 ;
						7'b11_1_0110	: coeff_m1_ff	<= 11'h060 ;
						7'b11_1_0111	: coeff_m1_ff	<= 11'h05e ;
						7'b11_1_1000	: coeff_m1_ff	<= 11'h05c ;
						7'b11_1_1001	: coeff_m1_ff	<= 11'h05b ;
						7'b11_1_1010	: coeff_m1_ff	<= 11'h059 ;
						7'b11_1_1011	: coeff_m1_ff	<= 11'h058 ;
						7'b11_1_1100	: coeff_m1_ff	<= 11'h057 ;
						7'b11_1_1101	: coeff_m1_ff	<= 11'h055 ;
						7'b11_1_1110	: coeff_m1_ff	<= 11'h054 ;
						7'b11_1_1111	: coeff_m1_ff	<= 11'h053 ;
						default			: coeff_m1_ff	<= {11{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_zr_ff		<= 11'h200 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_zr_ff	<= 11'h194 ;
						7'b00_0_0001	: coeff_zr_ff	<= 11'h193 ;
						7'b00_0_0010	: coeff_zr_ff	<= 11'h191 ;
						7'b00_0_0011	: coeff_zr_ff	<= 11'h18e ;
						7'b00_0_0100	: coeff_zr_ff	<= 11'h188 ;
						7'b00_0_0101	: coeff_zr_ff	<= 11'h182 ;
						7'b00_0_0110	: coeff_zr_ff	<= 11'h179 ;
						7'b00_0_0111	: coeff_zr_ff	<= 11'h170 ;
						7'b00_0_1000	: coeff_zr_ff	<= 11'h166 ;
						7'b00_0_1001	: coeff_zr_ff	<= 11'h15b ;
						7'b00_0_1010	: coeff_zr_ff	<= 11'h14e ;
						7'b00_0_1011	: coeff_zr_ff	<= 11'h142 ;
						7'b00_0_1100	: coeff_zr_ff	<= 11'h133 ;
						7'b00_0_1101	: coeff_zr_ff	<= 11'h125 ;
						7'b00_0_1110	: coeff_zr_ff	<= 11'h116 ;
						7'b00_0_1111	: coeff_zr_ff	<= 11'h107 ;
						7'b00_1_0000	: coeff_zr_ff	<= 11'h0f8 ;
						7'b00_1_0001	: coeff_zr_ff	<= 11'h0e8 ;
						7'b00_1_0010	: coeff_zr_ff	<= 11'h0d9 ;
						7'b00_1_0011	: coeff_zr_ff	<= 11'h0ca ;
						7'b00_1_0100	: coeff_zr_ff	<= 11'h0bb ;
						7'b00_1_0101	: coeff_zr_ff	<= 11'h0ad ;
						7'b00_1_0110	: coeff_zr_ff	<= 11'h09f ;
						7'b00_1_0111	: coeff_zr_ff	<= 11'h091 ;
						7'b00_1_1000	: coeff_zr_ff	<= 11'h085 ;
						7'b00_1_1001	: coeff_zr_ff	<= 11'h078 ;
						7'b00_1_1010	: coeff_zr_ff	<= 11'h06c ;
						7'b00_1_1011	: coeff_zr_ff	<= 11'h062 ;
						7'b00_1_1100	: coeff_zr_ff	<= 11'h058 ;
						7'b00_1_1101	: coeff_zr_ff	<= 11'h04f ;
						7'b00_1_1110	: coeff_zr_ff	<= 11'h045 ;
						7'b00_1_1111	: coeff_zr_ff	<= 11'h03d ;

						7'b01_0_0000	: coeff_zr_ff	<= 11'h102 ;
						7'b01_0_0001	: coeff_zr_ff	<= 11'h102 ;
						7'b01_0_0010	: coeff_zr_ff	<= 11'h101 ;
						7'b01_0_0011	: coeff_zr_ff	<= 11'h0ff ;
						7'b01_0_0100	: coeff_zr_ff	<= 11'h0fe ;
						7'b01_0_0101	: coeff_zr_ff	<= 11'h0fc ;
						7'b01_0_0110	: coeff_zr_ff	<= 11'h0fa ;
						7'b01_0_0111	: coeff_zr_ff	<= 11'h0f7 ;
						7'b01_0_1000	: coeff_zr_ff	<= 11'h0f4 ;
						7'b01_0_1001	: coeff_zr_ff	<= 11'h0f1 ;
						7'b01_0_1010	: coeff_zr_ff	<= 11'h0ed ;
						7'b01_0_1011	: coeff_zr_ff	<= 11'h0e9 ;
						7'b01_0_1100	: coeff_zr_ff	<= 11'h0e5 ;
						7'b01_0_1101	: coeff_zr_ff	<= 11'h0e1 ;
						7'b01_0_1110	: coeff_zr_ff	<= 11'h0dc ;
						7'b01_0_1111	: coeff_zr_ff	<= 11'h0d8 ;
						7'b01_1_0000	: coeff_zr_ff	<= 11'h0d3 ;
						7'b01_1_0001	: coeff_zr_ff	<= 11'h0cd ;
						7'b01_1_0010	: coeff_zr_ff	<= 11'h0c8 ;
						7'b01_1_0011	: coeff_zr_ff	<= 11'h0c2 ;
						7'b01_1_0100	: coeff_zr_ff	<= 11'h0bd ;
						7'b01_1_0101	: coeff_zr_ff	<= 11'h0b7 ;
						7'b01_1_0110	: coeff_zr_ff	<= 11'h0b1 ;
						7'b01_1_0111	: coeff_zr_ff	<= 11'h0ab ;
						7'b01_1_1000	: coeff_zr_ff	<= 11'h0a5 ;
						7'b01_1_1001	: coeff_zr_ff	<= 11'h0a0 ;
						7'b01_1_1010	: coeff_zr_ff	<= 11'h09a ;
						7'b01_1_1011	: coeff_zr_ff	<= 11'h094 ;
						7'b01_1_1100	: coeff_zr_ff	<= 11'h08e ;
						7'b01_1_1101	: coeff_zr_ff	<= 11'h088 ;
						7'b01_1_1110	: coeff_zr_ff	<= 11'h083 ;
						7'b01_1_1111	: coeff_zr_ff	<= 11'h07d ;

						7'b10_0_0000	: coeff_zr_ff	<= 11'h0d4 ;
						7'b10_0_0001	: coeff_zr_ff	<= 11'h0d4 ;
						7'b10_0_0010	: coeff_zr_ff	<= 11'h0d2 ;
						7'b10_0_0011	: coeff_zr_ff	<= 11'h0d2 ;
						7'b10_0_0100	: coeff_zr_ff	<= 11'h0d1 ;
						7'b10_0_0101	: coeff_zr_ff	<= 11'h0cf ;
						7'b10_0_0110	: coeff_zr_ff	<= 11'h0ce ;
						7'b10_0_0111	: coeff_zr_ff	<= 11'h0cd ;
						7'b10_0_1000	: coeff_zr_ff	<= 11'h0cb ;
						7'b10_0_1001	: coeff_zr_ff	<= 11'h0ca ;
						7'b10_0_1010	: coeff_zr_ff	<= 11'h0c7 ;
						7'b10_0_1011	: coeff_zr_ff	<= 11'h0c5 ;
						7'b10_0_1100	: coeff_zr_ff	<= 11'h0c3 ;
						7'b10_0_1101	: coeff_zr_ff	<= 11'h0c1 ;
						7'b10_0_1110	: coeff_zr_ff	<= 11'h0be ;
						7'b10_0_1111	: coeff_zr_ff	<= 11'h0bb ;
						7'b10_1_0000	: coeff_zr_ff	<= 11'h0b9 ;
						7'b10_1_0001	: coeff_zr_ff	<= 11'h0b6 ;
						7'b10_1_0010	: coeff_zr_ff	<= 11'h0b3 ;
						7'b10_1_0011	: coeff_zr_ff	<= 11'h0b0 ;
						7'b10_1_0100	: coeff_zr_ff	<= 11'h0ad ;
						7'b10_1_0101	: coeff_zr_ff	<= 11'h0a9 ;
						7'b10_1_0110	: coeff_zr_ff	<= 11'h0a6 ;
						7'b10_1_0111	: coeff_zr_ff	<= 11'h0a3 ;
						7'b10_1_1000	: coeff_zr_ff	<= 11'h0a0 ;
						7'b10_1_1001	: coeff_zr_ff	<= 11'h09c ;
						7'b10_1_1010	: coeff_zr_ff	<= 11'h098 ;
						7'b10_1_1011	: coeff_zr_ff	<= 11'h095 ;
						7'b10_1_1100	: coeff_zr_ff	<= 11'h092 ;
						7'b10_1_1101	: coeff_zr_ff	<= 11'h08e ;
						7'b10_1_1110	: coeff_zr_ff	<= 11'h08a ;
						7'b10_1_1111	: coeff_zr_ff	<= 11'h087 ;

						7'b11_0_0000	: coeff_zr_ff	<= 11'h0a1 ;
						7'b11_0_0001	: coeff_zr_ff	<= 11'h0a1 ;
						7'b11_0_0010	: coeff_zr_ff	<= 11'h0a1 ;
						7'b11_0_0011	: coeff_zr_ff	<= 11'h0a0 ;
						7'b11_0_0100	: coeff_zr_ff	<= 11'h09f ;
						7'b11_0_0101	: coeff_zr_ff	<= 11'h09f ;
						7'b11_0_0110	: coeff_zr_ff	<= 11'h09f ;
						7'b11_0_0111	: coeff_zr_ff	<= 11'h09e ;
						7'b11_0_1000	: coeff_zr_ff	<= 11'h09d ;
						7'b11_0_1001	: coeff_zr_ff	<= 11'h09c ;
						7'b11_0_1010	: coeff_zr_ff	<= 11'h09c ;
						7'b11_0_1011	: coeff_zr_ff	<= 11'h09b ;
						7'b11_0_1100	: coeff_zr_ff	<= 11'h09a ;
						7'b11_0_1101	: coeff_zr_ff	<= 11'h09a ;
						7'b11_0_1110	: coeff_zr_ff	<= 11'h098 ;
						7'b11_0_1111	: coeff_zr_ff	<= 11'h098 ;
						7'b11_1_0000	: coeff_zr_ff	<= 11'h097 ;
						7'b11_1_0001	: coeff_zr_ff	<= 11'h096 ;
						7'b11_1_0010	: coeff_zr_ff	<= 11'h094 ;
						7'b11_1_0011	: coeff_zr_ff	<= 11'h094 ;
						7'b11_1_0100	: coeff_zr_ff	<= 11'h093 ;
						7'b11_1_0101	: coeff_zr_ff	<= 11'h092 ;
						7'b11_1_0110	: coeff_zr_ff	<= 11'h091 ;
						7'b11_1_0111	: coeff_zr_ff	<= 11'h090 ;
						7'b11_1_1000	: coeff_zr_ff	<= 11'h08f ;
						7'b11_1_1001	: coeff_zr_ff	<= 11'h08e ;
						7'b11_1_1010	: coeff_zr_ff	<= 11'h08d ;
						7'b11_1_1011	: coeff_zr_ff	<= 11'h08c ;
						7'b11_1_1100	: coeff_zr_ff	<= 11'h08a ;
						7'b11_1_1101	: coeff_zr_ff	<= 11'h08a ;
						7'b11_1_1110	: coeff_zr_ff	<= 11'h089 ;
						7'b11_1_1111	: coeff_zr_ff	<= 11'h087 ;
						default			: coeff_zr_ff	<= {11{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p1_ff		<= 11'h000 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_p1_ff	<= 11'h036 ;
						7'b00_0_0001	: coeff_p1_ff	<= 11'h03d ;
						7'b00_0_0010	: coeff_p1_ff	<= 11'h045 ;
						7'b00_0_0011	: coeff_p1_ff	<= 11'h04e ;
						7'b00_0_0100	: coeff_p1_ff	<= 11'h058 ;
						7'b00_0_0101	: coeff_p1_ff	<= 11'h062 ;
						7'b00_0_0110	: coeff_p1_ff	<= 11'h06c ;
						7'b00_0_0111	: coeff_p1_ff	<= 11'h078 ;
						7'b00_0_1000	: coeff_p1_ff	<= 11'h085 ;
						7'b00_0_1001	: coeff_p1_ff	<= 11'h091 ;
						7'b00_0_1010	: coeff_p1_ff	<= 11'h09f ;
						7'b00_0_1011	: coeff_p1_ff	<= 11'h0ad ;
						7'b00_0_1100	: coeff_p1_ff	<= 11'h0bc ;
						7'b00_0_1101	: coeff_p1_ff	<= 11'h0ca ;
						7'b00_0_1110	: coeff_p1_ff	<= 11'h0d9 ;
						7'b00_0_1111	: coeff_p1_ff	<= 11'h0e9 ;
						7'b00_1_0000	: coeff_p1_ff	<= 11'h0f8 ;
						7'b00_1_0001	: coeff_p1_ff	<= 11'h108 ;
						7'b00_1_0010	: coeff_p1_ff	<= 11'h116 ;
						7'b00_1_0011	: coeff_p1_ff	<= 11'h125 ;
						7'b00_1_0100	: coeff_p1_ff	<= 11'h134 ;
						7'b00_1_0101	: coeff_p1_ff	<= 11'h142 ;
						7'b00_1_0110	: coeff_p1_ff	<= 11'h14e ;
						7'b00_1_0111	: coeff_p1_ff	<= 11'h15b ;
						7'b00_1_1000	: coeff_p1_ff	<= 11'h166 ;
						7'b00_1_1001	: coeff_p1_ff	<= 11'h170 ;
						7'b00_1_1010	: coeff_p1_ff	<= 11'h179 ;
						7'b00_1_1011	: coeff_p1_ff	<= 11'h182 ;
						7'b00_1_1100	: coeff_p1_ff	<= 11'h188 ;
						7'b00_1_1101	: coeff_p1_ff	<= 11'h18d ;
						7'b00_1_1110	: coeff_p1_ff	<= 11'h191 ;
						7'b00_1_1111	: coeff_p1_ff	<= 11'h193 ;

						7'b01_0_0000	: coeff_p1_ff	<= 11'h077 ;
						7'b01_0_0001	: coeff_p1_ff	<= 11'h07d ;
						7'b01_0_0010	: coeff_p1_ff	<= 11'h083 ;
						7'b01_0_0011	: coeff_p1_ff	<= 11'h089 ;
						7'b01_0_0100	: coeff_p1_ff	<= 11'h08e ;
						7'b01_0_0101	: coeff_p1_ff	<= 11'h094 ;
						7'b01_0_0110	: coeff_p1_ff	<= 11'h09a ;
						7'b01_0_0111	: coeff_p1_ff	<= 11'h0a0 ;
						7'b01_0_1000	: coeff_p1_ff	<= 11'h0a6 ;
						7'b01_0_1001	: coeff_p1_ff	<= 11'h0ac ;
						7'b01_0_1010	: coeff_p1_ff	<= 11'h0b2 ;
						7'b01_0_1011	: coeff_p1_ff	<= 11'h0b8 ;
						7'b01_0_1100	: coeff_p1_ff	<= 11'h0bd ;
						7'b01_0_1101	: coeff_p1_ff	<= 11'h0c2 ;
						7'b01_0_1110	: coeff_p1_ff	<= 11'h0c9 ;
						7'b01_0_1111	: coeff_p1_ff	<= 11'h0cd ;
						7'b01_1_0000	: coeff_p1_ff	<= 11'h0d3 ;
						7'b01_1_0001	: coeff_p1_ff	<= 11'h0d8 ;
						7'b01_1_0010	: coeff_p1_ff	<= 11'h0dd ;
						7'b01_1_0011	: coeff_p1_ff	<= 11'h0e1 ;
						7'b01_1_0100	: coeff_p1_ff	<= 11'h0e5 ;
						7'b01_1_0101	: coeff_p1_ff	<= 11'h0ea ;
						7'b01_1_0110	: coeff_p1_ff	<= 11'h0ee ;
						7'b01_1_0111	: coeff_p1_ff	<= 11'h0f2 ;
						7'b01_1_1000	: coeff_p1_ff	<= 11'h0f5 ;
						7'b01_1_1001	: coeff_p1_ff	<= 11'h0f7 ;
						7'b01_1_1010	: coeff_p1_ff	<= 11'h0fa ;
						7'b01_1_1011	: coeff_p1_ff	<= 11'h0fc ;
						7'b01_1_1100	: coeff_p1_ff	<= 11'h0fe ;
						7'b01_1_1101	: coeff_p1_ff	<= 11'h100 ;
						7'b01_1_1110	: coeff_p1_ff	<= 11'h101 ;
						7'b01_1_1111	: coeff_p1_ff	<= 11'h102 ;

						7'b10_0_0000	: coeff_p1_ff	<= 11'h084 ;
						7'b10_0_0001	: coeff_p1_ff	<= 11'h087 ;
						7'b10_0_0010	: coeff_p1_ff	<= 11'h08b ;
						7'b10_0_0011	: coeff_p1_ff	<= 11'h08e ;
						7'b10_0_0100	: coeff_p1_ff	<= 11'h092 ;
						7'b10_0_0101	: coeff_p1_ff	<= 11'h096 ;
						7'b10_0_0110	: coeff_p1_ff	<= 11'h099 ;
						7'b10_0_0111	: coeff_p1_ff	<= 11'h09c ;
						7'b10_0_1000	: coeff_p1_ff	<= 11'h0a0 ;
						7'b10_0_1001	: coeff_p1_ff	<= 11'h0a3 ;
						7'b10_0_1010	: coeff_p1_ff	<= 11'h0a6 ;
						7'b10_0_1011	: coeff_p1_ff	<= 11'h0aa ;
						7'b10_0_1100	: coeff_p1_ff	<= 11'h0ad ;
						7'b10_0_1101	: coeff_p1_ff	<= 11'h0b0 ;
						7'b10_0_1110	: coeff_p1_ff	<= 11'h0b3 ;
						7'b10_0_1111	: coeff_p1_ff	<= 11'h0b6 ;
						7'b10_1_0000	: coeff_p1_ff	<= 11'h0b9 ;
						7'b10_1_0001	: coeff_p1_ff	<= 11'h0bb ;
						7'b10_1_0010	: coeff_p1_ff	<= 11'h0be ;
						7'b10_1_0011	: coeff_p1_ff	<= 11'h0c1 ;
						7'b10_1_0100	: coeff_p1_ff	<= 11'h0c3 ;
						7'b10_1_0101	: coeff_p1_ff	<= 11'h0c6 ;
						7'b10_1_0110	: coeff_p1_ff	<= 11'h0c7 ;
						7'b10_1_0111	: coeff_p1_ff	<= 11'h0ca ;
						7'b10_1_1000	: coeff_p1_ff	<= 11'h0cb ;
						7'b10_1_1001	: coeff_p1_ff	<= 11'h0cd ;
						7'b10_1_1010	: coeff_p1_ff	<= 11'h0cf ;
						7'b10_1_1011	: coeff_p1_ff	<= 11'h0d0 ;
						7'b10_1_1100	: coeff_p1_ff	<= 11'h0d1 ;
						7'b10_1_1101	: coeff_p1_ff	<= 11'h0d2 ;
						7'b10_1_1110	: coeff_p1_ff	<= 11'h0d3 ;
						7'b10_1_1111	: coeff_p1_ff	<= 11'h0d4 ;

						7'b11_0_0000	: coeff_p1_ff	<= 11'h087 ;
						7'b11_0_0001	: coeff_p1_ff	<= 11'h087 ;
						7'b11_0_0010	: coeff_p1_ff	<= 11'h089 ;
						7'b11_0_0011	: coeff_p1_ff	<= 11'h08a ;
						7'b11_0_0100	: coeff_p1_ff	<= 11'h08b ;
						7'b11_0_0101	: coeff_p1_ff	<= 11'h08c ;
						7'b11_0_0110	: coeff_p1_ff	<= 11'h08d ;
						7'b11_0_0111	: coeff_p1_ff	<= 11'h08e ;
						7'b11_0_1000	: coeff_p1_ff	<= 11'h08f ;
						7'b11_0_1001	: coeff_p1_ff	<= 11'h090 ;
						7'b11_0_1010	: coeff_p1_ff	<= 11'h091 ;
						7'b11_0_1011	: coeff_p1_ff	<= 11'h092 ;
						7'b11_0_1100	: coeff_p1_ff	<= 11'h093 ;
						7'b11_0_1101	: coeff_p1_ff	<= 11'h094 ;
						7'b11_0_1110	: coeff_p1_ff	<= 11'h095 ;
						7'b11_0_1111	: coeff_p1_ff	<= 11'h096 ;
						7'b11_1_0000	: coeff_p1_ff	<= 11'h097 ;
						7'b11_1_0001	: coeff_p1_ff	<= 11'h098 ;
						7'b11_1_0010	: coeff_p1_ff	<= 11'h099 ;
						7'b11_1_0011	: coeff_p1_ff	<= 11'h09a ;
						7'b11_1_0100	: coeff_p1_ff	<= 11'h09a ;
						7'b11_1_0101	: coeff_p1_ff	<= 11'h09b ;
						7'b11_1_0110	: coeff_p1_ff	<= 11'h09c ;
						7'b11_1_0111	: coeff_p1_ff	<= 11'h09c ;
						7'b11_1_1000	: coeff_p1_ff	<= 11'h09d ;
						7'b11_1_1001	: coeff_p1_ff	<= 11'h09e ;
						7'b11_1_1010	: coeff_p1_ff	<= 11'h09f ;
						7'b11_1_1011	: coeff_p1_ff	<= 11'h09f ;
						7'b11_1_1100	: coeff_p1_ff	<= 11'h0a0 ;
						7'b11_1_1101	: coeff_p1_ff	<= 11'h0a0 ;
						7'b11_1_1110	: coeff_p1_ff	<= 11'h0a1 ;
						7'b11_1_1111	: coeff_p1_ff	<= 11'h0a1 ;
						default			: coeff_p1_ff	<= {11{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p2_ff		<= 11'h000 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_p2_ff	<= 11'h000 ;
						7'b00_0_0001	: coeff_p2_ff	<= 11'h000 ;
						7'b00_0_0010	: coeff_p2_ff	<= 11'h000 ;
						7'b00_0_0011	: coeff_p2_ff	<= 11'h000 ;
						7'b00_0_0100	: coeff_p2_ff	<= 11'h000 ;
						7'b00_0_0101	: coeff_p2_ff	<= 11'h000 ;
						7'b00_0_0110	: coeff_p2_ff	<= 11'h002 ;
						7'b00_0_0111	: coeff_p2_ff	<= 11'h002 ;
						7'b00_0_1000	: coeff_p2_ff	<= 11'h002 ;
						7'b00_0_1001	: coeff_p2_ff	<= 11'h003 ;
						7'b00_0_1010	: coeff_p2_ff	<= 11'h004 ;
						7'b00_0_1011	: coeff_p2_ff	<= 11'h004 ;
						7'b00_0_1100	: coeff_p2_ff	<= 11'h005 ;
						7'b00_0_1101	: coeff_p2_ff	<= 11'h006 ;
						7'b00_0_1110	: coeff_p2_ff	<= 11'h007 ;
						7'b00_0_1111	: coeff_p2_ff	<= 11'h007 ;
						7'b00_1_0000	: coeff_p2_ff	<= 11'h008 ;
						7'b00_1_0001	: coeff_p2_ff	<= 11'h009 ;
						7'b00_1_0010	: coeff_p2_ff	<= 11'h00a ;
						7'b00_1_0011	: coeff_p2_ff	<= 11'h00b ;
						7'b00_1_0100	: coeff_p2_ff	<= 11'h00c ;
						7'b00_1_0101	: coeff_p2_ff	<= 11'h00d ;
						7'b00_1_0110	: coeff_p2_ff	<= 11'h00f ;
						7'b00_1_0111	: coeff_p2_ff	<= 11'h011 ;
						7'b00_1_1000	: coeff_p2_ff	<= 11'h013 ;
						7'b00_1_1001	: coeff_p2_ff	<= 11'h016 ;
						7'b00_1_1010	: coeff_p2_ff	<= 11'h019 ;
						7'b00_1_1011	: coeff_p2_ff	<= 11'h01c ;
						7'b00_1_1100	: coeff_p2_ff	<= 11'h020 ;
						7'b00_1_1101	: coeff_p2_ff	<= 11'h024 ;
						7'b00_1_1110	: coeff_p2_ff	<= 11'h02a ;
						7'b00_1_1111	: coeff_p2_ff	<= 11'h030 ;

						7'b01_0_0000	: coeff_p2_ff	<= 11'h00f ;
						7'b01_0_0001	: coeff_p2_ff	<= 11'h00f ;
						7'b01_0_0010	: coeff_p2_ff	<= 11'h010 ;
						7'b01_0_0011	: coeff_p2_ff	<= 11'h011 ;
						7'b01_0_0100	: coeff_p2_ff	<= 11'h013 ;
						7'b01_0_0101	: coeff_p2_ff	<= 11'h014 ;
						7'b01_0_0110	: coeff_p2_ff	<= 11'h016 ;
						7'b01_0_0111	: coeff_p2_ff	<= 11'h018 ;
						7'b01_0_1000	: coeff_p2_ff	<= 11'h019 ;
						7'b01_0_1001	: coeff_p2_ff	<= 11'h01b ;
						7'b01_0_1010	: coeff_p2_ff	<= 11'h01d ;
						7'b01_0_1011	: coeff_p2_ff	<= 11'h01f ;
						7'b01_0_1100	: coeff_p2_ff	<= 11'h022 ;
						7'b01_0_1101	: coeff_p2_ff	<= 11'h025 ;
						7'b01_0_1110	: coeff_p2_ff	<= 11'h027 ;
						7'b01_0_1111	: coeff_p2_ff	<= 11'h02a ;
						7'b01_1_0000	: coeff_p2_ff	<= 11'h02d ;
						7'b01_1_0001	: coeff_p2_ff	<= 11'h031 ;
						7'b01_1_0010	: coeff_p2_ff	<= 11'h034 ;
						7'b01_1_0011	: coeff_p2_ff	<= 11'h038 ;
						7'b01_1_0100	: coeff_p2_ff	<= 11'h03c ;
						7'b01_1_0101	: coeff_p2_ff	<= 11'h040 ;
						7'b01_1_0110	: coeff_p2_ff	<= 11'h044 ;
						7'b01_1_0111	: coeff_p2_ff	<= 11'h048 ;
						7'b01_1_1000	: coeff_p2_ff	<= 11'h04d ;
						7'b01_1_1001	: coeff_p2_ff	<= 11'h051 ;
						7'b01_1_1010	: coeff_p2_ff	<= 11'h056 ;
						7'b01_1_1011	: coeff_p2_ff	<= 11'h05c ;
						7'b01_1_1100	: coeff_p2_ff	<= 11'h061 ;
						7'b01_1_1101	: coeff_p2_ff	<= 11'h067 ;
						7'b01_1_1110	: coeff_p2_ff	<= 11'h06c ;
						7'b01_1_1111	: coeff_p2_ff	<= 11'h072 ;

						7'b10_0_0000	: coeff_p2_ff	<= 11'h024 ;
						7'b10_0_0001	: coeff_p2_ff	<= 11'h025 ;
						7'b10_0_0010	: coeff_p2_ff	<= 11'h027 ;
						7'b10_0_0011	: coeff_p2_ff	<= 11'h029 ;
						7'b10_0_0100	: coeff_p2_ff	<= 11'h02a ;
						7'b10_0_0101	: coeff_p2_ff	<= 11'h02c ;
						7'b10_0_0110	: coeff_p2_ff	<= 11'h02e ;
						7'b10_0_0111	: coeff_p2_ff	<= 11'h030 ;
						7'b10_0_1000	: coeff_p2_ff	<= 11'h032 ;
						7'b10_0_1001	: coeff_p2_ff	<= 11'h034 ;
						7'b10_0_1010	: coeff_p2_ff	<= 11'h037 ;
						7'b10_0_1011	: coeff_p2_ff	<= 11'h039 ;
						7'b10_0_1100	: coeff_p2_ff	<= 11'h03c ;
						7'b10_0_1101	: coeff_p2_ff	<= 11'h03f ;
						7'b10_0_1110	: coeff_p2_ff	<= 11'h042 ;
						7'b10_0_1111	: coeff_p2_ff	<= 11'h045 ;
						7'b10_1_0000	: coeff_p2_ff	<= 11'h047 ;
						7'b10_1_0001	: coeff_p2_ff	<= 11'h04a ;
						7'b10_1_0010	: coeff_p2_ff	<= 11'h04d ;
						7'b10_1_0011	: coeff_p2_ff	<= 11'h050 ;
						7'b10_1_0100	: coeff_p2_ff	<= 11'h054 ;
						7'b10_1_0101	: coeff_p2_ff	<= 11'h058 ;
						7'b10_1_0110	: coeff_p2_ff	<= 11'h05c ;
						7'b10_1_0111	: coeff_p2_ff	<= 11'h05f ;
						7'b10_1_1000	: coeff_p2_ff	<= 11'h063 ;
						7'b10_1_1001	: coeff_p2_ff	<= 11'h067 ;
						7'b10_1_1010	: coeff_p2_ff	<= 11'h06b ;
						7'b10_1_1011	: coeff_p2_ff	<= 11'h06f ;
						7'b10_1_1100	: coeff_p2_ff	<= 11'h073 ;
						7'b10_1_1101	: coeff_p2_ff	<= 11'h077 ;
						7'b10_1_1110	: coeff_p2_ff	<= 11'h07c ;
						7'b10_1_1111	: coeff_p2_ff	<= 11'h080 ;

						7'b11_0_0000	: coeff_p2_ff	<= 11'h051 ;
						7'b11_0_0001	: coeff_p2_ff	<= 11'h053 ;
						7'b11_0_0010	: coeff_p2_ff	<= 11'h054 ;
						7'b11_0_0011	: coeff_p2_ff	<= 11'h055 ;
						7'b11_0_0100	: coeff_p2_ff	<= 11'h057 ;
						7'b11_0_0101	: coeff_p2_ff	<= 11'h058 ;
						7'b11_0_0110	: coeff_p2_ff	<= 11'h059 ;
						7'b11_0_0111	: coeff_p2_ff	<= 11'h05b ;
						7'b11_0_1000	: coeff_p2_ff	<= 11'h05c ;
						7'b11_0_1001	: coeff_p2_ff	<= 11'h05e ;
						7'b11_0_1010	: coeff_p2_ff	<= 11'h060 ;
						7'b11_0_1011	: coeff_p2_ff	<= 11'h061 ;
						7'b11_0_1100	: coeff_p2_ff	<= 11'h063 ;
						7'b11_0_1101	: coeff_p2_ff	<= 11'h064 ;
						7'b11_0_1110	: coeff_p2_ff	<= 11'h066 ;
						7'b11_0_1111	: coeff_p2_ff	<= 11'h067 ;
						7'b11_1_0000	: coeff_p2_ff	<= 11'h069 ;
						7'b11_1_0001	: coeff_p2_ff	<= 11'h06b ;
						7'b11_1_0010	: coeff_p2_ff	<= 11'h06d ;
						7'b11_1_0011	: coeff_p2_ff	<= 11'h06e ;
						7'b11_1_0100	: coeff_p2_ff	<= 11'h070 ;
						7'b11_1_0101	: coeff_p2_ff	<= 11'h072 ;
						7'b11_1_0110	: coeff_p2_ff	<= 11'h073 ;
						7'b11_1_0111	: coeff_p2_ff	<= 11'h076 ;
						7'b11_1_1000	: coeff_p2_ff	<= 11'h078 ;
						7'b11_1_1001	: coeff_p2_ff	<= 11'h079 ;
						7'b11_1_1010	: coeff_p2_ff	<= 11'h07b ;
						7'b11_1_1011	: coeff_p2_ff	<= 11'h07d ;
						7'b11_1_1100	: coeff_p2_ff	<= 11'h07f ;
						7'b11_1_1101	: coeff_p2_ff	<= 11'h081 ;
						7'b11_1_1110	: coeff_p2_ff	<= 11'h082 ;
						7'b11_1_1111	: coeff_p2_ff	<= 11'h085 ;
						default			: coeff_p2_ff	<= {11{1'bx}} ;
					endcase
				end
			end
		end
		else if ( Q_BIT == 12 ) begin : table_12bit
			//-------------------- Table Value Format -----------------------//
			//	 { Sign(1bit), Integral Part(1bit), Fraction Part(11bit) }	 //
			//---------------------------------------------------------------//
			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_m1_ff		<= 13'h0000 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_m1_ff	<= 13'h00da ;
						7'b00_0_0001	: coeff_m1_ff	<= 13'h00c0 ;
						7'b00_0_0010	: coeff_m1_ff	<= 13'h00a8 ;
						7'b00_0_0011	: coeff_m1_ff	<= 13'h0094 ;
						7'b00_0_0100	: coeff_m1_ff	<= 13'h0082 ;
						7'b00_0_0101	: coeff_m1_ff	<= 13'h0072 ;
						7'b00_0_0110	: coeff_m1_ff	<= 13'h0064 ;
						7'b00_0_0111	: coeff_m1_ff	<= 13'h0058 ;
						7'b00_0_1000	: coeff_m1_ff	<= 13'h004d ;
						7'b00_0_1001	: coeff_m1_ff	<= 13'h0045 ;
						7'b00_0_1010	: coeff_m1_ff	<= 13'h003d ;
						7'b00_0_1011	: coeff_m1_ff	<= 13'h0036 ;
						7'b00_0_1100	: coeff_m1_ff	<= 13'h0030 ;
						7'b00_0_1101	: coeff_m1_ff	<= 13'h002b ;
						7'b00_0_1110	: coeff_m1_ff	<= 13'h0027 ;
						7'b00_0_1111	: coeff_m1_ff	<= 13'h0023 ;
						7'b00_1_0000	: coeff_m1_ff	<= 13'h0020 ;
						7'b00_1_0001	: coeff_m1_ff	<= 13'h001d ;
						7'b00_1_0010	: coeff_m1_ff	<= 13'h001a ;
						7'b00_1_0011	: coeff_m1_ff	<= 13'h0018 ;
						7'b00_1_0100	: coeff_m1_ff	<= 13'h0015 ;
						7'b00_1_0101	: coeff_m1_ff	<= 13'h0012 ;
						7'b00_1_0110	: coeff_m1_ff	<= 13'h000f ;
						7'b00_1_0111	: coeff_m1_ff	<= 13'h000d ;
						7'b00_1_1000	: coeff_m1_ff	<= 13'h000b ;
						7'b00_1_1001	: coeff_m1_ff	<= 13'h0008 ;
						7'b00_1_1010	: coeff_m1_ff	<= 13'h0007 ;
						7'b00_1_1011	: coeff_m1_ff	<= 13'h0005 ;
						7'b00_1_1100	: coeff_m1_ff	<= 13'h0003 ;
						7'b00_1_1101	: coeff_m1_ff	<= 13'h0002 ;
						7'b00_1_1110	: coeff_m1_ff	<= 13'h0000 ;
						7'b00_1_1111	: coeff_m1_ff	<= 13'h0000 ;

						7'b01_0_0000	: coeff_m1_ff	<= 13'h01df ;
						7'b01_0_0001	: coeff_m1_ff	<= 13'h01c7 ;
						7'b01_0_0010	: coeff_m1_ff	<= 13'h01b0 ;
						7'b01_0_0011	: coeff_m1_ff	<= 13'h019a ;
						7'b01_0_0100	: coeff_m1_ff	<= 13'h0184 ;
						7'b01_0_0101	: coeff_m1_ff	<= 13'h016f ;
						7'b01_0_0110	: coeff_m1_ff	<= 13'h015a ;
						7'b01_0_0111	: coeff_m1_ff	<= 13'h0147 ;
						7'b01_0_1000	: coeff_m1_ff	<= 13'h0133 ;
						7'b01_0_1001	: coeff_m1_ff	<= 13'h0121 ;
						7'b01_0_1010	: coeff_m1_ff	<= 13'h010f ;
						7'b01_0_1011	: coeff_m1_ff	<= 13'h00fe ;
						7'b01_0_1100	: coeff_m1_ff	<= 13'h00ee ;
						7'b01_0_1101	: coeff_m1_ff	<= 13'h00de ;
						7'b01_0_1110	: coeff_m1_ff	<= 13'h00d0 ;
						7'b01_0_1111	: coeff_m1_ff	<= 13'h00c1 ;
						7'b01_1_0000	: coeff_m1_ff	<= 13'h00b4 ;
						7'b01_1_0001	: coeff_m1_ff	<= 13'h00a8 ;
						7'b01_1_0010	: coeff_m1_ff	<= 13'h009c ;
						7'b01_1_0011	: coeff_m1_ff	<= 13'h0091 ;
						7'b01_1_0100	: coeff_m1_ff	<= 13'h0086 ;
						7'b01_1_0101	: coeff_m1_ff	<= 13'h007c ;
						7'b01_1_0110	: coeff_m1_ff	<= 13'h0074 ;
						7'b01_1_0111	: coeff_m1_ff	<= 13'h006b ;
						7'b01_1_1000	: coeff_m1_ff	<= 13'h0063 ;
						7'b01_1_1001	: coeff_m1_ff	<= 13'h005c ;
						7'b01_1_1010	: coeff_m1_ff	<= 13'h0056 ;
						7'b01_1_1011	: coeff_m1_ff	<= 13'h004f ;
						7'b01_1_1100	: coeff_m1_ff	<= 13'h004a ;
						7'b01_1_1101	: coeff_m1_ff	<= 13'h0045 ;
						7'b01_1_1110	: coeff_m1_ff	<= 13'h0041 ;
						7'b01_1_1111	: coeff_m1_ff	<= 13'h003d ;

						7'b10_0_0000	: coeff_m1_ff	<= 13'h0210 ;
						7'b10_0_0001	: coeff_m1_ff	<= 13'h01ff ;
						7'b10_0_0010	: coeff_m1_ff	<= 13'h01ee ;
						7'b10_0_0011	: coeff_m1_ff	<= 13'h01dd ;
						7'b10_0_0100	: coeff_m1_ff	<= 13'h01cc ;
						7'b10_0_0101	: coeff_m1_ff	<= 13'h01bc ;
						7'b10_0_0110	: coeff_m1_ff	<= 13'h01ac ;
						7'b10_0_0111	: coeff_m1_ff	<= 13'h019c ;
						7'b10_0_1000	: coeff_m1_ff	<= 13'h018d ;
						7'b10_0_1001	: coeff_m1_ff	<= 13'h017d ;
						7'b10_0_1010	: coeff_m1_ff	<= 13'h016e ;
						7'b10_0_1011	: coeff_m1_ff	<= 13'h0160 ;
						7'b10_0_1100	: coeff_m1_ff	<= 13'h0151 ;
						7'b10_0_1101	: coeff_m1_ff	<= 13'h0143 ;
						7'b10_0_1110	: coeff_m1_ff	<= 13'h0136 ;
						7'b10_0_1111	: coeff_m1_ff	<= 13'h0129 ;
						7'b10_1_0000	: coeff_m1_ff	<= 13'h011c ;
						7'b10_1_0001	: coeff_m1_ff	<= 13'h0110 ;
						7'b10_1_0010	: coeff_m1_ff	<= 13'h0105 ;
						7'b10_1_0011	: coeff_m1_ff	<= 13'h00f9 ;
						7'b10_1_0100	: coeff_m1_ff	<= 13'h00ee ;
						7'b10_1_0101	: coeff_m1_ff	<= 13'h00e4 ;
						7'b10_1_0110	: coeff_m1_ff	<= 13'h00d9 ;
						7'b10_1_0111	: coeff_m1_ff	<= 13'h00d0 ;
						7'b10_1_1000	: coeff_m1_ff	<= 13'h00c7 ;
						7'b10_1_1001	: coeff_m1_ff	<= 13'h00bf ;
						7'b10_1_1010	: coeff_m1_ff	<= 13'h00b7 ;
						7'b10_1_1011	: coeff_m1_ff	<= 13'h00af ;
						7'b10_1_1100	: coeff_m1_ff	<= 13'h00a7 ;
						7'b10_1_1101	: coeff_m1_ff	<= 13'h00a1 ;
						7'b10_1_1110	: coeff_m1_ff	<= 13'h009b ;
						7'b10_1_1111	: coeff_m1_ff	<= 13'h0094 ;

						7'b11_0_0000	: coeff_m1_ff	<= 13'h021a ;
						7'b11_0_0001	: coeff_m1_ff	<= 13'h0213 ;
						7'b11_0_0010	: coeff_m1_ff	<= 13'h020a ;
						7'b11_0_0011	: coeff_m1_ff	<= 13'h0203 ;
						7'b11_0_0100	: coeff_m1_ff	<= 13'h01fc ;
						7'b11_0_0101	: coeff_m1_ff	<= 13'h01f4 ;
						7'b11_0_0110	: coeff_m1_ff	<= 13'h01ed ;
						7'b11_0_0111	: coeff_m1_ff	<= 13'h01e5 ;
						7'b11_0_1000	: coeff_m1_ff	<= 13'h01dd ;
						7'b11_0_1001	: coeff_m1_ff	<= 13'h01d6 ;
						7'b11_0_1010	: coeff_m1_ff	<= 13'h01cf ;
						7'b11_0_1011	: coeff_m1_ff	<= 13'h01c7 ;
						7'b11_0_1100	: coeff_m1_ff	<= 13'h01c0 ;
						7'b11_0_1101	: coeff_m1_ff	<= 13'h01b8 ;
						7'b11_0_1110	: coeff_m1_ff	<= 13'h01b2 ;
						7'b11_0_1111	: coeff_m1_ff	<= 13'h01ab ;
						7'b11_1_0000	: coeff_m1_ff	<= 13'h01a4 ;
						7'b11_1_0001	: coeff_m1_ff	<= 13'h019d ;
						7'b11_1_0010	: coeff_m1_ff	<= 13'h0196 ;
						7'b11_1_0011	: coeff_m1_ff	<= 13'h0190 ;
						7'b11_1_0100	: coeff_m1_ff	<= 13'h0189 ;
						7'b11_1_0101	: coeff_m1_ff	<= 13'h0183 ;
						7'b11_1_0110	: coeff_m1_ff	<= 13'h017d ;
						7'b11_1_0111	: coeff_m1_ff	<= 13'h0176 ;
						7'b11_1_1000	: coeff_m1_ff	<= 13'h0170 ;
						7'b11_1_1001	: coeff_m1_ff	<= 13'h016b ;
						7'b11_1_1010	: coeff_m1_ff	<= 13'h0165 ;
						7'b11_1_1011	: coeff_m1_ff	<= 13'h015f ;
						7'b11_1_1100	: coeff_m1_ff	<= 13'h015a ;
						7'b11_1_1101	: coeff_m1_ff	<= 13'h0155 ;
						7'b11_1_1110	: coeff_m1_ff	<= 13'h0150 ;
						7'b11_1_1111	: coeff_m1_ff	<= 13'h014b ;
						default			: coeff_m1_ff	<= {13{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_zr_ff		<= 13'h0800 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_zr_ff	<= 13'h064c ;
						7'b00_0_0001	: coeff_zr_ff	<= 13'h064a ;
						7'b00_0_0010	: coeff_zr_ff	<= 13'h0641 ;
						7'b00_0_0011	: coeff_zr_ff	<= 13'h0631 ;
						7'b00_0_0100	: coeff_zr_ff	<= 13'h061d ;
						7'b00_0_0101	: coeff_zr_ff	<= 13'h0602 ;
						7'b00_0_0110	: coeff_zr_ff	<= 13'h05e3 ;
						7'b00_0_0111	: coeff_zr_ff	<= 13'h05bf ;
						7'b00_0_1000	: coeff_zr_ff	<= 13'h0596 ;
						7'b00_0_1001	: coeff_zr_ff	<= 13'h0568 ;
						7'b00_0_1010	: coeff_zr_ff	<= 13'h0538 ;
						7'b00_0_1011	: coeff_zr_ff	<= 13'h0504 ;
						7'b00_0_1100	: coeff_zr_ff	<= 13'h04cd ;
						7'b00_0_1101	: coeff_zr_ff	<= 13'h0494 ;
						7'b00_0_1110	: coeff_zr_ff	<= 13'h0459 ;
						7'b00_0_1111	: coeff_zr_ff	<= 13'h041d ;
						7'b00_1_0000	: coeff_zr_ff	<= 13'h03e0 ;
						7'b00_1_0001	: coeff_zr_ff	<= 13'h03a3 ;
						7'b00_1_0010	: coeff_zr_ff	<= 13'h0366 ;
						7'b00_1_0011	: coeff_zr_ff	<= 13'h0329 ;
						7'b00_1_0100	: coeff_zr_ff	<= 13'h02ee ;
						7'b00_1_0101	: coeff_zr_ff	<= 13'h02b4 ;
						7'b00_1_0110	: coeff_zr_ff	<= 13'h027c ;
						7'b00_1_0111	: coeff_zr_ff	<= 13'h0245 ;
						7'b00_1_1000	: coeff_zr_ff	<= 13'h0212 ;
						7'b00_1_1001	: coeff_zr_ff	<= 13'h01e1 ;
						7'b00_1_1010	: coeff_zr_ff	<= 13'h01b2 ;
						7'b00_1_1011	: coeff_zr_ff	<= 13'h0187 ;
						7'b00_1_1100	: coeff_zr_ff	<= 13'h015e ;
						7'b00_1_1101	: coeff_zr_ff	<= 13'h0139 ;
						7'b00_1_1110	: coeff_zr_ff	<= 13'h0117 ;
						7'b00_1_1111	: coeff_zr_ff	<= 13'h00f7 ;

						7'b01_0_0000	: coeff_zr_ff	<= 13'h0409 ;
						7'b01_0_0001	: coeff_zr_ff	<= 13'h0407 ;
						7'b01_0_0010	: coeff_zr_ff	<= 13'h0404 ;
						7'b01_0_0011	: coeff_zr_ff	<= 13'h03ff ;
						7'b01_0_0100	: coeff_zr_ff	<= 13'h03f8 ;
						7'b01_0_0101	: coeff_zr_ff	<= 13'h03f1 ;
						7'b01_0_0110	: coeff_zr_ff	<= 13'h03e8 ;
						7'b01_0_0111	: coeff_zr_ff	<= 13'h03dd ;
						7'b01_0_1000	: coeff_zr_ff	<= 13'h03d2 ;
						7'b01_0_1001	: coeff_zr_ff	<= 13'h03c5 ;
						7'b01_0_1010	: coeff_zr_ff	<= 13'h03b7 ;
						7'b01_0_1011	: coeff_zr_ff	<= 13'h03a8 ;
						7'b01_0_1100	: coeff_zr_ff	<= 13'h0397 ;
						7'b01_0_1101	: coeff_zr_ff	<= 13'h0385 ;
						7'b01_0_1110	: coeff_zr_ff	<= 13'h0373 ;
						7'b01_0_1111	: coeff_zr_ff	<= 13'h0360 ;
						7'b01_1_0000	: coeff_zr_ff	<= 13'h034c ;
						7'b01_1_0001	: coeff_zr_ff	<= 13'h0337 ;
						7'b01_1_0010	: coeff_zr_ff	<= 13'h0321 ;
						7'b01_1_0011	: coeff_zr_ff	<= 13'h030b ;
						7'b01_1_0100	: coeff_zr_ff	<= 13'h02f4 ;
						7'b01_1_0101	: coeff_zr_ff	<= 13'h02de ;
						7'b01_1_0110	: coeff_zr_ff	<= 13'h02c6 ;
						7'b01_1_0111	: coeff_zr_ff	<= 13'h02af ;
						7'b01_1_1000	: coeff_zr_ff	<= 13'h0298 ;
						7'b01_1_1001	: coeff_zr_ff	<= 13'h027f ;
						7'b01_1_1010	: coeff_zr_ff	<= 13'h0268 ;
						7'b01_1_1011	: coeff_zr_ff	<= 13'h0251 ;
						7'b01_1_1100	: coeff_zr_ff	<= 13'h0239 ;
						7'b01_1_1101	: coeff_zr_ff	<= 13'h0222 ;
						7'b01_1_1110	: coeff_zr_ff	<= 13'h020b ;
						7'b01_1_1111	: coeff_zr_ff	<= 13'h01f5 ;

						7'b10_0_0000	: coeff_zr_ff	<= 13'h0351 ;
						7'b10_0_0001	: coeff_zr_ff	<= 13'h034f ;
						7'b10_0_0010	: coeff_zr_ff	<= 13'h034c ;
						7'b10_0_0011	: coeff_zr_ff	<= 13'h0349 ;
						7'b10_0_0100	: coeff_zr_ff	<= 13'h0345 ;
						7'b10_0_0101	: coeff_zr_ff	<= 13'h0340 ;
						7'b10_0_0110	: coeff_zr_ff	<= 13'h033a ;
						7'b10_0_0111	: coeff_zr_ff	<= 13'h0334 ;
						7'b10_0_1000	: coeff_zr_ff	<= 13'h032d ;
						7'b10_0_1001	: coeff_zr_ff	<= 13'h0326 ;
						7'b10_0_1010	: coeff_zr_ff	<= 13'h031f ;
						7'b10_0_1011	: coeff_zr_ff	<= 13'h0316 ;
						7'b10_0_1100	: coeff_zr_ff	<= 13'h030d ;
						7'b10_0_1101	: coeff_zr_ff	<= 13'h0304 ;
						7'b10_0_1110	: coeff_zr_ff	<= 13'h02f9 ;
						7'b10_0_1111	: coeff_zr_ff	<= 13'h02ef ;
						7'b10_1_0000	: coeff_zr_ff	<= 13'h02e4 ;
						7'b10_1_0001	: coeff_zr_ff	<= 13'h02d8 ;
						7'b10_1_0010	: coeff_zr_ff	<= 13'h02cc ;
						7'b10_1_0011	: coeff_zr_ff	<= 13'h02c0 ;
						7'b10_1_0100	: coeff_zr_ff	<= 13'h02b4 ;
						7'b10_1_0101	: coeff_zr_ff	<= 13'h02a6 ;
						7'b10_1_0110	: coeff_zr_ff	<= 13'h029a ;
						7'b10_1_0111	: coeff_zr_ff	<= 13'h028c ;
						7'b10_1_1000	: coeff_zr_ff	<= 13'h027e ;
						7'b10_1_1001	: coeff_zr_ff	<= 13'h0271 ;
						7'b10_1_1010	: coeff_zr_ff	<= 13'h0263 ;
						7'b10_1_1011	: coeff_zr_ff	<= 13'h0255 ;
						7'b10_1_1100	: coeff_zr_ff	<= 13'h0248 ;
						7'b10_1_1101	: coeff_zr_ff	<= 13'h0239 ;
						7'b10_1_1110	: coeff_zr_ff	<= 13'h022b ;
						7'b10_1_1111	: coeff_zr_ff	<= 13'h021e ;

						7'b11_0_0000	: coeff_zr_ff	<= 13'h0286 ;
						7'b11_0_0001	: coeff_zr_ff	<= 13'h0284 ;
						7'b11_0_0010	: coeff_zr_ff	<= 13'h0283 ;
						7'b11_0_0011	: coeff_zr_ff	<= 13'h0281 ;
						7'b11_0_0100	: coeff_zr_ff	<= 13'h027e ;
						7'b11_0_0101	: coeff_zr_ff	<= 13'h027d ;
						7'b11_0_0110	: coeff_zr_ff	<= 13'h027a ;
						7'b11_0_0111	: coeff_zr_ff	<= 13'h0277 ;
						7'b11_0_1000	: coeff_zr_ff	<= 13'h0276 ;
						7'b11_0_1001	: coeff_zr_ff	<= 13'h0273 ;
						7'b11_0_1010	: coeff_zr_ff	<= 13'h026f ;
						7'b11_0_1011	: coeff_zr_ff	<= 13'h026d ;
						7'b11_0_1100	: coeff_zr_ff	<= 13'h0269 ;
						7'b11_0_1101	: coeff_zr_ff	<= 13'h0267 ;
						7'b11_0_1110	: coeff_zr_ff	<= 13'h0263 ;
						7'b11_0_1111	: coeff_zr_ff	<= 13'h025f ;
						7'b11_1_0000	: coeff_zr_ff	<= 13'h025c ;
						7'b11_1_0001	: coeff_zr_ff	<= 13'h0258 ;
						7'b11_1_0010	: coeff_zr_ff	<= 13'h0255 ;
						7'b11_1_0011	: coeff_zr_ff	<= 13'h0251 ;
						7'b11_1_0100	: coeff_zr_ff	<= 13'h024d ;
						7'b11_1_0101	: coeff_zr_ff	<= 13'h0249 ;
						7'b11_1_0110	: coeff_zr_ff	<= 13'h0245 ;
						7'b11_1_0111	: coeff_zr_ff	<= 13'h0241 ;
						7'b11_1_1000	: coeff_zr_ff	<= 13'h023d ;
						7'b11_1_1001	: coeff_zr_ff	<= 13'h0238 ;
						7'b11_1_1010	: coeff_zr_ff	<= 13'h0234 ;
						7'b11_1_1011	: coeff_zr_ff	<= 13'h0230 ;
						7'b11_1_1100	: coeff_zr_ff	<= 13'h022b ;
						7'b11_1_1101	: coeff_zr_ff	<= 13'h0227 ;
						7'b11_1_1110	: coeff_zr_ff	<= 13'h0223 ;
						7'b11_1_1111	: coeff_zr_ff	<= 13'h021e ;
						default			: coeff_zr_ff	<= {13{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p1_ff		<= 13'h0000 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_p1_ff	<= 13'h00da ;
						7'b00_0_0001	: coeff_p1_ff	<= 13'h00f6 ;
						7'b00_0_0010	: coeff_p1_ff	<= 13'h0117 ;
						7'b00_0_0011	: coeff_p1_ff	<= 13'h0139 ;
						7'b00_0_0100	: coeff_p1_ff	<= 13'h015e ;
						7'b00_0_0101	: coeff_p1_ff	<= 13'h0187 ;
						7'b00_0_0110	: coeff_p1_ff	<= 13'h01b2 ;
						7'b00_0_0111	: coeff_p1_ff	<= 13'h01e1 ;
						7'b00_0_1000	: coeff_p1_ff	<= 13'h0212 ;
						7'b00_0_1001	: coeff_p1_ff	<= 13'h0246 ;
						7'b00_0_1010	: coeff_p1_ff	<= 13'h027c ;
						7'b00_0_1011	: coeff_p1_ff	<= 13'h02b4 ;
						7'b00_0_1100	: coeff_p1_ff	<= 13'h02ee ;
						7'b00_0_1101	: coeff_p1_ff	<= 13'h0329 ;
						7'b00_0_1110	: coeff_p1_ff	<= 13'h0366 ;
						7'b00_0_1111	: coeff_p1_ff	<= 13'h03a3 ;
						7'b00_1_0000	: coeff_p1_ff	<= 13'h03e0 ;
						7'b00_1_0001	: coeff_p1_ff	<= 13'h041d ;
						7'b00_1_0010	: coeff_p1_ff	<= 13'h0459 ;
						7'b00_1_0011	: coeff_p1_ff	<= 13'h0494 ;
						7'b00_1_0100	: coeff_p1_ff	<= 13'h04cd ;
						7'b00_1_0101	: coeff_p1_ff	<= 13'h0504 ;
						7'b00_1_0110	: coeff_p1_ff	<= 13'h0538 ;
						7'b00_1_0111	: coeff_p1_ff	<= 13'h0569 ;
						7'b00_1_1000	: coeff_p1_ff	<= 13'h0596 ;
						7'b00_1_1001	: coeff_p1_ff	<= 13'h05bf ;
						7'b00_1_1010	: coeff_p1_ff	<= 13'h05e3 ;
						7'b00_1_1011	: coeff_p1_ff	<= 13'h0602 ;
						7'b00_1_1100	: coeff_p1_ff	<= 13'h061d ;
						7'b00_1_1101	: coeff_p1_ff	<= 13'h0631 ;
						7'b00_1_1110	: coeff_p1_ff	<= 13'h0641 ;
						7'b00_1_1111	: coeff_p1_ff	<= 13'h0649 ;

						7'b01_0_0000	: coeff_p1_ff	<= 13'h01df ;
						7'b01_0_0001	: coeff_p1_ff	<= 13'h01f5 ;
						7'b01_0_0010	: coeff_p1_ff	<= 13'h020b ;
						7'b01_0_0011	: coeff_p1_ff	<= 13'h0222 ;
						7'b01_0_0100	: coeff_p1_ff	<= 13'h023a ;
						7'b01_0_0101	: coeff_p1_ff	<= 13'h0251 ;
						7'b01_0_0110	: coeff_p1_ff	<= 13'h0268 ;
						7'b01_0_0111	: coeff_p1_ff	<= 13'h0280 ;
						7'b01_0_1000	: coeff_p1_ff	<= 13'h0298 ;
						7'b01_0_1001	: coeff_p1_ff	<= 13'h02af ;
						7'b01_0_1010	: coeff_p1_ff	<= 13'h02c6 ;
						7'b01_0_1011	: coeff_p1_ff	<= 13'h02de ;
						7'b01_0_1100	: coeff_p1_ff	<= 13'h02f5 ;
						7'b01_0_1101	: coeff_p1_ff	<= 13'h030c ;
						7'b01_0_1110	: coeff_p1_ff	<= 13'h0321 ;
						7'b01_0_1111	: coeff_p1_ff	<= 13'h0337 ;
						7'b01_1_0000	: coeff_p1_ff	<= 13'h034c ;
						7'b01_1_0001	: coeff_p1_ff	<= 13'h0360 ;
						7'b01_1_0010	: coeff_p1_ff	<= 13'h0373 ;
						7'b01_1_0011	: coeff_p1_ff	<= 13'h0386 ;
						7'b01_1_0100	: coeff_p1_ff	<= 13'h0398 ;
						7'b01_1_0101	: coeff_p1_ff	<= 13'h03a8 ;
						7'b01_1_0110	: coeff_p1_ff	<= 13'h03b7 ;
						7'b01_1_0111	: coeff_p1_ff	<= 13'h03c5 ;
						7'b01_1_1000	: coeff_p1_ff	<= 13'h03d2 ;
						7'b01_1_1001	: coeff_p1_ff	<= 13'h03de ;
						7'b01_1_1010	: coeff_p1_ff	<= 13'h03e8 ;
						7'b01_1_1011	: coeff_p1_ff	<= 13'h03f1 ;
						7'b01_1_1100	: coeff_p1_ff	<= 13'h03f9 ;
						7'b01_1_1101	: coeff_p1_ff	<= 13'h03ff ;
						7'b01_1_1110	: coeff_p1_ff	<= 13'h0404 ;
						7'b01_1_1111	: coeff_p1_ff	<= 13'h0407 ;

						7'b10_0_0000	: coeff_p1_ff	<= 13'h0210 ;
						7'b10_0_0001	: coeff_p1_ff	<= 13'h021e ;
						7'b10_0_0010	: coeff_p1_ff	<= 13'h022b ;
						7'b10_0_0011	: coeff_p1_ff	<= 13'h0239 ;
						7'b10_0_0100	: coeff_p1_ff	<= 13'h0248 ;
						7'b10_0_0101	: coeff_p1_ff	<= 13'h0255 ;
						7'b10_0_0110	: coeff_p1_ff	<= 13'h0263 ;
						7'b10_0_0111	: coeff_p1_ff	<= 13'h0271 ;
						7'b10_0_1000	: coeff_p1_ff	<= 13'h027f ;
						7'b10_0_1001	: coeff_p1_ff	<= 13'h028d ;
						7'b10_0_1010	: coeff_p1_ff	<= 13'h029a ;
						7'b10_0_1011	: coeff_p1_ff	<= 13'h02a6 ;
						7'b10_0_1100	: coeff_p1_ff	<= 13'h02b4 ;
						7'b10_0_1101	: coeff_p1_ff	<= 13'h02c0 ;
						7'b10_0_1110	: coeff_p1_ff	<= 13'h02cc ;
						7'b10_0_1111	: coeff_p1_ff	<= 13'h02d8 ;
						7'b10_1_0000	: coeff_p1_ff	<= 13'h02e4 ;
						7'b10_1_0001	: coeff_p1_ff	<= 13'h02ef ;
						7'b10_1_0010	: coeff_p1_ff	<= 13'h02f9 ;
						7'b10_1_0011	: coeff_p1_ff	<= 13'h0304 ;
						7'b10_1_0100	: coeff_p1_ff	<= 13'h030d ;
						7'b10_1_0101	: coeff_p1_ff	<= 13'h0316 ;
						7'b10_1_0110	: coeff_p1_ff	<= 13'h031f ;
						7'b10_1_0111	: coeff_p1_ff	<= 13'h0327 ;
						7'b10_1_1000	: coeff_p1_ff	<= 13'h032e ;
						7'b10_1_1001	: coeff_p1_ff	<= 13'h0334 ;
						7'b10_1_1010	: coeff_p1_ff	<= 13'h033a ;
						7'b10_1_1011	: coeff_p1_ff	<= 13'h0340 ;
						7'b10_1_1100	: coeff_p1_ff	<= 13'h0345 ;
						7'b10_1_1101	: coeff_p1_ff	<= 13'h0349 ;
						7'b10_1_1110	: coeff_p1_ff	<= 13'h034c ;
						7'b10_1_1111	: coeff_p1_ff	<= 13'h034f ;

						7'b11_0_0000	: coeff_p1_ff	<= 13'h021a ;
						7'b11_0_0001	: coeff_p1_ff	<= 13'h021e ;
						7'b11_0_0010	: coeff_p1_ff	<= 13'h0223 ;
						7'b11_0_0011	: coeff_p1_ff	<= 13'h0227 ;
						7'b11_0_0100	: coeff_p1_ff	<= 13'h022c ;
						7'b11_0_0101	: coeff_p1_ff	<= 13'h0230 ;
						7'b11_0_0110	: coeff_p1_ff	<= 13'h0234 ;
						7'b11_0_0111	: coeff_p1_ff	<= 13'h0239 ;
						7'b11_0_1000	: coeff_p1_ff	<= 13'h023d ;
						7'b11_0_1001	: coeff_p1_ff	<= 13'h0241 ;
						7'b11_0_1010	: coeff_p1_ff	<= 13'h0245 ;
						7'b11_0_1011	: coeff_p1_ff	<= 13'h0249 ;
						7'b11_0_1100	: coeff_p1_ff	<= 13'h024e ;
						7'b11_0_1101	: coeff_p1_ff	<= 13'h0251 ;
						7'b11_0_1110	: coeff_p1_ff	<= 13'h0255 ;
						7'b11_0_1111	: coeff_p1_ff	<= 13'h0259 ;
						7'b11_1_0000	: coeff_p1_ff	<= 13'h025c ;
						7'b11_1_0001	: coeff_p1_ff	<= 13'h0260 ;
						7'b11_1_0010	: coeff_p1_ff	<= 13'h0263 ;
						7'b11_1_0011	: coeff_p1_ff	<= 13'h0267 ;
						7'b11_1_0100	: coeff_p1_ff	<= 13'h026a ;
						7'b11_1_0101	: coeff_p1_ff	<= 13'h026d ;
						7'b11_1_0110	: coeff_p1_ff	<= 13'h026f ;
						7'b11_1_0111	: coeff_p1_ff	<= 13'h0273 ;
						7'b11_1_1000	: coeff_p1_ff	<= 13'h0276 ;
						7'b11_1_1001	: coeff_p1_ff	<= 13'h0278 ;
						7'b11_1_1010	: coeff_p1_ff	<= 13'h027a ;
						7'b11_1_1011	: coeff_p1_ff	<= 13'h027d ;
						7'b11_1_1100	: coeff_p1_ff	<= 13'h027f ;
						7'b11_1_1101	: coeff_p1_ff	<= 13'h0281 ;
						7'b11_1_1110	: coeff_p1_ff	<= 13'h0283 ;
						7'b11_1_1111	: coeff_p1_ff	<= 13'h0284 ;
						default			: coeff_p1_ff	<= {13{1'bx}} ;
					endcase
				end
			end

			always @(  posedge clk or negedge rst_n ) begin
				if ( !rst_n ) begin
					coeff_p2_ff		<= 13'h0000 ;
				end
				else if ( enable ) begin
					case ( { s_i , x_i } )
						7'b00_0_0000	: coeff_p2_ff	<= 13'h0000 ;
						7'b00_0_0001	: coeff_p2_ff	<= 13'h0000 ;
						7'b00_0_0010	: coeff_p2_ff	<= 13'h0000 ;
						7'b00_0_0011	: coeff_p2_ff	<= 13'h0002 ;
						7'b00_0_0100	: coeff_p2_ff	<= 13'h0003 ;
						7'b00_0_0101	: coeff_p2_ff	<= 13'h0005 ;
						7'b00_0_0110	: coeff_p2_ff	<= 13'h0007 ;
						7'b00_0_0111	: coeff_p2_ff	<= 13'h0008 ;
						7'b00_0_1000	: coeff_p2_ff	<= 13'h000b ;
						7'b00_0_1001	: coeff_p2_ff	<= 13'h000d ;
						7'b00_0_1010	: coeff_p2_ff	<= 13'h000f ;
						7'b00_0_1011	: coeff_p2_ff	<= 13'h0012 ;
						7'b00_0_1100	: coeff_p2_ff	<= 13'h0015 ;
						7'b00_0_1101	: coeff_p2_ff	<= 13'h0018 ;
						7'b00_0_1110	: coeff_p2_ff	<= 13'h001a ;
						7'b00_0_1111	: coeff_p2_ff	<= 13'h001d ;
						7'b00_1_0000	: coeff_p2_ff	<= 13'h0020 ;
						7'b00_1_0001	: coeff_p2_ff	<= 13'h0023 ;
						7'b00_1_0010	: coeff_p2_ff	<= 13'h0027 ;
						7'b00_1_0011	: coeff_p2_ff	<= 13'h002b ;
						7'b00_1_0100	: coeff_p2_ff	<= 13'h0030 ;
						7'b00_1_0101	: coeff_p2_ff	<= 13'h0036 ;
						7'b00_1_0110	: coeff_p2_ff	<= 13'h003d ;
						7'b00_1_0111	: coeff_p2_ff	<= 13'h0045 ;
						7'b00_1_1000	: coeff_p2_ff	<= 13'h004d ;
						7'b00_1_1001	: coeff_p2_ff	<= 13'h0058 ;
						7'b00_1_1010	: coeff_p2_ff	<= 13'h0064 ;
						7'b00_1_1011	: coeff_p2_ff	<= 13'h0072 ;
						7'b00_1_1100	: coeff_p2_ff	<= 13'h0082 ;
						7'b00_1_1101	: coeff_p2_ff	<= 13'h0094 ;
						7'b00_1_1110	: coeff_p2_ff	<= 13'h00a8 ;
						7'b00_1_1111	: coeff_p2_ff	<= 13'h00c0 ;

						7'b01_0_0000	: coeff_p2_ff	<= 13'h0039 ;
						7'b01_0_0001	: coeff_p2_ff	<= 13'h003d ;
						7'b01_0_0010	: coeff_p2_ff	<= 13'h0041 ;
						7'b01_0_0011	: coeff_p2_ff	<= 13'h0045 ;
						7'b01_0_0100	: coeff_p2_ff	<= 13'h004a ;
						7'b01_0_0101	: coeff_p2_ff	<= 13'h004f ;
						7'b01_0_0110	: coeff_p2_ff	<= 13'h0056 ;
						7'b01_0_0111	: coeff_p2_ff	<= 13'h005c ;
						7'b01_0_1000	: coeff_p2_ff	<= 13'h0063 ;
						7'b01_0_1001	: coeff_p2_ff	<= 13'h006b ;
						7'b01_0_1010	: coeff_p2_ff	<= 13'h0074 ;
						7'b01_0_1011	: coeff_p2_ff	<= 13'h007c ;
						7'b01_0_1100	: coeff_p2_ff	<= 13'h0086 ;
						7'b01_0_1101	: coeff_p2_ff	<= 13'h0091 ;
						7'b01_0_1110	: coeff_p2_ff	<= 13'h009c ;
						7'b01_0_1111	: coeff_p2_ff	<= 13'h00a8 ;
						7'b01_1_0000	: coeff_p2_ff	<= 13'h00b4 ;
						7'b01_1_0001	: coeff_p2_ff	<= 13'h00c1 ;
						7'b01_1_0010	: coeff_p2_ff	<= 13'h00d0 ;
						7'b01_1_0011	: coeff_p2_ff	<= 13'h00de ;
						7'b01_1_0100	: coeff_p2_ff	<= 13'h00ee ;
						7'b01_1_0101	: coeff_p2_ff	<= 13'h00fe ;
						7'b01_1_0110	: coeff_p2_ff	<= 13'h010f ;
						7'b01_1_0111	: coeff_p2_ff	<= 13'h0121 ;
						7'b01_1_1000	: coeff_p2_ff	<= 13'h0133 ;
						7'b01_1_1001	: coeff_p2_ff	<= 13'h0147 ;
						7'b01_1_1010	: coeff_p2_ff	<= 13'h015a ;
						7'b01_1_1011	: coeff_p2_ff	<= 13'h016f ;
						7'b01_1_1100	: coeff_p2_ff	<= 13'h0184 ;
						7'b01_1_1101	: coeff_p2_ff	<= 13'h019a ;
						7'b01_1_1110	: coeff_p2_ff	<= 13'h01b0 ;
						7'b01_1_1111	: coeff_p2_ff	<= 13'h01c7 ;

						7'b10_0_0000	: coeff_p2_ff	<= 13'h008f ;
						7'b10_0_0001	: coeff_p2_ff	<= 13'h0094 ;
						7'b10_0_0010	: coeff_p2_ff	<= 13'h009b ;
						7'b10_0_0011	: coeff_p2_ff	<= 13'h00a1 ;
						7'b10_0_0100	: coeff_p2_ff	<= 13'h00a7 ;
						7'b10_0_0101	: coeff_p2_ff	<= 13'h00af ;
						7'b10_0_0110	: coeff_p2_ff	<= 13'h00b7 ;
						7'b10_0_0111	: coeff_p2_ff	<= 13'h00bf ;
						7'b10_0_1000	: coeff_p2_ff	<= 13'h00c7 ;
						7'b10_0_1001	: coeff_p2_ff	<= 13'h00d0 ;
						7'b10_0_1010	: coeff_p2_ff	<= 13'h00d9 ;
						7'b10_0_1011	: coeff_p2_ff	<= 13'h00e4 ;
						7'b10_0_1100	: coeff_p2_ff	<= 13'h00ee ;
						7'b10_0_1101	: coeff_p2_ff	<= 13'h00f9 ;
						7'b10_0_1110	: coeff_p2_ff	<= 13'h0105 ;
						7'b10_0_1111	: coeff_p2_ff	<= 13'h0110 ;
						7'b10_1_0000	: coeff_p2_ff	<= 13'h011c ;
						7'b10_1_0001	: coeff_p2_ff	<= 13'h0129 ;
						7'b10_1_0010	: coeff_p2_ff	<= 13'h0136 ;
						7'b10_1_0011	: coeff_p2_ff	<= 13'h0143 ;
						7'b10_1_0100	: coeff_p2_ff	<= 13'h0151 ;
						7'b10_1_0101	: coeff_p2_ff	<= 13'h0160 ;
						7'b10_1_0110	: coeff_p2_ff	<= 13'h016e ;
						7'b10_1_0111	: coeff_p2_ff	<= 13'h017d ;
						7'b10_1_1000	: coeff_p2_ff	<= 13'h018d ;
						7'b10_1_1001	: coeff_p2_ff	<= 13'h019c ;
						7'b10_1_1010	: coeff_p2_ff	<= 13'h01ac ;
						7'b10_1_1011	: coeff_p2_ff	<= 13'h01bc ;
						7'b10_1_1100	: coeff_p2_ff	<= 13'h01cc ;
						7'b10_1_1101	: coeff_p2_ff	<= 13'h01dd ;
						7'b10_1_1110	: coeff_p2_ff	<= 13'h01ee ;
						7'b10_1_1111	: coeff_p2_ff	<= 13'h01ff ;

						7'b11_0_0000	: coeff_p2_ff	<= 13'h0146 ;
						7'b11_0_0001	: coeff_p2_ff	<= 13'h014b ;
						7'b11_0_0010	: coeff_p2_ff	<= 13'h0150 ;
						7'b11_0_0011	: coeff_p2_ff	<= 13'h0155 ;
						7'b11_0_0100	: coeff_p2_ff	<= 13'h015a ;
						7'b11_0_0101	: coeff_p2_ff	<= 13'h015f ;
						7'b11_0_0110	: coeff_p2_ff	<= 13'h0165 ;
						7'b11_0_0111	: coeff_p2_ff	<= 13'h016b ;
						7'b11_0_1000	: coeff_p2_ff	<= 13'h0170 ;
						7'b11_0_1001	: coeff_p2_ff	<= 13'h0176 ;
						7'b11_0_1010	: coeff_p2_ff	<= 13'h017d ;
						7'b11_0_1011	: coeff_p2_ff	<= 13'h0183 ;
						7'b11_0_1100	: coeff_p2_ff	<= 13'h0189 ;
						7'b11_0_1101	: coeff_p2_ff	<= 13'h0190 ;
						7'b11_0_1110	: coeff_p2_ff	<= 13'h0196 ;
						7'b11_0_1111	: coeff_p2_ff	<= 13'h019d ;
						7'b11_1_0000	: coeff_p2_ff	<= 13'h01a4 ;
						7'b11_1_0001	: coeff_p2_ff	<= 13'h01ab ;
						7'b11_1_0010	: coeff_p2_ff	<= 13'h01b2 ;
						7'b11_1_0011	: coeff_p2_ff	<= 13'h01b8 ;
						7'b11_1_0100	: coeff_p2_ff	<= 13'h01c0 ;
						7'b11_1_0101	: coeff_p2_ff	<= 13'h01c7 ;
						7'b11_1_0110	: coeff_p2_ff	<= 13'h01cf ;
						7'b11_1_0111	: coeff_p2_ff	<= 13'h01d6 ;
						7'b11_1_1000	: coeff_p2_ff	<= 13'h01dd ;
						7'b11_1_1001	: coeff_p2_ff	<= 13'h01e5 ;
						7'b11_1_1010	: coeff_p2_ff	<= 13'h01ed ;
						7'b11_1_1011	: coeff_p2_ff	<= 13'h01f4 ;
						7'b11_1_1100	: coeff_p2_ff	<= 13'h01fc ;
						7'b11_1_1101	: coeff_p2_ff	<= 13'h0203 ;
						7'b11_1_1110	: coeff_p2_ff	<= 13'h020a ;
						7'b11_1_1111	: coeff_p2_ff	<= 13'h0213 ;
						default			: coeff_p2_ff	<= {13{1'bx}} ;
					endcase
				end
			end
		end
	endgenerate

	assign coeff_m1_o	= coeff_m1_ff ;
	assign coeff_zr_o	= coeff_zr_ff ;
	assign coeff_p1_o	= coeff_p1_ff ;
	assign coeff_p2_o	= coeff_p2_ff ;

endmodule

`default_nettype wire
