//----------------------------------------------------------------------------------------
//Copyright (C) 2012 Macnica Inc. All Rights Reserved.
//
//Use in source and binary forms, with or without modification, are permitted provided
//by agreeing to the following terms and conditions:
//
//REDISTRIBUTIONS OR SUBLICENSING IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS "AS IS"
//AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE
//FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
//SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
//CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
//OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//AND ALSO REGARDING THE REFERENCE SOFTWARE, REDISTRIBUTION OR SUBLICENSING
//IN SOURCE AND BINARY FORM ARE NOT ALLOWED.
//----------------------------------------------------------------------------------------
// DESCRIPTION
//		input buffer
//----------------------------------------------------------------------------------------
// REVISION HISTORY
//		v1.0 Nov. 06 2012	: Initial version release
//		v1.1 May  28 2013	: Signal base_param_valid_i and base_field_i are added to wait until valid frame is input
//		v1.2 May  28 2013	: Fix bug that ready_o is set for 2or3 clocks long at start timing of output frame
//		v1.3 Jun. 04 2013	: ~next_frame_ff is added to set condition of valid_lat#_ff
//		v1.4 Jun. 13 2013	: fld_diff_nxt_frm_ff is added in case new frame_start is received but make waited until field status is match
//		v1.5 Mar. 27 2014	: ready_o_ff is not set during end_flag_lat_adj==1
//----------------------------------------------------------------------------------------
// PARAMETERS
//		SIZE_BIT		: number of significant figures
//		PIXEL_BIT		: number of significant figures
//
//----------------------------------------------------------------------------------------
// I/O PORTS
//		clk 			: clock for all circuit
//		rst_n			: asynchronous reset ( low active )
//		srst			: synchronous reset
//		enable			: clock enable
//
//		count_en_i		: outside sirsuit counter enable
//		end_flag_i		: outside sirsuit frame end output
//		ready_i			: data reception ready
//
//		valid_i			: data valid of input frame data
//		frame_start_i	: frame start of input frame data
//		frame_end_i		: frame end of input frame data
//		pixel_i			: pixel data of input frame data
//		field_i			: field status of input frame data  1:even field  0:odd field
//		width_i			: horizontal size of input frame data
//		height_i		: vertical size of input frame data
//		ready_o			: data reception ready of input frame data
//
//		rd_i			: read buffer
//		valid_o			: data valid of buffer data
//		pixel_o			: pixel data of buffer data
//		field_o			: field status of buffer data
//		width_o			: horizontal size of buffer data
//		height_o		: vertical size of buffer data
//
//		frame_start_o	: frame period
//		next_frame_o	: next frame input start
//
//----------------------------------------------------------------------------------------
`timescale 1ps/1ps
`default_nettype none

module	pc11_in_buf (
	clk					,
	rst_n				,
	srst				,
	enable				,

	count_en_i			,
	end_flag_i			,
	ready_i				,
	end_flag_set_i		, //v1.5

	base_param_valid_i	, //v1.1
	base_field_i		, //v1.1

	ch_on_i				, //v1.2

	valid_i				,
	frame_start_i		,
	frame_end_i			,
	pixel_i				,
	field_i				,
	width_i				,
	height_i			,
	ready_o				,

	rd_i				,
	valid_o				,
	pixel_o				,
	field_o				,
	width_o				,
	height_o			,
	frame_start_o		,
	next_frame_o
	) ;


// =============================================================================
// PARAMETER DEFINITION
// =============================================================================

	// ---------------------------------------------------------------------
	// Below parameters have to be defined from upper module
	// ---------------------------------------------------------------------
	parameter	SIZE_BIT			= 12 ;
	parameter	PIXEL_BIT			= 24 ;

	// ---------------------------------------------------------------------
	// Please do not change the following parameters
	// ---------------------------------------------------------------------


// =============================================================================
// PORT DECLARATION
// =============================================================================
	input	wire							clk					;
	input	wire							rst_n				;
	input	wire							srst				;
	input	wire							enable				;

	input	wire							count_en_i			;
	input	wire							end_flag_i			;
	input	wire							ready_i				;
	input	wire							end_flag_set_i		; //v1.5

	input	wire							base_param_valid_i	; //v1.1
	input	wire							base_field_i		; //v1.1

	input	wire							ch_on_i				; //v1.2

	input	wire							valid_i				;
	input	wire							frame_start_i		;
	input	wire							frame_end_i			;
	input	wire	[ PIXEL_BIT-1 : 0 ]		pixel_i				;
	input	wire							field_i				;
	input	wire	[  SIZE_BIT-1 : 0 ]		width_i				;
	input	wire	[  SIZE_BIT-1 : 0 ]		height_i			;
	output	wire							ready_o				;

	input	wire							rd_i				;
	output	wire							valid_o				;
	output	wire	[ PIXEL_BIT-1 : 0 ]		pixel_o				;
	output	wire							field_o				;
	output	wire	[  SIZE_BIT-1 : 0 ]		width_o				;
	output	wire	[  SIZE_BIT-1 : 0 ]		height_o			;
	output	wire							frame_start_o		;
	output	wire							next_frame_o		;


// =============================================================================
// REG / WIRE DECLARATION
// =============================================================================
	wire							frame_start			;
	wire							frame_end			;
	wire							we					;

	reg								frame_start_ff		;
	reg								frame_end_ff		;
	reg								field_ff			;
	reg		[  SIZE_BIT-1 : 0 ]		width_ff			;
	reg		[  SIZE_BIT-1 : 0 ]		height_ff			;

	reg								next_frame_ff		;
	reg								fld_diff_nxt_frm_ff	; //v1.4
	reg								next_field_ff		;
	reg		[  SIZE_BIT-1 : 0 ]		next_width_ff		;
	reg		[  SIZE_BIT-1 : 0 ]		next_height_ff		;

	reg								valid_lat1_ff		;
	reg								valid_lat2_ff		;
	reg		[ PIXEL_BIT-1 : 0 ]		pixel_lat1_ff		;
	reg		[ PIXEL_BIT-1 : 0 ]		pixel_lat2_ff		;
	reg								frame_end_lat1_ff	;
	reg								frame_end_lat2_ff	;
	reg								ready_o_ff			;


// =============================================================================
// FUNCTION DESCRIPTION
// =============================================================================

	assign	frame_start	= ready_o_ff & valid_i & frame_start_i & ( pixel_i[3:0]==4'h0 ) ;
	assign	frame_end	= valid_i & frame_end_i & ready_o_ff ;
//	assign	we			= ( frame_start_ff | next_frame_ff ) & valid_i & ~frame_start_i & ready_o_ff ;
	assign	we			= ( frame_start_ff | next_frame_ff | fld_diff_nxt_frm_ff ) & valid_i & ~frame_start_i & ready_o_ff ; //v1.4

	always @ ( posedge clk or negedge rst_n ) begin
		if ( !rst_n ) begin
			frame_start_ff	<= 1'b0 ;
		end
		else if ( srst ) begin
			frame_start_ff	<= 1'b0 ;
		end
		else if ( enable ) begin
			if ( ( !count_en_i && frame_start ) ||
				 ( count_en_i && frame_start && ( !frame_end_ff || end_flag_i ) ) ) begin
				frame_start_ff	<= 1'b1 ;
			end
			else if ( end_flag_i && ready_i ) begin
//				frame_start_ff	<= next_frame_ff ;
				frame_start_ff	<= ( next_frame_ff | fld_diff_nxt_frm_ff ) ; //v1.4
			end
		end
	end

	always @ ( posedge clk or negedge rst_n ) begin
		if ( !rst_n ) begin
			frame_end_ff	<= 1'b0 ;
		end
		else if ( srst ) begin
			frame_end_ff	<= 1'b0 ;
		end
		else if ( enable ) begin
			if ( end_flag_i && ready_i ) begin
				frame_end_ff	<= 1'b0 ;
			end
			else if ( frame_start_ff && frame_end ) begin
				frame_end_ff	<= 1'b1 ;
			end
		end
	end

	always @ ( posedge clk or negedge rst_n ) begin
		if ( !rst_n ) begin
			field_ff	<= 1'b0 ;
			width_ff	<= { SIZE_BIT{1'b0} } ;
			height_ff	<= { SIZE_BIT{1'b0} } ;
		end
		else if ( srst ) begin
			field_ff	<= 1'b0 ;
			width_ff	<= { SIZE_BIT{1'b0} } ;
			height_ff	<= { SIZE_BIT{1'b0} } ;
		end
		else if ( enable ) begin
			if ( ( !count_en_i && frame_start ) ||
				 ( count_en_i && frame_start && ( !frame_end_ff || end_flag_i ) ) ) begin
				field_ff	<= field_i ;
				width_ff	<= width_i ;
				height_ff	<= height_i ;
			end
//			else if ( ready_i && end_flag_i && next_frame_ff ) begin
			else if ( ready_i && end_flag_i && ( next_frame_ff || fld_diff_nxt_frm_ff ) ) begin  //v1.4
				field_ff	<= next_field_ff  ;
				width_ff	<= next_width_ff ;
				height_ff	<= next_height_ff ;
			end
		end
	end

	always @ ( posedge clk or negedge rst_n ) begin
		if ( !rst_n ) begin
			next_frame_ff		<= 1'b0 ;
			fld_diff_nxt_frm_ff	<= 1'b0 ;	//v1.4
			next_field_ff		<= 1'b0 ;
			next_width_ff		<= { SIZE_BIT{1'b0} } ;
			next_height_ff		<= { SIZE_BIT{1'b0} } ;
		end
		else if ( srst ) begin
			next_frame_ff		<= 1'b0 ;
			fld_diff_nxt_frm_ff	<= 1'b0 ;	//v1.4
			next_field_ff		<= 1'b0 ;
			next_width_ff		<= { SIZE_BIT{1'b0} } ;
			next_height_ff		<= { SIZE_BIT{1'b0} } ;
		end
		else if ( enable ) begin
			if ( count_en_i && !end_flag_i && frame_start && frame_start_ff ) begin
				next_frame_ff		<= 1'b1					;
				fld_diff_nxt_frm_ff	<= 1'b0					;	//v1.4
				next_field_ff		<= field_i				;
				next_width_ff		<= width_i				;
				next_height_ff		<= height_i				;
			end
//			else if ( count_en_i && !end_flag_i && frame_start_ff && base_param_valid_i && (base_field_i != field_ff)) begin //v1.1
			else if ( count_en_i && !end_flag_i && frame_start_ff && base_param_valid_i && (base_field_i != field_ff) && ch_on_i ) begin	//v1.2
//				next_frame_ff	<= 1'b1 ;		//v1.1
				next_frame_ff		<= 1'b0					;	//v1.4
				fld_diff_nxt_frm_ff	<= 1'b1					;	//v1.4
				next_field_ff		<= field_ff				;	//v1.1
				next_width_ff		<= width_ff				;	//v1.1
				next_height_ff		<= height_ff			;	//v1.1
			end											//v1.1
			else if ( end_flag_i && ready_i ) begin
				next_frame_ff		<= 1'b0					;
				fld_diff_nxt_frm_ff	<= 1'b0					;	//v1.4
				next_field_ff		<= next_field_ff		;
				next_width_ff		<= next_width_ff		;
				next_height_ff		<= next_height_ff		;
			end
		end
	end

	always @ ( posedge clk or negedge rst_n ) begin
		if ( !rst_n ) begin
			valid_lat1_ff	<= 1'b0 ;
		end
		else if ( srst ) begin
			valid_lat1_ff	<= 1'b0 ;
		end
		else if ( enable ) begin
//			if ( end_flag_i && ready_i ) begin
//			if ( end_flag_i && ready_i && ~next_frame_ff ) begin				//v1.3
			if ( end_flag_i && ready_i && ~fld_diff_nxt_frm_ff ) begin			//v1.4
				valid_lat1_ff	<= 1'b0 ;
			end
			else if ( we && !valid_lat1_ff ) begin
				valid_lat1_ff	<= 1'b1 ;
			end
			else if ( !we && rd_i && !valid_lat2_ff ) begin
				valid_lat1_ff	<= 1'b0 ;
			end
		end
	end

	always @ ( posedge clk or negedge rst_n ) begin
		if ( !rst_n ) begin
			valid_lat2_ff	<= 1'b0 ;
		end
		else if ( srst ) begin
			valid_lat2_ff	<= 1'b0 ;
		end
		else if ( enable ) begin
//			if ( end_flag_i && ready_i ) begin
//			if ( end_flag_i && ready_i && ~next_frame_ff ) begin				//v1.3
			if ( end_flag_i && ready_i && ~fld_diff_nxt_frm_ff ) begin			//v1.4
				valid_lat2_ff	<= 1'b0 ;
			end
			else if ( we && !rd_i ) begin
				valid_lat2_ff	<= valid_lat1_ff ;
			end
			else if ( !we && rd_i ) begin
				valid_lat2_ff	<= 1'b0 ;
			end
		end
	end

	always @ ( posedge clk or negedge rst_n ) begin
		if ( !rst_n ) begin
			pixel_lat1_ff	<= {PIXEL_BIT{1'b0}} ;
			pixel_lat2_ff	<= {PIXEL_BIT{1'b0}} ;
		end
		else if ( srst ) begin
			pixel_lat1_ff	<= {PIXEL_BIT{1'b0}} ;
			pixel_lat2_ff	<= {PIXEL_BIT{1'b0}} ;
		end
		else if ( enable ) begin
			if ( we ) begin
				pixel_lat1_ff	<= pixel_i ;
				pixel_lat2_ff	<= pixel_lat1_ff ;
			end
		end
	end

	always @ ( posedge clk or negedge rst_n ) begin
		if ( !rst_n ) begin
			frame_end_lat1_ff	<= 1'b0 ;
			frame_end_lat2_ff	<= 1'b0 ;
		end
		else if ( srst ) begin
			frame_end_lat1_ff	<= 1'b0 ;
			frame_end_lat2_ff	<= 1'b0 ;
		end
		else if ( enable ) begin
			if ( end_flag_i ) begin
				frame_end_lat1_ff	<= 1'b0 ;
				frame_end_lat2_ff	<= 1'b0 ;
			end
			else if ( we ) begin
				frame_end_lat1_ff	<= frame_end_ff ;
				frame_end_lat2_ff	<= frame_end_lat1_ff ;
			end
		end
	end

	always @ ( posedge clk or negedge rst_n ) begin
		if ( !rst_n ) begin
			ready_o_ff	<= 1'b0 ;
		end
		else if ( srst ) begin
			ready_o_ff	<= 1'b0 ;
		end
		else if ( enable ) begin
//			if ( ( frame_start_ff && frame_start ) || frame_end_ff || next_frame_ff ) begin
//v1.5			if ( ( frame_start_ff && frame_start ) || frame_end_ff || next_frame_ff || fld_diff_nxt_frm_ff ) begin		//v1.4
			if ( ( frame_start_ff && frame_start ) || frame_end_ff || next_frame_ff || fld_diff_nxt_frm_ff || end_flag_set_i || end_flag_i ) begin //v1.5
				ready_o_ff	<= 1'b0 ;
			end
			else if ( !frame_start && !frame_start_ff ) begin
				ready_o_ff	<= 1'b1 ;
			end
			else if ( valid_lat1_ff && we && !rd_i ) begin
				ready_o_ff	<= 1'b0 ;
			end
			else if ( ( !we && rd_i ) || ( !we && !rd_i && !valid_lat2_ff ) ) begin
				ready_o_ff	<= 1'b1 ;
			end
		end
	end

//	assign	valid_o			= ( next_frame_ff ) |
//							  ( ( ~frame_end_lat1_ff & valid_lat1_ff ) |
//							    ( ~frame_end_lat2_ff & valid_lat2_ff ) ) |
//							  frame_end_ff ;

//v1.4
	assign	valid_o			= ( next_frame_ff | fld_diff_nxt_frm_ff )
							  | ( ( ~frame_end_lat1_ff & valid_lat1_ff ) | ( ~frame_end_lat2_ff & valid_lat2_ff ) )
							  | frame_end_ff ;

	assign	pixel_o			= ( valid_lat2_ff ) ? pixel_lat2_ff : pixel_lat1_ff ;
	assign	field_o			= field_ff ;
	assign	width_o			= width_ff ;
	assign	height_o		= height_ff ;
	assign	frame_start_o	= frame_start_ff ;
//	assign	next_frame_o	= next_frame_ff ;
	assign	next_frame_o	= ( next_frame_ff | fld_diff_nxt_frm_ff ) ;		//v1.4
	assign	ready_o			= ready_o_ff ;


endmodule

`default_nettype wire
