module xcvr_rx (
		input  wire [0:0]  i_rx_cdr_refclk_p,    //    i_rx_cdr_refclk_p.clk,                  The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]  i_pma_cu_clk,         //         i_pma_cu_clk.clk,                  The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]  i_rx_reset,           //           i_rx_reset.rx_reset,             RX reset input for RX XCVRs and RX datapath. Must be kept asserted until rx_reset_ack is asserted.
		output wire [0:0]  o_rx_reset_ack,       //       o_rx_reset_ack.rx_reset_ack,         RX fully in reset indicator.
		output wire [0:0]  o_rx_ready,           //           o_rx_ready.rx_ready,             RX de-skew NOT enabled: Status port to indicate when RX XCVRs and RX datapath are reset successfully and ready for data transfer. RX de-skew enabled: Status port to indicate when RX XCVRs and RX datapath are reset successfully, RX de-skew is done, and ready for data transfer.
		input  wire        i_rx_coreclkin,       //       i_rx_coreclkin.i_rx_coreclkin,       RX parallel clock input.
		output wire        o_rx_clkout,          //          o_rx_clkout.o_rx_clkout,          Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		input  wire [0:0]  i_src_rs_grant,       //       i_src_rs_grant.src_rs_grant,         Grant Signal
		output wire [0:0]  o_src_rs_req,         //         o_src_rs_req.src_rs_req,           Request Signal
		input  wire [0:0]  i_rx_serial_data,     //     i_rx_serial_data.i_rx_serial_data,     RX serial data port.
		input  wire [0:0]  i_rx_serial_data_n,   //   i_rx_serial_data_n.i_rx_serial_data_n,   Differential pair for RX serial data port. Historically was hidden; however now used in pam4 signal simulation model, hence needs to be connected by user.
		output wire [0:0]  o_rx_is_lockedtodata, // o_rx_is_lockedtodata.o_rx_is_lockedtodata, RX CDR data lock status signal. 1`b0: CDR is not locked to data. 1`b1: CDR is locked to data.
		output wire [0:0]  o_rx_is_lockedtoref,  //  o_rx_is_lockedtoref.o_rx_is_lockedtoref,  CDR lock status signal. 1`b1 - CDR is frequency locked to reference clock within the PPM threshold, 1`b0 - CDR is not frequency locked within the PPM threshold.
		output wire [79:0] o_rx_parallel_data    //   o_rx_parallel_data.o_rx_parallel_data,   RX parallel data.
	);
endmodule

