// xcvr_rx.v

// Generated using ACDS version 25.3 109

`timescale 1 ps / 1 ps
module xcvr_rx (
		input  wire [0:0]  i_rx_cdr_refclk_p,    //    i_rx_cdr_refclk_p.clk,                  The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]  i_pma_cu_clk,         //         i_pma_cu_clk.clk,                  The connection made from "Reference and SystemPLL Clocks IP" to this pin will guide Quartus on properly setting clock network.
		input  wire [0:0]  i_rx_reset,           //           i_rx_reset.rx_reset,             RX reset input for RX XCVRs and RX datapath. Must be kept asserted until rx_reset_ack is asserted.
		output wire [0:0]  o_rx_reset_ack,       //       o_rx_reset_ack.rx_reset_ack,         RX fully in reset indicator.
		output wire [0:0]  o_rx_ready,           //           o_rx_ready.rx_ready,             RX de-skew NOT enabled: Status port to indicate when RX XCVRs and RX datapath are reset successfully and ready for data transfer. RX de-skew enabled: Status port to indicate when RX XCVRs and RX datapath are reset successfully, RX de-skew is done, and ready for data transfer.
		input  wire        i_rx_coreclkin,       //       i_rx_coreclkin.i_rx_coreclkin,       RX parallel clock input.
		output wire        o_rx_clkout,          //          o_rx_clkout.o_rx_clkout,          Clockout ports are driven by word, bond or system pll clocks depending on customer selection for the source.
		input  wire [0:0]  i_src_rs_grant,       //       i_src_rs_grant.src_rs_grant,         Grant Signal
		output wire [0:0]  o_src_rs_req,         //         o_src_rs_req.src_rs_req,           Request Signal
		input  wire [0:0]  i_rx_serial_data,     //     i_rx_serial_data.i_rx_serial_data,     RX serial data port.
		input  wire [0:0]  i_rx_serial_data_n,   //   i_rx_serial_data_n.i_rx_serial_data_n,   Differential pair for RX serial data port. Historically was hidden; however now used in pam4 signal simulation model, hence needs to be connected by user.
		output wire [0:0]  o_rx_is_lockedtodata, // o_rx_is_lockedtodata.o_rx_is_lockedtodata, RX CDR data lock status signal. 1`b0: CDR is not locked to data. 1`b1: CDR is locked to data.
		output wire [0:0]  o_rx_is_lockedtoref,  //  o_rx_is_lockedtoref.o_rx_is_lockedtoref,  CDR lock status signal. 1`b1 - CDR is frequency locked to reference clock within the PPM threshold, 1`b0 - CDR is not frequency locked within the PPM threshold.
		output wire [79:0] o_rx_parallel_data    //   o_rx_parallel_data.o_rx_parallel_data,   RX parallel data.
	);

	xcvr_rx_intel_directphy_gts_1000_6m63gti #(
		.num_sys_cop                                   (1),
		.prof0_num_sys_cop                             (1),
		.refclk_recovery_en                            (0),
		.rcfg_group                                    ("lanes-1"),
		.num_xcvr_per_sys                              (1),
		.duplex_mode                                   ("rx"),
		.rx_deskew_en                                  (0),
		.l_num_aib_per_xcvr                            (1),
		.l_sys_xcvrs                                   (1),
		.l_quad_num                                    (1),
		.l_sys_xcvrs_cascade                           (1),
		.l_sys_aibs                                    (1),
		.l_tx_enable                                   (0),
		.l_rx_enable                                   (1),
		.fec_en                                        (0),
		.l_fec_mode                                    ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.l_av1_enable                                  (0),
		.avmm1_readdv_enable                           (1),
		.avmm1_split                                   (0),
		.avmm1_jtag_enable                             (0),
		.l_av1_aib_enable                              (0),
		.l_soft_csr_enable                             (0),
		.l_soft_csr_enable_rphy                        (0),
		.l_num_avmm1                                   (1),
		.l_av1_ifaces                                  (1),
		.l_av1_addr_bits                               (18),
		.l_line_rate_p1ghz                             (48),
		.l_av1_enable_rphy                             (0),
		.avmm1_readdv_enable_rphy                      (1),
		.avmm1_jtag_enable_rphy                        (0),
		.silicon_revision                              ("14nm5bcr3a"),
		.device_revision                               ("14nm5bcr3a"),
		.enable_port_latency_measurement               (0),
		.l_rx_deskew_enable                            (0),
		.txparalleldata_width                          (80),
		.txsimpleinterface_enable                      (0),
		.simulation_sip_only                           (0),
		.simulation_only                               (0),
		.prof0_num_xcvr_per_sys                        (1),
		.prof0_fec_en                                  (0),
		.prof0_l_fec_mode                              ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof0_l_sys_xcvrs                             (1),
		.prof1_num_xcvr_per_sys                        (1),
		.prof1_fec_en                                  (0),
		.prof1_l_fec_mode                              ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof1_l_sys_xcvrs                             (1),
		.prof2_num_xcvr_per_sys                        (1),
		.prof2_fec_en                                  (0),
		.prof2_l_fec_mode                              ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof2_l_sys_xcvrs                             (1),
		.prof3_num_xcvr_per_sys                        (1),
		.prof3_fec_en                                  (0),
		.prof3_l_fec_mode                              ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof3_l_sys_xcvrs                             (1),
		.prof4_num_xcvr_per_sys                        (1),
		.prof4_fec_en                                  (0),
		.prof4_l_fec_mode                              ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof4_l_sys_xcvrs                             (1),
		.prof5_num_xcvr_per_sys                        (1),
		.prof5_fec_en                                  (0),
		.prof5_l_fec_mode                              ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof5_l_sys_xcvrs                             (1),
		.prof6_num_xcvr_per_sys                        (1),
		.prof6_fec_en                                  (0),
		.prof6_l_fec_mode                              ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof6_l_sys_xcvrs                             (1),
		.prof7_num_xcvr_per_sys                        (1),
		.prof7_fec_en                                  (0),
		.prof7_l_fec_mode                              ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof7_l_sys_xcvrs                             (1),
		.prof8_num_xcvr_per_sys                        (1),
		.prof8_fec_en                                  (0),
		.prof8_l_fec_mode                              ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof8_l_sys_xcvrs                             (1),
		.prof9_num_xcvr_per_sys                        (1),
		.prof9_fec_en                                  (0),
		.prof9_l_fec_mode                              ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof9_l_sys_xcvrs                             (1),
		.prof10_num_xcvr_per_sys                       (1),
		.prof10_fec_en                                 (0),
		.prof10_l_fec_mode                             ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof10_l_sys_xcvrs                            (1),
		.prof11_num_xcvr_per_sys                       (1),
		.prof11_fec_en                                 (0),
		.prof11_l_fec_mode                             ("IEEE 802.3 BASE-R Firecode (CL 74)"),
		.prof11_l_sys_xcvrs                            (1),
		.bb_f_ehip_rx_fec_enable                       ("RX_FEC_ENABLE_DISABLED"),
		.bb_f_ehip_tx_fec_enable                       ("TX_FEC_ENABLE_DISABLED"),
		.bb_f_ehip_xcvr_mode                           ("XCVR_MODE_NRZ"),
		.bb_f_ehip_xcvr_type                           ("XCVR_TYPE_UX"),
		.bb_f_ux_tx_tuning_hint                        ("TX_TUNING_HINT_DISABLED"),
		.bb_f_ux_rx_tuning_hint                        ("RX_TUNING_HINT_DISABLED"),
		.tx_custom_cadence_enable                      (0),
		.enable_port_tx_cadence_slow_clk_locked        (0),
		.pldif_tx_fifo_mode                            ("phase_comp"),
		.pldif_tx_double_width_transfer_enable         (1),
		.pldif_rx_double_width_transfer_enable         (1),
		.prof0_tx_custom_cadence_enable                (0),
		.prof0_enable_port_tx_cadence_slow_clk_locked  (0),
		.prof0_pldif_tx_fifo_mode                      ("phase_comp"),
		.prof0_pldif_tx_double_width_transfer_enable   (1),
		.prof0_pldif_rx_double_width_transfer_enable   (1),
		.prof1_tx_custom_cadence_enable                (0),
		.prof1_enable_port_tx_cadence_slow_clk_locked  (0),
		.prof1_pldif_tx_fifo_mode                      ("phase_comp"),
		.prof1_pldif_tx_double_width_transfer_enable   (1),
		.prof1_pldif_rx_double_width_transfer_enable   (1),
		.prof2_tx_custom_cadence_enable                (0),
		.prof2_enable_port_tx_cadence_slow_clk_locked  (0),
		.prof2_pldif_tx_fifo_mode                      ("phase_comp"),
		.prof2_pldif_tx_double_width_transfer_enable   (1),
		.prof2_pldif_rx_double_width_transfer_enable   (1),
		.prof3_tx_custom_cadence_enable                (0),
		.prof3_enable_port_tx_cadence_slow_clk_locked  (0),
		.prof3_pldif_tx_fifo_mode                      ("phase_comp"),
		.prof3_pldif_tx_double_width_transfer_enable   (1),
		.prof3_pldif_rx_double_width_transfer_enable   (1),
		.prof4_tx_custom_cadence_enable                (0),
		.prof4_enable_port_tx_cadence_slow_clk_locked  (0),
		.prof4_pldif_tx_fifo_mode                      ("phase_comp"),
		.prof4_pldif_tx_double_width_transfer_enable   (1),
		.prof4_pldif_rx_double_width_transfer_enable   (1),
		.prof5_tx_custom_cadence_enable                (0),
		.prof5_enable_port_tx_cadence_slow_clk_locked  (0),
		.prof5_pldif_tx_fifo_mode                      ("phase_comp"),
		.prof5_pldif_tx_double_width_transfer_enable   (1),
		.prof5_pldif_rx_double_width_transfer_enable   (1),
		.prof6_tx_custom_cadence_enable                (0),
		.prof6_enable_port_tx_cadence_slow_clk_locked  (0),
		.prof6_pldif_tx_fifo_mode                      ("phase_comp"),
		.prof6_pldif_tx_double_width_transfer_enable   (1),
		.prof6_pldif_rx_double_width_transfer_enable   (1),
		.prof7_tx_custom_cadence_enable                (0),
		.prof7_enable_port_tx_cadence_slow_clk_locked  (0),
		.prof7_pldif_tx_fifo_mode                      ("phase_comp"),
		.prof7_pldif_tx_double_width_transfer_enable   (1),
		.prof7_pldif_rx_double_width_transfer_enable   (1),
		.prof8_tx_custom_cadence_enable                (0),
		.prof8_enable_port_tx_cadence_slow_clk_locked  (0),
		.prof8_pldif_tx_fifo_mode                      ("phase_comp"),
		.prof8_pldif_tx_double_width_transfer_enable   (1),
		.prof8_pldif_rx_double_width_transfer_enable   (1),
		.prof9_tx_custom_cadence_enable                (0),
		.prof9_enable_port_tx_cadence_slow_clk_locked  (0),
		.prof9_pldif_tx_fifo_mode                      ("phase_comp"),
		.prof9_pldif_tx_double_width_transfer_enable   (1),
		.prof9_pldif_rx_double_width_transfer_enable   (1),
		.prof10_tx_custom_cadence_enable               (0),
		.prof10_enable_port_tx_cadence_slow_clk_locked (0),
		.prof10_pldif_tx_fifo_mode                     ("phase_comp"),
		.prof10_pldif_tx_double_width_transfer_enable  (1),
		.prof10_pldif_rx_double_width_transfer_enable  (1),
		.prof11_tx_custom_cadence_enable               (0),
		.prof11_enable_port_tx_cadence_slow_clk_locked (0),
		.prof11_pldif_tx_fifo_mode                     ("phase_comp"),
		.prof11_pldif_tx_double_width_transfer_enable  (1),
		.prof11_pldif_rx_double_width_transfer_enable  (1)
	) intel_directphy_gts_0 (
		.i_rx_cdr_refclk_p              (i_rx_cdr_refclk_p),                                                                    //   input,   width = 1,    i_rx_cdr_refclk_p.clk
		.i_pma_cu_clk                   (i_pma_cu_clk),                                                                         //   input,   width = 1,         i_pma_cu_clk.clk
		.i_rx_reset                     (i_rx_reset),                                                                           //   input,   width = 1,           i_rx_reset.rx_reset
		.o_rx_reset_ack                 (o_rx_reset_ack),                                                                       //  output,   width = 1,       o_rx_reset_ack.rx_reset_ack
		.o_rx_ready                     (o_rx_ready),                                                                           //  output,   width = 1,           o_rx_ready.rx_ready
		.i_rx_coreclkin                 (i_rx_coreclkin),                                                                       //   input,   width = 1,       i_rx_coreclkin.i_rx_coreclkin
		.o_rx_clkout                    (o_rx_clkout),                                                                          //  output,   width = 1,          o_rx_clkout.o_rx_clkout
		.i_src_rs_grant                 (i_src_rs_grant),                                                                       //   input,   width = 1,       i_src_rs_grant.src_rs_grant
		.o_src_rs_req                   (o_src_rs_req),                                                                         //  output,   width = 1,         o_src_rs_req.src_rs_req
		.i_rx_serial_data               (i_rx_serial_data),                                                                     //   input,   width = 1,     i_rx_serial_data.i_rx_serial_data
		.i_rx_serial_data_n             (i_rx_serial_data_n),                                                                   //   input,   width = 1,   i_rx_serial_data_n.i_rx_serial_data_n
		.o_rx_is_lockedtodata           (o_rx_is_lockedtodata),                                                                 //  output,   width = 1, o_rx_is_lockedtodata.o_rx_is_lockedtodata
		.o_rx_is_lockedtoref            (o_rx_is_lockedtoref),                                                                  //  output,   width = 1,  o_rx_is_lockedtoref.o_rx_is_lockedtoref
		.o_rx_parallel_data             (o_rx_parallel_data),                                                                   //  output,  width = 80,   o_rx_parallel_data.o_rx_parallel_data
		.o_rx_cdr_divclk                (),                                                                                     // (terminated),                                   
		.i_rx_cdr_refclk2_p             (1'b0),                                                                                 // (terminated),                                   
		.i_tx_pll_refclk_p              (1'b0),                                                                                 // (terminated),                                   
		.i_tx_pll_refclk2_p             (1'b0),                                                                                 // (terminated),                                   
		.i_system_pll_clk               (1'b0),                                                                                 // (terminated),                                   
		.i_system_pll_lock              (1'b0),                                                                                 // (terminated),                                   
		.i_tx_reset                     (1'b0),                                                                                 // (terminated),                                   
		.o_tx_reset_ack                 (),                                                                                     // (terminated),                                   
		.o_tx_ready                     (),                                                                                     // (terminated),                                   
		.i_tx_coreclkin                 (1'b0),                                                                                 // (terminated),                                   
		.o_tx_clkout                    (),                                                                                     // (terminated),                                   
		.o_tx_clkout2                   (),                                                                                     // (terminated),                                   
		.o_rx_clkout2                   (),                                                                                     // (terminated),                                   
		.o_tx_cadence                   (),                                                                                     // (terminated),                                   
		.i_tx_cadence_fast_clk          (1'b0),                                                                                 // (terminated),                                   
		.i_tx_cadence_slow_clk          (1'b0),                                                                                 // (terminated),                                   
		.i_tx_cadence_slow_clk_locked   (1'b0),                                                                                 // (terminated),                                   
		.i_refclk_cmd_bus_in            (10'b0000000000),                                                                       // (terminated),                                   
		.o_refclk_status_bus_out        (),                                                                                     // (terminated),                                   
		.i_det_lat_rx_dl_clk            (1'b0),                                                                                 // (terminated),                                   
		.i_det_lat_rx_mux_select        (1'b0),                                                                                 // (terminated),                                   
		.i_det_lat_rx_sclk_flop         (1'b0),                                                                                 // (terminated),                                   
		.i_det_lat_rx_sclk_gen_clk      (1'b0),                                                                                 // (terminated),                                   
		.i_det_lat_rx_trig_flop         (1'b0),                                                                                 // (terminated),                                   
		.i_det_lat_sampling_clk         (1'b0),                                                                                 // (terminated),                                   
		.i_det_lat_tx_dl_clk            (1'b0),                                                                                 // (terminated),                                   
		.i_det_lat_tx_mux_select        (1'b0),                                                                                 // (terminated),                                   
		.i_det_lat_tx_sclk_flop         (1'b0),                                                                                 // (terminated),                                   
		.i_det_lat_tx_sclk_gen_clk      (1'b0),                                                                                 // (terminated),                                   
		.i_det_lat_tx_trig_flop         (1'b0),                                                                                 // (terminated),                                   
		.o_det_lat_rx_async_dl_sync     (),                                                                                     // (terminated),                                   
		.o_det_lat_rx_async_pulse       (),                                                                                     // (terminated),                                   
		.o_det_lat_rx_async_sample_sync (),                                                                                     // (terminated),                                   
		.o_det_lat_rx_sclk_sample_sync  (),                                                                                     // (terminated),                                   
		.o_det_lat_rx_trig_sample_sync  (),                                                                                     // (terminated),                                   
		.o_det_lat_tx_async_dl_sync     (),                                                                                     // (terminated),                                   
		.o_det_lat_tx_async_pulse       (),                                                                                     // (terminated),                                   
		.o_det_lat_tx_async_sample_sync (),                                                                                     // (terminated),                                   
		.o_det_lat_tx_sclk_sample_sync  (),                                                                                     // (terminated),                                   
		.o_det_lat_tx_trig_sample_sync  (),                                                                                     // (terminated),                                   
		.o_xcvrif_rx_latency_pulse      (),                                                                                     // (terminated),                                   
		.o_xcvrif_tx_latency_pulse      (),                                                                                     // (terminated),                                   
		.i_pma_async                    (80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000), // (terminated),                                   
		.i_pma_async_pcie_mux           (80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000), // (terminated),                                   
		.o_pma_async                    (),                                                                                     // (terminated),                                   
		.i_rx_cdr_freeze                (1'b0),                                                                                 // (terminated),                                   
		.i_rx_cdr_fast_freeze_sel       (1'b0),                                                                                 // (terminated),                                   
		.o_rx_signal_detect             (),                                                                                     // (terminated),                                   
		.o_rx_signal_detect_lfps        (),                                                                                     // (terminated),                                   
		.o_tx_serial_data               (),                                                                                     // (terminated),                                   
		.o_tx_serial_data_n             (),                                                                                     // (terminated),                                   
		.o_tx_pll_locked                (),                                                                                     // (terminated),                                   
		.i_rx_set_locktoref             (1'b0),                                                                                 // (terminated),                                   
		.i_rx_set_locktodata            (1'b0),                                                                                 // (terminated),                                   
		.o_tx_fifo_full                 (),                                                                                     // (terminated),                                   
		.o_tx_fifo_empty                (),                                                                                     // (terminated),                                   
		.o_tx_fifo_pfull                (),                                                                                     // (terminated),                                   
		.o_tx_fifo_pempty               (),                                                                                     // (terminated),                                   
		.o_rx_fifo_full                 (),                                                                                     // (terminated),                                   
		.o_rx_fifo_empty                (),                                                                                     // (terminated),                                   
		.o_rx_fifo_pfull                (),                                                                                     // (terminated),                                   
		.o_rx_fifo_pempty               (),                                                                                     // (terminated),                                   
		.i_rx_fifo_rd_en                (1'b0),                                                                                 // (terminated),                                   
		.o_rx_pmaif_fifo_empty          (),                                                                                     // (terminated),                                   
		.o_rx_pmaif_fifo_pempty         (),                                                                                     // (terminated),                                   
		.o_rx_pmaif_fifo_pfull          (),                                                                                     // (terminated),                                   
		.o_tx_pmaif_fifo_empty          (),                                                                                     // (terminated),                                   
		.o_tx_pmaif_fifo_pempty         (),                                                                                     // (terminated),                                   
		.o_tx_pmaif_fifo_pfull          (),                                                                                     // (terminated),                                   
		.o_fec_sf                       (),                                                                                     // (terminated),                                   
		.o_fec_status_rx_not_align      (),                                                                                     // (terminated),                                   
		.o_fec_status_rx_not_deskew     (),                                                                                     // (terminated),                                   
		.o_fec_status_rx_not_locked     (),                                                                                     // (terminated),                                   
		.i_fec_snapshot                 (1'b0),                                                                                 // (terminated),                                   
		.o_rx_block_lock                (),                                                                                     // (terminated),                                   
		.o_local_fault_status           (),                                                                                     // (terminated),                                   
		.o_rx_hi_ber                    (),                                                                                     // (terminated),                                   
		.o_rx_pcs_fully_aligned         (),                                                                                     // (terminated),                                   
		.o_refclk2core                  (),                                                                                     // (terminated),                                   
		.i_tx_parallel_data             (80'b00000000000000000000000000000000000000000000000000000000000000000000000000000000), // (terminated),                                   
		.i_tx_pma_elecidle_sync         (4'b0000),                                                                              // (terminated),                                   
		.i_txclkdivrate_sync            (3'b000),                                                                               // (terminated),                                   
		.i_reconfig_clk                 (1'b0),                                                                                 // (terminated),                                   
		.i_reconfig_reset               (1'b0),                                                                                 // (terminated),                                   
		.i_reconfig_write               (1'b0),                                                                                 // (terminated),                                   
		.i_reconfig_read                (1'b0),                                                                                 // (terminated),                                   
		.i_reconfig_address             (18'b000000000000000000),                                                               // (terminated),                                   
		.i_reconfig_byteenable          (4'b0000),                                                                              // (terminated),                                   
		.i_reconfig_writedata           (32'b00000000000000000000000000000000),                                                 // (terminated),                                   
		.o_reconfig_readdata            (),                                                                                     // (terminated),                                   
		.o_reconfig_waitrequest         (),                                                                                     // (terminated),                                   
		.o_reconfig_readdatavalid       ()                                                                                      // (terminated),                                   
	);

endmodule
