// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module ff_macro_init # (
 parameter DATA_WIDTH = 256,
 parameter DIRECTION = "INPUT",
 parameter NUM_FLOPS = 1 // based on number of flops you need in 1 dir 
 ) (
 input logic clk,
 
 input [DATA_WIDTH -1:0] in_data ,
 
 output [DATA_WIDTH -1:0] out_data
 
);
 
    genvar i;
 
    generate
        if ((DIRECTION == "INPUT") && (NUM_FLOPS == 0)) begin : CORE_TO_PERIPHERY_DIRECT
            assign out_data = in_data;
        end
 
        else if (DIRECTION == "INPUT") begin : CORE_TO_PERIPHERY_REG
            (* altera_attribute = {"-name PRESERVE_REGISTER ON; -name FORCE_HYPER_REGISTER_FOR_CORE_PERIPHERY_TRANSFER ON; -name HYPER_REGISTER_DELAY_CHAIN 225"} *)
            reg [DATA_WIDTH-1:0] out_data_reg;
            reg [DATA_WIDTH-1:0] in_data_reg [NUM_FLOPS-1:0]; 
        
            assign in_data_reg[0] = in_data;
 
            for (i=0 ; i<NUM_FLOPS-1 ; i=i+1 ) begin : PIPELINE_REG
                always @(posedge clk) begin
                    in_data_reg[i+1] <= in_data_reg[i];
                end
            end
 
            always @(posedge clk) begin
                out_data_reg <= in_data_reg[NUM_FLOPS-1];
            end
 
            assign out_data = out_data_reg;
        
        end
 
        else begin : PERIPHERY_TO_CORE_REG
            (* altera_attribute = {"-name PRESERVE_REGISTER ON; -name PRESERVE_FANOUT_FREE_NODE ON; -name FORCE_HYPER_REGISTER_FOR_PERIPHERY_CORE_TRANSFER ON"} *)
            reg [DATA_WIDTH-1:0] in_data_reg [NUM_FLOPS:0];
        
            assign in_data_reg[0] = in_data;
 
            for (i=0 ; i<NUM_FLOPS ; i=i+1 ) begin : PIPELINE_REG
                always @(posedge clk) begin
                in_data_reg[i+1] <= in_data_reg[i];
                end
            end
 
            assign out_data = in_data_reg[NUM_FLOPS];
        end
    endgenerate 
    
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "KvY3cInsyNb25msnrLt7stVcYrfTnHuIYVMQ1737VTJbaDsQP/fg37OQ8BqprVvzIW+w5ltsgbh+KL63tK5E/46JxXrXQPHower03fou3CtkaHIVqFQFY/TqIUSi3JDAI38mKKcWurZB6Wc8ZG5hj06oOJlI+8DfIxJfa5D5HCsq1ylDZ6HHjPT51Z+H71nwlAGcdbIr1aaGa3JYsYd6B5rDj8hxcsdjszWqfgZ98/c9H3CMx4VvWQfEubdzRs2nRtoWt+7PwnV34E4aJYAwBCK3VVFPD6Ll/bl2UTam2tQVcpshex8H1herXsaqbwe/lv/HuQmcjQ4lv5B8Z28kmjj6ey+HcNEvqoKu3nu+Va7rGywLLXKFKSFriTRXJxTLvClcU1C58bm1nGRLdRzthI1UAhX6Oc7YeelBZumurKpcn2lS3ls8NGggfPF3kn6XetDQvvPmSXmrMoFXwDQ4zRmxowEqeRzj/pum10P1dzHcQijSMklXFS7xaDnQGkNnzlYCFyBsP/SHGyJVNLuMd96NqddV6cyEuquS3Ao1f90PZ0VPLVhvS+3qbwhBnzrlCdTA0zNjpzP1Wc58MPwPcwgfaURtl+zHAK+gG9yyrm5mEVikMvrK5spS6IoIGpRUNM+pSpbf73/dqcW+Ky4CY+M/v+hNcw36lWydHyY5oloqnlqVKtV/yT2chveXWNitIHSCUeMhFI6S55hJWj7zd//tOxC+i9L07pat/tO9acDwOTj5D4Tf+7InDRMwQS4JbFbjOKqM8EuPZvxYCq5ycqsLo0yM4UQbRbd4aIoCbomgCu9q1MLyZM15h5hLMNXJ8unvp5Z5umTPI6fdYpEM1AnJxhcntf3gjV+VMkuDTBKtvXlu8OUavp90fWExHE7ZIs3I7tEPrxWr8KGW6ct6wUsiP+XeVmUD+9hAVyssJhCnBFG0CkudW5FfTaCBC7/YIJBOGbkkDQOUhwTj73l/mqbrscb7PzgxBruNRRIe9IQPfMvAO3ki1Ca+VVt0xIvp"
`endif