// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module refclk_recovery_sm (
    input  logic        i_reconfig_clk,             // Clock signal
    input  logic        i_reconfig_reset_n,         // Reset signal (active low)
    //Fabric interface
    input  logic [8:0]  i_refclk_on_cmd,            // Command signal driven by user, [7:0] corresponds to Refclks of 4xQUADs
                                                    // 1 - ON, 0 - OFF, EX: 8'b0000_1001=Quad0 Local_Refclk and Quad1 clkrx_refclk
    //output logic [9:0]  o_refclk_fail_stat,         // Status Signal [15:8] to USER [7:0] is Status Signal & Bit 8 is valid & bit 9 is o_error
    output logic [7:0]  o_refclk_fail_stat,         // Status Signal [15:8] to USER [7:0] is Status Signal
    output logic        o_refclk_on_ack,            // Refclk_On Acknowledgement to USER
    //HIP Interface
    input  logic        i_pldif_refclk_fail_intr,   // interrrupt signal this is bit 27 from PLDIF
    input  logic        i_pldif_refclk_on_ack,      // this is bit 28 or o_hio_rxdata_async[7] from PLDIF 
    //HIP AVMM Source Interface - towards HAL
    input  logic [31:0] i_refclk_avmm_rdata,         
    input  logic        i_refclk_avmm_rdata_valid,         
    input  logic        i_refclk_avmm_waitrequest,         
    output logic [20:0] o_refclk_avmm_addr,
    output logic        o_refclk_avmm_read,
    output logic        o_refclk_avmm_write,            
    output logic [31:0] o_refclk_avmm_writedata,         
    output logic [3:0]  o_refclk_avmm_byteenable         
             
);

    // State encoding
    logic [2:0] current_state, next_state;
    localparam  STATE_IDLE            = 0,    // Initial state
                STATE_READ_STATUS     = 1,    //Read the Register
                STATE_DISABLE_MASK    = 2,    
                STATE_CLR_BIT27       = 3,
                STATE_REFCLK_ON       = 4,
                STATE_CLR_BIT28       = 5;

    // Internal signals
    logic [8:0] fail_status_reg;
    logic [6:0] timeout_counter;
    logic o_error_reg;
    logic avmm_read_done;
    logic read_issued_read_status;
    logic read_issued_bit27;
    logic read_issued_bit28;
    logic read_done_bit27;
    logic write_done_bit27;
    logic read_done_bit28;
    logic write_done_bit28;
    logic read_issued_refclk_on;
    logic read_done_refclk_on;
    logic write_done_refclk_on;
    logic read_issued_disable_mask;
    logic read_done_disable_mask;
    logic write_done_disable_mask;  
    logic refclk_on_cmd_processed;
    logic [31:0] avmm_rdata_reg;
    logic [7:0] mask_reg_7_0;
    logic [7:0] mask_reg_15_8;
    logic [7:0] mask_reg_31_24;

                  
    // State transition logic
    always @(posedge i_reconfig_clk) begin
        if (!i_reconfig_reset_n || (i_refclk_on_cmd[8] == 1))
            current_state <= STATE_IDLE;
        else
            current_state <= next_state;
        end

    // Next-state logic
    always @* begin
        next_state = current_state;  // Default hold state
        case (current_state)
            STATE_IDLE: 
                if ((i_pldif_refclk_fail_intr) && (!i_pldif_refclk_on_ack))
                    next_state = STATE_READ_STATUS;
                else if ((!i_pldif_refclk_fail_intr) && (!i_pldif_refclk_on_ack) && (i_refclk_on_cmd[7:0] != 8'b0) && (!refclk_on_cmd_processed))
                    next_state = STATE_REFCLK_ON;
                else
                    next_state = STATE_IDLE;
            
            //Do a read to 0x4038 reg, send bits 15:8 to user on that refclk out port    
            STATE_READ_STATUS: 
                if ((avmm_read_done))
                    next_state = STATE_DISABLE_MASK;
                else
                    next_state = STATE_READ_STATUS;          

            //Do a write to 0x4038 bit [31:24]=[31:24] & ~(bits15:8), Disable the interrrupt Bits
            STATE_DISABLE_MASK:
                if (!i_refclk_avmm_waitrequest && write_done_disable_mask)
                    next_state = STATE_CLR_BIT27;
                else
                    next_state = STATE_DISABLE_MASK;
            
            //Do Read on Write to 0x001C Register and Clear Bit 27
            STATE_CLR_BIT27:
                if (!i_pldif_refclk_fail_intr)
                    next_state = STATE_IDLE;
                else
                    next_state = STATE_CLR_BIT27;

            //when refclk_on_cmd!=0 Do a write to 0x4038 bits 23:16 with refclk_on_cmd and
            //Clear only receive the on_cmd bits
            STATE_REFCLK_ON: 
                if (i_pldif_refclk_on_ack)
                    next_state = STATE_CLR_BIT28;
                else
                    next_state = STATE_REFCLK_ON;

            //Do Read on Write to 0x001C Register and Clear Bit 28 & set refclk_on_ack bit
            STATE_CLR_BIT28:
                if ((!i_pldif_refclk_on_ack) && (write_done_bit28) && (!i_refclk_avmm_waitrequest))
                    next_state = STATE_READ_STATUS;
                else
                    next_state = STATE_CLR_BIT28;               
            
            default: 
                next_state = STATE_IDLE;
        endcase
    end

    // Output logic and AVMM transactions
    always_ff @(posedge i_reconfig_clk) begin
        if (!i_reconfig_reset_n) begin
            fail_status_reg         <= 9'b0;
            mask_reg_7_0            <= 8'b0;
            mask_reg_15_8           <= 8'b0;
            mask_reg_31_24          <= 8'b0;
            o_refclk_on_ack         <= 1'b0;
            o_refclk_avmm_read      <= 1'b0;
            o_refclk_avmm_write     <= 1'b0;            
            avmm_read_done          <= 1'b0;            
            read_issued_read_status <= 1'b0;            
            read_issued_bit27       <= 1'b0;            
            read_issued_bit28       <= 1'b0;            
            read_done_bit27         <= 1'b0;            
            write_done_bit27        <= 1'b0;            
            read_done_bit28         <= 1'b0;            
            write_done_bit28        <= 1'b0;
            read_issued_refclk_on   <= 1'b0;
            read_done_refclk_on     <= 1'b0;
            write_done_refclk_on    <= 1'b0;
            read_issued_disable_mask<= 1'b0;
            read_done_disable_mask  <= 1'b0;
            write_done_disable_mask <= 1'b0;
            refclk_on_cmd_processed <= 1'b0;
            avmm_rdata_reg          <= 32'b0;
            o_refclk_avmm_writedata <= 32'b0;
            
        end 
        else begin
            case (current_state)
                STATE_IDLE: begin
                    o_refclk_on_ack          <= 1'b0;
                    o_refclk_avmm_addr       <= 21'h0000;
                    o_refclk_avmm_read       <= 1'b0;
                    o_refclk_avmm_byteenable <= 4'h0;
                    o_refclk_avmm_write      <= 1'b0;
                    avmm_read_done           <= 1'b0;
                    write_done_bit27         <= 1'b0;
                    read_done_bit27          <= 1'b0;
                    read_issued_bit27        <= 1'b0;
                    read_issued_read_status  <= 1'b0;
                    o_refclk_on_ack          <= 1'b0;
                    if (i_refclk_on_cmd[7:0] == 8'b0) begin
                        refclk_on_cmd_processed <= 1'b0;
                    end 
                end
                
                STATE_READ_STATUS: begin
                    write_done_bit27         <= 1'b0;
                    write_done_bit28         <= 1'b0;
                    read_done_bit27          <= 1'b0;
                    read_done_bit28          <= 1'b0;
                    read_issued_bit27        <= 1'b0;
                    read_issued_bit28        <= 1'b0;
                    o_refclk_on_ack          <= 1'b0;               
                    
                    if (i_refclk_avmm_rdata_valid) begin    
                        fail_status_reg[7:0]     <= i_refclk_avmm_rdata[15:8];
                        fail_status_reg[8]       <= 1'b1;
                        mask_reg_7_0             <= i_refclk_avmm_rdata[7:0];
                        mask_reg_15_8            <= i_refclk_avmm_rdata[15:8];
                        mask_reg_31_24           <= i_refclk_avmm_rdata[31:24];
                        avmm_read_done           <= 1'b1;
                    end 
                    if (!read_issued_read_status) begin
                        o_refclk_avmm_addr       <= 21'hA6038;
                        o_refclk_avmm_read       <= 1'b1;
                        o_refclk_avmm_write      <= 1'b0;
                        o_refclk_avmm_byteenable <= 4'b1011;
                        read_issued_read_status  <= 1'b1; // Set after issuing the read
                    end else if (read_issued_read_status && !i_refclk_avmm_waitrequest) begin
                        o_refclk_avmm_read       <= 1'b0; // Deassert after waitrequest is low
                    end
                end

                STATE_DISABLE_MASK: begin 
                    avmm_read_done           <= 1'b0;
                    read_issued_read_status  <= 1'b0;               
                    
                    // 1. Trigger Read (only once)
                    if (!read_done_disable_mask && !read_issued_disable_mask && i_refclk_avmm_waitrequest) begin
                        o_refclk_avmm_read       <= 1'b1;
                        o_refclk_avmm_write      <= 1'b0;
                        o_refclk_avmm_addr       <= 21'hA6038;    //Address 0xA6000+0x4038
                        o_refclk_avmm_byteenable <= 4'b1111;
                        read_issued_disable_mask <= 1'b1;
                    end else if (!i_refclk_avmm_waitrequest) begin
                        o_refclk_avmm_read       <= 1'b0;
                    end 
    
                    // 2. Wait and Capture Data when valid
                    if (read_issued_disable_mask && i_refclk_avmm_rdata_valid && !read_done_disable_mask) begin
                        avmm_rdata_reg          <= {(mask_reg_7_0 & ~(mask_reg_15_8)),i_refclk_avmm_rdata[23:0]};
                        read_done_disable_mask  <= 1'b1;
                    end                 
    
                    // 3. Trigger Write
                    if (read_done_disable_mask && !write_done_disable_mask) begin
                        o_refclk_avmm_write         <= 1'b1;
                        o_refclk_avmm_addr          <= 21'hA6038;    //Address 0xA6000+0x4038
                        o_refclk_avmm_byteenable    <= 4'b1111;
                        o_refclk_avmm_writedata     <= avmm_rdata_reg;
                        write_done_disable_mask     <= 1'b1;
                    end else if (write_done_disable_mask) begin
                        o_refclk_avmm_write <= 1'b0;
                    end
                end

                STATE_CLR_BIT27: begin          
                        read_issued_disable_mask <= 1'b0;                        
                        read_done_disable_mask   <= 1'b0;                        
                        write_done_disable_mask  <= 1'b0;                   
                    
                        // 1. Trigger Read (only once)
                        if (!read_done_bit27 && !read_issued_bit27 && i_pldif_refclk_fail_intr) begin
                            o_refclk_avmm_read       <= 1'b1;
                            o_refclk_avmm_write      <= 1'b0;
                            o_refclk_avmm_addr       <= 21'h2001C;      //Address 0x20000+0x001C;
                            o_refclk_avmm_byteenable <= 4'b1111;
                            read_issued_bit27        <= 1'b1;                           
                        end else if (!i_refclk_avmm_waitrequest && i_pldif_refclk_fail_intr) begin
                            o_refclk_avmm_read       <= 1'b0;
                        end 
    
                        // 2. Wait and Capture Data when valid
                        if (read_issued_bit27 && i_refclk_avmm_rdata_valid && !read_done_bit27) begin
                            avmm_rdata_reg      <= {i_refclk_avmm_rdata[31:28],1'd0,i_refclk_avmm_rdata[26:0]};         //refclk_avmm_rdata_reg & ~(31'h1 << 27);  // Clear Bit 27
                            read_done_bit27     <= 1'b1;
                        end                 
    
                        // 3. Trigger Write
                        if (read_done_bit27 && !write_done_bit27) begin
                            o_refclk_avmm_write     <= 1'b1;
                            o_refclk_avmm_addr      <= 21'h2001C;   //Address 0x20000+0x001C;
                            o_refclk_avmm_byteenable<= 4'b1000;
                            o_refclk_avmm_writedata <= avmm_rdata_reg;
                            write_done_bit27        <= 1'b1;
                        end else if (write_done_bit27) begin
                            o_refclk_avmm_write <= 1'b0;
                        end
                end

                STATE_REFCLK_ON: begin          
                    // 1. Trigger Read (only once)
                    if (!read_done_refclk_on && !read_issued_refclk_on && i_refclk_avmm_waitrequest) begin
                        o_refclk_avmm_read       <= 1'b1;
                        o_refclk_avmm_write      <= 1'b0;
                        o_refclk_avmm_addr       <= 21'hA6038;
                        o_refclk_avmm_byteenable <= 4'b1111;
                        read_issued_refclk_on    <= 1'b1;
                    end else if (!i_refclk_avmm_waitrequest) begin
                        o_refclk_avmm_read       <= 1'b0;
                    end 
    
                    // 2. Wait and Capture Data when valid
                    if (read_issued_refclk_on && i_refclk_avmm_rdata_valid && !read_done_refclk_on) begin
                        avmm_rdata_reg      <= {i_refclk_avmm_rdata[31:24],i_refclk_on_cmd[7:0],i_refclk_avmm_rdata[15:0]};
                        read_done_refclk_on <= 1'b1;
                    end                 
    
                    // 3. Trigger Write
                    if (read_done_refclk_on && !write_done_refclk_on) begin
                        o_refclk_avmm_write     <= 1'b1;
                        o_refclk_avmm_addr      <= 21'hA6038;
                        o_refclk_avmm_byteenable<= 4'b1111;
                        o_refclk_avmm_writedata <= avmm_rdata_reg;
                        write_done_refclk_on    <= 1'b1;
                    end else if (write_done_refclk_on) begin
                        o_refclk_avmm_write <= 1'b0;
                    end
                end

                STATE_CLR_BIT28: begin
                    read_issued_refclk_on       <= 1'b0;                        
                    read_done_refclk_on         <= 1'b0;                        
                    write_done_refclk_on        <= 1'b0;                
                    
                    // 1. Trigger Read (only once)
                    if (!read_done_bit28 && !read_issued_bit28 && i_refclk_avmm_waitrequest) begin
                        o_refclk_avmm_read          <= 1'b1;
                        o_refclk_avmm_write         <= 1'b0;
                        o_refclk_avmm_addr          <= 21'h2001C;     //Address 0x20000+0x001C;
                        o_refclk_avmm_byteenable    <= 4'b1111;
                        read_issued_bit28           <= 1'b1;                                                
                    end else if (!i_refclk_avmm_waitrequest) begin
                        o_refclk_avmm_read          <= 1'b0;
                    end
                
                    // 2. Wait and Capture Data when valid
                    if (read_issued_bit28 && i_refclk_avmm_rdata_valid && !read_done_bit28) begin
                        avmm_rdata_reg              <= {i_refclk_avmm_rdata[31:29],1'd0,i_refclk_avmm_rdata[27:0]};         //refclk_avmm_rdata_reg & ~(31'h1 << 28);  // Clear Bit 28
                        read_done_bit28             <= 1'b1;
                    end
                    
                    // 3. Trigger Write
                    if (read_done_bit28 && !write_done_bit28) begin
                        o_refclk_avmm_write     <= 1'b1;
                        o_refclk_avmm_addr      <= 21'h2001C;   //Address 0x20000+0x001C;
                        o_refclk_avmm_byteenable<= 4'b1000;
                        o_refclk_avmm_writedata <= avmm_rdata_reg;
                        write_done_bit28        <= 1'b1;
                        o_refclk_on_ack         <= 1'b1;                        
                        refclk_on_cmd_processed <= 1'b1;                        
                    end else if (!i_refclk_avmm_waitrequest) begin
                        o_refclk_avmm_write <= 1'b0;
                    end
                end
            endcase
        end
    end

    // Timeout Counter Logic
    always @(posedge i_reconfig_clk) begin
        if ((!i_reconfig_reset_n) || (current_state == STATE_IDLE)) begin
            timeout_counter     <= 7'b0000000;
            o_error_reg         <= 1'b0;
        end else if (timeout_counter == 7'h64) begin            //Set o_error to 1 when counter Reaches to 100
            o_error_reg         <= 1'b1;
            timeout_counter     <= 7'b0000000;                  //Clear timeout_counter
        end else begin
            o_error_reg         <= 1'b0;
            timeout_counter     <= timeout_counter + 7'b0000001;        
        end
    end

    // Assign outputs
    assign o_refclk_fail_stat    = fail_status_reg[7:0];

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "KvY3cInsyNb25msnrLt7stVcYrfTnHuIYVMQ1737VTJbaDsQP/fg37OQ8BqprVvzIW+w5ltsgbh+KL63tK5E/46JxXrXQPHower03fou3CtkaHIVqFQFY/TqIUSi3JDAI38mKKcWurZB6Wc8ZG5hj06oOJlI+8DfIxJfa5D5HCsq1ylDZ6HHjPT51Z+H71nwlAGcdbIr1aaGa3JYsYd6B5rDj8hxcsdjszWqfgZ98/f/Ev3NZYbXeIERfr++ql3m7igUrS7hrlTQcmGn92ieWHxkvWyxwD0j1fWkeybfp9tdKqvptgqpzNy9zewH2I8+qUE5d2kwN6fNo/HK2XK/pLsJ/zOQNLq70tlfj9637pYTpGnpIhC8D1s8UaqPX7MBINPUdhdw0B2fXbdWgiN/9aQDhFNuNnsbyd2vdu0uKhOfoEueRIN+H4s2TtDXtC5MVzEUk02CV7lFqmuISB9ZnVlf08c3R+vAY4Ie22qiT2KzP/q7ms46HCylBRKzNktPPfNUpPa0MEfWSjutIZKizR92hSXFdSjUQvSO9czjEbpYYN/aMR59uEuZBRyAADHyKSCIwL27KjmZxzn4JUQEqAwRJWGuONckUkWPQNLKr1Lr4jqopDsTHdSBTm/mnEE5xe9xd5a4EBJ8T8zLEKd6YLUNXBCTcykZhlb1YOqnPHSOAhlmhTbyYtVevji0MldrVEQjJM2TkW5J6e/lOp9FkO9hZkbSR80LqTvznY7VH5CH7xWraihmfzVCXGggj/CjP7v6UEzUs00ue+WbhK2pDAwBpOC92cprbmIxxPzUUQSp3k73463vdegyBqxbRfL/8B9+it8/9k6Oi9SAa05FYULdmtprzoJ1rBpPVlxVEfIo3U3M8KkoeL7xDunLsyRWMIgHNmT5KlqVGLVnileje6yNf6TnjokGonKvEtLFJOctLrB3BP6vpK1Oz01vmmXP7yyQZLtxtHEBsRMKUUzkYmvFCpDocyGOV5KbMnMSMtLcsXtRhf8BgBYd28TRCYTB"
`endif