# (C) 2001-2025 Altera Corporation. All rights reserved.
# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Altera Program License Subscription 
# Agreement, Altera IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Altera and sold by 
# Altera or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


## SDC ##
set dir_name [file dirname [info script]] 
#source "${dir_name}/xcvr_rx_intel_directphy_gts_1000_h5jfb7q_sip_ip_parameters.tcl"
source "${dir_name}/xcvr_sdc_utils.tcl"

set module_name xcvr_rx_intel_directphy_gts_1000_h5jfb7q_sip


## set global variables
global ::ip_sdc_debug


 set ip_sdc_debug 0
 
 ## get current IP instance 
 set ip_inst_name [get_current_instance]
 if {$ip_sdc_debug == 1} { 
	post_message -type info "IP SDC: $ip_inst_name"
 }
#set profile_cnt 1 


## Set parameters based on IP configuration, generated by HWTCL


set rx_user_clk1_mhz 118.8


set rx_user_clk1_div 2





# -------------------------------------------------------------------------------------
# SETTING CLOCK CONSTRAINTS FOR XCVR USER CLOCK OUTPUTS
# -------------------------------------------------------------------------------------
# Typically there are 4 user output clocks from the Transceiver
# 2 for TX and 2 for RX
#
# -------------------------------------------------------------------------------------
# Prerequisites:
# -------------------------------------------------------------------------------------
# 1. Instantiate dummy flops in SIP which are clocked by the XCVR user clock outputs
# 2. Pass the frequency of the user clocks from HWTCL as per IP configuration
# 3. Pass the divider value used on the user clocks from HWTCL as per IP configuration
# 4. Entity associated with this SDC should be pointing to the SIP module in QIP
#
# -------------------------------------------------------------------------------------
# Goals of the script:
# -------------------------------------------------------------------------------------
# 1. Using the SIP dummy flop, trace the pin on the PLDIF (or HIP boundary)
#    which is driving the clock to this dummy flop
# 2. Using the pin found above, trace back into the timing model to 
#    find the source reference clock and register inside the HIP (or HSSI SS)
# 3. The output clock towards the fabric passes through a Divider in PLDIF
#    and hence this divider value set by user is also taken into account
# 4. Create the clock constraint for the original Ref clock source
# 5. Create the Generated clock constraint for the Reg clock 
# 6. Create the Generated clock constraint for the User clock output towards fabric
#
# -------------------------------------------------------------------------------------


    ## Compute the Source Ref Clock frequency after adjusting for Divider in PLDIF

    set clk_ref_freq_mhz(2) [expr $rx_user_clk1_mhz * $rx_user_clk1_div] 
     







    ## Load the Divider values into variables

    set clk_out_div(2) $rx_user_clk1_div 





                    set total_no_of_clocks 1*1*1
    
    
## Set the total number of clocks that need to be constrained
# -------------------------------------------------------------------------------------
# Channel Number 0
# -------------------------------------------------------------------------------------
 
    ## Set the exact name of the dummy registers instantiated in SIP for each clock
 
    set dummy_sip_flop_names_ch0(2) dummy_rx_user_clk1_reg[0]
 
    ## Set the names of the source reference clock inside the HIP
    
	
	
       
    set clk_ref_names_ch0(2) rx_user_clk1_ref[0]
    
	

    ## Set the names of the register clock inside the HIP
	
	
	

    set clk_reg_names_ch0(2) rx_user_clk1_reg[0]
 
 
 
    ## Set the names of the Output clocks
    ## These are the names that will appear in the "Clocks" report after clock creation
    
	


   
        
 
    set clk_out_names_ch0(2) o_rx_clkout[0]

   
	
	     
## Load the ref node which needs to be found



 
 
set ref_search_node_ch0(2) {{[tr]xuser[12]_clk_ref}}

 
 
## Load the reg node which needs to be found

## Load the reg node which needs to be found
 

 
set reg_search_node_ch0(2) {{[tr]xuser[12]_clk.reg}}
 
 
 
    
    ## Create clock constraints for Ref/Reg/Output clocks
	
	 ## Create clock constraints for Ref/Reg/Output clocks
 
 
    ## rx clockout    
        #Find clock pin/ref/reg nodes for each user clock
        set xcvrclk_pin_node_ch0(2) [xcvrphy_traverse_fanins $ip_inst_name $dummy_sip_flop_names_ch0(2) "pin" $ip_inst_name $ip_sdc_debug]
        set xcvrclk_ref_node_ch0(2) [xcvrphy_traverse_fanins $ip_inst_name $dummy_sip_flop_names_ch0(2) $ref_search_node_ch0(2) $ip_inst_name $ip_sdc_debug]
        set xcvrclk_reg_node_ch0(2) [xcvrphy_traverse_fanins $ip_inst_name $dummy_sip_flop_names_ch0(2) $reg_search_node_ch0(2) $ip_inst_name $ip_sdc_debug]
	
        #Check if clock with target "syspll_c0_ref" already exists; if yes, get the target node and clock name 
	set clk_exists "0"
	set clk_exists_node ""
	set clk_exists_name ""
	##if {$ref_search_node_ch0(2) == "syspll_c0_ref"} {
		set clk_exists [lookup_clock_target $xcvrclk_ref_node_ch0(2)]
		if {$clk_exists == 1} {
			set clk_exists_name [lookup_clock_target_name $xcvrclk_ref_node_ch0(2)]
			set clk_exists_node [get_node_info -name [get_clock_info -target $clk_exists_name]]
			if {$ip_sdc_debug == 1 && $clk_exists == 1} {
				post_message -type info "IP SDC: Clock already created with same target, skipping new clock creation: $clk_exists_name"
				#post_message -type info "Clock already created: NODE: $clk_exists_node"				
			}				
		}
	##}
    
    if { $clk_exists == 0 } {
        #create clock for source ref clock inside HIP
        create_clock \
                                      -name $ip_inst_name|$clk_ref_names_ch0(2) \
                                      -period "$clk_ref_freq_mhz(2) MHz"\
                                      -add   $xcvrclk_ref_node_ch0(2)

    }
    
    if { $clk_exists == 0 } {
        #create generated clock for reg clock inside HIP
        create_generated_clock \
                                      -name $ip_inst_name|$clk_reg_names_ch0(2) \
                                      -source $xcvrclk_ref_node_ch0(2) \
                                      -master_clock $ip_inst_name|$clk_ref_names_ch0(2) \
                                      -multiply_by 1 \
                                      -divide_by 1 \
                                      -duty_cycle 50 \
                                      -add $xcvrclk_reg_node_ch0(2)


    } else { 
            #create generated clock for reg clock inside HIP
        create_generated_clock \
                                      -name $ip_inst_name|$clk_reg_names_ch0(2) \
                                      -source $clk_exists_node \
                                      -master_clock $clk_exists_name \
                                      -multiply_by 1 \
                                      -divide_by 1 \
                                      -duty_cycle 50 \
                                      -add $xcvrclk_reg_node_ch0(2)


    }    
    
        #create generated clock for user output clock to Fabric/SIP
        create_generated_clock \
                                       -name $ip_inst_name|$clk_out_names_ch0(2) \
                                       -source $xcvrclk_reg_node_ch0(2) \
                                       -master_clock $ip_inst_name|$clk_reg_names_ch0(2) \
                                       -multiply_by 1 \
                                       -divide_by $clk_out_div(2) \
                                       -duty_cycle 50 \
                                       -add $xcvrclk_pin_node_ch0(2) 
     
	
	
    if { $clk_exists == 0 } {
    disable_min_pulse_width [get_clocks $ip_inst_name|$clk_ref_names_ch0(2)]
    }

	    
#    disable_min_pulse_width [get_clocks $ip_inst_name|$clk_reg_names_ch0(2)]
#    disable_min_pulse_width [get_clocks $ip_inst_name|$clk_out_names_ch0(2)]
 
    
# -------------------------------------------------------------------------------------
# Channel Number 0 end
# -------------------------------------------------------------------------------------
    
 
        
        

##-----------------------------------------------------------------------------------------------##
##----  CCG cross clock false paths                                                          ----##
##-----------------------------------------------------------------------------------------------##
for {set i 0} {$i < 1} {incr i} {
     set raddr_g_completed [get_registers -nowarn $ip_inst_name|*persystem[$i].ccg.ccg|raddr_g_completed*]
     set ccg_sr1_din_meta [get_registers -nowarn $ip_inst_name|*persystem[$i].ccg.ccg|sr1|resync_chains*.synchronizer_nocut|din_s1]
     if {[get_collection_size $raddr_g_completed] > 0 && [get_collection_size $ccg_sr1_din_meta] > 0} {
       set_max_skew -from $raddr_g_completed -to $ccg_sr1_din_meta -get_skew_value_from_clock_period src_clock_period -skew_value_multiplier 0.8
        set_net_delay -from $raddr_g_completed -to $ccg_sr1_din_meta -max -get_value_from_clock_period dst_clock_period -value_multiplier 0.8
        set_max_delay -from $raddr_g_completed -to $ccg_sr1_din_meta 100
        set_min_delay -from $raddr_g_completed -to $ccg_sr1_din_meta -100
     }
     
     
     set waddr_g_completed [get_registers -nowarn $ip_inst_name|*persystem[$i].ccg.ccg|waddr_g_completed*]
     set ccg_sr0_din_meta [get_registers -nowarn $ip_inst_name|*persystem[$i].ccg.ccg|sr0|resync_chains*.synchronizer_nocut|din_s1]
     if {[get_collection_size $waddr_g_completed] > 0 && [get_collection_size $ccg_sr0_din_meta] > 0} {
       set_max_skew -from $waddr_g_completed -to $ccg_sr0_din_meta -get_skew_value_from_clock_period src_clock_period -skew_value_multiplier 0.8
        set_net_delay -from $waddr_g_completed -to $ccg_sr0_din_meta -max -get_value_from_clock_period dst_clock_period -value_multiplier 0.8
        set_max_delay -from $waddr_g_completed -to $ccg_sr0_din_meta 100
        set_min_delay -from $waddr_g_completed -to $ccg_sr0_din_meta -100
     }
 
 
 
     set rst_sync_tx_rd_clk_dreg [get_registers -nowarn $ip_inst_name|*persystem[$i].ccg.ccg|rst_sync_tx_rd_clk|resync_chains[*].synchronizer_nocut|dreg[*]]
     set rst_sync_tx_rd_clk_dreg_clrn [get_pins -nowarn -compat $ip_inst_name|*persystem[$i].ccg.ccg|rst_sync_tx_rd_clk|resync_chains[*].synchronizer_nocut|dreg[*]|clrn]
      if {[get_collection_size $rst_sync_tx_rd_clk_dreg_clrn] > 0 && [get_collection_size $rst_sync_tx_rd_clk_dreg] > 0} {
	  set_max_delay -through $rst_sync_tx_rd_clk_dreg_clrn -to $rst_sync_tx_rd_clk_dreg 100
	  set_min_delay -through $rst_sync_tx_rd_clk_dreg_clrn -to $rst_sync_tx_rd_clk_dreg -100
      }
	  
     set rst_sync_tx_rd_clk_din [get_registers -nowarn $ip_inst_name|*persystem[$i].ccg.ccg|rst_sync_tx_rd_clk|resync_chains[*].synchronizer_nocut|din_s1]
     set rst_sync_tx_rd_clk_din_clrn [get_pins -nowarn -compat $ip_inst_name|*persystem[$i].ccg.ccg|rst_sync_tx_rd_clk|resync_chains[*].synchronizer_nocut|din_s1|clrn]
      if {[get_collection_size $rst_sync_tx_rd_clk_din_clrn] > 0 && [get_collection_size $rst_sync_tx_rd_clk_din] > 0} {
	  set_max_delay -through $rst_sync_tx_rd_clk_din_clrn -to $rst_sync_tx_rd_clk_din 100
	  set_min_delay -through $rst_sync_tx_rd_clk_din_clrn -to $rst_sync_tx_rd_clk_din -100
      }
 
	  
     set rst_sync_tx_wr_clk_dreg [get_registers -nowarn $ip_inst_name|*persystem[$i].ccg.ccg|rst_sync_tx_wr_clk|resync_chains[*].synchronizer_nocut|dreg[*]]
     set rst_sync_tx_wr_clk_dreg_clrn [get_pins -nowarn -compat $ip_inst_name|*persystem[$i].ccg.ccg|rst_sync_tx_wr_clk|resync_chains[*].synchronizer_nocut|dreg[*]|clrn]
      if {[get_collection_size $rst_sync_tx_wr_clk_dreg_clrn] > 0 && [get_collection_size $rst_sync_tx_wr_clk_dreg] > 0} {
         set_max_delay -through $rst_sync_tx_wr_clk_dreg_clrn -to $rst_sync_tx_wr_clk_dreg 100
         set_min_delay -through $rst_sync_tx_wr_clk_dreg_clrn -to $rst_sync_tx_wr_clk_dreg -100
      }
	  
     set rst_sync_tx_wr_clk_din [get_registers -nowarn $ip_inst_name|*persystem[$i].ccg.ccg|rst_sync_tx_wr_clk|resync_chains[*].synchronizer_nocut|din_s1]
     set rst_sync_tx_wr_clk_din_clrn [get_pins -nowarn -compat $ip_inst_name|*persystem[$i].ccg.ccg|rst_sync_tx_wr_clk|resync_chains[*].synchronizer_nocut|din_s1|clrn]
      if {[get_collection_size $rst_sync_tx_wr_clk_din_clrn] > 0 && [get_collection_size $rst_sync_tx_wr_clk_din] > 0} {
	 set_max_delay -through $rst_sync_tx_wr_clk_din_clrn -to $rst_sync_tx_wr_clk_din 100
	 set_min_delay -through $rst_sync_tx_wr_clk_din_clrn -to $rst_sync_tx_wr_clk_din -100
      }
}

  #--- Clock domain crossing for Div2             --- #
  #---                                            --- #
  #-------------------------------------------------- #
  ## seting group for TX  & RX source clocks
 set rx_clkout2 [get_clocks -nowarn *o_rx_clkout2[*]]
 set rx_clkout [get_clocks -nowarn *o_rx_clkout[*]]
  if {[get_collection_size $rx_clkout2] > 0 && [get_collection_size $rx_clkout] > 0} {
     set_clock_groups -asynchronous -group $rx_clkout2 -group $rx_clkout      
  }
 set tx_clkout2 [get_clocks -nowarn *o_tx_clkout2[*]]
 set tx_clkout [get_clocks -nowarn *o_tx_clkout[*]]
  if {[get_collection_size $tx_clkout2] > 0 && [get_collection_size $tx_clkout] > 0} {
    set_clock_groups -asynchronous -group $tx_clkout2 -group $tx_clkout
}


set count_sync_inst_din [get_registers -nowarn *|count_sync_inst|din_reg[*] ]
set count_sync_inst_dout [get_registers -nowarn *|count_sync_inst|data_out[*]]
  if {[get_collection_size $count_sync_inst_din] > 0 && [get_collection_size $count_sync_inst_dout] > 0} {
    set_false_path -from $count_sync_inst_din -to $count_sync_inst_dout
    set_max_skew -from $count_sync_inst_din -to $count_sync_inst_dout -get_skew_value_from_clock_period src_clock_period -skew_value_multiplier 0.8
    set_net_delay -from $count_sync_inst_din -to $count_sync_inst_dout -max -get_value_from_clock_period dst_clock_period -value_multiplier 0.8	
       
  }

 # --- Added SRC related constraint for multibit synchronizer added for DA warning --- #
 # ---                                                                             --- #
 # ----------------------------------------------------------------------------------- #
set count_sync_inst_din [get_registers -nowarn *|src_tx_lane_cur_state_bit_sync|din_reg[*] ]
set count_sync_inst_dout [get_registers -nowarn *|src_tx_lane_cur_state_bit_sync|data_out[*]]
  if {[get_collection_size $count_sync_inst_din] > 0 && [get_collection_size $count_sync_inst_dout] > 0} {
    set_false_path -from $count_sync_inst_din -to $count_sync_inst_dout
    set_max_skew -from $count_sync_inst_din -to $count_sync_inst_dout -get_skew_value_from_clock_period src_clock_period -skew_value_multiplier 0.8
    set_net_delay -from $count_sync_inst_din -to $count_sync_inst_dout -max -get_value_from_clock_period dst_clock_period -value_multiplier 0.8	       
  }
set count_sync_inst_din [get_registers -nowarn *|src_rx_lane_cur_state_bit_sync|din_reg[*] ]
set count_sync_inst_dout [get_registers -nowarn *|src_rx_lane_cur_state_bit_sync|data_out[*]]
  if {[get_collection_size $count_sync_inst_din] > 0 && [get_collection_size $count_sync_inst_dout] > 0} {
    set_false_path -from $count_sync_inst_din -to $count_sync_inst_dout
    set_max_skew -from $count_sync_inst_din -to $count_sync_inst_dout -get_skew_value_from_clock_period src_clock_period -skew_value_multiplier 0.8
    set_net_delay -from $count_sync_inst_din -to $count_sync_inst_dout -max -get_value_from_clock_period dst_clock_period -value_multiplier 0.8	       
  }  

     


set sync_reconfig_reset [get_registers -nowarn *|sync_reconfig_reset|resync_chains[0].synchronizer_nocut|din_s1]
      if {[get_collection_size $sync_reconfig_reset] > 0} {
	  set_max_delay  -to $sync_reconfig_reset 100
	  set_min_delay  -to $sync_reconfig_reset -100
      }
set pcslp_sync [get_registers -nowarn *|pcslp_sync|resync_chains[0].synchronizer_nocut|din_s1]
      if {[get_collection_size $pcslp_sync] > 0} {
	  set_max_delay  -to $pcslp_sync 100
	  set_min_delay  -to $pcslp_sync -100
      }
 # set_false_path -from *|FEC_AM_GEN.count_sync_inst|din_reg[*] -to *|FEC_AM_GEN.count_sync_inst|data_out[*]

###gpon timing issue
set cpi_cmn_busy_real_reg_din_s1 [get_registers -nowarn *|sip_inst|cpi_cmn_busy_real_reg]
 if {[get_collection_size $cpi_cmn_busy_real_reg_din_s1 ] > 0} {
     set_max_delay  -to $cpi_cmn_busy_real_reg_din_s1 100
     set_min_delay  -to $cpi_cmn_busy_real_reg_din_s1 -100     
  }

set osc_clks [get_registers -nowarn "${ip_inst_name}|divided_osc_clk" ]
if {[get_collection_size $osc_clks] > 0} {
create_generated_clock -divide_by 2 \
       -source [get_nodes {*|intosc|oscillator_dut~oscillator_clock}] \
         -name "${ip_inst_name}_src_divided_osc_clk"  [get_registers "${ip_inst_name}|divided_osc_clk" ]
}








