// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// -----------------------------------------------------------------------------
//  Generated by Magillem, from Arteris IPD division and modified
//  Version: 5.16.0 (20230705092541_5.16.0)
//  Date   : 2025-06-23 00:40:57
// -----------------------------------------------------------------------------
//  Verilog Register Bank
// -----------------------------------------------------------------------------
//  Component Name: intel_directphy_sip_csr
//  File Ref      : /nfs/site/disks/swuser_work_edwinjos/R_25_3_0610_sc_B31/p4/ip/alt_xcvr/intel_monolithic/directphy/intel_directphy_gts/csr_gen/rdl/sip/intel_directphy_sip_csr_out/_workspace_mrv_gen_py_/xmlProject/_local_copy_Vendor_Library_intel_directphy_sip_csr_1.0.xml
//  Protocol      : AVALON
//  Wait State    : WS1_OUTPUT
// -----------------------------------------------------------------------------

module intel_directphy_sip_csr(

   // gui_option.line_rate_p1ghz
   input wire [11:0] gui_option_line_rate_p1ghz_i,
   // gui_option.xcvr_type
   input wire gui_option_xcvr_type_i,
   // gui_option.modulation_type
   input wire gui_option_modulation_type_i,
   // gui_option.duplex_mode
   input wire [2:0] gui_option_duplex_mode_i,
   // gui_option.num_xcvr
   input wire [3:0] gui_option_num_xcvr_i,
   // gui_option.fec_enable
   input wire gui_option_fec_enable_i,
   // dphy_reset.soft_tx_rst
   output reg dphy_reset_soft_tx_rst,
   // dphy_reset.soft_rx_rst
   output reg dphy_reset_soft_rx_rst,
   // dphy_reset.tx_rst_ovr
   output reg dphy_reset_tx_rst_ovr,
   // dphy_reset.rx_rst_ovr
   output reg dphy_reset_rx_rst_ovr,
   // dphy_reset_status.tx_rst_ack_n
   input wire dphy_reset_status_tx_rst_ack_n_i,
   // dphy_reset_status.rx_rst_ack_n
   input wire dphy_reset_status_rx_rst_ack_n_i,
   // dphy_reset_status.tx_ready
   input wire dphy_reset_status_tx_ready_i,
   // dphy_reset_status.rx_ready
   input wire dphy_reset_status_rx_ready_i,
   // phy_tx_pll_locked.tx_pll_locked
   input wire [15:0] phy_tx_pll_locked_tx_pll_locked_i,
   // phy_rx_cdr_locked.rx_cdr_locked
   input wire [15:0] phy_rx_cdr_locked_rx_cdr_locked_i,
   // phy_rx_cdr_locked.rx_cdr_locked2data
   input wire [15:0] phy_rx_cdr_locked_rx_cdr_locked2data_i,
   // src_ctrl.rx_ignore_locked2data
   output reg src_ctrl_rx_ignore_locked2data,
   // src_ctrl.tx_clear_alarm
   output reg [7:0] src_ctrl_tx_clear_alarm,
   // src_ctrl.rx_clear_alarm
   output reg [7:0] src_ctrl_rx_clear_alarm,
   // src_alarms.tx_alarm
   input wire [7:0] src_alarms_tx_alarm_i,
   // src_alarms.rx_alarm
   input wire [7:0] src_alarms_rx_alarm_i,
   // mr_ctrl1.fec_en
   output reg mr_ctrl1_fec_en,
   // mr_ctrl1.fec_type
   output reg [2:0] mr_ctrl1_fec_type,
   // mr_ctrl1.scratch
   output reg [27:0] mr_ctrl1_scratch,
   // mr_ctrl2.is_base_prof
   output reg mr_ctrl2_is_base_prof,
   // mr_ctrl2.scratch
   output reg [30:0] mr_ctrl2_scratch,
   // mr_ctrl3.reconfig_group_xcvr_per_fracture
   output reg [3:0] mr_ctrl3_reconfig_group_xcvr_per_fracture,
   // mr_ctrl3.reconfig_group_fracture_count
   output reg [3:0] mr_ctrl3_reconfig_group_fracture_count,
   // mr_ctrl3.reconfig_group_scratch
   output reg [23:0] mr_ctrl3_reconfig_group_scratch,
   // mr_ctrl4.profile_id_query_id
   output reg [15:0] mr_ctrl4_profile_id_query_id,
   // mr_ctrl4.profile_id_currently_active_id
   input wire [15:0] mr_ctrl4_profile_id_currently_active_id_i,

   // Bus interface
   input wire clk,
   input wire reset,
   input wire [31:0] writedata,
   input wire read,
   input wire write,
   output waitrequest,
   input wire [3:0] byteenable,
   output reg [31:0] readdata,
   output reg readdatavalid,
   input wire [5:0] address
);

wire reset_n = !reset;

reg [31:0] dhpy_scratch_scratch;

// -----------------------------------------------------------------------------
// Protocol management
// -----------------------------------------------------------------------------

reg [31:0] rdata_comb;
reg readdatavalid_pre;
wire sip_waitrequest;

always @(posedge clk)
   if (!reset_n) readdata[31:0] <= 32'h00000000; else readdata[31:0] <= rdata_comb[31:0];

// Read data is always valid the cycle after read transaction is asserted
assign waitrequest= sip_waitrequest;

always @( posedge clk)
begin 
   if (!reset_n) begin 
     readdatavalid_pre     <= 1'b0;   
     readdatavalid <= 1'b0; 
   end else begin      
     readdatavalid_pre <= !sip_waitrequest && read;
	 readdatavalid     <= !sip_waitrequest && read;
end
end
//----------------------------------
reg     write_d1;
reg     read_d1;
reg waitreq_wr, waitreq_rd;
reg valid_wreq_d1;
reg valid_rreq_d1;
 
 
assign  valid_rreq = (read & ~read_d1);
wire    valid_wreq = (write & ~write_d1);
 
always @(posedge clk) begin
  write_d1      <=  write; 
  read_d1       <=  read; 
  valid_wreq_d1 <= valid_wreq;
  valid_rreq_d1 <= valid_rreq;
end
 
always @(posedge clk) begin
  if (reset)   waitreq_wr <= 1'b0;
  else if (valid_wreq)    waitreq_wr <= 1'b1;
  else if (valid_wreq_d1) waitreq_wr <= 1'b0;
  if (reset)   waitreq_rd <= 1'b0;
  else if (valid_rreq)    waitreq_rd <= 1'b1;
  else if (valid_rreq_d1) waitreq_rd <= 1'b0;
end
assign  sip_waitrequest = reset | (waitreq_wr) | (waitreq_rd);

wire we = write;
wire re = read;
wire [5:0] addr = address[5:0];
wire [31:0] din = writedata[31:0];

// -----------------------------------------------------------------------------
// Write byte enables
// -----------------------------------------------------------------------------

// Register dhpy_scratch
wire [3:0] we_dhpy_scratch = we & (addr[5:0] == 6'h04) ? byteenable[3:0] : {4{1'b0}};
// Register dphy_reset
wire we_dphy_reset = we & (addr[5:0] == 6'h08) ? byteenable[0] : 1'b0;
// Register src_ctrl
wire [2:0] we_src_ctrl = we & (addr[5:0] == 6'h18) ? byteenable[2:0] : {3{1'b0}};
// Register mr_ctrl1
wire [3:0] we_mr_ctrl1 = we & (addr[5:0] == 6'h20) ? byteenable[3:0] : {4{1'b0}};
// Register mr_ctrl2
wire [3:0] we_mr_ctrl2 = we & (addr[5:0] == 6'h24) ? byteenable[3:0] : {4{1'b0}};
// Register mr_ctrl3
wire [3:0] we_mr_ctrl3 = we & (addr[5:0] == 6'h28) ? byteenable[3:0] : {4{1'b0}};
// Register mr_ctrl4
wire [1:0] we_mr_ctrl4 = we & (addr[5:0] == 6'h2c) ? byteenable[1:0] : {2{1'b0}};

// -----------------------------------------------------------------------------
// Read byte enables
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
// Register gui_option implementation
// -----------------------------------------------------------------------------

// gui_option_line_rate_p1ghz
//    bitfield description: Line rate in 0.1GHz
//                          // Line datarate in 0.1GHz per transceiver.
//    customType          : RO
//    hwAccess            : WO
//    inputPort           : gui_option_line_rate_p1ghz_i
//
// No register generated

// gui_option_xcvr_type
//    bitfield description: Xcvr type
//                          // 0:GTS tranceiver
//    customType          : RO
//    hwAccess            : WO
//    inputPort           : gui_option_xcvr_type_i
//
// No register generated

// gui_option_modulation_type
//    bitfield description: Modulation type
//                          // 0:NRZ
//    customType          : RO
//    hwAccess            : WO
//    inputPort           : gui_option_modulation_type_i
//
// No register generated

// gui_option_duplex_mode
//    bitfield description: Duplex mode
//                          // 0:Not used, 1:RX simplex, 2:TX simplex, 3:TX/RX duplex, 4:Dual-Simplex
//    customType          : RO
//    hwAccess            : WO
//    inputPort           : gui_option_duplex_mode_i
//
// No register generated

// gui_option_num_xcvr
//    bitfield description: Number of transceivers
//                          // Number of transceivers per system
//    customType          : RO
//    hwAccess            : WO
//    inputPort           : gui_option_num_xcvr_i
//
// No register generated

// gui_option_fec_enable
//    bitfield description: FEC Enabled?
//                          // 0:FEC is disabled, 1:FEC is enabled
//    customType          : RO
//    hwAccess            : WO
//    inputPort           : gui_option_fec_enable_i
//
// No register generated

// -----------------------------------------------------------------------------
// Register dhpy_scratch implementation
// -----------------------------------------------------------------------------

// dhpy_scratch_scratch
//    bitfield description: Register to test the basic read and write functionality
//    customType          : RW
//    hwAccess            : NA
//    reset value         : 32'h00000000

always @(posedge clk)
   if (!reset_n) begin
      dhpy_scratch_scratch <= 32'h00000000;
   end
   else begin
      if (we_dhpy_scratch[0]) begin
         dhpy_scratch_scratch[7:0] <= din[7:0];
      end
      if (we_dhpy_scratch[1]) begin
         dhpy_scratch_scratch[15:8] <= din[15:8];
      end
      if (we_dhpy_scratch[2]) begin
         dhpy_scratch_scratch[23:16] <= din[23:16];
      end
      if (we_dhpy_scratch[3]) begin
         dhpy_scratch_scratch[31:24] <= din[31:24];
      end
   end

// -----------------------------------------------------------------------------
// Register dphy_reset implementation
// -----------------------------------------------------------------------------

// dphy_reset_soft_tx_rst
//    bitfield description: Soft TX Reset
//                          // 1:Reset the TX datapath if tx_rst_ovr is also set
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 1'h0

always @(posedge clk)
   if (!reset_n) begin
      dphy_reset_soft_tx_rst <= 1'h0;
   end
   else begin
      if (we_dphy_reset) begin
         dphy_reset_soft_tx_rst <= din[0];
      end
   end

// dphy_reset_soft_rx_rst
//    bitfield description: Soft RX Reset
//                          // 1:Reset the RX datapath if tx_rst_ovr is also set
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 1'h0

always @(posedge clk)
   if (!reset_n) begin
      dphy_reset_soft_rx_rst <= 1'h0;
   end
   else begin
      if (we_dphy_reset) begin
         dphy_reset_soft_rx_rst <= din[1];
      end
   end

// dphy_reset_tx_rst_ovr
//    bitfield description: TX Reset Override
//                          // 0:Use TX Reset from user interface, 1:use Soft TX Reset
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 1'h0

always @(posedge clk)
   if (!reset_n) begin
      dphy_reset_tx_rst_ovr <= 1'h0;
   end
   else begin
      if (we_dphy_reset) begin
         dphy_reset_tx_rst_ovr <= din[4];
      end
   end

// dphy_reset_rx_rst_ovr
//    bitfield description: RX Reset Override
//                          // 0:Use RX Reset from user interface, 1:use Soft RX Reset
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 1'h0

always @(posedge clk)
   if (!reset_n) begin
      dphy_reset_rx_rst_ovr <= 1'h0;
   end
   else begin
      if (we_dphy_reset) begin
         dphy_reset_rx_rst_ovr <= din[5];
      end
   end

// -----------------------------------------------------------------------------
// Register dphy_reset_status implementation
// -----------------------------------------------------------------------------

// dphy_reset_status_tx_rst_ack_n
//    bitfield description: TX Reset acknowledge. Active high (either the hard tx reset or the soft_tx_rst )
//                          // 1:acknowledge the reset completed.
//    customType          : RO
//    hwAccess            : WO
//    reset value         : 1'h0
//    inputPort           : dphy_reset_status_tx_rst_ack_n_i
//
// No register generated

// dphy_reset_status_rx_rst_ack_n
//    bitfield description: RX Reset acknowledge. Active high (either the hard rx reset or the soft_rx_rst )
//                          // 1:acknowledge the reset completed.
//    customType          : RO
//    hwAccess            : WO
//    reset value         : 1'h0
//    inputPort           : dphy_reset_status_rx_rst_ack_n_i
//
// No register generated

// dphy_reset_status_tx_ready
//    bitfield description: tx_ready state
//                          // Current state of TX side:
//                          // [0]: Not ready to accept user data
//                          // [1]: Ready to send user data, indicates tx pll locked and data path reset done
//    customType          : RO
//    hwAccess            : WO
//    reset value         : 1'h0
//    inputPort           : dphy_reset_status_tx_ready_i
//
// No register generated

// dphy_reset_status_rx_ready
//    bitfield description: rx_ready state
//                          // Current state of RX side:
//                          // [0]: Not ready to recover line data to paralell interface
//                          // [1]: Ready to deliver recovered line data to parallel interface, indicates rx CDR locked and data path reset done
//    customType          : RO
//    hwAccess            : WO
//    reset value         : 1'h0
//    inputPort           : dphy_reset_status_rx_ready_i
//
// No register generated

// -----------------------------------------------------------------------------
// Register phy_tx_pll_locked implementation
// -----------------------------------------------------------------------------

// phy_tx_pll_locked_tx_pll_locked
//    bitfield description: TX PLL Locked
//                          // 1=TX PLL used by this lane physical lane is locked
//    customType          : RO
//    hwAccess            : WO
//    reset value         : 16'h0000
//    inputPort           : phy_tx_pll_locked_tx_pll_locked_i
//
// No register generated

// -----------------------------------------------------------------------------
// Register phy_rx_cdr_locked implementation
// -----------------------------------------------------------------------------

// phy_rx_cdr_locked_rx_cdr_locked
//    bitfield description: CDR PLL locked
//                          // 1:Corresponding physical lane's CDR has locked to reference
//    customType          : RO
//    hwAccess            : WO
//    reset value         : 16'h0000
//    inputPort           : phy_rx_cdr_locked_rx_cdr_locked_i
//
// No register generated

// phy_rx_cdr_locked_rx_cdr_locked2data
//    bitfield description: CDR PLL locked to data
//                          // 1:Corresponding physical lane's CDR has locked to data
//    customType          : RO
//    hwAccess            : WO
//    reset value         : 16'h0000
//    inputPort           : phy_rx_cdr_locked_rx_cdr_locked2data_i
//
// No register generated

// -----------------------------------------------------------------------------
// Register src_ctrl implementation
// -----------------------------------------------------------------------------

// src_ctrl_rx_ignore_locked2data
//    bitfield description: Ignore RX CDR Locked2data status
//                          // 1:ignore
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 1'h0

always @(posedge clk)
   if (!reset_n) begin
      src_ctrl_rx_ignore_locked2data <= 1'h0;
   end
   else begin
      if (we_src_ctrl[0]) begin
         src_ctrl_rx_ignore_locked2data <= din[0];
      end
   end

// src_ctrl_tx_clear_alarm
//    bitfield description: Clear tx_clear_alarm
//                          // 1:Clear Alarm
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 8'h00

always @(posedge clk)
   if (!reset_n) begin
      src_ctrl_tx_clear_alarm <= 8'h00;
   end
   else begin
      if (we_src_ctrl[1]) begin
         src_ctrl_tx_clear_alarm[7:0] <= din[15:8];
      end
   end

// src_ctrl_rx_clear_alarm
//    bitfield description: Clear rx_clear_alarm
//                          // 1:Clear Alarm
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 8'h00

always @(posedge clk)
   if (!reset_n) begin
      src_ctrl_rx_clear_alarm <= 8'h00;
   end
   else begin
      if (we_src_ctrl[2]) begin
         src_ctrl_rx_clear_alarm[7:0] <= din[23:16];
      end
   end

// -----------------------------------------------------------------------------
// Register src_alarms implementation
// -----------------------------------------------------------------------------

// src_alarms_tx_alarm
//    bitfield description: tx alarm status
//                          // 1:Corresponding physical lane's tx alarm status
//    customType          : RO
//    hwAccess            : WO
//    reset value         : 8'h00
//    inputPort           : src_alarms_tx_alarm_i
//
// No register generated

// src_alarms_rx_alarm
//    bitfield description: rx alarm status
//                          // 1:Corresponding physical lane's rx alarm status
//    customType          : RO
//    hwAccess            : WO
//    reset value         : 8'h00
//    inputPort           : src_alarms_rx_alarm_i
//
// No register generated

// -----------------------------------------------------------------------------
// Register mr_ctrl1 implementation
// -----------------------------------------------------------------------------

// mr_ctrl1_fec_en
//    bitfield description: fec enable for current profile
//                          // 1:fec is enabled for current profile
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 1'h0

always @(posedge clk)
   if (!reset_n) begin
      mr_ctrl1_fec_en <= 1'h0;
   end
   else begin
      if (we_mr_ctrl1[0]) begin
         mr_ctrl1_fec_en <= din[0];
      end
   end

// mr_ctrl1_fec_type
//    bitfield description: fec type
//                          // 0:default is Firecode FEC
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 3'h0

always @(posedge clk)
   if (!reset_n) begin
      mr_ctrl1_fec_type <= 3'h0;
   end
   else begin
      if (we_mr_ctrl1[0]) begin
         mr_ctrl1_fec_type[2:0] <= din[3:1];
      end
   end

// mr_ctrl1_scratch
//    bitfield description: Scratch Register to configure future changes
//                          // 0:default at the moment
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 28'h0000000

always @(posedge clk)
   if (!reset_n) begin
      mr_ctrl1_scratch <= 28'h0000000;
   end
   else begin
      if (we_mr_ctrl1[0]) begin
         mr_ctrl1_scratch[3:0] <= din[7:4];
      end
      if (we_mr_ctrl1[1]) begin
         mr_ctrl1_scratch[11:4] <= din[15:8];
      end
      if (we_mr_ctrl1[2]) begin
         mr_ctrl1_scratch[19:12] <= din[23:16];
      end
      if (we_mr_ctrl1[3]) begin
         mr_ctrl1_scratch[27:20] <= din[31:24];
      end
   end

// -----------------------------------------------------------------------------
// Register mr_ctrl2 implementation
// -----------------------------------------------------------------------------

// mr_ctrl2_is_base_prof
//    bitfield description: base profile enablement
//                          // 1:current profile is base profile
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 1'h1

always @(posedge clk)
   if (!reset_n) begin
      mr_ctrl2_is_base_prof <= 1'h1;
   end
   else begin
      if (we_mr_ctrl2[0]) begin
         mr_ctrl2_is_base_prof <= din[0];
      end
   end

// mr_ctrl2_scratch
//    bitfield description: Scratch Register to configure future changes
//                          // 0:default at the moment
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 31'h00000000

always @(posedge clk)
   if (!reset_n) begin
      mr_ctrl2_scratch <= 31'h00000000;
   end
   else begin
      if (we_mr_ctrl2[0]) begin
         mr_ctrl2_scratch[6:0] <= din[7:1];
      end
      if (we_mr_ctrl2[1]) begin
         mr_ctrl2_scratch[14:7] <= din[15:8];
      end
      if (we_mr_ctrl2[2]) begin
         mr_ctrl2_scratch[22:15] <= din[23:16];
      end
      if (we_mr_ctrl2[3]) begin
         mr_ctrl2_scratch[30:23] <= din[31:24];
      end
   end

// -----------------------------------------------------------------------------
// Register mr_ctrl3 implementation
// -----------------------------------------------------------------------------

// mr_ctrl3_reconfig_group_xcvr_per_fracture
//    bitfield description: Trasceiver Count per Fracture
//                          // 1:1 Trasceiver per fracture
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 4'h1

always @(posedge clk)
   if (!reset_n) begin
      mr_ctrl3_reconfig_group_xcvr_per_fracture <= 4'h1;
   end
   else begin
      if (we_mr_ctrl3[0]) begin
         mr_ctrl3_reconfig_group_xcvr_per_fracture[3:0] <= din[3:0];
      end
   end

// mr_ctrl3_reconfig_group_fracture_count
//    bitfield description: Total Number of Fractures
//                          // 1:Total Fracture is 1
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 4'h1

always @(posedge clk)
   if (!reset_n) begin
      mr_ctrl3_reconfig_group_fracture_count <= 4'h1;
   end
   else begin
      if (we_mr_ctrl3[0]) begin
         mr_ctrl3_reconfig_group_fracture_count[3:0] <= din[7:4];
      end
   end

// mr_ctrl3_reconfig_group_scratch
//    bitfield description: Scratch Register to configure future changes
//                          // 0:default at the moment
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 24'h000000

always @(posedge clk)
   if (!reset_n) begin
      mr_ctrl3_reconfig_group_scratch <= 24'h000000;
   end
   else begin
      if (we_mr_ctrl3[1]) begin
         mr_ctrl3_reconfig_group_scratch[7:0] <= din[15:8];
      end
      if (we_mr_ctrl3[2]) begin
         mr_ctrl3_reconfig_group_scratch[15:8] <= din[23:16];
      end
      if (we_mr_ctrl3[3]) begin
         mr_ctrl3_reconfig_group_scratch[23:16] <= din[31:24];
      end
   end

// -----------------------------------------------------------------------------
// Register mr_ctrl4 implementation
// -----------------------------------------------------------------------------

// mr_ctrl4_profile_id_query_id
//    bitfield description: Profile ID which you want to query CSR
//                          // 1:Query based on Profile ID 1
//    customType          : RW
//    hwAccess            : RO
//    reset value         : 16'h0001

always @(posedge clk)
   if (!reset_n) begin
      mr_ctrl4_profile_id_query_id <= 16'h0001;
   end
   else begin
      if (we_mr_ctrl4[0]) begin
         mr_ctrl4_profile_id_query_id[7:0] <= din[7:0];
      end
      if (we_mr_ctrl4[1]) begin
         mr_ctrl4_profile_id_query_id[15:8] <= din[15:8];
      end
   end

// mr_ctrl4_profile_id_currently_active_id
//    bitfield description: Current Profile ID
//                          // 1:Currently Active Profile ID is 1
//    customType          : RO
//    hwAccess            : WO
//    reset value         : 16'h0001
//    inputPort           : mr_ctrl4_profile_id_currently_active_id_i
//
// No register generated

// -----------------------------------------------------------------------------
// Data read management
// -----------------------------------------------------------------------------

always @(*)
begin
   rdata_comb = 32'h00000000;
   if (re) begin
      case (addr)
         // Register gui_option: gui_option_line_rate_p1ghz (RO)
         //                      gui_option_xcvr_type (RO)
         //                      gui_option_modulation_type (RO)
         //                      gui_option_duplex_mode (RO)
         //                      gui_option_num_xcvr (RO)
         //                      gui_option_fec_enable (RO)
         6'h00: begin
            rdata_comb[11:0] = gui_option_line_rate_p1ghz_i[11:0];
            rdata_comb[12] = gui_option_xcvr_type_i;
            rdata_comb[13] = gui_option_modulation_type_i;
            rdata_comb[16:14] = gui_option_duplex_mode_i[2:0];
            rdata_comb[20:17] = gui_option_num_xcvr_i[3:0];
            rdata_comb[21] = gui_option_fec_enable_i;
         end
         // Register dhpy_scratch: dhpy_scratch_scratch (RW)
         6'h04: begin
            rdata_comb[31:0] = dhpy_scratch_scratch[31:0];
         end
         // Register dphy_reset: dphy_reset_soft_tx_rst (RW)
         //                      dphy_reset_soft_rx_rst (RW)
         //                      dphy_reset_tx_rst_ovr (RW)
         //                      dphy_reset_rx_rst_ovr (RW)
         6'h08: begin
            rdata_comb[0] = dphy_reset_soft_tx_rst;
            rdata_comb[1] = dphy_reset_soft_rx_rst;
            rdata_comb[4] = dphy_reset_tx_rst_ovr;
            rdata_comb[5] = dphy_reset_rx_rst_ovr;
         end
         // Register dphy_reset_status: dphy_reset_status_tx_rst_ack_n (RO)
         //                             dphy_reset_status_rx_rst_ack_n (RO)
         //                             dphy_reset_status_tx_ready (RO)
         //                             dphy_reset_status_rx_ready (RO)
         6'h0c: begin
            rdata_comb[0] = dphy_reset_status_tx_rst_ack_n_i;
            rdata_comb[1] = dphy_reset_status_rx_rst_ack_n_i;
            rdata_comb[4] = dphy_reset_status_tx_ready_i;
            rdata_comb[5] = dphy_reset_status_rx_ready_i;
         end
         // Register phy_tx_pll_locked: phy_tx_pll_locked_tx_pll_locked (RO)
         6'h10: begin
            rdata_comb[15:0] = phy_tx_pll_locked_tx_pll_locked_i[15:0];
         end
         // Register phy_rx_cdr_locked: phy_rx_cdr_locked_rx_cdr_locked (RO)
         //                             phy_rx_cdr_locked_rx_cdr_locked2data (RO)
         6'h14: begin
            rdata_comb[15:0] = phy_rx_cdr_locked_rx_cdr_locked_i[15:0];
            rdata_comb[31:16] = phy_rx_cdr_locked_rx_cdr_locked2data_i[15:0];
         end
         // Register src_ctrl: src_ctrl_rx_ignore_locked2data (RW)
         //                    src_ctrl_tx_clear_alarm (RW)
         //                    src_ctrl_rx_clear_alarm (RW)
         6'h18: begin
            rdata_comb[0] = src_ctrl_rx_ignore_locked2data;
            rdata_comb[15:8] = src_ctrl_tx_clear_alarm[7:0];
            rdata_comb[23:16] = src_ctrl_rx_clear_alarm[7:0];
         end
         // Register src_alarms: src_alarms_tx_alarm (RO)
         //                      src_alarms_rx_alarm (RO)
         6'h1c: begin
            rdata_comb[15:8] = src_alarms_tx_alarm_i[7:0];
            rdata_comb[23:16] = src_alarms_rx_alarm_i[7:0];
         end
         // Register mr_ctrl1: mr_ctrl1_fec_en (RW)
         //                    mr_ctrl1_fec_type (RW)
         //                    mr_ctrl1_scratch (RW)
         6'h20: begin
            rdata_comb[0] = mr_ctrl1_fec_en;
            rdata_comb[3:1] = mr_ctrl1_fec_type[2:0];
            rdata_comb[31:4] = mr_ctrl1_scratch[27:0];
         end
         // Register mr_ctrl2: mr_ctrl2_is_base_prof (RW)
         //                    mr_ctrl2_scratch (RW)
         6'h24: begin
            rdata_comb[0] = mr_ctrl2_is_base_prof;
            rdata_comb[31:1] = mr_ctrl2_scratch[30:0];
         end
         // Register mr_ctrl3: mr_ctrl3_reconfig_group_xcvr_per_fracture (RW)
         //                    mr_ctrl3_reconfig_group_fracture_count (RW)
         //                    mr_ctrl3_reconfig_group_scratch (RW)
         6'h28: begin
            rdata_comb[3:0] = mr_ctrl3_reconfig_group_xcvr_per_fracture[3:0];
            rdata_comb[7:4] = mr_ctrl3_reconfig_group_fracture_count[3:0];
            rdata_comb[31:8] = mr_ctrl3_reconfig_group_scratch[23:0];
         end
         // Register mr_ctrl4: mr_ctrl4_profile_id_query_id (RW)
         //                    mr_ctrl4_profile_id_currently_active_id (RO)
         6'h2c: begin
            rdata_comb[15:0] = mr_ctrl4_profile_id_query_id[15:0];
            rdata_comb[31:16] = mr_ctrl4_profile_id_currently_active_id_i[15:0];
         end
         default: begin
            rdata_comb = 32'h00000000;
         end
      endcase
   end
end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5Conti+gYNYo9cSL/gyDnw/m0Cu7CADdtO6YoN4G91pw+rbOEGOK98vhOwNwkl4AW674AE6MpJOjDkdGUtFAsBC2xNImiT/XyMfyEPyCWOM8ZpzbZM0QOzl/DgRH1iDvBEWZ8SIwvWC9QH/PsUWf5suzYwhMelcG6f3lg94mhnCkB2HTY9JeYYVIrUn6e3Gn2DNSg4KlNfi3zSU3SPv5miApSjh43Tk5sGHlkLyXvXXzbhSURvqkyde1a+YjIHJefgtA6od+SR36vqETIhE8F0j5R9fafa3yEuuq2YPjuw3uLzxNZpnn3fUyCWozK6jDS5dbgl5upTDcirk7+w6ugERbYxIwAtW2eWAEot1ld1QMWM4btcLn0MLUJyObUr2ZzupAM5TDF27Wr7sThCz96QEzPy4nVeJF5glRFlEX4JE7Sxup0eNbvO/DMbC6OqTX2+KYN4hDvehrBLgqZdcZC92WF3CQif15u+6EApBeW+RHq2IhN/9rEHN0w4tdhdR0NDjmJLZPDXz1W+v2zdrMAtsYScDgh1LtYm4fuMEWa/vacJcZLw6EgBfxO0RisDToVad3MJyC+uBAHOgppgheyQPbF1buejkGc2dTpA2Nn6uYzrIemPQurGs6nMbGe3O0iRklmfgXt7uxnlwRPGkS2Slqqx0UfWOFWY4naAvmNRrcl+tT9bkIZHd0YuaYvHsY+soNHws9qN45/rOXNiqUzqYaUceBIENIi7ChVUXIyTlPBrLIdFe18XR0b/vrnr3WvyXtduqj3XCRyTdgvSuKzo8CuiFF2X9P3rs9b7HFkiHHc2hZYg7cTag7RVe9PNfz+kVTdubU1ioRA8Sh1gSgrAWWjAxJeRxq1C+doVe69TeX8L5xEfdlR8m4skLD+CF7mtwUsc7AfrrMDfz2jsuO2cmB77pq3aFVYW2MCrU7v7yu1RnWr/Tzk5C0gF+GX1Uvu5ldnMPlFttzpHBseGMDgzqKORSPajV9IrkE1rAiUIDnuE30x6ng4H56WgUnioK+"
`endif