// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


`timescale 1 ps/1 ps
module dphy_tx_dsk_gen 
  #(
    parameter WIDTH                 = 64,
    parameter LANES                 = 2,
 //   parameter SYS_COP       = 1,
    parameter FEC_ON                = 1,
    parameter FEC_MODE              = "IEEE 802.3 RS(528,514) (CL 91,KR)",
    parameter pldif_tx_fifo_mode    = "phase_comp", // PLDIF TX FIFO Mode
    parameter DOUBLE_WIDTH_ON       = 1,
    parameter ENABLE_DESKEW_PULSE   = 1
    )(  
      input logic 		     i_clk,
    //  input   logic        i_reset,
      input logic [LANES*WIDTH-1:0]  i_data,
      input i_pld_ready_deskew,
      input i_mr_ctrl1_fec_en,
      output logic [LANES*WIDTH-1:0] o_data
      );
wire i_pld_ready_deskew_sync;
//// Synchronizer logic for PLD RESET signal
alt_xcvr_resync_etile #(
        .SYNC_CHAIN_LENGTH (3),
        .WIDTH(1)
    )
      i_pld_ready_deskew_sync_inst  (
        .clk   (i_clk),
        .reset (1'b0),
        .d     ( i_pld_ready_deskew ),
        .q     ( i_pld_ready_deskew_sync)
      );



//For RSFEC patterns, tx deskew pulses are matching with the valid counts for
//each RSFEC mode. It's either 32 or 16 based on modes.
// 16 -> LLFEC or KP(544,514), tx deskew pulses are toggling every 16 cycles
// 32 -> KR(528,514),tx deskew pulses are toggling every 32 cycles.
// 16 means counter counts up to 15, so [3:0], WIDTH_CNT = 4.
// 32 means counter counts up to 31, so [4:0], WIDTH_CNT = 5
//
// For PMA patterns, tx deskew pulses are generated every 32 cycles.
      localparam WIDTH_CNT_FEC_REG = ((FEC_MODE == "IEEE 802.3 RS(528,514) (CL 91,KR)") || 
                        (FEC_MODE == "Ethernet Consortium RS(528,514)") || 
                    (FEC_MODE == "FC RS(528,514)") ||
                    (FEC_MODE == "FlexO RS(528,514)")) ? 5 : 4;

   
   localparam WIDTH_CNT = FEC_ON ? 
			  (((FEC_MODE == "IEEE 802.3 RS(528,514) (CL 91,KR)") || 
	                    (FEC_MODE == "Ethernet Consortium RS(528,514)") || 
		            (FEC_MODE == "FC RS(528,514)") ||
		            (FEC_MODE == "FlexO RS(528,514)")) ? 5 : 4)
     : 5;
   
   logic [WIDTH_CNT-1:0] 	     counter = 'b0;
   logic [WIDTH_CNT_FEC_REG-1:0]     counter_fec_reg = 'b0;
   logic 			     tx_dsk_pulse;
   logic [LANES-1:0] write_enable;
   assign tx_dsk_pulse = i_mr_ctrl1_fec_en ? &counter_fec_reg : &counter;

  always @ (posedge i_clk ) begin : increment_deskew_counter
     if (!i_pld_ready_deskew_sync)
        counter<='d0;
      else
        counter <= counter + 1'b1;
  end : increment_deskew_counter

  always @ (posedge i_clk ) begin : increment_deskew_counter_mr_ctrl1_fec_en
     if (!i_pld_ready_deskew_sync)
        counter_fec_reg<='d0;
      else
        counter_fec_reg <= counter_fec_reg + 1'b1;
  end : increment_deskew_counter_mr_ctrl1_fec_en
  
  generate
   genvar l;
   for(l=0;l<LANES;l=l+1)  begin:lane
      //assign o_data[l*80+:80] = DOUBLE_WIDTH_ON ? {1'b1/*i_data[l*80+79]*/, tx_dsk_pulse, i_data[l*80+:78]} 
//	                                            : {i_data[l*80+79 : l*80+37], tx_dsk_pulse, i_data[l*80+:36]};
      
	assign write_enable[l] = (pldif_tx_fifo_mode=="elastic") ? i_data[l*80+79] : 1'b1;

	assign o_data[l*80+:80] = ENABLE_DESKEW_PULSE ? (DOUBLE_WIDTH_ON ? {write_enable[l], tx_dsk_pulse, i_data[l*80+:78]} 
                                                                     : {i_data[l*80+79 : l*80+37], tx_dsk_pulse, i_data[l*80+:36]}) 
                                                  : (DOUBLE_WIDTH_ON ? {write_enable[l], i_data[l*80+:79]} 
                                                                     : {i_data[l*80+79 : l*80+37], i_data[l*80+:37]});

   end : lane

endgenerate
endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "5Conti+gYNYo9cSL/gyDnw/m0Cu7CADdtO6YoN4G91pw+rbOEGOK98vhOwNwkl4AW674AE6MpJOjDkdGUtFAsBC2xNImiT/XyMfyEPyCWOM8ZpzbZM0QOzl/DgRH1iDvBEWZ8SIwvWC9QH/PsUWf5suzYwhMelcG6f3lg94mhnCkB2HTY9JeYYVIrUn6e3Gn2DNSg4KlNfi3zSU3SPv5miApSjh43Tk5sGHlkLyXvXVj1lXKii+hX+hcfFUChBTovSPQOlpAnQO2elPDpxry3eQaUsJ0gwjLgU6sSLa9HUGlha0OIIwsMUk1w6l4TxzjHMqj57eUUJw0h8Lhbp7kawqRVQVt2LPkVeWV9WVkFjRRIWoneVYLFK8Yn+BJuwBAaQtFqMlVX8dqiq0KEZ3ekjs9lv9euhG9A06EGu3J0HtOGA/9WUvTBXA653cUbi6XYFncV0QKc2lyQtvRKjYmQWGCBOfBgJ7r+cZ4RLN85Tp3fdx7qu0GYx66ZCTBQLu7fBlrn25orc2ZUWsFcn1iONGAUDV9Z+vK1h6qDT2mZd4CFb86jMzFtjE1hSxeD9IhJW/p1m+sHj6vhEg42/969knubaKzbYOiKWlKNYYHQ+3dRj7KMpdI434pQcgnZlmeZgC+FcrQPtVUYjfR6zWM4fpTmFqMBREo5hXC9arL/rIbX4B31XqJiDbl7yQb7tdXkjWaKBsMnFM1DZ6Svc02ON2EbEmUQC2SeNhWDyeGpDsiEYkGdLO51V4jzzqfhV7RfJtTL2//nf4nH5x8fEo4W46UjFJh8uT+g7f48048IaMaFo+/e8K4Q7/NPHkuEJsjpq+oiJuVISKWnkiAWY8n7FdsITOhrNi3lcJ5TdERlOZf6LLaUcsme7Af7G7tTnWxP0T6CSubAQJ163uu0EqFIdPrbKhESpHkvag1alt2HVDhZskQffhr8PDjRXG7ogTaz5g427hd8ahodoGiBmJZ7dl96B5+cwXeolBmHfSq7J5hiMxsmlfcrD2nc9uiHO5f"
`endif