`timescale 1 ps / 1 ps
`default_nettype none

module slec_rx_xcvr
	#(
		parameter	AW					= 13
	)
	(
		input	wire					clk						,
		input	wire					rst_n					,

		input	wire	[ AW - 1 : 0 ]	avsi_phy_address		,
		input	wire					avsi_phy_write			,
		input	wire	[     31 : 0 ]	avsi_phy_writedata		,
		input	wire					avsi_phy_read			,
		output	wire	[     31 : 0 ]	avsi_phy_readdata		,
		output	wire					avsi_phy_waitrequest	,

		output	wire	[ AW - 1 : 0 ]	avso_phy_address		,
		output	wire					avso_phy_write			,
		output	wire	[     31 : 0 ]	avso_phy_writedata		,
		output	wire					avso_phy_read			,
		input	wire	[     31 : 0 ]	avso_phy_readdata		,
		input	wire					avso_phy_waitrequest

	);

	assign avso_phy_address			= avsi_phy_address			;
	assign avso_phy_write			= avsi_phy_write			;
	assign avso_phy_writedata		= avsi_phy_writedata		;
	assign avso_phy_read			= avsi_phy_read				;
	assign avsi_phy_readdata		= avso_phy_readdata			;
	assign avsi_phy_waitrequest		= avso_phy_waitrequest		;

endmodule
`default_nettype wire