	component niosv_ss is
		port (
			clk_clk                   : in  std_logic                     := 'X';             -- clk
			pio_0_export              : out std_logic_vector(31 downto 0);                    -- export
			pio_1_export              : in  std_logic_vector(31 downto 0) := (others => 'X'); -- export
			rst_n_reset_n             : in  std_logic                     := 'X';             -- reset_n
			slec_rx_csr_address       : out std_logic_vector(7 downto 0);                     -- address
			slec_rx_csr_byteenable    : out std_logic_vector(3 downto 0);                     -- byteenable
			slec_rx_csr_write         : out std_logic;                                        -- write
			slec_rx_csr_writedata     : out std_logic_vector(31 downto 0);                    -- writedata
			slec_rx_csr_read          : out std_logic;                                        -- read
			slec_rx_csr_readdata      : in  std_logic_vector(31 downto 0) := (others => 'X'); -- readdata
			slec_rx_csr_readdatavalid : in  std_logic                     := 'X';             -- readdatavalid
			slec_rx_csr_waitrequest   : in  std_logic                     := 'X';             -- waitrequest
			spi_MISO                  : in  std_logic                     := 'X';             -- MISO
			spi_MOSI                  : out std_logic;                                        -- MOSI
			spi_SCLK                  : out std_logic;                                        -- SCLK
			spi_SS_n                  : out std_logic                                         -- SS_n
		);
	end component niosv_ss;

	u0 : component niosv_ss
		port map (
			clk_clk                   => CONNECTED_TO_clk_clk,                   --         clk.clk
			pio_0_export              => CONNECTED_TO_pio_0_export,              --       pio_0.export
			pio_1_export              => CONNECTED_TO_pio_1_export,              --       pio_1.export
			rst_n_reset_n             => CONNECTED_TO_rst_n_reset_n,             --       rst_n.reset_n
			slec_rx_csr_address       => CONNECTED_TO_slec_rx_csr_address,       -- slec_rx_csr.address
			slec_rx_csr_byteenable    => CONNECTED_TO_slec_rx_csr_byteenable,    --            .byteenable
			slec_rx_csr_write         => CONNECTED_TO_slec_rx_csr_write,         --            .write
			slec_rx_csr_writedata     => CONNECTED_TO_slec_rx_csr_writedata,     --            .writedata
			slec_rx_csr_read          => CONNECTED_TO_slec_rx_csr_read,          --            .read
			slec_rx_csr_readdata      => CONNECTED_TO_slec_rx_csr_readdata,      --            .readdata
			slec_rx_csr_readdatavalid => CONNECTED_TO_slec_rx_csr_readdatavalid, --            .readdatavalid
			slec_rx_csr_waitrequest   => CONNECTED_TO_slec_rx_csr_waitrequest,   --            .waitrequest
			spi_MISO                  => CONNECTED_TO_spi_MISO,                  --         spi.MISO
			spi_MOSI                  => CONNECTED_TO_spi_MOSI,                  --            .MOSI
			spi_SCLK                  => CONNECTED_TO_spi_SCLK,                  --            .SCLK
			spi_SS_n                  => CONNECTED_TO_spi_SS_n                   --            .SS_n
		);

