`timescale 1 ps / 1 ps
`default_nettype none

module slec_rx_csr
	#(
		parameter	AW						= 8
	)
	(
		input	wire						clk						,
		input	wire						rst_n					,

		input	wire	[ AW - 1 : 0 ]		avsi_csr_address		,
		input	wire	[      3 : 0 ]		avsi_csr_byteenable		,
		input	wire						avsi_csr_write			,
		input	wire	[     31 : 0 ]		avsi_csr_writedata		,
		input	wire						avsi_csr_read			,
		output	wire						avsi_csr_readdatavalid	,
		output	wire	[     31 : 0 ]		avsi_csr_readdata		,
		output	wire						avsi_csr_waitrequest	,

		output	wire	[ AW - 1 : 0 ]		avso_csr_address		,
		output	wire	[      3 : 0 ]		avso_csr_byteenable		,
		output	wire						avso_csr_write			,
		output	wire	[     31 : 0 ]		avso_csr_writedata		,
		output	wire						avso_csr_read			,
		input	wire						avso_csr_readdatavalid	,
		input	wire	[     31 : 0 ]		avso_csr_readdata		,
		input	wire						avso_csr_waitrequest
	);

	assign avso_csr_address			= avsi_csr_address			;
	assign avso_csr_byteenable		= avsi_csr_byteenable		;
	assign avso_csr_write			= avsi_csr_write			;
	assign avso_csr_writedata		= avsi_csr_writedata		;
	assign avso_csr_read			= avsi_csr_read				;
	assign avsi_csr_readdatavalid	= avso_csr_readdatavalid	;
	assign avsi_csr_readdata		= avso_csr_readdata			;
	assign avsi_csr_waitrequest		= avso_csr_waitrequest		;

endmodule
`default_nettype wire