// (C) 2001-2025 Altera Corporation. All rights reserved.
// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


module mem_reset_handler #(
   parameter  SYNC_TO_CLK          = 1,
   parameter  USE_AND_GATE         = 1,
   parameter  NUM_RESETS           = 1,
   parameter  NUM_CONDUITS         = 0,
   parameter  CONDUIT_INVERT_0     = 0,
   parameter  CONDUIT_INVERT_1     = 0,
   parameter  CONDUIT_INVERT_2     = 0,
   parameter  CONDUIT_INVERT_3     = 0,
   parameter  CONDUIT_INVERT_4     = 0,
   parameter  CONDUIT_INVERT_5     = 0,
   parameter  CONDUIT_INVERT_6     = 0,
   parameter  CONDUIT_INVERT_7     = 0,
   parameter  CONDUIT_INVERT_8     = 0,
   parameter  CONDUIT_INVERT_9     = 0,
   parameter  CONDUIT_INVERT_10    = 0,
   parameter  CONDUIT_INVERT_11    = 0,
   parameter  CONDUIT_INVERT_12    = 0,
   parameter  CONDUIT_INVERT_13    = 0,
   parameter  CONDUIT_INVERT_14    = 0,
   parameter  CONDUIT_INVERT_15    = 0
) (
   input logic clk ,
   input logic reset_n_0 ,
   input logic reset_n_1 ,
   input logic reset_n_2 ,
   input logic reset_n_3 ,
   input logic reset_n_4 ,
   input logic reset_n_5 ,
   input logic reset_n_6 ,
   input logic reset_n_7 ,
   input logic reset_n_8 ,
   input logic reset_n_9 ,
   input logic reset_n_10,
   input logic reset_n_11,
   input logic reset_n_12,
   input logic reset_n_13,
   input logic reset_n_14,
   input logic reset_n_15,
   input logic conduit_0 ,
   input logic conduit_1 ,
   input logic conduit_2 ,
   input logic conduit_3 ,
   input logic conduit_4 ,
   input logic conduit_5 ,
   input logic conduit_6 ,
   input logic conduit_7 ,
   input logic conduit_8 ,
   input logic conduit_9 ,
   input logic conduit_10,
   input logic conduit_11,
   input logic conduit_12,
   input logic conduit_13,
   input logic conduit_14,
   input logic conduit_15,
   output logic reset_out_n
);
   timeunit 1ps;
   timeprecision 1ps;

   logic [15:0] resets_n;
   logic [15:0] conduits;
   logic reset_out_n_async;

   assign resets_n[0 ] = NUM_RESETS > 0  ? reset_n_0  : 1'b1;
   assign resets_n[1 ] = NUM_RESETS > 1  ? reset_n_1  : 1'b1;
   assign resets_n[2 ] = NUM_RESETS > 2  ? reset_n_2  : 1'b1;
   assign resets_n[3 ] = NUM_RESETS > 3  ? reset_n_3  : 1'b1;
   assign resets_n[4 ] = NUM_RESETS > 4  ? reset_n_4  : 1'b1;
   assign resets_n[5 ] = NUM_RESETS > 5  ? reset_n_5  : 1'b1;
   assign resets_n[6 ] = NUM_RESETS > 6  ? reset_n_6  : 1'b1;
   assign resets_n[7 ] = NUM_RESETS > 7  ? reset_n_7  : 1'b1;
   assign resets_n[8 ] = NUM_RESETS > 8  ? reset_n_8  : 1'b1;
   assign resets_n[9 ] = NUM_RESETS > 9  ? reset_n_9  : 1'b1;
   assign resets_n[10] = NUM_RESETS > 10 ? reset_n_10 : 1'b1;
   assign resets_n[11] = NUM_RESETS > 11 ? reset_n_11 : 1'b1;
   assign resets_n[12] = NUM_RESETS > 12 ? reset_n_12 : 1'b1;
   assign resets_n[13] = NUM_RESETS > 13 ? reset_n_13 : 1'b1;
   assign resets_n[14] = NUM_RESETS > 14 ? reset_n_14 : 1'b1;
   assign resets_n[15] = NUM_RESETS > 15 ? reset_n_15 : 1'b1;

   assign conduits[0 ] = NUM_CONDUITS > 0  ? (CONDUIT_INVERT_0 ? !conduit_0  : conduit_0 ) : 1'b1;
   assign conduits[1 ] = NUM_CONDUITS > 1  ? (CONDUIT_INVERT_1 ? !conduit_1  : conduit_1 ) : 1'b1;
   assign conduits[2 ] = NUM_CONDUITS > 2  ? (CONDUIT_INVERT_2 ? !conduit_2  : conduit_2 ) : 1'b1;
   assign conduits[3 ] = NUM_CONDUITS > 3  ? (CONDUIT_INVERT_3 ? !conduit_3  : conduit_3 ) : 1'b1;
   assign conduits[4 ] = NUM_CONDUITS > 4  ? (CONDUIT_INVERT_4 ? !conduit_4  : conduit_4 ) : 1'b1;
   assign conduits[5 ] = NUM_CONDUITS > 5  ? (CONDUIT_INVERT_5 ? !conduit_5  : conduit_5 ) : 1'b1;
   assign conduits[6 ] = NUM_CONDUITS > 6  ? (CONDUIT_INVERT_6 ? !conduit_6  : conduit_6 ) : 1'b1;
   assign conduits[7 ] = NUM_CONDUITS > 7  ? (CONDUIT_INVERT_7 ? !conduit_7  : conduit_7 ) : 1'b1;
   assign conduits[8 ] = NUM_CONDUITS > 8  ? (CONDUIT_INVERT_8 ? !conduit_8  : conduit_8 ) : 1'b1;
   assign conduits[9 ] = NUM_CONDUITS > 9  ? (CONDUIT_INVERT_9 ? !conduit_9  : conduit_9 ) : 1'b1;
   assign conduits[10] = NUM_CONDUITS > 10 ? (CONDUIT_INVERT_10? !conduit_10 : conduit_10) : 1'b1;
   assign conduits[11] = NUM_CONDUITS > 11 ? (CONDUIT_INVERT_11? !conduit_11 : conduit_11) : 1'b1;
   assign conduits[12] = NUM_CONDUITS > 12 ? (CONDUIT_INVERT_12? !conduit_12 : conduit_12) : 1'b1;
   assign conduits[13] = NUM_CONDUITS > 13 ? (CONDUIT_INVERT_13? !conduit_13 : conduit_13) : 1'b1;
   assign conduits[14] = NUM_CONDUITS > 14 ? (CONDUIT_INVERT_14? !conduit_14 : conduit_14) : 1'b1;
   assign conduits[15] = NUM_CONDUITS > 15 ? (CONDUIT_INVERT_15? !conduit_15 : conduit_15) : 1'b1;

   assign reset_out_n_async = USE_AND_GATE ? (&resets_n) && (&conduits) : (&resets_n) || (&conduits);

   if (SYNC_TO_CLK) begin : reset_n_sync
      (* altera_attribute = "-name DESIGN_ASSISTANT_EXCLUDE \"CDC-50012\" -to \"reset_n_sync.reset_sync_inst\|*\" " *)
      altera_std_synchronizer_nocut #(
         .depth(3),
         .rst_value (0)
      ) reset_sync_inst (
         .clk(clk),
         .reset_n(1'b1),
         .din(reset_out_n_async),
         .dout(reset_out_n)
      );
   end else begin : reset_n_async
      assign reset_out_n = reset_out_n_async;
   end

endmodule
`ifdef QUESTA_INTEL_OEM
`pragma questa_oem_00 "3fJG10xm+SckVgwL7ZMX8ZuuLDithIhiYYN6A7lkOnOPlNncSxsio+nQnBQ4lthm/llFgf2lwOCyNn6IdqlDdv6PoyYMo8W3SETiNqtDLHTxejY8j27TlFIKoAjhmmGxGggxTWMVW7MVkcfAG964Wmil6wViNMTIod2FtBCXwjQFGeMTwvO/WrC+1z/kDwlvobKDL+UCWRSDCBKZvjWky2I9C5tO9xa4PVfq7/cTepb4FP/v+czHDGUJo39I7ZLtXKRJEiLmiRgfC+LUOojy4Hu4dV/aFXJbnTTDID3Alj+Wz+0/7LSTwO2FgefKUz8dlnCMxfalCQenVzhKKx8aTCfE0Pe9uK9c8rqdgy3JXp4hxoJs6F0QOcGvmasBDjyGlgfubs+vU8+yoOyKEg3it/pgZhvM2LLyITfc/ndFdmR6g5J35T5LdTWpfp4FOV8IjZoVnaL0g1caAZdFRqZBMHWx7TI17f+O3nzU6aeFb92gfWB1LhlgkXmfex80h+hsRrsgut5pVqKSSIvJrIng0a3c7F38Vmm+jgl8FOvJ2CBba7hbQPtPSdGEC6Pt3wySr80i7nGs9YlNihzszrhAB4p2LM+XiFybbi+F3r6yBuuDeTK+PyClnETDFyg+lpcj3pewwYyniNp/kXONxejhViWbMN/siAx82NtvOox80X80NkwfwaqJhcbzqF0e3SmURkiIpfPPkbFY6pxJKWYWSs7uShAowF5B5y1V0xmyPdio2OnLFxWVbE2rMsO+J8pg0RpUO2aZngibvyMuC9YBQGEoh1aPzyKKs0XXcHclGGsdpUGkGdUUhmlygLjR31m+p5gPylvk6FQg9Mg1hI819f1ZnB4Fd7J5AeJVAKptnq6mHV92afgvqThuDEC2CGmFc2ydctwLPNql/DjkyhKIPI5bYHg3UUQzcviy4iMGWL8Qk6GKkWLAXhsKWuBU/aYCFm9MGo/OfXXvENsEknhmVolfxpURPGmpzodftjcuQG3fWBjEgS/pFnkAe2PIBB9l"
`endif