// lvds_top.v

// Generated using ACDS version 25.3 109

`timescale 1 ps / 1 ps
module lvds_top (
		input  wire        inclock,         //         inclock.export, PLL reference clock.
		input  wire        pll_areset,      //      pll_areset.export, Active-high asynchronous reset to all blocks in LVDS SERDES IP and PLL.
		output wire        coreclock,       //       coreclock.export, Drives the core logic feeding the serializer.
		output wire        pll_locked,      //      pll_locked.export, Asserts when internal PLL locks.
		input  wire [15:0] tx_in,           //           tx_in.export, Parallel data from the core.
		output wire [3:0]  tx_out_p,        //        tx_out_p.export, Serial output data differential pair.
		output wire [3:0]  tx_out_n,        //        tx_out_n.export, Serial output data differential pair.
		input  wire [3:0]  rx_in_p,         //         rx_in_p.export, LVDS serial input data differential pair.
		input  wire [3:0]  rx_in_n,         //         rx_in_n.export, LVDS serial input data differential pair.
		output wire [15:0] rx_out,          //          rx_out.export, Receiver parallel data output. DPA-FIFO and non-DPA mode - synchronous to coreclock.Soft-CDR mode - each channel has parallel data synchronous to its rx_divfwdclk.
		input  wire [3:0]  rx_bitslip_ctrl, // rx_bitslip_ctrl.export, Positive-edge triggered increment for bit slip circuitry. Each assertion adds one bit of latency to the received bit stream.
		input  wire [3:0]  rx_dpa_reset,    //    rx_dpa_reset.export, Asynchronous, active-high reset to DPA blocks. Minimum pulse width: one parallel clock period. Applicable in DPA-FIFO and soft-CDR modes only.
		output wire [3:0]  rx_dpa_locked,   //   rx_dpa_locked.export, Asserted when the DPA block selects the ideal phase. Driven by the LVDS SERDES IP. Asserts when the signal settles on an ideal phase for that given channel. Deasserts in one of these conditions:The DPA moves one phase.The DPA moves two phases in the same direction.Applicable in DPA-FIFO and soft-CDR modes only. Ignore all toggling of the rx_dpa_locked signal after rx_dpa_hold asserts.
		input  wire [3:0]  rx_fifo_reset    //   rx_fifo_reset.export, Asynchronous, active-high reset to FIFO block. Minimum pulse width: one parallel clock period. Applicable in DPA-FIFO mode only.
	);

	lvds_top_intel_lvds_2400_4oromrq #(
		.hw_rx_mode                ("fifo"),
		.enable_pll_2              ("false"),
		.enable_clkgen             ("true"),
		.tx_num_channels           (4),
		.rx_num_channels           (4),
		.loopback_mode             ("false"),
		.dpa_locked_used           ("true"),
		.use_bitslip               ("true"),
		.bitslip_use_reset         ("false"),
		.bitslip_assert_max        ("false"),
		.dpa_use_reset             ("true"),
		.fifo_use_reset            ("true"),
		.dpa_use_hold              ("false"),
		.use_tx_outclock           ("false"),
		.tx_outclock_div_word      (0),
		.io96b_revb                ("0"),
		.clkgen_feedback_dly_steps (5)
	) intel_lvds_0 (
		.inclock         (inclock),         //   input,   width = 1,         inclock.export
		.pll_areset      (pll_areset),      //   input,   width = 1,      pll_areset.export
		.coreclock       (coreclock),       //  output,   width = 1,       coreclock.export
		.pll_locked      (pll_locked),      //  output,   width = 1,      pll_locked.export
		.tx_in           (tx_in),           //   input,  width = 16,           tx_in.export
		.tx_out_p        (tx_out_p),        //  output,   width = 4,        tx_out_p.export
		.tx_out_n        (tx_out_n),        //  output,   width = 4,        tx_out_n.export
		.rx_in_p         (rx_in_p),         //   input,   width = 4,         rx_in_p.export
		.rx_in_n         (rx_in_n),         //   input,   width = 4,         rx_in_n.export
		.rx_out          (rx_out),          //  output,  width = 16,          rx_out.export
		.rx_bitslip_ctrl (rx_bitslip_ctrl), //   input,   width = 4, rx_bitslip_ctrl.export
		.rx_dpa_reset    (rx_dpa_reset),    //   input,   width = 4,    rx_dpa_reset.export
		.rx_dpa_locked   (rx_dpa_locked),   //  output,   width = 4,   rx_dpa_locked.export
		.rx_fifo_reset   (rx_fifo_reset)    //   input,   width = 4,   rx_fifo_reset.export
	);

endmodule
