module lvds_top (
		input  wire        inclock,         //         inclock.export, PLL reference clock.
		input  wire        pll_areset,      //      pll_areset.export, Active-high asynchronous reset to all blocks in LVDS SERDES IP and PLL.
		output wire        coreclock,       //       coreclock.export, Drives the core logic feeding the serializer.
		output wire        pll_locked,      //      pll_locked.export, Asserts when internal PLL locks.
		input  wire [15:0] tx_in,           //           tx_in.export, Parallel data from the core.
		output wire [3:0]  tx_out_p,        //        tx_out_p.export, Serial output data differential pair.
		output wire [3:0]  tx_out_n,        //        tx_out_n.export, Serial output data differential pair.
		input  wire [3:0]  rx_in_p,         //         rx_in_p.export, LVDS serial input data differential pair.
		input  wire [3:0]  rx_in_n,         //         rx_in_n.export, LVDS serial input data differential pair.
		output wire [15:0] rx_out,          //          rx_out.export, Receiver parallel data output. DPA-FIFO and non-DPA mode - synchronous to coreclock.Soft-CDR mode - each channel has parallel data synchronous to its rx_divfwdclk.
		input  wire [3:0]  rx_bitslip_ctrl, // rx_bitslip_ctrl.export, Positive-edge triggered increment for bit slip circuitry. Each assertion adds one bit of latency to the received bit stream.
		input  wire [3:0]  rx_dpa_reset,    //    rx_dpa_reset.export, Asynchronous, active-high reset to DPA blocks. Minimum pulse width: one parallel clock period. Applicable in DPA-FIFO and soft-CDR modes only.
		output wire [3:0]  rx_dpa_locked,   //   rx_dpa_locked.export, Asserted when the DPA block selects the ideal phase. Driven by the LVDS SERDES IP. Asserts when the signal settles on an ideal phase for that given channel. Deasserts in one of these conditions:The DPA moves one phase.The DPA moves two phases in the same direction.Applicable in DPA-FIFO and soft-CDR modes only. Ignore all toggling of the rx_dpa_locked signal after rx_dpa_hold asserts.
		input  wire [3:0]  rx_fifo_reset    //   rx_fifo_reset.export, Asynchronous, active-high reset to FIFO block. Minimum pulse width: one parallel clock period. Applicable in DPA-FIFO mode only.
	);
endmodule

