// lvds_top_intel_lvds_core10_ph2_altera_iopll_191_gyqqmxq.v

// Generated using ACDS version 25.3 109

`timescale 1 ps / 1 ps
module lvds_top_intel_lvds_core10_ph2_altera_iopll_191_gyqqmxq (
		input  wire       refclk,        //        refclk.clk,           The reference clock source that drives the I/O PLL.
		output wire       locked,        //        locked.export,        The IOPLL IP core drives this port high when the PLL acquires lock. The port remains high as long as the I/O PLL is locked. The I/O PLL asserts the locked port when the phases and frequencies of the reference clock and feedback clock are the same or within the lock circuit tolerance. When the difference between the two clock signals exceeds the lock circuit tolerance, the I/O PLL loses lock.
		input  wire       rst,           //         reset.reset,         The asynchronous reset port for the output clocks. Drive this port high to reset all output clocks to the value of 0.
		output wire [7:0] phout,         //         phout.phout,         Port is enabled after Enable access to PLL DPA output port is turned on.  This signal can be configured by turning on Specify VCO frequency in the PLL and specifying the VCO frequency value.
		output wire [1:0] outclk_periph, // outclk_periph.outclk_periph, Port is enabled after Enabled access to I/O Bank clock ports is turned on. This signal indicates the output clocks for the periphery, e.g. LVDS. The clock can only be connected to one LVDS only. Enables this parameter in case the PLL feeds an LVDS SERDES block with external PLL.
		output wire       phout_periph,  //  phout_periph.clk,           Port is enabled after Enabled access to I/O Bank clock ports is turned on. This signal indicates VCO clock that gets routed throughout periphery. The clock port can only be connected to one LVDS. Enables this parameter in case the PLL feeds an LVDS SERDES block with external PLL.
		input  wire       fbclkin_lvds   //  fbclkin_lvds.clk,           Input Port to the LVDS. The Clock from the fabric is connected to the LVDS PLL
	);

	lvds_top_altera_iopll_2100_4eqauji internal_pll (
		.refclk        (refclk),        //   input,  width = 1,        refclk.clk
		.locked        (locked),        //  output,  width = 1,        locked.export
		.rst           (rst),           //   input,  width = 1,         reset.reset
		.phout         (phout),         //  output,  width = 8,         phout.phout
		.outclk_periph (outclk_periph), //  output,  width = 2, outclk_periph.outclk_periph
		.phout_periph  (phout_periph),  //  output,  width = 1,  phout_periph.clk
		.fbclkin_lvds  (fbclkin_lvds)   //   input,  width = 1,  fbclkin_lvds.clk
	);

endmodule
